/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.difforder.strategy;

import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.service.business.difforder.DiffOrderOptAbleImpl;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.IDiffOrderOptAble;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.IDiffOrderOptCallBack;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component(value="inDiffOrderOptContext")
public class DiffOrderOptContext
implements ApplicationContextAware {
    public static final String DEFAULT_CODE = "default";
    private static IDiffOrderOptAble diffOrderOptAble;
    private static final Map<String, IDiffOrderOptCallBack> DIFF_ORDER_OPT_CALLBACK_MAP;

    @PostConstruct
    public void setDiffOrderOptAble() {
        diffOrderOptAble = (IDiffOrderOptAble)SpringBeanUtil.getBean(IDiffOrderOptAble.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        applicationContext.getBeansOfType(IDiffOrderOptCallBack.class).values().forEach(opt -> DIFF_ORDER_OPT_CALLBACK_MAP.put(opt.getCode(), (IDiffOrderOptCallBack)opt));
        diffOrderOptAble = (IDiffOrderOptAble)applicationContext.getBean(DiffOrderOptAbleImpl.class);
    }

    public static IDiffOrderOptCallBack getCurCallBack(String code) {
        return Optional.ofNullable(code).filter(StringUtils::isNotBlank).map(DIFF_ORDER_OPT_CALLBACK_MAP::get).orElse(DIFF_ORDER_OPT_CALLBACK_MAP.get(DEFAULT_CODE));
    }

    public static IDiffOrderOptAble getDiffOrderOptAble() {
        return diffOrderOptAble;
    }

    static {
        DIFF_ORDER_OPT_CALLBACK_MAP = Maps.newHashMap();
    }
}

