/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.guard;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InspectionPassSuccessEvent;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IWaitInspectionRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEventEnum;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.stereotype.Component;

@Component
public class PassSuccessGuard
implements Guard<DgInspectionPassRecordStatusEnum, DgInspectionPassRecordStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(PassSuccessGuard.class);
    @Resource
    private IInventoryBatchDomain inventoryBatchDomain;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private ILogicInventoryDomain logicInventoryDomain;
    @Resource
    private IWaitInspectionRecordService waitInspectionRecordService;

    public boolean evaluate(StateContext<DgInspectionPassRecordStatusEnum, DgInspectionPassRecordStatusEventEnum> context) {
        log.info("\u65b0\u589e\u5e93\u5b58\u72b6\u6001\u8c03\u6574\u5355\u5f85\u68c0->\u6b63\u54c1");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        InspectionPassRecordEo inspectionPassRecordEo = (InspectionPassRecordEo)executorBo.getEo();
        InventoryBatchEo inventoryBatchEo = (InventoryBatchEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryBatchDomain.filter().eq((Object)"sku_code", (Object)inspectionPassRecordEo.getSkuCode())).eq((Object)"batch", (Object)inspectionPassRecordEo.getBatch())).orderByDesc((Object)"id")).last(" limit 1")).one();
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)inspectionPassRecordEo.getLogicWarehouseCode())).orderByDesc((Object)"id")).last(" limit 1")).one();
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        ArrayList<AdjustmentOrderDetailDto> adjustmentOrderDetailDtoList = new ArrayList<AdjustmentOrderDetailDto>();
        adjustmentOrderDto.setBusinessType("inventory_status_adjustment");
        adjustmentOrderDto.setBizDate(new Date());
        adjustmentOrderDto.setOrigWarehouseCode(inspectionPassRecordEo.getLogicWarehouseCode());
        adjustmentOrderDto.setOrganizationName(inspectionPassRecordEo.getLogicWarehouseName());
        adjustmentOrderDto.setWarehouseCode(inspectionPassRecordEo.getLogicWarehouseCode());
        adjustmentOrderDto.setWarehouseName(inspectionPassRecordEo.getLogicWarehouseName());
        adjustmentOrderDto.setOrganizationCode(inspectionPassRecordEo.getOrganizationCode());
        adjustmentOrderDto.setOrganizationName(inspectionPassRecordEo.getOrganizationName());
        adjustmentOrderDto.setInventoryProperty(inspectionPassRecordEo.getInventoryProperty());
        adjustmentOrderDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
        adjustmentOrderDto.setExternalOrderNo(inspectionPassRecordEo.getInspectionPassRecordNo());
        adjustmentOrderDto.setPushSap(Integer.valueOf(1));
        adjustmentOrderDto.setPushWms(Integer.valueOf(1));
        adjustmentOrderDto.setRemark("\u8d28\u68c0\u653e\u884c\u5ba1\u6838\u901a\u8fc7");
        adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pushFeiShu", "0");
        adjustmentOrderDto.setExtension(JSON.toJSONString(map));
        if (Objects.nonNull(logicWarehouseEo)) {
            adjustmentOrderDto.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            adjustmentOrderDto.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
        }
        AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
        adjustmentOrderDetailDto.setSkuCode(inspectionPassRecordEo.getSkuCode());
        adjustmentOrderDetailDto.setSkuName(inspectionPassRecordEo.getSkuName());
        adjustmentOrderDetailDto.setBatch(inspectionPassRecordEo.getBatch());
        adjustmentOrderDetailDto.setOrigBatch(inspectionPassRecordEo.getBatch());
        adjustmentOrderDetailDto.setInventoryProperty(inspectionPassRecordEo.getInventoryProperty());
        if (Objects.nonNull(inventoryBatchEo)) {
            adjustmentOrderDetailDto.setExpireTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setProduceTime(inventoryBatchEo.getProduceTime());
            adjustmentOrderDetailDto.setOrigProduceTime(inventoryBatchEo.getExpireTime());
            adjustmentOrderDetailDto.setOrigExpireTime(inventoryBatchEo.getProduceTime());
            adjustmentOrderDetailDto.setSpuCode(inventoryBatchEo.getSpuCode());
            adjustmentOrderDetailDto.setSpuName(inventoryBatchEo.getSpuName());
        }
        LogicInventoryEo logicInventoryEo = (LogicInventoryEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicInventoryDomain.filter().eq((Object)"sku_code", (Object)inspectionPassRecordEo.getSkuCode())).eq((Object)"batch", (Object)inspectionPassRecordEo.getBatch())).eq((Object)"warehouse_code", (Object)inspectionPassRecordEo.getLogicWarehouseCode())).eq((Object)"inventory_property", (Object)inspectionPassRecordEo.getInventoryProperty())).last("limit 1")).one();
        log.info("\u67e5\u8be2\u5e93\u5b58\u53ef\u7528\u5f85\u68c0\u6570:{}", (Object)JSON.toJSONString((Object)logicInventoryEo));
        if (Objects.isNull(logicInventoryEo)) {
            inspectionPassRecordEo.setFailureMessage("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u5e93\u5b58\u4fe1\u606f");
            return false;
        }
        try {
            Thread.sleep(3000L);
            this.waitInspectionRecordService.updateQuantity(inspectionPassRecordEo.getSkuCode(), inspectionPassRecordEo.getBatch());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (BigDecimalUtils.leZero((BigDecimal)logicInventoryEo.getAvailable()).booleanValue()) {
            inspectionPassRecordEo.setActualQuantity(BigDecimal.ZERO);
            return true;
        }
        adjustmentOrderDetailDto.setChangeQuantity(BigDecimalUtils.gt((BigDecimal)logicInventoryEo.getAvailable(), (BigDecimal)inspectionPassRecordEo.getQuantity()) != false ? inspectionPassRecordEo.getQuantity() : logicInventoryEo.getAvailable());
        adjustmentOrderDetailDto.setUnit(inspectionPassRecordEo.getUnit());
        adjustmentOrderDetailDto.setNewInventoryProperty(LogicWarehouseQualityEnum.QUALIFIED.getCode());
        adjustmentOrderDetailDtoList.add(adjustmentOrderDetailDto);
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtoList);
        InventoryConfig.pushEvent(new InspectionPassSuccessEvent(adjustmentOrderDto));
        inspectionPassRecordEo.setActualQuantity(adjustmentOrderDetailDto.getChangeQuantity());
        return true;
    }
}

