/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IAssemblyDisassemblyOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OrderSaleCancelMessageDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryDetailMessageDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryMessageDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCloseAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCompleteAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.helper.TransferOrderDeliveryHelper;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.executor.AdjustmentOrderStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.statemachine.executor.AssemblyDisassemblyOrderStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.statemachine.executor.OtherInOutStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.statemachine.executor.PlanStatemachineExecutor;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryEvent;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractBusinessOrder {
    private static final Logger log = LoggerFactory.getLogger(AbstractBusinessOrder.class);
    @Autowired
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Autowired
    IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Autowired
    ITransferOrderDomain transferOrderDomain;
    @Autowired
    private ICommonsMqService mqService;
    @Autowired
    private IOrderUnitConversionRecordDomain iOrderUnitConversionRecordDomain;
    @Resource
    private StateMachineFactory<TransferOrderReceiveState, TransferOrderReceiveEvent> receiveStateMachineFactory;
    @Autowired
    private StateMachinePersister<TransferOrderReceiveState, TransferOrderReceiveEvent, String> receivePersister;
    @Autowired
    private StateMachinePersister<TransferOrderDeliveryState, TransferOrderDeliveryEvent, String> deliveryPersister;
    @Resource
    private StateMachineFactory<TransferOrderDeliveryState, TransferOrderDeliveryEvent> deliveryStateMachineFactory;
    @Resource
    private OtherInOutStatemachineExecutor otherInOutStatemachineExecutor;
    @Resource
    private PlanStatemachineExecutor planStatemachineExecutor;
    @Resource
    private IPlanOrderDomain planOrderDomain;
    @Resource
    private IAssemblyDisassemblyOrderDomain assemblyDisassemblyOrderDomain;
    @Resource
    private IAdjustmentOrderDomain adjustmentOrderDomain;
    @Resource
    private IInOtherStorageOrderDomain otherStorageOrderDomain;
    @Resource
    private TransferOrderCloseAction transferOrderCloseAction;
    @Resource
    private TransferOrderCompleteAction transferOrderCompleteAction;
    @Resource
    private AdjustmentOrderStatemachineExecutor adjustmentOrderStatemachineExecutor;
    @Resource
    protected AssemblyDisassemblyOrderStatemachineExecutor assemblyDisassemblyOrderStatemachineExecutor;
    @Resource
    private TransferOrderDeliveryHelper deliveryStateMachineHelper;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public abstract void outBackEvent(ReceiveDeliveryResultOrderContext var1);

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public abstract void inBackEvent(ReceiveDeliveryResultOrderContext var1);

    public abstract void inNoticeCancelEvent(InOutNoticeOrderContext var1);

    public abstract void outNoticeCancelEvent(InOutNoticeOrderContext var1);

    public abstract void deliveryNoticeCloseEvent(ReceiveDeliveryNoticeOrderContext var1);

    public abstract void receiveNoticeCloseEvent(ReceiveDeliveryNoticeOrderContext var1);

    public abstract void outNoticeGenEvent(InOutNoticeOrderContext var1);

    public abstract void inNoticeGenEvent(InOutNoticeOrderContext var1);

    public abstract void inOutNoticeOrderComplete(InOutNoticeOrderContext var1);

    protected void closeProcess(ReceiveDeliveryNoticeOrderContext source) {
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)source.getRelevanceTableName())) {
            TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)source.getRelevanceNo())).one();
            if (TransferOrderStatus.PARTIALLY_DELIVERED_WAITING_FOR_DELIVERY.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code().equals(transferOrderEo.getOrderStatus())) {
                if (transferOrderEo.getShipmentStatus().equals(TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode())) {
                    this.transferOrderCompleteAction.doComplete(transferOrderEo);
                } else {
                    this.transferOrderCloseAction.close(source.getRelevanceNo());
                }
            } else if (TransferOrderStatus.ALL_DELIVERED_WAITING_FOR_DELIVERY.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code().equals(transferOrderEo.getOrderStatus())) {
                this.transferOrderCompleteAction.doComplete(transferOrderEo);
            } else {
                this.transferOrderCompleteAction.doComplete(transferOrderEo);
            }
        } else if (CsRelevanceTableNameEnum.IN_OTHER_STORAGE_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
            inOtherStorageOrderEoStatemachineExecutorBo.getVariables().put("storageOrderNo", relevanceNo);
            inOtherStorageOrderEoStatemachineExecutorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)((ExtQueryChainWrapper)this.otherStorageOrderDomain.filter().eq((Object)"storage_order_no", (Object)relevanceNo)).one();
            inOtherStorageOrderEoStatemachineExecutorBo.setEo(inOtherStorageOrderEo);
            if (CsPcpBusinessTypeEnum.OTHER_IN.getCode().equals(inOtherStorageOrderEo.getType())) {
                this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHIN, inOtherStorageOrderEoStatemachineExecutorBo);
            } else {
                this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.FINISHOUT, inOtherStorageOrderEoStatemachineExecutorBo);
            }
        } else if (CsRelevanceTableNameEnum.PLAN_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            StatemachineExecutorBo<PlanOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
            PlanOrderEo planOrderEo = (PlanOrderEo)((ExtQueryChainWrapper)this.planOrderDomain.filter().eq((Object)"order_no", (Object)relevanceNo)).one();
            statemachineExecutorBo.setEo(planOrderEo);
            statemachineExecutorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
            statemachineExecutorBo.getVariables().put("orderNo", planOrderEo.getOrderNo());
            this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.FINISH, statemachineExecutorBo);
        } else if (CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            log.info("content:{}", (Object)JSONObject.toJSONString((Object)source));
            List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)"out")).list();
            if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
                InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
                StatemachineExecutorBo<Object> executorBo = new StatemachineExecutorBo<Object>();
                executorBo.setEo(((ExtQueryChainWrapper)this.assemblyDisassemblyOrderDomain.filter().eq((Object)"order_no", (Object)relevanceNo)).one());
                executorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
                this.assemblyDisassemblyOrderStatemachineExecutor.execute(AssemblyDisassemblyOrderStatusEventEnum.CLOSE, executorBo);
            }
        }
    }

    protected void cancelProcess(InOutNoticeOrderContext source) {
        log.info("cancelProcess\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)source));
        if (!source.isCancelBizOrder()) {
            return;
        }
        if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.equals((Object)source.getRelevanceTableName())) {
            TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)source.getRelevanceNo())).one();
            this.deliveryStateMachineHelper.sendEvent(TransferOrderDeliveryEvent.CANCEL, transferOrderEo.getTransferOrderNo());
        } else if (CsRelevanceTableNameEnum.IN_OTHER_STORAGE_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            StatemachineExecutorBo<InOtherStorageOrderEo> inOtherStorageOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<InOtherStorageOrderEo>();
            inOtherStorageOrderEoStatemachineExecutorBo.getVariables().put("storageOrderNo", relevanceNo);
            inOtherStorageOrderEoStatemachineExecutorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)((ExtQueryChainWrapper)this.otherStorageOrderDomain.filter().eq((Object)"storage_order_no", (Object)relevanceNo)).one();
            inOtherStorageOrderEoStatemachineExecutorBo.setEo(inOtherStorageOrderEo);
            this.otherInOutStatemachineExecutor.execute(DgOtherOrderStatusEventEnum.CANCEL, inOtherStorageOrderEoStatemachineExecutorBo);
        } else if (CsRelevanceTableNameEnum.PLAN_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            StatemachineExecutorBo<PlanOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
            PlanOrderEo planOrderEo = (PlanOrderEo)((ExtQueryChainWrapper)this.planOrderDomain.filter().eq((Object)"order_no", (Object)relevanceNo)).one();
            statemachineExecutorBo.setEo(planOrderEo);
            statemachineExecutorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
            statemachineExecutorBo.getVariables().put("orderNo", planOrderEo.getOrderNo());
            this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.CANCEL, statemachineExecutorBo);
        } else if (CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<AdjustmentOrderEo>();
            AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)this.adjustmentOrderDomain.filter().eq((Object)"order_no", (Object)relevanceNo)).one();
            statemachineExecutorBo.setEo(adjustmentOrderEo);
            statemachineExecutorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
            statemachineExecutorBo.getVariables().put("orderNo", adjustmentOrderEo.getAdjustmentNo());
            this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.CANCEL, statemachineExecutorBo);
        } else if (CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.equals((Object)source.getRelevanceTableName())) {
            String relevanceNo = source.getRelevanceNo();
            log.info("content:{}", (Object)JSONObject.toJSONString((Object)source));
            List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)"out")).list();
            if (CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList)) {
                InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
                StatemachineExecutorBo<Object> executorBo = new StatemachineExecutorBo<Object>();
                executorBo.setEo(((ExtQueryChainWrapper)this.assemblyDisassemblyOrderDomain.filter().eq((Object)"order_no", (Object)relevanceNo)).one());
                executorBo.getVariables().put("receiveDeliveryResultOrderContext", source);
                this.assemblyDisassemblyOrderStatemachineExecutor.execute(AssemblyDisassemblyOrderStatusEventEnum.CANCEL, executorBo);
            }
        }
    }

    protected void noticeOrderSend(ReceiveDeliveryResultOrderContext callBackContext) {
        log.info("\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3noticeOrderSend:{}", (Object)JSON.toJSONString((Object)callBackContext));
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = callBackContext.getReceiveDeliveryResultOrderEo();
        List<ReceiveDeliveryResultOrderDetailEo> inOutResultDetailRespDtoList = callBackContext.getReceiveDeliveryResultOrderDetailEoList();
        ArrayList deliveryDetailMessageDtoList = Lists.newArrayList();
        List orderUnitConversionRecordEoList = ((ExtQueryChainWrapper)this.iOrderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)callBackContext.getRelevanceNo())).list();
        Map<String, BigDecimal> bigDecimalMap = orderUnitConversionRecordEoList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getMatchKey, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, BigDecimal> decimalMap = orderUnitConversionRecordEoList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        for (ReceiveDeliveryResultOrderDetailEo detailRespDto : inOutResultDetailRespDtoList) {
            OutDeliveryDetailMessageDto deliveryDetailMessageDto = new OutDeliveryDetailMessageDto();
            deliveryDetailMessageDto.setOrderNo(receiveDeliveryResultOrderEo.getRelevanceNo());
            deliveryDetailMessageDto.setOutQuantity(detailRespDto.getDoneQuantity());
            deliveryDetailMessageDto.setLongCode(detailRespDto.getSkuCode());
            deliveryDetailMessageDto.setBatch(StringUtils.defaultString((String)detailRespDto.getBatch(), (String)InventoryConfig.getDefaultBatch()));
            deliveryDetailMessageDto.setSnCode(detailRespDto.getSnCode());
            deliveryDetailMessageDto.setRatio(bigDecimalMap.getOrDefault(detailRespDto.getPreOrderItemId() + "", decimalMap.get(detailRespDto.getSkuCode())));
            deliveryDetailMessageDto.setTradeOrderItemId(detailRespDto.getPreOrderItemId());
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)JSON.parseObject((String)detailRespDto.getExtension(), BasicOrderDtoExtension.class);
            if (Objects.nonNull(basicOrderDtoExtension)) {
                deliveryDetailMessageDto.setWeight(basicOrderDtoExtension.getWeight());
                deliveryDetailMessageDto.setVolume(basicOrderDtoExtension.getVolume());
            }
            deliveryDetailMessageDtoList.add(deliveryDetailMessageDto);
        }
        OutDeliveryMessageDto outDeliveryMessageDto = new OutDeliveryMessageDto();
        outDeliveryMessageDto.setDeliveryTime(receiveDeliveryResultOrderEo.getCreateTime());
        outDeliveryMessageDto.setOrderNo(receiveDeliveryResultOrderEo.getRelevanceNo());
        outDeliveryMessageDto.setTotalQuantity(receiveDeliveryResultOrderEo.getTotalQuantity());
        outDeliveryMessageDto.setTotalCartons(receiveDeliveryResultOrderEo.getTotalCartons());
        outDeliveryMessageDto.setMergeQuantity(receiveDeliveryResultOrderEo.getMergeQuantity());
        outDeliveryMessageDto.setDeliveryDetailMessageDtoList((List)deliveryDetailMessageDtoList);
        outDeliveryMessageDto.setShippingNo(receiveDeliveryResultOrderEo.getShippingCode());
        outDeliveryMessageDto.setShipmentEnterpriseCode(receiveDeliveryResultOrderEo.getShippingCompanyCode());
        outDeliveryMessageDto.setShipmentEnterpriseName(receiveDeliveryResultOrderEo.getShippingCompany());
        String physicsWarehouseCode = receiveDeliveryResultOrderEo.getDeliveryPhysicsWarehouseCode();
        if ("receive".equals(receiveDeliveryResultOrderEo.getOrderType())) {
            physicsWarehouseCode = receiveDeliveryResultOrderEo.getReceivePhysicsWarehouseCode();
        }
        List physicsWarehouseEos = null;
        if (StringUtils.isNotBlank((CharSequence)physicsWarehouseCode) && Objects.nonNull(physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(physicsWarehouseCode))) {
            outDeliveryMessageDto.setPhoneNum(((PhysicsWarehouseEo)physicsWarehouseEos.get(0)).getPhone());
        }
        String shippingJson = receiveDeliveryResultOrderEo.getShippingJson();
        ArrayList notOutInNoticeStatusList = Lists.newArrayList();
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.INO_CANCEL.getCode());
        String type = "delivery".equals(receiveDeliveryResultOrderEo.getOrderType()) ? "out" : "in";
        List outNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)receiveDeliveryResultOrderEo.getRelevanceNo())).eq((Object)"order_type", (Object)type)).notIn((Object)"order_status", (Collection)notOutInNoticeStatusList)).orderByDesc((Object)"id")).list();
        List outResultOrderEos = this.inOutResultOrderDomain.queryByDocumentNo(receiveDeliveryResultOrderEo.getPreOrderNo());
        if (CollectionUtils.isNotEmpty((Collection)outResultOrderEos)) {
            InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)outResultOrderEos.get(0);
            outDeliveryMessageDto.setDeliveryTime(Optional.ofNullable(inOutResultOrderEo.getInOutTime()).orElse(inOutResultOrderEo.getCreateTime()));
        }
        log.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3\uff0c\u67e5\u8be2\u901a\u77e5\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)outNoticeOrderEos));
        if (!callBackContext.isOnlyGenResult()) {
            AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)outNoticeOrderEos), (String)String.format("\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u901a\u77e5\u5355\u4fe1\u606f\uff0c\u5173\u8054\u5355\u53f7\uff1a%s", receiveDeliveryResultOrderEo.getRelevanceNo()));
            InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)outNoticeOrderEos.get(0);
            outDeliveryMessageDto.setDeliveryNoticeOrderNo(outNoticeOrderEo.getPreOrderNo());
            outDeliveryMessageDto.setOutNoticeOrderNo(outNoticeOrderEo.getDocumentNo());
            if (StringUtils.isBlank((CharSequence)shippingJson)) {
                outDeliveryMessageDto.setDeliveryNoticeOrderNo(outNoticeOrderEo.getPreOrderNo());
                outDeliveryMessageDto.setOutNoticeOrderNo(outNoticeOrderEo.getDocumentNo());
                shippingJson = outNoticeOrderEo.getShippingJson();
                outDeliveryMessageDto.setShippingNo(outNoticeOrderEo.getShippingCode());
                outDeliveryMessageDto.setShipmentEnterpriseCode(outNoticeOrderEo.getShippingCompany());
                outDeliveryMessageDto.setShipmentEnterpriseName(outNoticeOrderEo.getShippingCompanyName());
            }
            if (CsRelevanceTableNameEnum.CS_ORDER_SALE.equals((Object)callBackContext.getRelevanceTableName())) {
                outDeliveryMessageDto.setPortionFlag(Boolean.valueOf(!BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(outNoticeOrderEo.getOrderStatus())));
            } else {
                outDeliveryMessageDto.setPortionFlag(Boolean.valueOf(!BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(outNoticeOrderEo.getOrderStatus())));
            }
        } else {
            outDeliveryMessageDto.setPortionFlag(Boolean.valueOf(true));
        }
        log.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,shippingJson:{}", (Object)LogUtils.buildLogContent((Object)shippingJson));
        if (StringUtils.isNotBlank((CharSequence)shippingJson)) {
            try {
                List csWmsShippingInfoReqDtoList = JSON.parseArray((String)shippingJson, CsWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)csWmsShippingInfoReqDtoList)) {
                    csWmsShippingInfoReqDtoList.stream().filter(e -> Objects.isNull(e.getDeliveryTime())).forEach(e -> e.setDeliveryTime(outDeliveryMessageDto.getDeliveryTime()));
                    csWmsShippingInfoReqDtoList.forEach(item -> {
                        try {
                            String shippingCode = "JDDJ".equals(outDeliveryMessageDto.getShipmentEnterpriseCode()) ? item.getShippingNo().split("-")[0] : item.getShippingNo();
                            item.setShippingNo(shippingCode);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    });
                }
                log.info("noticeOrderSend==>\u901a\u77e5\u4ea4\u6613\u4e2d\u5fc3,csWmsShippingInfoReqDtoList:{}", (Object)LogUtils.buildLogContent((Collection)csWmsShippingInfoReqDtoList));
                outDeliveryMessageDto.setShippingInfoList(csWmsShippingInfoReqDtoList);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e2.getMessage(), (Object)e2);
            }
        }
        outDeliveryMessageDto.setCommonBack(Boolean.TRUE);
        outDeliveryMessageDto.setOutResultOrderNo(callBackContext.getPreOrderNo());
        outDeliveryMessageDto.setCommonBack(Boolean.valueOf(true));
        log.info("outDelivery==>\u5373\u5c06\u53d1\u9001MQ\u901a\u77e5\u8ba2\u5355\u5df2\u53d1\u8d27,messageVo:{}", (Object)LogUtils.buildLogContent((Object)outDeliveryMessageDto));
        boolean allProcess = true;
        if (CollectionUtils.isNotEmpty((Collection)outNoticeOrderEos)) {
            List inOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryByDocumentNo(((InOutNoticeOrderEo)outNoticeOrderEos.get(0)).getDocumentNo());
            allProcess = inOutNoticeOrderDetailEos.stream().allMatch(r -> BigDecimalUtils.ge((BigDecimal)r.getDoneQuantity(), (BigDecimal)r.getPlanQuantity()));
        }
        if (CsRelevanceTableNameEnum.CS_ORDER_SALE.equals((Object)callBackContext.getRelevanceTableName())) {
            outDeliveryMessageDto.setPortionFlag(Boolean.valueOf(!allProcess));
            this.mqService.sendSingleMessage("ORDER_SALE_WMS_SEND_BACK_TAG", (Object)JSONObject.toJSONString((Object)outDeliveryMessageDto));
        } else {
            outDeliveryMessageDto.setPortionFlag(Boolean.valueOf(!allProcess));
            this.mqService.sendSingleMessage("ORDER_AFTER_SALE_WMS_SEND_BACK_TAG", (Object)JSONObject.toJSONString((Object)outDeliveryMessageDto));
        }
    }

    protected void sendTradeMQ(ReceiveDeliveryNoticeOrderContext context) {
        OrderSaleCancelMessageDto orderSaleCancelMessageDto = new OrderSaleCancelMessageDto();
        orderSaleCancelMessageDto.setType(BaseOrderStatusEnum.FINISH_OVER.getCode());
        orderSaleCancelMessageDto.setOrderNo(context.getRelevanceNo());
        this.mqService.sendSingleMessage("ORDER_SALE_REFUND_WMS_CANCEL_TAG", (Object)JSONObject.toJSONString((Object)orderSaleCancelMessageDto));
    }
}

