/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.dict.dto.dto.DictDto;
import com.yunxi.dg.base.center.dict.dto.dto.DictValueDto;
import com.yunxi.dg.base.center.dict.proxy.api.IDictApiProxy;
import com.yunxi.dg.base.center.dict.proxy.api.IDictValueApiProxy;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InOtherStorageBusinessTypeConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageBusinessTypeDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageBusinessTypeDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageBusinessTypePageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageBusinessTypeEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.other.IInOtherStorageBusinessTypeService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOtherStorageBusinessTypeServiceImpl
extends BaseServiceImpl<InOtherStorageBusinessTypeDto, InOtherStorageBusinessTypeEo, IInOtherStorageBusinessTypeDomain>
implements IInOtherStorageBusinessTypeService {
    private static final Logger log = LoggerFactory.getLogger(InOtherStorageBusinessTypeServiceImpl.class);
    @Resource
    private IInOtherStorageBusinessTypeDomain domain;
    @Resource
    private IInOtherStorageOrderDomain inOtherStorageOrderDomain;
    @Resource
    private IDictApiProxy dictApi;
    @Resource
    private IDictValueApiProxy dictValueApiProxy;

    public InOtherStorageBusinessTypeServiceImpl(IInOtherStorageBusinessTypeDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOtherStorageBusinessTypeDto, InOtherStorageBusinessTypeEo> converter() {
        return InOtherStorageBusinessTypeConverter.INSTANCE;
    }

    private void checkAddParam(InOtherStorageBusinessTypeDto addReqDto) {
        AssertUtils.notNull((Object)addReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getParentCode(), (String)"\u7236\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getStatus(), (String)"\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)addReqDto.getType(), (String)"\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.isGroup(addReqDto)) {
            AssertUtils.notNull((Object)addReqDto.getBusinessTypeName(), (String)"\u4e1a\u52a1\u5206\u7ec4\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        } else {
            AssertUtils.notNull((Object)addReqDto.getBusinessTypeName(), (String)"\u4e1a\u52a1\u7c7b\u578b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)addReqDto.getParentName(), (String)"\u7236\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)addReqDto.getAutoOut(), (String)"\u672a\u8bbe\u7f6e\u662f\u5426\u81ea\u52a8\u51fa\u5e93");
        }
    }

    private boolean isGroup(InOtherStorageBusinessTypeDto dto) {
        return "0".equals(dto.getParentCode());
    }

    private RestResponse<Long> addServiceGroup(InOtherStorageBusinessTypeDto addReqDto) {
        InOtherStorageBusinessTypeEo eo = new InOtherStorageBusinessTypeEo();
        BeanUtils.copyProperties((Object)addReqDto, (Object)eo, (String[])new String[]{"id"});
        this.domain.insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    private RestResponse<Long> addServiceType(InOtherStorageBusinessTypeDto addReqDto) {
        InOtherStorageBusinessTypeEo serviceGroup = (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeCode, (Object)addReqDto.getParentCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        AssertUtils.notNull((Object)serviceGroup, (String)"\u4e1a\u52a1\u7c7b\u578b\u6240\u5c5e\u7684\u4e1a\u52a1\u5206\u7ec4\u4e0d\u5b58\u5728");
        InOtherStorageBusinessTypeEo eo = new InOtherStorageBusinessTypeEo();
        BeanUtils.copyProperties((Object)addReqDto, (Object)eo, (String[])new String[]{"id"});
        eo.setParentCode(serviceGroup.getBusinessTypeCode());
        eo.setParentName(serviceGroup.getBusinessTypeName());
        this.domain.insert((BaseEo)eo);
        this.dictMapping(eo);
        return new RestResponse((Object)eo.getId());
    }

    private void dictMapping(InOtherStorageBusinessTypeEo eo) {
        String typeCode = eo.getType();
        String typeStatement = "";
        switch (typeCode) {
            case "other_out": {
                typeStatement = "\u5176\u4ed6\u51fa\u5e93\u4e1a\u52a1\u7c7b\u578b";
                break;
            }
            case "other_in": {
                typeStatement = "\u5176\u4ed6\u5165\u5e93\u4e1a\u52a1\u7c7b\u578b";
            }
        }
        DictDto dictDto = new DictDto();
        dictDto.setGroupCode(typeCode);
        dictDto.setCode(typeCode);
        dictDto.setValue(typeCode);
        dictDto.setStatement(typeStatement);
        dictDto.setType("enum");
        dictDto.setStatus(Integer.valueOf(1));
        ArrayList<DictValueDto> dictValueDtos = new ArrayList<DictValueDto>();
        DictValueDto dictValueDto = new DictValueDto();
        dictValueDto.setStatus(YesNoEnum.YES.getValue());
        dictValueDto.setValue(eo.getBusinessTypeCode());
        dictValueDto.setLabel(eo.getBusinessTypeName());
        dictValueDtos.add(dictValueDto);
        dictDto.setDictValueList(dictValueDtos);
        this.dictApi.saveOrModify4Lcd(dictDto);
    }

    @Override
    public RestResponse<Long> add(InOtherStorageBusinessTypeDto addReqDto) {
        this.checkAddParam(addReqDto);
        InOtherStorageBusinessTypeEo eo = this.isGroup(addReqDto) ? (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeName, (Object)addReqDto.getBusinessTypeName())).eq(InOtherStorageBusinessTypeEo::getType, (Object)addReqDto.getType())).eq(InOtherStorageBusinessTypeEo::getParentCode, (Object)addReqDto.getParentCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue())) : (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeName, (Object)addReqDto.getBusinessTypeName())).eq(InOtherStorageBusinessTypeEo::getType, (Object)addReqDto.getType())).ne(InOtherStorageBusinessTypeEo::getParentCode, (Object)"0")).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        String errMsg = this.isGroup(addReqDto) ? "\u4e1a\u52a1\u5206\u7ec4\u5df2\u5b58\u5728\u3002" : "\u4e1a\u52a1\u7c7b\u578b\u5df2\u5b58\u5728\u3002";
        AssertUtils.isNull((Object)eo, (String)errMsg, (Object[])new Object[0]);
        addReqDto.setBusinessTypeCode(this.convertToEnglishEnum(addReqDto.getBusinessTypeName()));
        return this.isGroup(addReqDto) ? this.addServiceGroup(addReqDto) : this.addServiceType(addReqDto);
    }

    private int updateOpt(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        int n;
        InOtherStorageBusinessTypeEo updateEo = new InOtherStorageBusinessTypeEo();
        BeanUtil.copyProperties((Object)reqDto, (Object)updateEo, (String[])new String[0]);
        if (!reqDto.getBusinessTypeName().equals(eo.getBusinessTypeName()) && this.isGroup(reqDto)) {
            List subtypeList = this.domain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getParentCode, (Object)eo.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
            subtypeList.forEach(o -> o.setParentName(updateEo.getBusinessTypeName()));
            if (CollectionUtils.isNotEmpty((Collection)subtypeList)) {
                this.domain.getMapper().updateBatchByIds(subtypeList);
            }
        }
        if ((n = this.domain.updateSelective((BaseEo)updateEo)) <= 0) {
            log.warn("\u6570\u636e: {} \u4fee\u6539\u5931\u8d25!", JSON.toJSON((Object)updateEo));
            throw new RuntimeException("\u6570\u636e\u4fee\u6539\u5931\u8d25!");
        }
        return n;
    }

    private RestResponse<Integer> editServiceGroup(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        if (!Objects.equals(eo.getStatus(), reqDto.getStatus())) {
            if (1 == reqDto.getStatus() && eo.getStatus() == 0) {
                return this.enableServiceGroup(reqDto, eo);
            }
            if (0 == reqDto.getStatus() && eo.getStatus() == 1) {
                return this.disableServiceGroup(reqDto, eo);
            }
            throw new BizException("\u7f16\u8f91\u5931\u8d25, \u72b6\u6001\u5f02\u5e38!");
        }
        AssertUtils.isTrue((eo.getStatus() == 0 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5931\u8d25! \u542f\u7528\u72b6\u6001\u4e0b\u65e0\u6cd5\u7f16\u8f91");
        int n = this.updateOpt(reqDto, eo);
        return new RestResponse((Object)n);
    }

    private RestResponse<Integer> enableServiceGroup(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        int n = this.updateOpt(reqDto, eo);
        return new RestResponse((Object)n);
    }

    private RestResponse<Integer> disableServiceGroup(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        List subtypeList = this.domain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getParentCode, (Object)reqDto.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        List enableSubtypeList = subtypeList.stream().filter(o -> 1 == o.getStatus()).collect(Collectors.toList());
        if (!enableSubtypeList.isEmpty()) {
            log.info("\u4e1a\u52a1\u5206\u7ec4: {}\u7981\u7528\u5931\u8d25:\u5b58\u5728\u5b50\u7c7b\u578b: {}\u4e0d\u662f\u7981\u7528\u72b6\u6001", JSON.toJSON((Object)reqDto), JSON.toJSON(enableSubtypeList));
            throw new BizException("\u8be5\u4e1a\u52a1\u5206\u7ec4\u6709\u4e1a\u52a1\u7c7b\u578b\u542f\u7528\u4e2d\uff0c\u65e0\u6cd5\u7981\u7528");
        }
        int n = this.updateOpt(reqDto, eo);
        return new RestResponse((Object)n);
    }

    private RestResponse<Integer> editServiceType(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        InOtherStorageBusinessTypeEo parenType = (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeCode, (Object)reqDto.getParentCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        AssertUtils.notNull((Object)parenType, (String)"\u7f16\u8f91\u5931\u8d25, \u4e1a\u52a1\u7c7b\u578b\u6240\u5c5e\u5206\u7ec4\u4e0d\u5b58\u5728");
        if (!Objects.equals(eo.getStatus(), reqDto.getStatus())) {
            if (1 == reqDto.getStatus() && eo.getStatus() == 0) {
                return this.enableServiceType(reqDto, eo);
            }
            if (0 == reqDto.getStatus() && eo.getStatus() == 1) {
                return this.disableServiceType(reqDto, eo);
            }
            throw new BizException("\u72b6\u6001\u5c5e\u6027\u503c\u65e0\u6548");
        }
        AssertUtils.isTrue((eo.getStatus() == 0 ? 1 : 0) != 0, (String)"\u7f16\u8f91\u5931\u8d25! \u542f\u7528\u72b6\u6001\u4e0b\u65e0\u6cd5\u7f16\u8f91");
        int n = this.updateOpt(reqDto, eo);
        eo = (InOtherStorageBusinessTypeEo)this.domain.getMapper().findById(eo.getId());
        this.dictMapping(eo);
        return new RestResponse((Object)n);
    }

    private RestResponse<Integer> enableServiceType(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        InOtherStorageBusinessTypeEo parenType = (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeCode, (Object)reqDto.getParentCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        if (0 == parenType.getStatus()) {
            log.info("\u542f\u7528\u5931\u8d25: \u8be5\u4e1a\u52a1\u7c7b\u578b\u6240\u5c5e\u4e1a\u52a1\u5206\u7ec4: {} \u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u542f\u7528", JSON.toJSON((Object)parenType));
            throw new BizException("\u8be5\u4e1a\u52a1\u7c7b\u578b\u6240\u5c5e\u5206\u7ec4\u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u542f\u7528");
        }
        int n = this.updateOpt(reqDto, eo);
        return new RestResponse((Object)n);
    }

    private RestResponse<Integer> disableServiceType(InOtherStorageBusinessTypeDto reqDto, InOtherStorageBusinessTypeEo eo) {
        List orderEoList = this.inOtherStorageOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageOrderEo.class).eq(InOtherStorageOrderEo::getBusinessType, (Object)eo.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        AssertUtils.isTrue((boolean)orderEoList.isEmpty(), (String)"\u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u53ef\u7981\u7528");
        int n = this.updateOpt(reqDto, eo);
        return new RestResponse((Object)n);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Integer> edit(InOtherStorageBusinessTypeDto reqDto) {
        this.checkAddParam(reqDto);
        AssertUtils.notNull((Object)reqDto.getBusinessTypeCode(), (String)"\u4e3b\u4e1a\u52a1\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageBusinessTypeEo eo = (InOtherStorageBusinessTypeEo)this.domain.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeCode, (Object)reqDto.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
        AssertUtils.notNull((Object)eo, (String)"\u7f16\u8f91\u5931\u8d25, \u4e1a\u52a1\u5206\u7ec4\u6216\u8005\u4e1a\u52a1\u7c7b\u578b\u4e0d\u5b58\u5728");
        return this.isGroup(reqDto) ? this.editServiceGroup(reqDto, eo) : this.editServiceType(reqDto, eo);
    }

    @Override
    public RestResponse<Void> removeById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageBusinessTypeEo eo = (InOtherStorageBusinessTypeEo)this.domain.getMapper().findById(id);
        InOtherStorageBusinessTypeDto dto = new InOtherStorageBusinessTypeDto();
        BeanCopyUtil.copyProperties((Object)eo, (Object)dto);
        String titleMsg = this.isGroup(dto) ? "\u4e1a\u52a1\u5206\u7ec4" : "\u4e1a\u52a1\u7c7b\u578b";
        AssertUtils.notNull((Object)eo, (String)(titleMsg + "\u4e0d\u5b58\u5728"));
        AssertUtils.isTrue((eo.getStatus() == 0 ? 1 : 0) != 0, (String)(titleMsg + "\u5904\u4e8e\u542f\u7528\u72b6\u6001, \u4e0d\u80fd\u5220\u9664"));
        AssertUtils.isTrue((null == eo.getCandel() || eo.getCandel() == 1 ? 1 : 0) != 0, (String)("\u8be5" + titleMsg + "\u914d\u7f6e\u4e3a\u4e0d\u53ef\u5220\u9664!"));
        if (this.isGroup(dto)) {
            List subtypeList = this.domain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getParentCode, (Object)eo.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
            if (CollectionUtils.isNotEmpty((Collection)subtypeList)) {
                log.info("\u4e1a\u52a1\u5206\u7ec4\u5220\u9664\u5931\u8d25, \u8be5\u4e1a\u52a1\u5206\u7ec4\u5b58\u5728\u5b50\u7c7b\u578b: {}", JSON.toJSON((Object)subtypeList));
                throw new BizException("\u4e1a\u52a1\u5206\u7ec4\u5b58\u5728\u6709\u5b50\u7c7b\u578b\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\uff0c\u4e0d\u80fd\u5220\u9664");
            }
        } else {
            List orderEoList = this.inOtherStorageOrderDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(InOtherStorageOrderEo.class).eq(InOtherStorageOrderEo::getBusinessType, (Object)eo.getBusinessTypeCode())).eq(BaseEo::getDr, (Object)YesNoEnum.NO.getValue()));
            if (CollectionUtils.isNotEmpty((Collection)orderEoList)) {
                log.info("\u4e1a\u52a1\u7c7b\u578b\u5220\u9664\u5931\u8d25, \u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u88ab\u5355\u636e: {} \u4f7f\u7528", JSON.toJSON((Object)orderEoList));
                throw new BizException("\u8be5\u4e1a\u52a1\u7c7b\u578b\u5df2\u88ab\u4f7f\u7528\uff0c\u4e0d\u53ef\u5220\u9664");
            }
        }
        this.domain.logicDeleteById(id);
        this.deleteDictMapping(eo);
        return new RestResponse();
    }

    private void deleteDictMapping(InOtherStorageBusinessTypeEo eo) {
        String typeCode = eo.getType();
        String typeStatement = "";
        switch (typeCode) {
            case "other_out": {
                typeStatement = "\u5176\u4ed6\u51fa\u5e93\u4e1a\u52a1\u7c7b\u578b";
                break;
            }
            case "other_in": {
                typeStatement = "\u5176\u4ed6\u5165\u5e93\u4e1a\u52a1\u7c7b\u578b";
            }
        }
        DictDto dictDto = new DictDto();
        dictDto.setGroupCode(typeCode);
        dictDto.setCode(typeCode);
        dictDto.setValue(typeCode);
        dictDto.setStatement(typeStatement);
        dictDto.setType("enum");
        dictDto.setStatus(Integer.valueOf(1));
        ArrayList<DictValueDto> dictValueDtos = new ArrayList<DictValueDto>();
        DictValueDto dictValueDto = new DictValueDto();
        dictValueDto.setStatus(YesNoEnum.YES.getValue());
        dictValueDto.setValue(eo.getBusinessTypeCode());
        dictValueDto.setLabel(eo.getBusinessTypeName());
        dictValueDtos.add(dictValueDto);
        dictDto.setDictValueList(dictValueDtos);
        this.dictValueApiProxy.deleteDictValue(dictDto);
    }

    @Override
    public RestResponse<PageInfo<InOtherStorageBusinessTypeDto>> queryPage(InOtherStorageBusinessTypePageReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getPageNum(), (String)"\u9875\u9762\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)reqDto.getPageSize(), (String)"\u9875\u9762\u884c\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        InOtherStorageBusinessTypeEo eo = new InOtherStorageBusinessTypeEo();
        BeanCopyUtil.copyProperties((Object)reqDto, (Object)eo);
        PageInfo eoPage = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.domain.filter().eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getParentCode()), (Object)"parent_code", (Object)reqDto.getParentCode())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getType()), (Object)"type", (Object)reqDto.getType())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBusinessTypeCode()), (Object)"business_type_code", (Object)reqDto.getBusinessTypeCode())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getBusinessTypeCodeList()), (Object)"business_type_code", (Collection)reqDto.getBusinessTypeCodeList())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getBusinessTypeName()), (Object)"business_type_name", (Object)reqDto.getBusinessTypeName())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getBusinessTypeNameList()), (Object)"business_type_name", (Collection)reqDto.getBusinessTypeNameList())).eq(null != reqDto.getStatus(), (Object)"status", (Object)reqDto.getStatus())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getAutoOut()), (Object)"auto_out", (Object)reqDto.getAutoOut())).eq(StringUtils.isNotBlank((CharSequence)reqDto.getCandel()), (Object)"candel", (Object)reqDto.getCandel())).orderByDesc((Object)"create_time")).page(reqDto.getPageNum(), reqDto.getPageSize());
        PageInfo dtoPage = new PageInfo();
        BeanUtil.copyProperties((Object)eoPage, (Object)dtoPage, (String[])new String[]{"list"});
        LinkedList dtoList = new LinkedList();
        if (!eoPage.getList().isEmpty()) {
            eoPage.getList().forEach(o -> {
                InOtherStorageBusinessTypeDto dto = new InOtherStorageBusinessTypeDto();
                BeanCopyUtil.copyProperties((Object)o, (Object)dto);
                dtoList.add(dto);
            });
            dtoPage.setList(dtoList);
        }
        return new RestResponse((Object)dtoPage);
    }

    private String convertToEnglishEnum(String chinese) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        boolean flag = false;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            for (char c : chinese.toCharArray()) {
                String[] pinyinArray = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)format);
                if (pinyinArray != null && pinyinArray.length > 0) {
                    stringBuilder.append(pinyinArray[0].toUpperCase());
                    flag = true;
                    continue;
                }
                stringBuilder.append(flag ? InventoryConfig.getCommonSeparate() + c : Character.valueOf(c));
                flag = false;
            }
            List nameList = this.domain.getMapper().selectList((Wrapper)Wrappers.lambdaQuery(InOtherStorageBusinessTypeEo.class).eq(InOtherStorageBusinessTypeEo::getBusinessTypeName, (Object)chinese));
            if (CollectionUtils.isNotEmpty((Collection)nameList)) {
                stringBuilder.append(nameList.size());
            }
            return stringBuilder.toString();
        }
        catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            return "";
        }
    }
}

