/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.config;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CommitEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryThirdAuditConfigurationDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InOtherStorageOrderDto;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageAuditPassAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageCancelAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageFinishAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageReceiveDeliveryAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageReceiveDeliveryPartAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageSaveAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.InOutStorageWithdrawAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.OtherStorageOrderPreemptionChoiceAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.actions.OtherStorageReleasePreemptionAction;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgExternalAuditStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgOtherStorageOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.guards.AuditOtherStorageOrderCheckChoiceGuard;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.guards.CancelWmsNoticeGuard;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.guards.OutInNoticeOrderIsAllShipGuard;
import com.yunxi.dg.base.center.inventory.service.helper.InventoryCheckHelper;
import com.yunxi.dg.base.center.inventory.service.third.PushThirdAuditBo;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineHelper;
import com.yunxi.dg.base.center.inventory.statemachine.executor.OtherInOutStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.StateMachineConfigurerAdapter;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.statemachine.state.State;

@Configuration
@EnableStateMachineFactory(name={"otherStorageOrderStateMachineFactory"})
public class DgOtherStateMachineBuilder
extends StateMachineConfigurerAdapter<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(DgOtherStateMachineBuilder.class);
    @Resource
    private IInOtherStorageOrderDomain otherStorageOrderDomain;
    @Resource
    private IInOtherStorageOrderDetailDomain otherStorageOrderDetailDomain;
    @Resource
    private OtherStorageOrderPreemptionChoiceAction otherStorageOrderPreemptionChoiceAction;
    @Resource
    private InOutStorageAuditPassAction inOutNoticeAuditPassAction;
    @Resource
    private OtherStorageReleasePreemptionAction otherStorageReleasePreemptionAction;
    @Resource
    private InOutStorageWithdrawAction inOutNoticeWithdrawAction;
    @Resource
    private OutInNoticeOrderIsAllShipGuard outInNoticeOrderIsAllShipGuard;
    @Resource
    private InOutStorageReceiveDeliveryAction inOutStorageReceiveDeliveryAction;
    @Resource
    private InOutStorageFinishAction inOutStorageFinishAction;
    @Resource
    private CancelWmsNoticeGuard cancelWmsNoticeGuard;
    @Resource
    private InOutStorageCancelAction inOutStorageCancelAction;
    @Resource
    private InOutStorageSaveAction inOutStorageSaveAction;
    @Resource
    private AuditOtherStorageOrderCheckChoiceGuard auditOtherStorageOrderCheckChoiceGuard;
    @Resource
    private InOutStorageReceiveDeliveryPartAction inOutStorageReceiveDeliveryPartAction;
    @Resource
    private IInventoryThirdAuditConfigurationDomain inventoryThirdAuditConfigurationDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private InventoryCheckHelper inventoryCheckHelper;
    @Resource
    @Lazy
    private OtherInOutStatemachineExecutor executor;

    public void configure(StateMachineStateConfigurer<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> states) throws Exception {
        states.withStates().initial((Object)DgOtherOrderStatusEnum.INIT).choice((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).choice((Object)DgOtherOrderStatusEnum.IN_INVENTORY_CHOISE).choice((Object)DgOtherOrderStatusEnum.OUT_INVENTORY_CHOISE).choice((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).choice((Object)DgOtherOrderStatusEnum.COMMIT_CHOISE).choice((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).choice((Object)DgOtherOrderStatusEnum.AUDIT_CHOISE).state((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.WAIT_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            if (DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT.getKey().equals(inOtherStorageOrderEo.getOrderStatus())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_WITHDRAW_SUCCEED.getKey());
            }
            this.inOtherStorageOrderSendMqAction();
        }).state((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            if (inOtherStorageOrderEo.getOrderStatus().equals(DgOtherOrderStatusEnum.WAIT_AUDIT.getKey())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDITING.getKey());
            } else if (DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT.getKey().equals(inOtherStorageOrderEo.getOrderStatus())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDIT_FAILED.getKey());
            }
            this.inOtherStorageOrderSendMqAction().execute(context);
        }).state((Object)DgOtherOrderStatusEnum.AUDIT_FAILED, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            if (DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT.getKey().equals(inOtherStorageOrderEo.getOrderStatus())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDIT_FAILED.getKey());
            }
            this.inOtherStorageOrderSendMqAction().execute(context);
        }).state((Object)DgOtherOrderStatusEnum.WAIT_IN, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            if (DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT.getKey().equals(inOtherStorageOrderEo.getOrderStatus())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDIT_PASS.getKey());
            }
            this.inOtherStorageOrderSendMqAction().execute(context);
        }).state((Object)DgOtherOrderStatusEnum.WAIT_OUT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            if (DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT.getKey().equals(inOtherStorageOrderEo.getOrderStatus())) {
                inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDIT_PASS.getKey());
            }
            this.inOtherStorageOrderSendMqAction().execute(context);
        }).state((Object)DgOtherOrderStatusEnum.PORTION_IN, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.PORTION_OUT, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.COMPLETED, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.FINISH, this.inOtherStorageOrderSendMqAction()).state((Object)DgOtherOrderStatusEnum.CANCEL, this.inOtherStorageOrderSendMqAction());
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> pushThirdAudit() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
                DgOtherStateMachineBuilder.this.otherStorageOrderPreemptionChoiceAction.execute(context);
                StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
                InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executorBo.getEo();
                eo.setExternalProcessState(DgExternalAuditStatusEnum.OA_AUDITING.getKey());
                TransactionCallBackService transactionCallBackService = new TransactionCallBackService();
                transactionCallBackService.execute(() -> {
                    boolean flag = true;
                    try {
                        InventoryConfig.getPushThirdAuditAble().push(PushThirdAuditBo.builder().businessOrderId(eo.getId()).businessOrderNo(eo.getStorageOrderNo()).businessType(eo.getBusinessType()).orderType(eo.getType()).userCode(requestUserCode).userName(requestUserCode).build());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        flag = false;
                    }
                    InOtherStorageOrderEo order = (InOtherStorageOrderEo)executorBo.getEo();
                    InOtherStorageOrderEo storageOrderEo = new InOtherStorageOrderEo();
                    storageOrderEo.setId(order.getId());
                    if (!flag) {
                        order.setExternalProcessState(DgExternalAuditStatusEnum.OA_PUSH_FAILED.getKey());
                        DgOtherStateMachineBuilder.this.otherStorageOrderDomain.updateSelective((BaseEo)storageOrderEo);
                        try {
                            ((InOtherStorageOrderEo)executorBo.getEo()).setExternalProcessState(DgExternalAuditStatusEnum.OA_PUSH_FAILED.getKey());
                            DgOtherStateMachineBuilder.this.executor.execute(DgOtherOrderStatusEventEnum.ROLLBACK, executorBo);
                        }
                        catch (Exception e) {
                            log.error("\u72b6\u6001\u673a\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                    }
                });
            }
        };
    }

    @NotNull
    private boolean pushThirdCancel(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executorBo.getEo();
        return InventoryConfig.getPushThirdAuditAble().cancel(PushThirdAuditBo.builder().businessOrderId(eo.getId()).businessOrderNo(eo.getStorageOrderNo()).businessType(eo.getBusinessType()).orderType(eo.getType()).userCode(requestUserCode).userName(requestUserCode).build());
    }

    public void configure(StateMachineConfigurationConfigurer<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> config) throws Exception {
        config.withConfiguration().machineId("inOutOther").autoStartup(true).listener((StateMachineListener)new StateMachineListenerAdapter<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            public void stateChanged(State<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> from, State<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> to) {
                log.info("State change to {}", (Object)((DgOtherOrderStatusEnum)((Object)to.getId())).getKey());
            }

            public void stateMachineStopped(StateMachine<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> stateMachine) {
                log.info("stateMachineStopped");
                if (stateMachine.hasStateMachineError()) {
                    log.info("stateMachineError");
                    return;
                }
                StatemachineExecutorBo executeBo = (StatemachineExecutorBo)stateMachine.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
                if (ObjectUtil.isEmpty((Object)executeBo) || StringUtils.isNotEmpty((CharSequence)executeBo.getErrorMsg())) {
                    return;
                }
                DgOtherOrderStatusEnum id = (DgOtherOrderStatusEnum)((Object)stateMachine.getState().getId());
                InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executeBo.getEo();
                if (ObjectUtil.isNull((Object)eo.getId())) {
                    return;
                }
                eo.setOrderStatus(id.getKey());
                DgOtherStateMachineBuilder.this.otherStorageOrderDomain.updateSelective((BaseEo)eo);
            }
        });
    }

    @Bean
    public OtherInOutStatemachineExecutor otherInOutStatemachineExecutor() {
        return new OtherInOutStatemachineExecutor();
    }

    @Bean
    public StateMachinePersister<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum, InOtherStorageOrderEo> otherInOutStatemachineExecutorPersister(OtherInOutStatemachineExecutor otherInOutStatemachineExecutor) {
        return new DefaultStateMachinePersister((StateMachinePersist)otherInOutStatemachineExecutor);
    }

    public void configure(StateMachineTransitionConfigurer<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> transitions) throws Exception {
        ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)DgOtherOrderStatusEnum.INIT)).event((Object)DgOtherOrderStatusEventEnum.SAVE)).target((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).action(context -> this.inOutStorageSaveAction.execute(context))).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgOtherOrderStatusEventEnum.SAVE)).target((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).action(context -> this.inOutStorageSaveAction.execute(context))).and()).withExternal().source((Object)DgOtherOrderStatusEnum.AUDIT_FAILED)).event((Object)DgOtherOrderStatusEventEnum.SAVE)).target((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).action(context -> this.inOutStorageSaveAction.execute(context))).and()).withExternal().source((Object)DgOtherOrderStatusEnum.AUDIT_FAILED)).event((Object)DgOtherOrderStatusEventEnum.SAVE)).target((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.SAVE_CHOISE).first((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT, context -> this.auditOtherStorageOrderCheckChoiceGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context), context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            boolean canAudit = this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1)) || this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
            inOtherStorageOrderEo.setExternalProcessState(canAudit ? DgExternalAuditStatusEnum.OA_WAIT_AUDIT.getKey() : DgExternalAuditStatusEnum.OA_DISPENSE_WITH.getKey());
        }).then((Object)DgOtherOrderStatusEnum.COMPLETED, context -> {
            InOtherStorageOrderDto inOtherStorageOrderDto = (InOtherStorageOrderDto)context.getExtendedState().getVariables().get(OtherStorageOrderContextEnum.UPDATE_OTHER_STORAGE.getCode());
            try {
                this.checkInventory((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context);
            }
            catch (Exception e) {
                context.getStateMachine().setStateMachineError(e);
                return false;
            }
            return CommitEnum.AUTOCOMPLETE.code().equals(inOtherStorageOrderDto.getCommitType());
        }, this.completed()).then((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT, context -> {
            try {
                this.checkInventory((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context);
            }
            catch (Exception e) {
                context.getStateMachine().setStateMachineError(e);
                return false;
            }
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
        }, this.pushThirdAudit()).last((Object)DgOtherOrderStatusEnum.WAIT_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_WAIT_AUDIT.getKey());
            this.otherStorageOrderPreemptionChoiceAction.execute(context);
        }).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgOtherOrderStatusEventEnum.SUBMIT)).target((Object)DgOtherOrderStatusEnum.COMMIT_CHOISE).action(this.getDgOtherOrderStatusEventEnumAction())).and()).withChoice().source((Object)DgOtherOrderStatusEnum.COMMIT_CHOISE).first((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
        }, this.pushThirdAudit()).last((Object)DgOtherOrderStatusEnum.WAIT_AUDIT).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDIT)).target((Object)DgOtherOrderStatusEnum.AUDIT_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.AUDIT_CHOISE).first((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(2));
        }, this.pushThirdAudit()).last((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
            inOtherStorageOrderEo.setExternalProcessState(DgExternalAuditStatusEnum.OA_DISPENSE_WITH.getKey());
        }).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDIT)).target((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDIT)).target((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.TWO_AUDIT)).target((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDIT)).target((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.TWO_AUDIT)).target((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.WAIT_INVENTORY_CHOISE).first((Object)DgOtherOrderStatusEnum.WAIT_IN, context -> {
            StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getStateMachine().getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
            return ObjectUtil.equals((Object)((InOtherStorageOrderEo)executorBo.getEo()).getType(), (Object)DgOtherStorageOrderTypeEnum.IN.getCode());
        }, context -> this.inOutNoticeAuditPassAction.execute(context)).last((Object)DgOtherOrderStatusEnum.WAIT_OUT, (Action)this.inOutNoticeAuditPassAction).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDITFAILED)).target((Object)DgOtherOrderStatusEnum.AUDIT_FAILED).action((Action)this.otherStorageReleasePreemptionAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDITFAILED)).target((Object)DgOtherOrderStatusEnum.AUDIT_FAILED).action(this.auditFailed())).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDITFAILED)).target((Object)DgOtherOrderStatusEnum.AUDIT_FAILED).action((Action)this.otherStorageReleasePreemptionAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.AUDITFAILED)).target((Object)DgOtherOrderStatusEnum.AUDIT_FAILED).action(this.auditFailed())).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.WITHDRAW)).target((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_OUT)).event((Object)DgOtherOrderStatusEventEnum.WITHDRAW)).target((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).action(context -> this.inOutNoticeWithdrawAction.execute(context))).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_IN)).event((Object)DgOtherOrderStatusEventEnum.WITHDRAW)).target((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).action(context -> this.inOutNoticeWithdrawAction.execute(context))).and()).withChoice().source((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).first((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT, context -> {
            StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
        }, this::pushThirdCancel).last((Object)DgOtherOrderStatusEnum.WAIT_AUDIT).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_IN)).event((Object)DgOtherOrderStatusEventEnum.RECEIVE)).target((Object)DgOtherOrderStatusEnum.IN_INVENTORY_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.IN_INVENTORY_CHOISE).first((Object)DgOtherOrderStatusEnum.COMPLETED, context -> this.outInNoticeOrderIsAllShipGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context), context -> this.inOutStorageReceiveDeliveryAction.execute(context)).then((Object)DgOtherOrderStatusEnum.FINISH, this.checkFinish(), context -> this.inOutStorageFinishAction.execute(context)).last((Object)DgOtherOrderStatusEnum.PORTION_IN, context -> this.inOutStorageReceiveDeliveryPartAction.execute(context)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.PORTION_IN)).event((Object)DgOtherOrderStatusEventEnum.RECEIVE)).target((Object)DgOtherOrderStatusEnum.IN_INVENTORY_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.IN_INVENTORY_CHOISE).first((Object)DgOtherOrderStatusEnum.COMPLETED, context -> this.outInNoticeOrderIsAllShipGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context), context -> this.inOutStorageReceiveDeliveryAction.execute(context)).then((Object)DgOtherOrderStatusEnum.FINISH, this.checkFinish(), context -> this.inOutStorageFinishAction.execute(context)).last((Object)DgOtherOrderStatusEnum.PORTION_IN, context -> this.inOutStorageReceiveDeliveryPartAction.execute(context)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_OUT)).event((Object)DgOtherOrderStatusEventEnum.DELIVERY)).target((Object)DgOtherOrderStatusEnum.OUT_INVENTORY_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.OUT_INVENTORY_CHOISE).first((Object)DgOtherOrderStatusEnum.COMPLETED, context -> this.outInNoticeOrderIsAllShipGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context), context -> this.inOutStorageReceiveDeliveryAction.execute(context)).then((Object)DgOtherOrderStatusEnum.FINISH, this.checkFinish(), this.doFinish()).last((Object)DgOtherOrderStatusEnum.PORTION_OUT, (Action)this.inOutStorageReceiveDeliveryPartAction).and()).withExternal().source((Object)DgOtherOrderStatusEnum.PORTION_OUT)).event((Object)DgOtherOrderStatusEventEnum.DELIVERY)).target((Object)DgOtherOrderStatusEnum.OUT_INVENTORY_CHOISE).and()).withChoice().source((Object)DgOtherOrderStatusEnum.OUT_INVENTORY_CHOISE).first((Object)DgOtherOrderStatusEnum.COMPLETED, context -> this.outInNoticeOrderIsAllShipGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context), context -> this.inOutStorageReceiveDeliveryAction.execute(context)).then((Object)DgOtherOrderStatusEnum.FINISH, this.checkFinish(), this.doFinish()).last((Object)DgOtherOrderStatusEnum.PORTION_OUT, (Action)this.inOutStorageReceiveDeliveryPartAction).and()).withExternal().source((Object)DgOtherOrderStatusEnum.PORTION_IN)).event((Object)DgOtherOrderStatusEventEnum.FINISHIN)).target((Object)DgOtherOrderStatusEnum.FINISH).action((Action)this.inOutStorageFinishAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.PORTION_OUT)).event((Object)DgOtherOrderStatusEventEnum.FINISHOUT)).target((Object)DgOtherOrderStatusEnum.FINISH).action((Action)this.inOutStorageFinishAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_OUT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).guard(context -> this.cancelWmsNoticeGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context))).action((Action)this.inOutStorageCancelAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.AUDIT_FAILED)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_IN)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).guard(context -> this.cancelWmsNoticeGuard.evaluate((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context))).action((Action)this.inOutStorageCancelAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).guard(context -> true)).action((Action)this.otherStorageReleasePreemptionAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).action((Action)this.otherStorageReleasePreemptionAction)).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).action(this.cancelAction())).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.WITHDRAW)).target((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT).action(this.cancelAction())).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.WITHDRAW)).target((Object)DgOtherOrderStatusEnum.WITHDRAW_CHOISE).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.CANCEL)).target((Object)DgOtherOrderStatusEnum.CANCEL).action(this.cancelAction())).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.ROLLBACK)).target((Object)DgOtherOrderStatusEnum.WAIT_SUBMIT).and()).withExternal().source((Object)DgOtherOrderStatusEnum.WAIT_THIRD_TWO_AUDIT)).event((Object)DgOtherOrderStatusEventEnum.ROLLBACK)).target((Object)DgOtherOrderStatusEnum.WAIT_AUDIT);
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> auditFailed() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                DgOtherStateMachineBuilder.this.otherStorageReleasePreemptionAction.execute(context);
            }
        };
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> completed() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                DgOtherStateMachineBuilder.this.inOutNoticeAuditPassAction.execute(context);
                DgOtherStateMachineBuilder.this.inOutStorageReceiveDeliveryPartAction.execute(context);
                DgOtherStateMachineBuilder.this.inOutStorageFinishAction.doWriteBack(context);
            }
        };
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> cancelAction() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                if (DgOtherStateMachineBuilder.this.pushThirdCancel((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context)) {
                    DgOtherStateMachineBuilder.this.otherStorageReleasePreemptionAction.execute(context);
                }
            }
        };
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> doFinish() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                DgOtherStateMachineBuilder.this.inOutStorageFinishAction.doWriteBack(context);
            }
        };
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> getDgOtherOrderStatusEventEnumAction() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                DgOtherStateMachineBuilder.this.checkInventory((StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>)context);
                StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
                boolean flag = DgOtherStateMachineBuilder.this.inventoryThirdAuditConfigurationDomain.canThirdAudit(((InOtherStorageOrderEo)executorBo.getEo()).getType(), ((InOtherStorageOrderEo)executorBo.getEo()).getBusinessType(), Integer.valueOf(1));
                InOtherStorageOrderEo eo = (InOtherStorageOrderEo)executorBo.getEo();
                if (!flag) {
                    log.info("\u662f\u975e\u7b2c\u4e09\u65b9\u5ba1\u6838\u9884\u5360");
                    DgOtherStateMachineBuilder.this.otherStorageOrderPreemptionChoiceAction.execute(context);
                } else {
                    eo.setExternalProcessState(DgExternalAuditStatusEnum.OA_WAIT_AUDIT.getKey());
                }
            }
        };
    }

    private void checkInventory(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
        StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
        InOtherStorageOrderEo executorBoEo = (InOtherStorageOrderEo)executorBo.getEo();
        if (DgOtherStorageOrderTypeEnum.OUT.getCode().equals(executorBoEo.getType())) {
            List variables = Optional.ofNullable(executorBo.getVariables(OtherStorageOrderContextEnum.OTHER_STORAGE_ORDER_DETAIL.getCode())).map(r -> (List)r).orElseGet(() -> ((ExtQueryChainWrapper)this.otherStorageOrderDetailDomain.filter().eq((Object)"storage_order_no", (Object)executorBoEo.getStorageOrderNo())).list());
            this.inventoryCheckHelper.inventoryCheck(variables.stream().collect(Collectors.groupingBy(InOtherStorageOrderDetailEo::getSkuCode, Collectors.mapping(InOtherStorageOrderDetailEo::getQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))), executorBoEo.getWarehouseCode(), executorBoEo.getSubWarehouseCode());
        }
    }

    @NotNull
    private Action<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> inOtherStorageOrderSendMqAction() {
        return new AbstractAction<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum>(){

            @Override
            protected void doExecute(StateContext<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> context) {
                StatemachineExecutorBo executorBo = StatemachineHelper.getExecutorBo(context);
                InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)executorBo.getEo();
                inOtherStorageOrderEo.setOrderStatus(((DgOtherOrderStatusEnum)((Object)context.getStateMachine().getState().getId())).getKey());
                log.info("\u5176\u4ed6\u51fa\u5165\u5e93\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001:{},{}", (Object)inOtherStorageOrderEo.getStorageOrderNo(), (Object)inOtherStorageOrderEo.getExternalOrderNo());
                DgOtherStateMachineBuilder.this.commonsMqService.publishMessage("PUBLISH_TOPIC", "OTHER_STORAGE_ORDER", (Object)JSON.toJSONString((Object)inOtherStorageOrderEo));
            }
        };
    }

    private Guard<DgOtherOrderStatusEnum, DgOtherOrderStatusEventEnum> checkFinish() {
        return context -> {
            log.info("\u5165\u5e93\u5224\u65ad\u662f\u5426\u5b8c\u7ed3\u3002\u3002\u3002{}", (Object)JSONObject.toJSONString((Object)context));
            String storageOrderNo = (String)context.getExtendedState().getVariables().get("storageOrderNo");
            return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)storageOrderNo)).in((Object)"order_status", new Object[]{BaseOrderStatusEnum.FINISH_OVER.getCode()})).count() > 0;
        };
    }
}

