/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.plan.Impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.PlanOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IBaseOrderAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderDetailExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderReduceDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassRecordEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassRecordService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.inspection.stateMachine.enums.DgInspectionPassRecordStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.other.impl.OtherStorageOrderContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.IPlanOrderService;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.plan.stateMachine.enums.DgPlanOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineMap;
import com.yunxi.dg.base.center.inventory.statemachine.executor.PlanStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.transcation.TransactionAfterService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Disabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PlanOrderServiceImpl
extends BaseServiceImpl<PlanOrderDto, PlanOrderEo, IPlanOrderDomain>
implements IPlanOrderService {
    private static final Logger log = LoggerFactory.getLogger(PlanOrderServiceImpl.class);
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IPlanOrderDetailDomain planOrderDetailDomain;
    @Resource
    private PlanStatemachineExecutor planStatemachineExecutor;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IBaseOrderAddressDomain baseOrderAddressDomain;
    @Resource
    private IPlanOrderService planOrderService;
    @Resource
    private TransactionAfterService transactionAfterService;
    @Resource
    protected IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    private IInspectionPassDomain inspectionPassDomain;
    @Resource
    private IInspectionPassRecordService inspectionPassRecordService;
    @Resource
    IItemSkuDgQueryApiProxy itemSkuProxy;
    @Resource
    private ILockService lockService;

    public PlanOrderServiceImpl(IPlanOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PlanOrderDto, PlanOrderEo> converter() {
        return PlanOrderConverter.INSTANCE;
    }

    @Override
    public Long addPlanOrder(PlanOrderExtDto planOrderDto) {
        log.info("\u6dfb\u52a0\u8ba1\u5212\u7c7b\u5165\u51fa\u5e93\u5355\u636e,\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)planOrderDto));
        String organizationCode = null;
        PlanOrderEo orderEo = new PlanOrderEo();
        boolean updateFlag = Objects.nonNull(planOrderDto.getId());
        if (updateFlag) {
            orderEo = (PlanOrderEo)((IPlanOrderDomain)this.domain).selectByPrimaryKey(planOrderDto.getId());
            AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
            planOrderDto.setOrderNo(orderEo.getOrderNo());
            planOrderDto.setExtension(orderEo.getExtension());
            planOrderDto.setSourceSystem(orderEo.getSourceSystem());
            organizationCode = orderEo.getOrganizationCode();
            if (StringUtils.isEmpty((CharSequence)orderEo.getExternalOrderNo())) {
                organizationCode = null;
            }
        }
        LogicWarehouseEo logicWarehouseEo = this.checkLogicWarehouse(planOrderDto.getLogicWarehouseCode());
        this.checkPhysicsWarehouse(planOrderDto.getPhysicsWarehouseCode());
        List planOrderDetailDtos = planOrderDto.getPlanOrderDetailExtList();
        this.checkSku(planOrderDetailDtos);
        PlanOrderEo insertEo = (PlanOrderEo)PlanOrderConverter.INSTANCE.toEo((BaseDto)planOrderDto);
        insertEo.setInventoryProperty(Optional.ofNullable(planOrderDto.getInventoryProperty()).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
        String code = planOrderDto.getOrderNo();
        if (StringUtils.isBlank((CharSequence)code)) {
            insertEo.setOrderNo(InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.valueOf(planOrderDto.getOrderType())));
        } else {
            insertEo.setOrderNo(code);
        }
        this.computerVolumeAndQuantity(planOrderDetailDtos, insertEo);
        insertEo.setOrganizationName(logicWarehouseEo.getOrganizationName());
        insertEo.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
        if (Objects.isNull(planOrderDto.getBizDate())) {
            insertEo.setBizDate(new Date());
        }
        insertEo.setLogicWarehouseName(logicWarehouseEo.getWarehouseName());
        if (StringUtils.isEmpty((CharSequence)organizationCode)) {
            insertEo.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
        }
        ArrayList<PlanOrderDetailEo> eoList = new ArrayList<PlanOrderDetailEo>(planOrderDetailDtos.size());
        BigDecimal totalQuantity = BigDecimal.ZERO;
        for (PlanOrderDetailExtDto detail : planOrderDetailDtos) {
            PlanOrderDetailEo detailEo = new PlanOrderDetailEo();
            BeanUtil.copyProperties((Object)detail, (Object)detailEo, (String[])new String[0]);
            detailEo.setInventoryProperty((String)DataExtractUtils.ifNullElse((Object)detail.getInventoryProperty(), (Object)insertEo.getInventoryProperty()));
            detailEo.setId((Long)ObjectUtils.defaultIfNull((Object)detail.getId(), (Object)IdUtil.getSnowflake().nextId()));
            detailEo.setOrigLineId(detailEo.getId());
            detailEo.setUnit(detail.getUnit());
            detailEo.setOrderNo(insertEo.getOrderNo());
            String parentOrderNo = detailEo.getParentOrderNo();
            detailEo.setParentOrderNo(StrUtil.blankToDefault((CharSequence)parentOrderNo, (String)insertEo.getParentOrderNo()));
            String externalOrderNo = detailEo.getExternalOrderNo();
            detailEo.setExternalOrderNo(StrUtil.blankToDefault((CharSequence)externalOrderNo, (String)insertEo.getExternalOrderNo()));
            eoList.add(detailEo);
            totalQuantity = BigDecimalUtils.add((BigDecimal)totalQuantity, (BigDecimal)detail.getWaitQuantity());
        }
        insertEo.setTotalQuantity(totalQuantity);
        insertEo.setOrderStatus(DgPlanOrderStatusEnum.WAIT_SUBMIT.getKey());
        if (StringUtils.isBlank((CharSequence)planOrderDto.getOperationType())) {
            insertEo.setOperationType(DgPlanOrderTypeEnum.getOperationTypeByKey(insertEo.getOrderType()));
        }
        if (updateFlag) {
            ((IPlanOrderDomain)this.domain).updateSelective((BaseEo)insertEo);
            QueryWrapper planOrderDetailEoQueryWrapper = new QueryWrapper();
            planOrderDetailEoQueryWrapper.eq((Object)"order_no", (Object)code);
            planOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            this.planOrderDetailDomain.getMapper().delete((Wrapper)planOrderDetailEoQueryWrapper);
            QueryWrapper baseOrderAddressEoQueryWrapper = new QueryWrapper();
            baseOrderAddressEoQueryWrapper.eq((Object)"document_no", (Object)code);
            baseOrderAddressEoQueryWrapper.eq((Object)"order_type", (Object)insertEo.getOrderType());
            baseOrderAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            this.baseOrderAddressDomain.getMapper().delete((Wrapper)baseOrderAddressEoQueryWrapper);
        } else {
            ((IPlanOrderDomain)this.domain).insert((BaseEo)insertEo);
        }
        this.planOrderDetailDomain.insertBatch(eoList);
        if (Objects.nonNull(planOrderDto.getBaseOrderAddressAddReqDto())) {
            BaseOrderAddressEo addressEo = new BaseOrderAddressEo();
            CubeBeanUtils.copyProperties((Object)addressEo, (Object)planOrderDto.getBaseOrderAddressAddReqDto(), (String[])new String[0]);
            addressEo.setDocumentNo(insertEo.getOrderNo());
            addressEo.setOrderType(insertEo.getOrderType());
            this.baseOrderAddressDomain.insert((BaseEo)addressEo);
        }
        if ("syncAudit".equals(planOrderDto.getCommitType())) {
            this.planOrderService.commit(insertEo, orderEo, true);
        } else if ("commit".equals(planOrderDto.getCommitType()) || "autoAudit".equals(planOrderDto.getCommitType())) {
            this.planOrderService.commit(insertEo, orderEo, "autoAudit".equals(planOrderDto.getCommitType()));
        } else if ("autoComplete".equals(planOrderDto.getCommitType())) {
            StatemachineExecutorBo<PlanOrderEo> executorBo = new StatemachineExecutorBo<PlanOrderEo>();
            executorBo.setEo(insertEo);
            StatemachineMap storageOrderDetailListMap = new StatemachineMap();
            List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)insertEo.getOrderNo())).list();
            storageOrderDetailListMap.put("onlyGenResult", planOrderDto.isOnlyGenResult());
            executorBo.setVariables(storageOrderDetailListMap);
            storageOrderDetailListMap.put(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode(), detailEos);
            this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.AUTOCOMPLETE, executorBo);
        }
        this.addInspectionPassRecord(planOrderDto, insertEo, eoList);
        OptUtil.addOptLog((String)OperationLogTypeEnum.getEditType((boolean)updateFlag), (String)"EMPTY", (String)insertEo.getOrderNo(), (String)planOrderDto.getOrderType());
        return insertEo.getId();
    }

    private void addInspectionPassRecord(PlanOrderExtDto planOrderDto, PlanOrderEo insertEo, List<PlanOrderDetailEo> eoList) {
        List inspectionPassEos;
        if (CodeGenEnum.INSPECTION_PASS_ORDER.getRefTableName().equals(planOrderDto.getSourceSystem()) && "out".equals(DgPlanOrderTypeEnum.getOperationTypeByKey(insertEo.getOrderType())) && CollectionUtil.isNotEmpty((Collection)(inspectionPassEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().eq((Object)"inspection_no", (Object)planOrderDto.getExternalOrderNo())).orderByDesc((Object)"id")).list()))) {
            Map inspectionPassEosMap = inspectionPassEos.stream().collect(Collectors.toMap(e -> this.getMapKey(e.getSkuCode(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
            eoList.forEach(e -> {
                InspectionPassEo inspectionPassEo = (InspectionPassEo)inspectionPassEosMap.get(this.getMapKey(e.getSkuCode(), e.getBatch()));
                if (Objects.nonNull(inspectionPassEo)) {
                    InspectionPassRecordEo inspectionPassRecordEo = new InspectionPassRecordEo();
                    CubeBeanUtils.copyProperties((Object)inspectionPassRecordEo, (Object)inspectionPassEo, (String[])new String[]{"id"});
                    inspectionPassRecordEo.setRelevanceNo(insertEo.getOrderNo());
                    inspectionPassRecordEo.setBusinessType(insertEo.getBusinessType());
                    inspectionPassRecordEo.setOrderType(insertEo.getOrderType());
                    inspectionPassRecordEo.setQuantity(e.getPlanQuantity());
                    inspectionPassRecordEo.setPassStatus(DgInspectionPassRecordStatusEnum.WAIT_COMMIT.getKey());
                    this.inspectionPassRecordService.add(inspectionPassRecordEo, DgInspectionPassRecordStatusEventEnum.BUSINESS_ORDER_COMPLETE);
                    OptUtil.addOptLog((String)OperationLogTypeEnum.PURCHASE_REFUND.name(), (String)"EMPTY", (String)inspectionPassEo.getInspectionNo(), (String)CodeGenEnum.INSPECTION_PASS_ORDER.getCode());
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void commit(PlanOrderEo insertEo, PlanOrderEo orderEo, boolean autoAudit) {
        StatemachineExecutorBo<PlanOrderEo> executorBo = new StatemachineExecutorBo<PlanOrderEo>();
        executorBo.setEo(insertEo);
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)insertEo.getOrderNo())).list();
        executorBo.setVariables(storageOrderDetailListMap);
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode(), detailEos);
        this.planStatemachineExecutor.execute(DgPlanOrderStatusEnum.AUDIT_FAILED.getKey().equals(insertEo.getOrderStatus()) ? DgPlanOrderStatusEventEnum.RESUBMIT : DgPlanOrderStatusEventEnum.SUBMIT, executorBo);
        boolean isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(insertEo.getOrderType(), insertEo.getBusinessType());
        if (autoAudit || isAutoAudit) {
            PlanOrderUpdateDto updateDto = new PlanOrderUpdateDto();
            updateDto.setOrderNo(insertEo.getOrderNo());
            updateDto.setAuditResult(Integer.valueOf(1));
            updateDto.setRemark("\u81ea\u52a8\u5ba1\u6838");
            this.audit(updateDto);
        }
    }

    @Override
    public void submitById(Long id) {
        PlanOrderEo planOrderEo = new PlanOrderEo();
        planOrderEo.setId(id);
        PlanOrderEo orderEo = (PlanOrderEo)((IPlanOrderDomain)this.domain).selectOne((BaseEo)planOrderEo);
        AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        StatemachineExecutorBo<PlanOrderEo> executorBo = new StatemachineExecutorBo<PlanOrderEo>();
        executorBo.setEo(orderEo);
        StatemachineMap storageOrderDetailListMap = new StatemachineMap();
        List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)orderEo.getOrderNo())).list();
        executorBo.setVariables(storageOrderDetailListMap);
        storageOrderDetailListMap.put(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode(), detailEos);
        if (!this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.SUBMIT, executorBo)) {
            log.error("\u7ebf\u7a0b\u540d\u79f0\uff1a{},\u63d0\u4ea4\u5355\u636e, \u72b6\u6001\u5f02\u5e38\uff0c\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u63d0\u4ea4\u5355\u636e\u72b6\u6001\u5f02\u5e38\uff0c\u5355\u636e\u72b6\u6001\u5f02\u5e38");
        }
        boolean isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(orderEo.getOrderType(), orderEo.getBusinessType());
        if (isAutoAudit) {
            PlanOrderUpdateDto updateDto = new PlanOrderUpdateDto();
            updateDto.setOrderNo(orderEo.getOrderNo());
            updateDto.setAuditResult(Integer.valueOf(1));
            updateDto.setRemark("\u81ea\u52a8\u5ba1\u6838");
            this.audit(updateDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void submit(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)planOrderUpdateDto.getOrderNo())).list();
        StatemachineMap varMap = new StatemachineMap();
        varMap.put(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode(), detailEos);
        StatemachineExecutorBo<PlanOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        statemachineExecutorBo.setEo(orderEo);
        statemachineExecutorBo.setVariables(varMap);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.SUBMIT, statemachineExecutorBo);
        if (!execute) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u63d0\u4ea4\u5931\u8d25");
        }
        boolean isAutoAudit = this.automaticAuditPolicyDomain.isAutoAudit(orderEo.getOrderType(), orderEo.getBusinessType());
        if (isAutoAudit) {
            PlanOrderUpdateDto updateDto = new PlanOrderUpdateDto();
            updateDto.setOrderNo(orderEo.getOrderNo());
            updateDto.setAuditResult(Integer.valueOf(1));
            updateDto.setRemark("\u81ea\u52a8\u5ba1\u6838");
            this.audit(updateDto);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void withdraw(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        StatemachineExecutorBo<PlanOrderEo> planOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        planOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.WITHDRAW, planOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u64a4\u56de\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u64a4\u56de\u5931\u8d25");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void audit(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        orderEo.setAuditRemark(planOrderUpdateDto.getRemark());
        List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)planOrderUpdateDto.getOrderNo())).list();
        List addressEos = ((ExtQueryChainWrapper)this.baseOrderAddressDomain.filter().eq((Object)"document_no", (Object)planOrderUpdateDto.getOrderNo())).list();
        StatemachineMap varMap = new StatemachineMap();
        varMap.put(OtherStorageOrderContextEnum.PLAN_ORDER_DETAIL_LIST.getCode(), detailEos);
        varMap.put(OtherStorageOrderContextEnum.BASE_ORDER_ADDRESS_LIST.getCode(), addressEos);
        StatemachineExecutorBo<PlanOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        statemachineExecutorBo.setEo(orderEo);
        statemachineExecutorBo.setVariables(varMap);
        boolean isApproved = YesNoEnum.YES.getValue().equals(planOrderUpdateDto.getAuditResult());
        boolean execute = isApproved ? this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.AUDIT, statemachineExecutorBo) : this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.AUDITFAILED, statemachineExecutorBo);
        if (!execute) {
            log.error("\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25");
        }
        String remark = StrUtil.emptyToDefault((CharSequence)planOrderUpdateDto.getRemark(), (String)"EMPTY");
        OptUtil.addOptLog((String)OperationLogTypeEnum.getAuditType((boolean)isApproved), (String)remark, (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void cancel(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        StatemachineExecutorBo<PlanOrderEo> planOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        planOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.CANCEL, planOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u53d6\u6d88\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u53d6\u6d88\u5931\u8d25");
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.CANCELED.name(), (String)"EMPTY", (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void close(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        StatemachineExecutorBo<PlanOrderEo> planOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        planOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.FINISH, planOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u5173\u95ed\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u5173\u95ed\u5931\u8d25");
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.CLOSE.name(), (String)"EMPTY", (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void updateErpNoByOrderNo(PlanOrderUpdateDto dto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(dto);
        log.info("VMI\u5355\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)orderEo));
        if (Objects.nonNull(orderEo)) {
            PlanOrderEo planOrderEo = new PlanOrderEo();
            planOrderEo.setId(orderEo.getId());
            planOrderEo.setPreOrderNo(dto.getErpReceveNoticeNo());
            ((IPlanOrderDomain)this.domain).updateSelective((BaseEo)planOrderEo);
        }
    }

    @Override
    @Disabled
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void complete(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo orderEo = this.getPlanOrderEo(planOrderUpdateDto);
        StatemachineExecutorBo<PlanOrderEo> planOrderEoStatemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        planOrderEoStatemachineExecutorBo.setEo(orderEo);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.COMPLETED, planOrderEoStatemachineExecutorBo);
        if (!execute) {
            log.error("\u5b8c\u6210\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u5b8c\u6210\u5931\u8d25");
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.COMPLETED.name(), (String)"EMPTY", (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Long reduce(PlanOrderReduceDto dto) {
        PlanOrderEo planOrderEo = new PlanOrderEo();
        planOrderEo.setId(dto.getOrderId());
        PlanOrderEo orderEo = (PlanOrderEo)((IPlanOrderDomain)this.domain).selectOne((BaseEo)planOrderEo);
        AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u91c7\u8d2d\u5355\u5173\u8054\u7684\u91c7\u8d2d\u5165\u5e93\u5355\u636e\u4e0d\u5b58\u5728");
        StatemachineExecutorBo<PlanOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<PlanOrderEo>();
        statemachineExecutorBo.setEo(orderEo);
        StatemachineMap statemachineMap = new StatemachineMap();
        statemachineMap.put("reduce_plan_order_dto", dto);
        statemachineExecutorBo.setVariables(statemachineMap);
        boolean execute = this.planStatemachineExecutor.execute(DgPlanOrderStatusEventEnum.FINISH, statemachineExecutorBo);
        if (!execute) {
            log.error("\u91c7\u8d2d\u5165\u5e93\u5355\u6539\u5c0f\u5931\u8d25\uff1a{}", (Object)Thread.currentThread().getName());
            throw new RuntimeException("\u91c7\u8d2d\u5165\u5e93\u5355\u6539\u5c0f\u5931\u8d25");
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.CLOSE.name(), (String)"EMPTY", (String)orderEo.getOrderNo(), (String)orderEo.getOrderType());
        return statemachineExecutorBo.getVariables().getOrDefault("orderId", 0L);
    }

    @Override
    public PlanOrderDetailDto queryById(Long id) {
        PlanOrderEo planOrderEo = (PlanOrderEo)((ExtQueryChainWrapper)((IPlanOrderDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        return (PlanOrderDetailDto)BeanUtil.copyProperties((Object)planOrderEo, PlanOrderDetailDto.class, (String[])new String[0]);
    }

    private LogicWarehouseEo checkLogicWarehouse(String warehouseCode) {
        LogicWarehouseEo logicWarehouseEo = this.logicWarehouseDomain.queryByCode(warehouseCode);
        AssertUtil.isTrue((boolean)Objects.nonNull(logicWarehouseEo), (String)(warehouseCode + ",\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728"));
        return logicWarehouseEo;
    }

    private PhysicsWarehouseEo checkPhysicsWarehouse(String warehouseCode) {
        List physicsWarehouseEos = this.physicsWarehouseDomain.queryByWarehouseCode(warehouseCode);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)physicsWarehouseEos), (String)(warehouseCode + ",\u7269\u7406\u4ed3\u5e93\u4e0d\u5b58\u5728"));
        return (PhysicsWarehouseEo)physicsWarehouseEos.get(0);
    }

    private void checkSku(List<PlanOrderDetailExtDto> planOrderDetailDtos) {
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty(planOrderDetailDtos), (String)"\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List skuCodes = planOrderDetailDtos.stream().map(PlanOrderDetailDto::getSkuCode).filter(CharSequenceUtil::isNotEmpty).collect(Collectors.toList());
        HashSet existCodes = new HashSet();
        List itemSkus = null;
        if (CollectionUtils.isNotEmpty(skuCodes) && CollectionUtil.isNotEmpty((Collection)(itemSkus = this.itemSkuProxy.queryBySkuCode(skuCodes)))) {
            existCodes.addAll(itemSkus.stream().map(ItemSkuDgRespDto::getCode).collect(Collectors.toSet()));
        }
        planOrderDetailDtos.forEach(d -> {
            AssertUtil.isTrue((boolean)Objects.nonNull(d.getCurNum()), (String)"\u5f53\u524d\u5355\u4f4d\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((d.getCurNum().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u5355\u4f4d\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)d.getUnit()), (String)"\u5f53\u524d\u5546\u54c1\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)d.getSkuCode()), (String)"sku \u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)existCodes.contains(d.getSkuCode()), (String)String.format("sku:%s\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", d.getSkuCode()));
        });
    }

    private void computerVolumeAndQuantity(List<PlanOrderDetailExtDto> detailList, PlanOrderEo updateEo) {
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setType(updateEo.getOperationType());
        record.setDocumentCode(updateEo.getOrderNo());
        List orderUnitConversionDetailList = detailList.stream().map(e -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(e.getCurUnit());
            unitConversionDetail.setSkuCode(e.getSkuCode());
            unitConversionDetail.setCurNum(e.getCurNum());
            return unitConversionDetail;
        }).collect(Collectors.toList());
        record.setOrderUnitConversionDetailList(orderUnitConversionDetailList);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(record);
        Map<Object, Object> map = new HashMap(orderUnitConversionDetailList.size());
        if (CollectionUtils.isNotEmpty(orderUnitConversionRecordDtos)) {
            map = orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(e -> this.getUnitConversionKey(e.getSkuCode(), e.getNum(), e.getUnit()), o -> o, (o1, o2) -> o1));
        }
        log.info("\u8f6c\u6362\u5355\u4f4d\u540e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(map));
    }

    @NotNull
    private String getUnitConversionKey(String skuCode, BigDecimal num, String unit) {
        return skuCode + " " + num + " " + unit;
    }

    @NotNull
    private PlanOrderEo getPlanOrderEo(PlanOrderUpdateDto planOrderUpdateDto) {
        PlanOrderEo planOrderEo = new PlanOrderEo();
        planOrderEo.setOrderNo(planOrderUpdateDto.getOrderNo());
        PlanOrderEo orderEo = (PlanOrderEo)((IPlanOrderDomain)this.domain).selectOne((BaseEo)planOrderEo);
        AssertUtil.isTrue((boolean)Objects.nonNull(orderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        return orderEo;
    }

    @NotNull
    private String getMapKey(String skuCode, String batch) {
        return skuCode + " " + batch;
    }
}

