/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.plan.exe;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.PlanOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderDetailExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderExtDto;
import com.yunxi.dg.base.center.inventory.dto.entity.PlanOrderReduceDto;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlanOrderReissueExe {
    private static final Logger log = LoggerFactory.getLogger(PlanOrderReissueExe.class);
    @Resource
    private IPlanOrderDetailDomain planOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    public Long reissue(PlanOrderEo planOrderEo, PlanOrderReduceDto dto, List<ReceiveDeliveryNoticeOrderDetailEo> noticeOrderDetailEoList) {
        String orderNo = planOrderEo.getOrderNo();
        List detailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)orderNo)).list();
        HashMap receiveOrderId2EoMap = new HashMap();
        if (CollectionUtils.isNotEmpty(noticeOrderDetailEoList)) {
            receiveOrderId2EoMap.putAll(noticeOrderDetailEoList.stream().collect(Collectors.toMap(ReceiveDeliveryNoticeOrderDetailEo::getPreOrderItemId, Function.identity(), (k1, k2) -> k1)));
        }
        List planOrderDetailExtList = dto.getPlanOrderDetailExtList();
        HashMap<String, BigDecimal> orderId2doneQuantityMap = new HashMap<String, BigDecimal>();
        if (CollectionUtils.isNotEmpty((Collection)planOrderDetailExtList)) {
            orderId2doneQuantityMap.putAll(planOrderDetailExtList.stream().collect(Collectors.toMap(PlanOrderDetailDto::getSkuCode, PlanOrderDetailDto::getPlanQuantity)));
        }
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)orderNo)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
        ArrayList<PlanOrderDetailExtDto> details = new ArrayList<PlanOrderDetailExtDto>();
        for (PlanOrderDetailEo item : detailEos) {
            ReceiveDeliveryNoticeOrderDetailEo detailEo = (ReceiveDeliveryNoticeOrderDetailEo)receiveOrderId2EoMap.get(item.getId());
            if (detailEo == null || detailEo.getPlanQuantity().equals(detailEo.getDoneQuantity())) {
                log.info("\u5546\u54c1sku\uff1a{}\uff0c \u6536\u8d27\u901a\u77e5\u5355\uff1a{}", (Object)item.getSkuCode(), (Object)JSONObject.toJSONString((Object)detailEo));
                continue;
            }
            BigDecimal doneQuantity = detailEo.getDoneQuantity();
            if (unitConversionMap.containsKey(item.getSkuCode() + item.getUnit())) {
                doneQuantity = UnitTransferUtils.pareSaleNum((BigDecimal)detailEo.getDoneQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties(unitConversionMap.get(item.getSkuCode() + item.getUnit()), OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false);
            }
            BigDecimal planQuantity = item.getPlanQuantity();
            if (orderId2doneQuantityMap.containsKey(item.getSkuCode())) {
                planQuantity = (BigDecimal)orderId2doneQuantityMap.get(item.getSkuCode());
            }
            planQuantity = planQuantity.subtract(doneQuantity);
            PlanOrderDetailExtDto planOrderDetailExtDto = new PlanOrderDetailExtDto();
            planOrderDetailExtDto.setSkuCode(item.getSkuCode());
            planOrderDetailExtDto.setSkuName(item.getSkuName());
            planOrderDetailExtDto.setBatch(item.getBatch());
            planOrderDetailExtDto.setRemark(item.getRemark());
            planOrderDetailExtDto.setInventoryProperty(item.getInventoryProperty());
            planOrderDetailExtDto.setUnit(item.getUnit());
            planOrderDetailExtDto.setPlanQuantity(planQuantity);
            planOrderDetailExtDto.setCurNum(planQuantity);
            details.add(planOrderDetailExtDto);
        }
        this.calculateWeightAndVolume(orderNo, details);
        PlanOrderExtDto planOrderDto = new PlanOrderExtDto();
        BeanUtil.copyProperties((Object)PlanOrderConverter.INSTANCE.toDto((BaseEo)planOrderEo), (Object)planOrderDto, (String[])new String[]{"id", "totalQuantity", "doneQuantity", "orderNo"});
        planOrderDto.setCommitType("autoAudit");
        planOrderDto.setPlanOrderDetailExtList(details);
        log.info("\u91cd\u65b0\u751f\u6210\u91c7\u8d2d\u5355\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)planOrderDto));
        return null;
    }

    public void calculateWeightAndVolume(String documentNo, List<PlanOrderDetailExtDto> details) {
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(details.stream().map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getPlanQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setDocumentCode(documentNo);
        Map<String, BasicOrderDtoExtension> volumeMap = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        details.forEach(eo -> {
            BasicOrderDtoExtension dtoExtension = (BasicOrderDtoExtension)volumeMap.get(eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getPlanQuantity());
            eo.setVolume(dtoExtension.getVolume());
            eo.setWeight(dtoExtension.getWeight());
        });
    }
}

