/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.takeStock.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.InventoryTakeStockOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.InventoryTakeStockOrderItemTakeStockTypeEnum;
import com.yunxi.dg.base.center.enums.InventoryTakeStockOrderStatusEnum;
import com.yunxi.dg.base.center.enums.InventoryTakeStockOrderStatusLogEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InventoryTakeStockOrderConverter;
import com.yunxi.dg.base.center.inventory.dao.das.IInventoryTakeStockOrderItemDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryTakeStockOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryTakeStockOrderItemDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderItemDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryTakeStockOrderStatusDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryTakeStockOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryTakeStockOrderItemEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentExternalOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.takeStock.IInventoryTakeStockOrderItemService;
import com.yunxi.dg.base.center.inventory.service.business.takeStock.IInventoryTakeStockOrderService;
import com.yunxi.dg.base.center.inventory.service.business.takeStock.IInventoryTakeStockOrderStatusService;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.UnitDgRespDto;
import com.yunxi.dg.base.center.item.dto.old.UnitDgReqDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IUnitDgQueryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InventoryTakeStockOrderServiceImpl
extends BaseServiceImpl<InventoryTakeStockOrderDto, InventoryTakeStockOrderEo, IInventoryTakeStockOrderDomain>
implements IInventoryTakeStockOrderService {
    private static final Logger log = LoggerFactory.getLogger(InventoryTakeStockOrderServiceImpl.class);
    @Resource
    private IInventoryTakeStockOrderItemService iInventoryTakeStockOrderItemService;
    @Resource
    private IInventoryTakeStockOrderItemDomain inventoryTakeStockOrderItemDomain;
    @Resource
    private IInventoryTakeStockOrderStatusService iInventoryTakeStockOrderStatusService;
    @Resource
    private IInventoryTakeStockOrderItemDas inventoryTakeStockOrderItemDas;
    @Resource
    private IUnitDgQueryApiProxy unitDgQueryApiProxy;
    @Resource
    protected ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource(name="inventoryAdjustmentOrderServiceImpl")
    private IAdjustmentOrderService adjustmentOrderService;

    public InventoryTakeStockOrderServiceImpl(IInventoryTakeStockOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryTakeStockOrderDto, InventoryTakeStockOrderEo> converter() {
        return InventoryTakeStockOrderConverter.INSTANCE;
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CREATE_STOCK_ORDER, orderCodeSpel="#dto.orderNo", value="INVENTORY_TAKE_STOCK_ORDER")
    public RestResponse<Long> save(InventoryTakeStockOrderDto dto) {
        log.info("InventoryTakeStockOrderSave-->InventoryTakeStockOrderDto:{}", (Object)LogUtils.buildLogContent((Object)dto));
        this.checkSaveDto(dto);
        this.writeBack(dto);
        List itemWarehouseCodes = dto.getItemList().stream().map(InventoryTakeStockOrderItemDto::getWarehouseCode).distinct().collect(Collectors.toList());
        Map warehouseEoMap = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", itemWarehouseCodes)).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        List skuCodes = dto.getItemList().stream().map(InventoryTakeStockOrderItemDto::getSkuCode).collect(Collectors.toList());
        dto.getItemList().forEach(o -> {
            o.setOrderNo(dto.getOrderNo());
            o.setInventoryProperty(Optional.ofNullable(o.getInventoryProperty()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
            if (StringUtils.isBlank((CharSequence)o.getWarehouseName()) || StringUtils.isBlank((CharSequence)o.getOrganizationName())) {
                Optional.ofNullable(warehouseEoMap.get(o.getWarehouseCode())).ifPresent(i -> {
                    o.setWarehouseCode(i.getWarehouseCode());
                    o.setWarehouseName(i.getWarehouseName());
                    o.setOrganizationCode(i.getOrganizationCode());
                    o.setOrganizationName(i.getOrganizationName());
                });
            }
        });
        List itemEos = BeanUtil.copyToList((Collection)dto.getItemList(), InventoryTakeStockOrderItemEo.class);
        RestResponse orderId = this.insert((BaseDto)dto);
        this.inventoryTakeStockOrderItemDomain.insertBatch(itemEos);
        this.saveInventoryTakeStockOrderStatus(dto.getOrderNo(), InventoryTakeStockOrderStatusLogEnum.CREATE.getCode(), dto.getOrganizationId(), dto.getOrganizationName());
        return orderId;
    }

    private void writeBack(InventoryTakeStockOrderDto dto) {
        dto.setOrderNo(InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.INVENTORY_TAKE_STOCK_ORDER));
        if (StringUtils.isEmpty((CharSequence)dto.getOrderStatus())) {
            dto.setOrderStatus(InventoryTakeStockOrderStatusEnum.WAIT_STOCKTAKING.getCode());
        }
        if (StringUtils.isBlank((CharSequence)dto.getPhysicsWarehouseName())) {
            PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)dto.getPhysicsWarehouseCode())).last("limit 1")).one();
            dto.setPhysicsWarehouseName(physicsWarehouseEo.getWarehouseName());
        }
    }

    private void checkSaveDto(InventoryTakeStockOrderDto dto) {
        AssertUtil.isFalse((boolean)Objects.isNull(InventoryTakeStockOrderBizTypeEnum.getByCode((Integer)dto.getBizType())), (String)"\u76d8\u70b9\u7c7b\u578b\u6709\u8bef");
        AssertUtil.isFalse((Objects.equals(dto.getBizType(), InventoryTakeStockOrderBizTypeEnum.SPOT_CHECK.getCode()) && CollectionUtils.isEmpty((Collection)dto.getItemList()) ? 1 : 0) != 0, (String)"\u76d8\u70b9\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getPhysicsWarehouseCode()), (String)"\u7269\u7406\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        dto.getItemList().forEach(item -> {
            AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)item.getWarehouseCode()), (String)"\u903b\u8f91\u4ed3\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isFalse((boolean)StringUtils.isBlank((CharSequence)item.getSkuCode()), (String)"sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }

    private void calculateDifferences(InventoryTakeStockOrderDto dto) {
        List itemList = dto.getItemList();
        if (CollectionUtils.isEmpty((Collection)itemList)) {
            return;
        }
        for (InventoryTakeStockOrderItemDto inventoryTakeStockOrderItemDto : itemList) {
            inventoryTakeStockOrderItemDto.setDifferenceNum(BigDecimalUtils.subtract((BigDecimal)inventoryTakeStockOrderItemDto.getFirmOfferNum(), (BigDecimal)inventoryTakeStockOrderItemDto.getAccountNum()));
            inventoryTakeStockOrderItemDto.setTakeStockType(this.getTakeStockTypeByDifferenceNum(inventoryTakeStockOrderItemDto.getDifferenceNum()));
        }
    }

    private Integer getTakeStockTypeByDifferenceNum(BigDecimal differenceNum) {
        if (BigDecimalUtils.gtZero((BigDecimal)differenceNum).booleanValue()) {
            return InventoryTakeStockOrderItemTakeStockTypeEnum.INVENTORY_PROFIT.getCode();
        }
        if (BigDecimalUtils.ltZero((BigDecimal)differenceNum).booleanValue()) {
            return InventoryTakeStockOrderItemTakeStockTypeEnum.INVENTORY_LOSS.getCode();
        }
        return InventoryTakeStockOrderItemTakeStockTypeEnum.NOT_HANDLED.getCode();
    }

    private void saveInventoryTakeStockOrderStatus(String orderNo, Integer status, Long organizationId, String organizationName) {
        InventoryTakeStockOrderStatusDto inventoryTakeStockOrderStatusDto = new InventoryTakeStockOrderStatusDto();
        inventoryTakeStockOrderStatusDto.setStatus(status);
        inventoryTakeStockOrderStatusDto.setOrderNo(orderNo);
        inventoryTakeStockOrderStatusDto.setOrganizationId(organizationId);
        inventoryTakeStockOrderStatusDto.setOrganizationName(organizationName);
        this.iInventoryTakeStockOrderStatusService.insert((BaseDto)inventoryTakeStockOrderStatusDto);
    }

    @Override
    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByPage(InventoryTakeStockOrderPageReqDto dto) {
        PageInfo inventoryTakeStockOrderDtoPageInfo = ((IInventoryTakeStockOrderDomain)this.domain).queryByPage(dto);
        this.setEnumDesc((PageInfo<InventoryTakeStockOrderDto>)inventoryTakeStockOrderDtoPageInfo);
        return new RestResponse((Object)inventoryTakeStockOrderDtoPageInfo);
    }

    @Override
    public RestResponse<PageInfo<InventoryTakeStockOrderDto>> queryByItemPage(InventoryTakeStockOrderPageReqDto dto) {
        List<String> skuCodeList;
        PageInfo inventoryTakeStockOrderDtoPageInfo = ((IInventoryTakeStockOrderDomain)this.domain).queryByItemPage(dto);
        List list = inventoryTakeStockOrderDtoPageInfo.getList();
        HashMap skuMap = new HashMap();
        if (CollectionUtil.isNotEmpty((Collection)list) && CollectionUtil.isNotEmpty(skuCodeList = list.stream().map(InventoryTakeStockOrderDto::getSkuCode).collect(Collectors.toList()))) {
            List dtoList = this.itemDataQueryHelper.getByCodes(skuCodeList);
            Map dtoMap = dtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o1, o2) -> o1));
            skuMap.putAll(dtoMap);
        }
        list.forEach(o -> {
            if (skuMap.containsKey(o.getSkuCode())) {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)skuMap.get(o.getSkuCode());
                o.setSkuDisplayName(itemSkuDgRespDto.getSkuName());
                o.setBarCode(itemSkuDgRespDto.getBarCode());
            }
        });
        this.setEnumDesc((PageInfo<InventoryTakeStockOrderDto>)inventoryTakeStockOrderDtoPageInfo);
        return new RestResponse((Object)inventoryTakeStockOrderDtoPageInfo);
    }

    private void setEnumDesc(PageInfo<InventoryTakeStockOrderDto> inventoryTakeStockOrderDtoPageInfo) {
        if (ObjectUtils.isNotEmpty(inventoryTakeStockOrderDtoPageInfo) && CollectionUtils.isNotEmpty((Collection)inventoryTakeStockOrderDtoPageInfo.getList())) {
            List<String> orderNos = inventoryTakeStockOrderDtoPageInfo.getList().stream().map(InventoryTakeStockOrderDto::getOrderNo).distinct().collect(Collectors.toList());
            List<Object> adjustmentOrderDtos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(orderNos)) {
                adjustmentOrderDtos = this.adjustmentOrderService.queryByExternalOrderNos(orderNos);
            }
            Map<String, List<AdjustmentOrderDto>> adjustmentOrderDtoMap = adjustmentOrderDtos.stream().collect(Collectors.groupingBy(AdjustmentOrderDto::getExternalOrderNo));
            List unitDgRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.unitDgQueryApiProxy.queryList(new UnitDgReqDto()));
            for (InventoryTakeStockOrderDto dto : inventoryTakeStockOrderDtoPageInfo.getList()) {
                UnitDgRespDto unitDgRespDto;
                List<AdjustmentOrderDto> adjustmentOrderDtoFilterList = adjustmentOrderDtoMap.get(dto.getOrderNo());
                if (CollectionUtil.isNotEmpty(adjustmentOrderDtoFilterList) && adjustmentOrderDtoFilterList.stream().allMatch(o -> DgAdjustmentInventoryOrderStatusEnum.FINISHED.getKey().equals(o.getOrderStatus()))) {
                    dto.setAdjustmentStatus(DgAdjustmentInventoryOrderStatusEnum.FINISHED.getKey());
                }
                if (CollectionUtils.isNotEmpty((Collection)unitDgRespDtos) && ObjectUtils.isNotEmpty((Object)(unitDgRespDto = (UnitDgRespDto)unitDgRespDtos.stream().filter(o -> StringUtils.equals((CharSequence)o.getCode(), (CharSequence)dto.getUnit())).findFirst().orElse(null)))) {
                    dto.setUnitName(unitDgRespDto.getName());
                }
                dto.setBizTypeDesc(InventoryTakeStockOrderBizTypeEnum.getDescByCode((Integer)dto.getBizType()));
                dto.setOrderStatusDesc(InventoryTakeStockOrderStatusEnum.getDescByCode((String)dto.getOrderStatus()));
                dto.setTakeStockTypeDesc(InventoryTakeStockOrderItemTakeStockTypeEnum.getDescByCode((Integer)dto.getTakeStockType()));
            }
        }
    }

    @Override
    public RestResponse<InventoryTakeStockOrderDto> details(String orderNo) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)orderNo), (String)"\u76d8\u70b9\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryTakeStockOrderEo inventoryTakeStockOrderEo = (InventoryTakeStockOrderEo)((ExtQueryChainWrapper)((IInventoryTakeStockOrderDomain)this.domain).filter().eq((Object)"order_no", (Object)orderNo)).one();
        if (ObjectUtils.isNotEmpty((Object)inventoryTakeStockOrderEo)) {
            InventoryTakeStockOrderDto inventoryTakeStockOrderDto = (InventoryTakeStockOrderDto)this.converter().toDto((BaseEo)inventoryTakeStockOrderEo);
            inventoryTakeStockOrderDto.setBizTypeDesc(InventoryTakeStockOrderBizTypeEnum.getDescByCode((Integer)inventoryTakeStockOrderDto.getBizType()));
            inventoryTakeStockOrderDto.setOrderStatusDesc(InventoryTakeStockOrderStatusEnum.getDescByCode((String)inventoryTakeStockOrderDto.getOrderStatus()));
            inventoryTakeStockOrderDto.setItemList(this.iInventoryTakeStockOrderItemService.queryByOrderNo(orderNo));
            return new RestResponse((Object)inventoryTakeStockOrderDto);
        }
        return new RestResponse();
    }

    @Override
    public InventoryTakeStockOrderDto queryByExternalOrderNo(String externalOrderNo) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)externalOrderNo), (String)"\u5916\u90e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryTakeStockOrderEo inventoryTakeStockOrderEo = (InventoryTakeStockOrderEo)((ExtQueryChainWrapper)((IInventoryTakeStockOrderDomain)this.domain).filter().eq((Object)"external_order_no", (Object)externalOrderNo)).one();
        if (ObjectUtils.isNotEmpty((Object)inventoryTakeStockOrderEo)) {
            InventoryTakeStockOrderDto inventoryTakeStockOrderDto = (InventoryTakeStockOrderDto)this.converter().toDto((BaseEo)inventoryTakeStockOrderEo);
            inventoryTakeStockOrderDto.setBizTypeDesc(InventoryTakeStockOrderBizTypeEnum.getDescByCode((Integer)inventoryTakeStockOrderDto.getBizType()));
            inventoryTakeStockOrderDto.setOrderStatusDesc(InventoryTakeStockOrderStatusEnum.getDescByCode((String)inventoryTakeStockOrderDto.getOrderStatus()));
            inventoryTakeStockOrderDto.setItemList(this.iInventoryTakeStockOrderItemService.queryByOrderNo(inventoryTakeStockOrderEo.getOrderNo()));
            return inventoryTakeStockOrderDto;
        }
        return null;
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CANCELED, orderCodeSpel="#orderNo", value="INVENTORY_TAKE_STOCK_ORDER")
    public RestResponse<Void> cancel(String orderNo) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)orderNo), (String)"\u76d8\u70b9\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryTakeStockOrderEo inventoryTakeStockOrderEo = (InventoryTakeStockOrderEo)((ExtQueryChainWrapper)((IInventoryTakeStockOrderDomain)this.domain).filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)inventoryTakeStockOrderEo), (String)"\u76d8\u70b9\u5355\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
        AssertUtil.isFalse((boolean)StringUtils.equals((CharSequence)inventoryTakeStockOrderEo.getOrderStatus(), (CharSequence)InventoryTakeStockOrderStatusEnum.CANCEL.getCode()), (String)"\u76d8\u70b9\u5355\u72b6\u6001\u9519\u8bef");
        AssertUtil.isFalse((boolean)StringUtils.equals((CharSequence)inventoryTakeStockOrderEo.getOrderStatus(), (CharSequence)InventoryTakeStockOrderStatusEnum.COMPLETED.getCode()), (String)"\u76d8\u70b9\u5355\u72b6\u6001\u9519\u8bef");
        InventoryTakeStockOrderEo updateInventoryTakeStockOrderEo = new InventoryTakeStockOrderEo();
        updateInventoryTakeStockOrderEo.setId(inventoryTakeStockOrderEo.getId());
        updateInventoryTakeStockOrderEo.setOrderStatus(InventoryTakeStockOrderStatusEnum.CANCEL.getCode());
        int updateCount = ((IInventoryTakeStockOrderDomain)this.domain).updateSelective((BaseEo)updateInventoryTakeStockOrderEo);
        if (updateCount > 0) {
            this.saveInventoryTakeStockOrderStatus(orderNo, InventoryTakeStockOrderStatusLogEnum.CANCEL.getCode(), inventoryTakeStockOrderEo.getOrganizationId(), inventoryTakeStockOrderEo.getOrganizationName());
        }
        return RestResponse.VOID;
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.COMPLETED, orderCodeSpel="#orderNo", value="INVENTORY_TAKE_STOCK_ORDER")
    public RestResponse<Void> completed(String orderNo) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)orderNo), (String)"\u76d8\u70b9\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryTakeStockOrderEo inventoryTakeStockOrderEo = (InventoryTakeStockOrderEo)((ExtQueryChainWrapper)((IInventoryTakeStockOrderDomain)this.domain).filter().eq((Object)"order_no", (Object)orderNo)).one();
        AssertUtil.isFalse((boolean)ObjectUtils.isEmpty((Object)inventoryTakeStockOrderEo), (String)"\u76d8\u70b9\u5355\u53f7\u4fe1\u606f\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((boolean)StringUtils.equals((CharSequence)inventoryTakeStockOrderEo.getOrderStatus(), (CharSequence)InventoryTakeStockOrderStatusEnum.WAIT_COMPLETED.getCode()), (String)"\u76d8\u70b9\u5355\u72b6\u6001\u9519\u8bef");
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.isNull(InventoryTakeStockOrderItemEo::getFirmOfferNum);
        wrapper.eq(BaseEo::getDr, (Object)0);
        wrapper.eq(InventoryTakeStockOrderItemEo::getOrderNo, (Object)orderNo);
        Integer count = this.inventoryTakeStockOrderItemDas.getMapper().selectCount((Wrapper)wrapper);
        AssertUtil.isFalse((count > 0 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5b9e\u76d8\u6570\u91cf\u4e3a\u7a7a\u5546\u54c1\uff0c\u4e0d\u5141\u8bb8\u5b8c\u7ed3\u3002");
        wrapper = new LambdaQueryWrapper();
        wrapper.ne(InventoryTakeStockOrderItemEo::getTakeStockType, (Object)InventoryTakeStockOrderItemTakeStockTypeEnum.NOT_HANDLED.getCode());
        wrapper.eq(InventoryTakeStockOrderItemEo::getOrderNo, (Object)orderNo);
        wrapper.eq(BaseEo::getDr, (Object)0);
        List inventoryTakeStockOrderItemEos = this.inventoryTakeStockOrderItemDas.getMapper().selectList((Wrapper)wrapper);
        if (InventoryConfig.isCanTakeStockGenAdjustmentOrder() && CollectionUtils.isNotEmpty((Collection)inventoryTakeStockOrderItemEos)) {
            Map<String, List<InventoryTakeStockOrderItemEo>> inventoryTakeStockOrderItemEoMap = inventoryTakeStockOrderItemEos.stream().collect(Collectors.groupingBy(o -> o.getWarehouseCode() + InventoryConfig.getCommonSeparate() + o.getInventoryProperty()));
            inventoryTakeStockOrderItemEoMap.forEach((k, v) -> {
                AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
                this.converterAdjustmentOrderDto(adjustmentOrderDto, (List<InventoryTakeStockOrderItemEo>)v, inventoryTakeStockOrderEo);
                this.adjustmentOrderService.addAdjustmentOrder(adjustmentOrderDto);
            });
        }
        InventoryTakeStockOrderEo updateInventoryTakeStockOrderEo = new InventoryTakeStockOrderEo();
        updateInventoryTakeStockOrderEo.setId(inventoryTakeStockOrderEo.getId());
        updateInventoryTakeStockOrderEo.setOrderStatus(InventoryTakeStockOrderStatusEnum.COMPLETED.getCode());
        int updateCount = ((IInventoryTakeStockOrderDomain)this.domain).updateSelective((BaseEo)updateInventoryTakeStockOrderEo);
        if (updateCount > 0) {
            this.saveInventoryTakeStockOrderStatus(orderNo, InventoryTakeStockOrderStatusLogEnum.COMPLETED.getCode(), inventoryTakeStockOrderEo.getOrganizationId(), inventoryTakeStockOrderEo.getOrganizationName());
        }
        return RestResponse.VOID;
    }

    private void converterAdjustmentOrderDto(AdjustmentOrderDto adjustmentOrderDto, List<InventoryTakeStockOrderItemEo> inventoryTakeStockOrderItemEos, InventoryTakeStockOrderEo inventoryTakeStockOrderEo) {
        InventoryTakeStockOrderItemEo stockOrderItemEo = inventoryTakeStockOrderItemEos.get(0);
        adjustmentOrderDto.setBusinessType(AdjustmentBusinessTypeEnum.INVENTORY_PROFIT_LOSS.getType());
        adjustmentOrderDto.setOrderType(AdjustmentOrderTypeEnum.INVENTORY_ADJUSTMENT.getType());
        adjustmentOrderDto.setExternalOrderNo(inventoryTakeStockOrderEo.getOrderNo());
        adjustmentOrderDto.setExternalOrderType(AdjustmentExternalOrderTypeEnum.INVENTORY_TAKE_STOCK_ORDER.getType());
        adjustmentOrderDto.setWarehouseCode(stockOrderItemEo.getWarehouseCode());
        adjustmentOrderDto.setWarehouseName(stockOrderItemEo.getWarehouseName());
        adjustmentOrderDto.setPhysicsWarehouseId(inventoryTakeStockOrderEo.getPhysicsWarehouseId());
        adjustmentOrderDto.setPhysicsWarehouseCode(inventoryTakeStockOrderEo.getPhysicsWarehouseCode());
        adjustmentOrderDto.setPhysicsWarehouseName(inventoryTakeStockOrderEo.getPhysicsWarehouseName());
        adjustmentOrderDto.setOrganizationCode(stockOrderItemEo.getOrganizationCode());
        adjustmentOrderDto.setOrganizationName(stockOrderItemEo.getOrganizationName());
        adjustmentOrderDto.setInventoryProperty(stockOrderItemEo.getInventoryProperty());
        adjustmentOrderDto.setBizDate(new Date());
        ArrayList adjustmentOrderDetailDtos = Lists.newArrayList();
        for (InventoryTakeStockOrderItemEo inventoryTakeStockOrderItemEo : inventoryTakeStockOrderItemEos) {
            AdjustmentOrderDetailDto adjustmentOrderDetailDto = new AdjustmentOrderDetailDto();
            if (Objects.equals(InventoryTakeStockOrderItemTakeStockTypeEnum.INVENTORY_PROFIT.getCode(), inventoryTakeStockOrderItemEo.getTakeStockType())) {
                adjustmentOrderDetailDto.setChangeType(AdjustmentChangeTypeEnum.INCREASE.getCode());
            } else {
                if (!Objects.equals(InventoryTakeStockOrderItemTakeStockTypeEnum.INVENTORY_LOSS.getCode(), inventoryTakeStockOrderItemEo.getTakeStockType())) continue;
                adjustmentOrderDetailDto.setChangeType(AdjustmentChangeTypeEnum.DECREASE.getCode());
            }
            adjustmentOrderDetailDto.setChangeQuantity(inventoryTakeStockOrderItemEo.getDifferenceNum().abs());
            adjustmentOrderDetailDto.setSkuName(inventoryTakeStockOrderItemEo.getSkuName());
            adjustmentOrderDetailDto.setSkuCode(inventoryTakeStockOrderItemEo.getSkuCode());
            adjustmentOrderDetailDto.setSpuCode(inventoryTakeStockOrderItemEo.getSpuCode());
            adjustmentOrderDetailDto.setSpuName(inventoryTakeStockOrderItemEo.getSpuName());
            adjustmentOrderDetailDto.setBatch(inventoryTakeStockOrderItemEo.getBatch());
            adjustmentOrderDetailDto.setUnit(inventoryTakeStockOrderItemEo.getUnit());
            adjustmentOrderDetailDto.setInventoryProperty(inventoryTakeStockOrderItemEo.getInventoryProperty());
            adjustmentOrderDetailDto.setProduceTime(inventoryTakeStockOrderItemEo.getProduceTime());
            adjustmentOrderDetailDto.setExpireTime(inventoryTakeStockOrderItemEo.getExpireTime());
            adjustmentOrderDetailDto.setRemark(inventoryTakeStockOrderItemEo.getRemark());
            adjustmentOrderDetailDtos.add(adjustmentOrderDetailDto);
        }
        adjustmentOrderDto.setAdjustmentOrderDetailDtos((List)adjustmentOrderDetailDtos);
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.UPDATE_STOCK_ORDER, orderCodeSpel="#dto.orderNo", value="INVENTORY_TAKE_STOCK_ORDER")
    public RestResponse<Void> updateItemList(InventoryTakeStockOrderDto dto) {
        this.update((BaseDto)dto);
        InventoryTakeStockOrderItemEo inventoryTakeStockOrderItemEo = new InventoryTakeStockOrderItemEo();
        inventoryTakeStockOrderItemEo.setOrderNo(dto.getOrderNo());
        this.inventoryTakeStockOrderItemDas.logicDelete((BaseEo)inventoryTakeStockOrderItemEo);
        if (CollectionUtils.isNotEmpty((Collection)dto.getItemList())) {
            List itemWarehouseCodes = dto.getItemList().stream().map(InventoryTakeStockOrderItemDto::getWarehouseCode).distinct().collect(Collectors.toList());
            Map warehouseEoMap = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", itemWarehouseCodes)).list().stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
            dto.getItemList().forEach(o -> {
                o.setId(null);
                o.setOrderNo(dto.getOrderNo());
                o.setInventoryProperty(Optional.ofNullable(o.getInventoryProperty()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(LogicWarehouseQualityEnum.QUALIFIED.getCode()));
                if (StringUtils.isBlank((CharSequence)o.getWarehouseName()) || StringUtils.isBlank((CharSequence)o.getOrganizationName())) {
                    Optional.ofNullable(warehouseEoMap.get(o.getWarehouseCode())).ifPresent(i -> {
                        o.setWarehouseCode(i.getWarehouseCode());
                        o.setWarehouseName(i.getWarehouseName());
                        o.setOrganizationCode(i.getOrganizationCode());
                        o.setOrganizationName(i.getOrganizationName());
                    });
                }
            });
            this.calculateDifferences(dto);
            List itemEos = BeanUtil.copyToList((Collection)dto.getItemList(), InventoryTakeStockOrderItemEo.class);
            this.inventoryTakeStockOrderItemDomain.insertBatch(itemEos);
        }
        this.saveInventoryTakeStockOrderStatus(dto.getOrderNo(), InventoryTakeStockOrderStatusLogEnum.IMPORT_RESULTS.getCode(), dto.getOrganizationId(), dto.getOrganizationName());
        return RestResponse.VOID;
    }
}

