/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.TransferOrderEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryPreemptionDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryUsageRecordEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class TransferOrderInventoryExe {
    @Autowired
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IInventoryPreemptionDomain inventoryPreemptionDomain;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ITransferOrderDas transferOrderDas;

    public void preemptLogicInventory(TransferOrderReqDto reqDto, String transferNo, List<TransferOrderDetailReqDto> detailList) {
        PreemptDto preemptParam = new PreemptDto();
        preemptParam.setSourceNo(transferNo);
        preemptParam.setExternalOrderNo(reqDto.getPreOrderNo());
        preemptParam.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_PREEMPT.getCode());
        preemptParam.setBusinessType(reqDto.getType());
        preemptParam.setValidNegative(Boolean.valueOf(true));
        preemptParam.setNoneLineNo(Boolean.valueOf(true));
        ArrayList detailParams = Lists.newArrayList();
        for (TransferOrderDetailReqDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            BigDecimal preemptNum = BigDecimalUtils.abs((BigDecimal)detailReqDto.getQuantity());
            detailParam.setNum(preemptNum);
            detailParam.setSkuCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getSkuCode()) ? detailReqDto.getSkuCode() : detailReqDto.getLongCode());
            detailParam.setLogicWarehouseCode(reqDto.getOutLogicWarehouseCode());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        this.calcInventoryService.preempt(preemptParam);
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void preemptLogicInventory(PreemptDto preemptParam, String outLogicWarehouseCode, List<TransferOrderDetailReqDto> detailList) {
        ArrayList detailParams = Lists.newArrayList();
        TransferOrderEo transferOrderEo = this.transferOrderDas.selectByTransferOrderNo(preemptParam.getSourceNo());
        Map<Object, OrderUnitConversionRecordDto> unitConversionRecordDtoMap = this.unitProcess(transferOrderEo, detailList, true);
        ArrayList noValidNegativeTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode(), TransferOrderTypeEnum.EXTERNAL_WAREHOUSE_C_B.getCode(), TransferOrderEnum.TRANSFER_POSITION_ORDER.getCode()});
        if (noValidNegativeTypeList.contains(transferOrderEo.getOrderType())) {
            preemptParam.setValidNegative(Boolean.FALSE);
        }
        for (TransferOrderDetailReqDto detailReqDto : detailList) {
            CalcDetailDto detailParam = new CalcDetailDto();
            OrderUnitConversionRecordDto orderUnitConversionRecordDto = unitConversionRecordDtoMap.get(this.getKey(detailReqDto.getSkuCode(), detailReqDto.getUnit()));
            BigDecimal rate = Objects.nonNull(orderUnitConversionRecordDto) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getNum(), (BigDecimal)orderUnitConversionRecordDto.getToNum(), (int)6) : BigDecimal.ONE;
            BigDecimal toRate = Objects.nonNull(orderUnitConversionRecordDto) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getToNum(), (BigDecimal)orderUnitConversionRecordDto.getNum(), (int)6) : BigDecimal.ZERO;
            BigDecimal quantity = UnitTransferUtils.pareSaleNum((BigDecimal)detailReqDto.getQuantity(), (BigDecimal)rate, (BigDecimal)toRate);
            detailParam.setNum(quantity);
            detailParam.setLineNo(detailReqDto.getId());
            detailParam.setSkuCode(StringUtils.isNotBlank((CharSequence)detailReqDto.getSkuCode()) ? detailReqDto.getSkuCode() : detailReqDto.getLongCode());
            detailParam.setLogicWarehouseCode(outLogicWarehouseCode);
            detailParam.setInventoryProperty(detailReqDto.getInventoryProperty());
            detailParam.setBatch(detailReqDto.getBatch());
            detailParam.setProduceDate(detailReqDto.getProduceTime());
            detailParam.setExpireDate(detailReqDto.getExpireTime());
            detailParams.add(detailParam);
        }
        preemptParam.setDetails((List)detailParams);
        List<InventoryUsageRecordEo> preemptionEoList = this.calcInventoryService.updatePreempt(preemptParam);
        if (!(InventoryConfig.isPreemptHiddenBatch() || preemptParam.getShoutBatch().booleanValue() || InventoryConfig.isNoneBatch())) {
            Map orderDetailEoMap = detailList.stream().collect(Collectors.toMap(TransferOrderDetailReqDto::getId, Function.identity()));
            ArrayList<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo> volumeDetailBos = new ArrayList<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo>();
            List<TransferOrderDetailEo> detailEoList = preemptionEoList.stream().map(item -> {
                TransferOrderDetailReqDto orgDetail = (TransferOrderDetailReqDto)orderDetailEoMap.get(item.getLineNo());
                TransferOrderDetailEo newDetail = (TransferOrderDetailEo)BeanUtil.copyProperties((Object)orgDetail, TransferOrderDetailEo.class, (String[])new String[]{"id"});
                OrderUnitConversionRecordDto orderUnitConversionRecordDto = (OrderUnitConversionRecordDto)unitConversionRecordDtoMap.get(this.getKey(item.getSkuCode(), orgDetail.getUnit()));
                BigDecimal rate = Objects.nonNull(orderUnitConversionRecordDto) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getNum(), (BigDecimal)orderUnitConversionRecordDto.getToNum(), (int)6) : BigDecimal.ZERO;
                BigDecimal toRate = Objects.nonNull(orderUnitConversionRecordDto) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getToNum(), (BigDecimal)orderUnitConversionRecordDto.getNum(), (int)6) : BigDecimal.ZERO;
                BigDecimal quantity = UnitTransferUtils.pareSaleNum((BigDecimal)item.getPreemptNum(), (BigDecimal)toRate, (BigDecimal)rate);
                newDetail.setBatch(item.getBatch());
                newDetail.setQuantity(quantity);
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo detail = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                detail.setUnit(newDetail.getUnit());
                detail.setSkuCode(newDetail.getSkuCode());
                detail.setQuantity(newDetail.getQuantity());
                volumeDetailBos.add(detail);
                return newDetail;
            }).collect(Collectors.toList());
            if (InventoryConfig.isEnableUnit()) {
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo reqDto = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
                reqDto.setDocumentCode(preemptParam.getSourceNo());
                reqDto.setVolumeDetailBos(volumeDetailBos);
                Map weightAndVolumeMap = Optional.ofNullable(this.orderUnitConversionRecordService.calculateWeightAndVolume(reqDto)).orElse(new HashMap());
                detailEoList.forEach(item -> {
                    BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)weightAndVolumeMap.get(item.getSkuCode() + InventoryConfig.getCommonSeparate() + item.getQuantity());
                    if (basicOrderDtoExtension != null) {
                        item.setWeight(basicOrderDtoExtension.getWeight());
                        item.setVolume(basicOrderDtoExtension.getVolume());
                    }
                });
            }
            this.transferOrderDetailDomain.deleteByTransferOrderNo(preemptParam.getSourceNo());
            this.transferOrderDetailDomain.insertBatch(detailEoList);
        }
    }

    public String getKey(String skuCode, BigDecimal num) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6);
    }

    public void release(String transferOrderNo, String type, boolean isAllRelease) {
        this.rollbackLogicInventory(transferOrderNo, type, isAllRelease);
    }

    private void rollbackLogicInventory(String transferOrderNo, String type, boolean isAllRelease) {
        ReleasePreemptDto releasePreemptParam = new ReleasePreemptDto();
        releasePreemptParam.setSourceNo(transferOrderNo);
        releasePreemptParam.setSourceType(CsInventorySourceTypeEnum.TRANSFER_OTHER_RELEASE.getCode());
        releasePreemptParam.setBusinessType(type);
        releasePreemptParam.setAllRelease(Boolean.valueOf(isAllRelease));
        this.calcInventoryService.releasePreempt(releasePreemptParam);
    }

    private void releaseLogicPreemptRecord(String warehouseType, List<String> sourceNoList) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryPreemptionDomain.filter().eq((Object)"warehouse_classify", (Object)warehouseType)).in((Object)"source_no", sourceNoList)).eq((Object)"valid", (Object)CsValidFlagEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).list();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List idList = list.stream().map(BaseEo::getId).collect(Collectors.toList());
            InventoryUsageRecordEo updateEo = new InventoryUsageRecordEo();
            updateEo.setValid(CsValidFlagEnum.DISABLE.getCode());
            updateEo.setDisplay(YesNoEnum.NO.getValue());
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.in((Object)"id", idList);
            this.inventoryPreemptionDomain.getMapper().update((Object)updateEo, (Wrapper)updateWrapper);
        }
    }

    public List<InventoryUsageRecordEo> queryPreemptTypeBySourceNo(String sourceNo, String valid, String warehouseClassify) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"source_no", (Object)sourceNo);
        wrapper.eq((Object)"valid", (Object)valid);
        wrapper.eq((Object)"warehouse_classify", (Object)warehouseClassify);
        wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        wrapper.orderByDesc((Object)"create_time");
        return this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)wrapper);
    }

    private Map<Object, OrderUnitConversionRecordDto> unitProcess(TransferOrderEo transferOrderEo, List<TransferOrderDetailReqDto> detailList, boolean canSave) {
        ArrayList unitConversionDetails = new ArrayList();
        detailList.forEach(detailEo -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(detailEo.getUnit());
            unitConversionDetail.setSkuCode(detailEo.getSkuCode());
            unitConversionDetail.setCurNum(detailEo.getQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(transferOrderEo.getTransferOrderNo());
        orderUnitConversionReqDto.setType(transferOrderEo.getType());
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        return orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

