/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.yunxi.dg.base.center.enums.InterOrganizationTransactionEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseCrossOrgConfigDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseCrossOrgConfigPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Component;

@Component
public class TransferOrderWarehouseExe {
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private ILogicWarehouseCrossOrgConfigDomain logicWarehouseCrossOrgConfigDomain;

    public void checkWarehouse(TransferOrderReqDto dto) {
        String outLogicWarehouseCode;
        String inLogicWarehouseCode = dto.getInLogicWarehouseCode();
        AssertUtil.isTrue((!inLogicWarehouseCode.equals(outLogicWarehouseCode = dto.getOutLogicWarehouseCode()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u51fa\u4e0e\u8c03\u62e8\u5165\u7684\u903b\u8f91\u4ed3\u4e00\u81f4\uff0c\u65e0\u6cd5\u521b\u5efa\u8c03\u62e8\u5355");
        HashSet<String> logicWarehouses = new HashSet<String>(2);
        logicWarehouses.add(inLogicWarehouseCode);
        logicWarehouses.add(outLogicWarehouseCode);
        this.checkLogicWarehouse(logicWarehouses);
        if (InterOrganizationTransactionEnum.COMPANY_TRANSACTION.getCode().equals(dto.getType()) || InterOrganizationTransactionEnum.COMPANY_TRANSACTION_RETURN.getCode().equals(dto.getType())) {
            List logicWarehouseRespDtoList = this.logicWarehouseCrossOrgConfigDomain.query(LogicWarehouseCrossOrgConfigPageReqDto.builder().businessType(Integer.valueOf(InterOrganizationTransactionEnum.COMPANY_TRANSACTION.getCode().equals(dto.getType()) ? 1 : 2)).build());
            AssertUtil.isTrue((boolean)logicWarehouseRespDtoList.stream().filter(o -> o.getType() == 1).map(LogicWarehouseRespDto::getWarehouseCode).anyMatch(o -> o.contains(outLogicWarehouseCode)), (String)"\u8c03\u62e8\u51fa\u903b\u8f91\u4ed3\u8d85\u51fa\u901a\u7528\u914d\u7f6e\u8303\u56f4");
            AssertUtil.isTrue((boolean)logicWarehouseRespDtoList.stream().filter(o -> o.getType() == 2).map(LogicWarehouseRespDto::getWarehouseCode).anyMatch(o -> o.contains(inLogicWarehouseCode)), (String)"\u8c03\u62e8\u5165\u903b\u8f91\u4ed3\u8d85\u51fa\u901a\u7528\u914d\u7f6e\u8303\u56f4");
        }
        LogicWarehouseEo inLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(inLogicWarehouseCode);
        AssertUtil.isTrue((boolean)Objects.nonNull(inLogicWarehouseEo), (String)"\u8c03\u5165\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        List inPhysicsWarehouseList = this.physicsWarehouseDomain.queryByWarehouseCode(inLogicWarehouseEo.getPhysicsWarehouseCode());
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inPhysicsWarehouseList), (String)"\u8c03\u5165\u903b\u8f91\u4ed3\u65e0\u5173\u8054\u7269\u7406\u4ed3");
        dto.setInPhysicsWarehouseCode(((PhysicsWarehouseEo)inPhysicsWarehouseList.get(0)).getWarehouseCode());
        dto.setInPhysicsWarehouseName(((PhysicsWarehouseEo)inPhysicsWarehouseList.get(0)).getWarehouseName());
        dto.setInLogicWarehouseName(inLogicWarehouseEo.getWarehouseName());
        LogicWarehouseEo outLogicWarehouseEo = this.logicWarehouseDomain.queryByCode(outLogicWarehouseCode);
        AssertUtil.isTrue((boolean)Objects.nonNull(outLogicWarehouseCode), (String)"\u8c03\u51fa\u903b\u8f91\u4ed3\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        List outPhysicsWarehouseList = this.physicsWarehouseDomain.queryByWarehouseCode(outLogicWarehouseEo.getPhysicsWarehouseCode());
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)outPhysicsWarehouseList), (String)"\u8c03\u51fa\u903b\u8f91\u4ed3\u65e0\u5173\u8054\u7269\u7406\u4ed3");
        dto.setOutPhysicsWarehouseCode(((PhysicsWarehouseEo)outPhysicsWarehouseList.get(0)).getWarehouseCode());
        dto.setOutPhysicsWarehouseName(((PhysicsWarehouseEo)outPhysicsWarehouseList.get(0)).getWarehouseName());
        dto.setOutLogicWarehouseName(outLogicWarehouseEo.getWarehouseName());
    }

    private void checkPhysicsWarehouse(Set<String> warehouseCodes) {
        List list = ((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (warehouseCodes.size() != list.size()) {
            Map<String, String> physicsMap = list.stream().collect(Collectors.toMap(PhysicsWarehouseEo::getWarehouseCode, PhysicsWarehouseEo::getWarehouseName, (o, o1) -> o));
            this.checkExist(warehouseCodes, physicsMap);
        }
    }

    private void checkLogicWarehouse(Set<String> warehouseCodes) {
        List list = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().in((Object)"warehouse_code", warehouseCodes)).list();
        if (warehouseCodes.size() != list.size()) {
            Map<String, String> logicMap = list.stream().collect(Collectors.toMap(LogicWarehouseEo::getWarehouseCode, LogicWarehouseEo::getWarehouseName));
            this.checkExist(warehouseCodes, logicMap);
        }
    }

    private void checkExist(Set<String> warehouseCodes, Map<String, String> warehouseMap) {
        StringBuilder errorMsg = new StringBuilder();
        for (String warehouseCode : warehouseCodes) {
            if (warehouseMap.containsKey(warehouseCode)) continue;
            errorMsg.append(warehouseCode);
        }
        errorMsg.append("\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728");
        throw new BizException(errorMsg.toString());
    }
}

