/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.guard;

import cn.hutool.core.util.ObjectUtil;
import com.dtyunxi.exceptions.BizException;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.share.dto.entity.DgVirtualInventoryDto;
import com.yunxi.dg.base.center.share.dto.entity.LogicVirtualInventoryDto;
import com.yunxi.dg.base.center.share.dto.entity.LogicWarehouseReqDto;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgVirtualInventoryApiProxy;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.guard.Guard;
import org.springframework.stereotype.Component;

@Component
public class VirtualInventoryCheckGuard
implements Guard<TransferOrderApprovalState, TransferOrderApprovalEvent> {
    private static final Logger log = LoggerFactory.getLogger(VirtualInventoryCheckGuard.class);
    @Resource
    private IDgVirtualInventoryApiProxy iDgVirtualInventoryApiProxy;

    public boolean evaluate(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        Boolean judge = false;
        TransferOrderKeyDto keyDto = (TransferOrderKeyDto)context.getExtendedState().getVariables().get("transferOrderReqDto");
        TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().getVariables().get("transferOrderEo");
        List detailEoList = (List)context.getExtendedState().getVariables().get("detailEoList");
        if (ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)keyDto.getIsSupplyInventory())) {
            LogicWarehouseReqDto logicWarehouseReqDto = new LogicWarehouseReqDto();
            logicWarehouseReqDto.setLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
            logicWarehouseReqDto.setSkuCodeList(detailEoList.stream().map(TransferOrderDetailEo::getSkuCode).collect(Collectors.toList()));
            List logicVirtualInventoryDtoList = (List)this.iDgVirtualInventoryApiProxy.logicByVirtualInventory(Arrays.asList(logicWarehouseReqDto)).getData();
            AssertUtils.notNull((Object)logicVirtualInventoryDtoList, (String)"\u903b\u8f91\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u7b56\u7565");
            Map<String, BigDecimal> skuCodeAvailableMap = ((LogicVirtualInventoryDto)logicVirtualInventoryDtoList.get(0)).getDgVirtualInventoryDtoList().stream().filter(r -> ObjectUtil.equals((Object)r.getWarehouseCode(), (Object)transferOrderEo.getSubWarehouseCode())).collect(Collectors.toMap(DgVirtualInventoryDto::getSkuCode, DgVirtualInventoryDto::getAvailable, (k, k1) -> k));
            for (TransferOrderDetailEo transferOrderDetailEo : detailEoList) {
                BigDecimal virtualAvailable = skuCodeAvailableMap.get(transferOrderDetailEo.getSkuCode());
                if (!skuCodeAvailableMap.containsKey(transferOrderDetailEo.getSkuCode())) {
                    throw new BizException("\u903b\u8f91\u4ed3\u672a\u5173\u8054\u4f9b\u8d27\u7b56\u7565");
                }
                if (BigDecimalUtils.le((BigDecimal)virtualAvailable, (BigDecimal)transferOrderDetailEo.getQuantity()).booleanValue() && !ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)keyDto.getIsBorrowGoods())) {
                    throw new BizException("\u5546\u54c1\u7f16\u7801" + transferOrderDetailEo.getSkuCode() + "\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4e0d\u8db3");
                }
                judge = BigDecimalUtils.le((BigDecimal)virtualAvailable, (BigDecimal)transferOrderDetailEo.getQuantity()) != false && ObjectUtil.equals((Object)YesNoEnum.YES.getValue(), (Object)keyDto.getIsBorrowGoods());
            }
        }
        return judge;
    }
}

