/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.dao.mapper.StateMachineMapper;
import com.yunxi.dg.base.center.inventory.eo.StateMachineEo;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import javax.annotation.Resource;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.support.DefaultStateMachineContext;
import org.springframework.stereotype.Component;

@Component
public class ReceiveStateMachinePersist
implements StateMachinePersist<TransferOrderReceiveState, TransferOrderReceiveEvent, String> {
    @Resource
    private StateMachineMapper stateMachineMapper;

    private String convertToJson(StateMachineContext<TransferOrderReceiveState, TransferOrderReceiveEvent> ctx) {
        return JSON.toJSONString(ctx);
    }

    public void write(StateMachineContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context, String transferOrderNo) throws Exception {
        StateMachineEo db = this.stateMachineMapper.selectByTypeAndMachineKey("RECEIVE", transferOrderNo);
        if (db == null) {
            StateMachineEo entity = new StateMachineEo();
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderReceiveState)context.getState()).getCode());
            entity.setType("RECEIVE");
            this.stateMachineMapper.insert((Object)entity);
        } else {
            StateMachineEo entity = new StateMachineEo();
            entity.setId(db.getId());
            entity.setMachineKey(transferOrderNo);
            entity.setStatus(((TransferOrderReceiveState)context.getState()).getCode());
            entity.setType("RECEIVE");
            this.stateMachineMapper.updateById((BaseEo)entity);
        }
    }

    public StateMachineContext<TransferOrderReceiveState, TransferOrderReceiveEvent> read(String transferOrderNo) throws Exception {
        StateMachineEo entity = this.stateMachineMapper.selectByTypeAndMachineKey("RECEIVE", transferOrderNo);
        if (entity != null) {
            TransferOrderReceiveState approvalState = TransferOrderReceiveState.getByCode((String)entity.getStatus());
            return new DefaultStateMachineContext((Object)approvalState, null, null, null, null, transferOrderNo);
        }
        return new DefaultStateMachineContext((Object)TransferOrderReceiveState.WAITING_FOR_DELIVERY, null, null, null, null, transferOrderNo);
    }
}

