/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryThirdAuditConfigurationDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.other.stateMachine.enums.DgExternalAuditStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderWithdrawExe;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderApprovalAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCancelAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.guard.VirtualInventoryCheckGuard;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.AbstractTransferAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.ApprovalStateMachinePersist;
import com.yunxi.dg.base.center.inventory.service.third.PushThirdAuditBo;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalEvent;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.EnumStateMachineConfigurerAdapter;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.statemachine.state.State;

@Configuration
@EnableStateMachineFactory(name={"approvalStateMachine"})
public class TransferOrderApprovalStateMachineConfig
extends EnumStateMachineConfigurerAdapter<TransferOrderApprovalState, TransferOrderApprovalEvent> {
    @Resource
    private TransferOrderWithdrawExe transferOrderWithdrawExe;
    @Resource
    private TransferOrderCancelAction transferOrderCancelAction;
    @Resource
    private TransferOrderApprovalAction transferOrderApprovalAction;
    @Resource
    private ApprovalStateMachinePersist approvalStateMachinePersist;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IInventoryThirdAuditConfigurationDomain inventoryThirdAuditConfigurationDomain;
    @Resource
    private ITransferOrderDomain iTransferOrderDomain;
    @Resource
    private VirtualInventoryCheckGuard virtualInventoryCheckGuard;
    @Resource
    private TransactionCallBackService transactionCallBackService;
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderApprovalStateMachineConfig.class);

    public void configure(StateMachineConfigurationConfigurer<TransferOrderApprovalState, TransferOrderApprovalEvent> config) throws Exception {
        config.withConfiguration().autoStartup(false).machineId("approvalStateMachine").listener(this.listener());
    }

    public void configure(StateMachineStateConfigurer<TransferOrderApprovalState, TransferOrderApprovalEvent> states) throws Exception {
        states.withStates().initial((Object)TransferOrderApprovalState.PENDING_SUBMISSION, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.PRIMARY_PENDING, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.PRIMARY_REJECTED, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.TRANSFER_HANG_UP, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.SECONDARY_APPROVED, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.WAIT_THIRD_AUDIT, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.SECONDARY_REJECTED, this.getTransferOrderSendMqAction()).state((Object)TransferOrderApprovalState.CANCELLED, this.getTransferOrderSendMqAction()).choice((Object)TransferOrderApprovalState.COMMIT_CHOISE).choice((Object)TransferOrderApprovalState.AUDIT_CHOISE);
    }

    public void configure(StateMachineTransitionConfigurer<TransferOrderApprovalState, TransferOrderApprovalEvent> transitions) throws Exception {
        ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)TransferOrderApprovalState.PENDING_SUBMISSION)).event((Object)TransferOrderApprovalEvent.SUBMIT_PRIMARY)).target((Object)TransferOrderApprovalState.COMMIT_CHOISE).and()).withChoice().source((Object)TransferOrderApprovalState.COMMIT_CHOISE).first((Object)TransferOrderApprovalState.WAIT_THIRD_AUDIT, context -> {
            TransferOrderEo transferEo = (TransferOrderEo)context.getStateMachine().getExtendedState().getVariables().get("transferEo");
            return this.inventoryThirdAuditConfigurationDomain.canThirdAudit(transferEo.getOrderType(), transferEo.getType(), Integer.valueOf(1));
        }, this.thirdAuditAction()).last((Object)TransferOrderApprovalState.PRIMARY_PENDING, this.commitAction()).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_PENDING)).target((Object)TransferOrderApprovalState.TRANSFER_HANG_UP).event((Object)TransferOrderApprovalEvent.HANG_UP)).action(this.getTransferOrderHangUpStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.TRANSFER_HANG_UP)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.UN_HANG_UP)).action(this.getTransferOrderUnHangUpStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_REJECTED)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.SUBMIT_PRIMARY)).action(this.getTransferOrderApprovalStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.SECONDARY_REJECTED)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.SUBMIT_PRIMARY)).action(this.getTransferOrderApprovalStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_PENDING)).target((Object)TransferOrderApprovalState.AUDIT_CHOISE).event((Object)TransferOrderApprovalEvent.PASS_PRIMARY)).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_AUDIT)).target((Object)TransferOrderApprovalState.AUDIT_CHOISE).event((Object)TransferOrderApprovalEvent.PASS_PRIMARY)).and()).withChoice().source((Object)TransferOrderApprovalState.AUDIT_CHOISE).first((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT, context -> {
            TransferOrderEo transferEo = (TransferOrderEo)context.getExtendedState().getVariables().get("transferOrderEo");
            boolean isPhysics = TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode().equals(transferEo.getType()) && transferEo.getOutLogicWarehouseCode().equals(transferEo.getInLogicWarehouseCode());
            return !isPhysics && this.inventoryThirdAuditConfigurationDomain.canThirdAudit(transferEo.getOrderType(), transferEo.getType(), Integer.valueOf(2));
        }, this.waitThirdTwoAuditAction()).then((Object)TransferOrderApprovalState.SECONDARY_APPROVED, context -> {
            TransferOrderEo transferEo = (TransferOrderEo)context.getExtendedState().getVariables().get("transferOrderEo");
            return TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode().equals(transferEo.getType()) && transferEo.getOutLogicWarehouseCode().equals(transferEo.getInLogicWarehouseCode());
        }, this.oaStatusAction(DgExternalAuditStatusEnum.OA_DISPENSE_WITH)).last((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY, context -> {
            context.getExtendedState().getVariables().put("orderStatus", TransferOrderStatus.WAITING_SECONDARY_APPROVAL.code());
            context.getExtendedState().getVariables().put("approvalStatus", TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode());
            this.getOrderApprovalStateTransferOrderApprovalEventAction().execute(context);
        }).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_PENDING)).target((Object)TransferOrderApprovalState.PRIMARY_REJECTED).event((Object)TransferOrderApprovalEvent.REJECT_PRIMARY)).action(this.getApprovalStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_PENDING)).target((Object)TransferOrderApprovalState.CANCELLED).event((Object)TransferOrderApprovalEvent.CANCEL)).action(this.getStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_AUDIT)).target((Object)TransferOrderApprovalState.CANCELLED).event((Object)TransferOrderApprovalEvent.CANCEL)).action(this.thirdCancelAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.WAITING_SECONDARY_WITHDRAW)).action(this.getTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.WAITING_SECONDARY_WITHDRAW)).action(context -> {
            context.getExtendedState().getVariables().put("externalProcessState", DgExternalAuditStatusEnum.OA_WITHDRAW_SUCCEED.getKey());
            if (this.pushThirdCancel((StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent>)context)) {
                this.getTransferOrderApprovalEventAction().execute(context);
            }
        })).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY)).target((Object)TransferOrderApprovalState.SECONDARY_APPROVED).event((Object)TransferOrderApprovalEvent.PASS_SECONDARY)).action(this.getOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT)).target((Object)TransferOrderApprovalState.SECONDARY_APPROVED).event((Object)TransferOrderApprovalEvent.PASS_SECONDARY)).action(this.oaStatusAction(DgExternalAuditStatusEnum.OA_AUDIT_PASS))).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_PENDING)).target((Object)TransferOrderApprovalState.SECONDARY_APPROVED).event((Object)TransferOrderApprovalEvent.PASS_SECONDARY)).action(this.getOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_AUDIT)).target((Object)TransferOrderApprovalState.SECONDARY_APPROVED).event((Object)TransferOrderApprovalEvent.PASS_SECONDARY)).action(this.getOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PENDING_SUBMISSION)).target((Object)TransferOrderApprovalState.SECONDARY_APPROVED).event((Object)TransferOrderApprovalEvent.PASS_SECONDARY)).action(this.getOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY)).target((Object)TransferOrderApprovalState.SECONDARY_REJECTED).event((Object)TransferOrderApprovalEvent.REJECT_SECONDARY)).action(this.getApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT)).target((Object)TransferOrderApprovalState.SECONDARY_REJECTED).event((Object)TransferOrderApprovalEvent.REJECT_SECONDARY)).action(context -> this.getApprovalEventAction().execute(context))).and()).withExternal().source((Object)TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.CANCEL)).action(this.getStateTransferOrderApprovalEventAction())).and()).withExternal().source((Object)TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT)).target((Object)TransferOrderApprovalState.PRIMARY_PENDING).event((Object)TransferOrderApprovalEvent.CANCEL)).action(this.thirdCancelAction());
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> commitAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                context.getExtendedState().getVariables().put("orderStatus", TransferOrderStatus.WAITING_APPROVAL.code());
                context.getExtendedState().getVariables().put("approvalStatus", TransferOrderApprovalState.PRIMARY_PENDING.getCode());
                TransferOrderEo transferEo = (TransferOrderEo)context.getStateMachine().getExtendedState().getVariables().get("transferEo");
                if (Objects.nonNull(transferEo)) {
                    boolean thirdAudit = TransferOrderApprovalStateMachineConfig.this.inventoryThirdAuditConfigurationDomain.canThirdAudit(transferEo.getOrderType(), transferEo.getType(), Integer.valueOf(2));
                    context.getExtendedState().getVariables().put("externalProcessState", thirdAudit ? DgExternalAuditStatusEnum.OA_WAIT_AUDIT.getKey() : DgExternalAuditStatusEnum.OA_DISPENSE_WITH.getKey());
                }
                TransferOrderApprovalStateMachineConfig.this.getTransferOrderApprovalStateTransferOrderApprovalEventAction().execute(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> oaStatusAction(final DgExternalAuditStatusEnum oaDispenseWith) {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                context.getExtendedState().getVariables().put("externalProcessState", oaDispenseWith.getKey());
                TransferOrderApprovalStateMachineConfig.this.getOrderApprovalEventAction().execute(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> thirdCancelAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                if (TransferOrderApprovalStateMachineConfig.this.pushThirdCancel((StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent>)context)) {
                    TransferOrderApprovalStateMachineConfig.this.getStateTransferOrderApprovalEventAction().execute(context);
                }
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> waitThirdTwoAuditAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                context.getExtendedState().getVariables().put("orderStatus", TransferOrderStatus.WAIT_THIRD_TWO_AUDIT.code());
                context.getExtendedState().getVariables().put("approvalStatus", TransferOrderApprovalState.WAIT_THIRD_TWO_AUDIT.getCode());
                context.getExtendedState().getVariables().put("externalProcessState", DgExternalAuditStatusEnum.OA_AUDITING.getKey());
                if (TransferOrderApprovalStateMachineConfig.this.pushThirdAudit((StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent>)context)) {
                    TransferOrderApprovalStateMachineConfig.this.getOrderApprovalStateTransferOrderApprovalEventAction().execute(context);
                }
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> thirdAuditAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                context.getExtendedState().getVariables().put("orderStatus", TransferOrderStatus.WAIT_THIRD_AUDIT.code());
                context.getExtendedState().getVariables().put("approvalStatus", TransferOrderApprovalState.WAIT_THIRD_AUDIT.getCode());
                if (TransferOrderApprovalStateMachineConfig.this.pushThirdAudit((StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent>)context)) {
                    TransferOrderApprovalStateMachineConfig.this.getTransferOrderApprovalStateTransferOrderApprovalEventAction().execute(context);
                }
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.rejectSecondary(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.passSecondary(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderWithdrawExe.waitingSecondWithdrawApprovalWithdraw(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderCancelAction.approvalStatusCancel(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getApprovalStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.rejectPrimary(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getOrderApprovalStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.passPrimary(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getTransferOrderApprovalStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.submitPrimary(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getTransferOrderHangUpStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.hangUp(context);
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getTransferOrderUnHangUpStateTransferOrderApprovalEventAction() {
        return new AbstractTransferAction<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
                TransferOrderApprovalStateMachineConfig.this.transferOrderApprovalAction.unHangUp(context);
            }
        };
    }

    @Bean
    public StateMachineListener<TransferOrderApprovalState, TransferOrderApprovalEvent> listener() {
        return new StateMachineListenerAdapter<TransferOrderApprovalState, TransferOrderApprovalEvent>(){

            public void stateChanged(State<TransferOrderApprovalState, TransferOrderApprovalEvent> from, State<TransferOrderApprovalState, TransferOrderApprovalEvent> to) {
                logger.info("--------------\u72b6\u6001\u673a-\u76d1\u542c\u5668--------------------");
                logger.info("\u76d1\u542c\u5668:  {}", (Object)to.getStates().toString());
                logger.info("-----------------------------------");
            }

            public void stateMachineError(StateMachine<TransferOrderApprovalState, TransferOrderApprovalEvent> stateMachine, Exception exception) {
                if (exception == null) {
                    return;
                }
                logger.info("\u72b6\u6001\u673a\u6267\u884c\u5f02\u5e38:{}", (Object)exception.getMessage());
                stateMachine.getExtendedState().getVariables().put("errMsg", exception.getMessage());
            }
        };
    }

    @NotNull
    private Action<TransferOrderApprovalState, TransferOrderApprovalEvent> getTransferOrderSendMqAction() {
        return context -> {
            logger.info("\u8c03\u62e8\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001");
            TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                if (transferOrderEo == null) {
                    return;
                }
                TransferOrderRespDto transferOrderRespDto = this.iTransferOrderDomain.queryByTransferOrderNo(transferOrderEo.getTransferOrderNo());
                Optional.ofNullable(transferOrderRespDto).ifPresent(or -> this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)or)));
            });
        };
    }

    @NotNull
    private boolean pushThirdAudit(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        TransferOrderEo transferOrderEo = (TransferOrderEo)context.getStateMachine().getExtendedState().getVariables().get("transferOrderEo");
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        boolean result = false;
        try {
            result = InventoryConfig.getPushThirdAuditAble().push(PushThirdAuditBo.builder().businessOrderId(transferOrderEo.getId()).businessOrderNo(transferOrderEo.getTransferOrderNo()).businessType(transferOrderEo.getType()).userCode(requestUserCode).userName(requestUserCode).orderType("transfer_order").build());
        }
        catch (Exception e) {
            context.getStateMachine().setStateMachineError(e);
            context.getExtendedState().getVariables().put("errMsg", e.getMessage());
        }
        return result;
    }

    @NotNull
    private boolean pushThirdCancel(StateContext<TransferOrderApprovalState, TransferOrderApprovalEvent> context) {
        String transferOrderNo = (String)context.getExtendedState().get((Object)"transferOrderNo", String.class);
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iTransferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).last("limit 1")).one();
        String requestUserCode = (String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"");
        boolean result = false;
        try {
            result = InventoryConfig.getPushThirdAuditAble().cancel(PushThirdAuditBo.builder().businessOrderId(transferOrderEo.getId()).businessOrderNo(transferOrderEo.getTransferOrderNo()).businessType(transferOrderEo.getType()).userCode(requestUserCode).userName(requestUserCode).orderType("transfer_order").build());
        }
        catch (Exception e) {
            context.getStateMachine().setStateMachineError(e);
            context.getExtendedState().getVariables().put("errMsg", e.getMessage());
        }
        return result;
    }

    @Bean(name={"approvalStateMachinePersister"})
    public StateMachinePersister<TransferOrderApprovalState, TransferOrderApprovalEvent, String> approvalStateMachinePersister() {
        return new DefaultStateMachinePersister((StateMachinePersist)this.approvalStateMachinePersist);
    }
}

