/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.FutureInDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.IFutureInAble;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FutureInAbleImpl
extends BaseAble
implements IFutureInAble {
    private static final Logger log = LoggerFactory.getLogger(FutureInAbleImpl.class);

    @Override
    public void futureIn(FutureInDto dto) {
        log.info("warehouse inventory futureIn(\u589e\u52a0\u5f85\u6536), param:{}", (Object)JSON.toJSONString((Object)dto));
        dto.setNoneBatch(Boolean.valueOf(true));
        dto.setValidNegative(Boolean.FALSE);
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        List details = dto.getDetails();
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, (source, target) -> {
            target.setValidNegative(dto.getValidNegative());
            target.setOperate(dto.getDesc());
            target.setChangeFutureIn(source.getNum());
            target.setBatch((String)DataExtractUtils.ifNullElse((Object)target.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
        });
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        List<LogicWarehouseEo> logicWarehouseEos = this.getLogicWarehouseEosAndCheck(details);
        this.checkSku(details);
        this.inventoryDueInDomain.insertBatch(this.transferDueIn(details, dto.getSourceNo()));
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(true).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    public CalcInventoryDto createLogicTotalCalcDto(FutureInDto dto) {
        CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
        calcInventoryDto.setSourceNo(dto.getSourceNo());
        calcInventoryDto.setSourceType(dto.getSourceType());
        calcInventoryDto.setBusinessType(dto.getBusinessType());
        calcInventoryDto.setExternalOrderNo(dto.getExternalOrderNo());
        calcInventoryDto.setRemark(dto.getDesc());
        ArrayList details = Lists.newArrayList();
        for (CalcDetailDto pd : dto.getDetails()) {
            CalcInventoryDetailDto detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc());
            detailDto.setChangeFutureIn(pd.getNum());
            detailDto.setWarehouseCode(pd.getLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setValidNegative(dto.getValidNegative());
            detailDto.setInventoryProperty(pd.getInventoryProperty());
            details.add(detailDto);
        }
        calcInventoryDto.setDetails((List)details);
        return calcInventoryDto;
    }
}

