/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.calc.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.calc.TransferOutDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.calc.BaseAble;
import com.yunxi.dg.base.center.inventory.service.calc.CalcExecuteBo;
import com.yunxi.dg.base.center.inventory.service.calc.ITransferOutAble;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TransferOutAbleImpl
extends BaseAble
implements ITransferOutAble {
    private static final Logger log = LoggerFactory.getLogger(TransferOutAbleImpl.class);

    @Override
    public void transferOut(TransferOutDto dto) {
        log.info("warehouse inventory transferOut(\u8c03\u62e8\u51fa\u5e93), param:{}", (Object)JSON.toJSONString((Object)dto));
        this.check((CalcDto)dto);
        this.checkDetails((CalcDto)dto);
        AssertUtils.notBlank((String)dto.getInLogicWarehouseCode(), (String)"\u5165\u4ed3\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List details = dto.getDetails();
        List inventoryUsageRecordEos = this.inventoryPreemptionDomain.queryBySourceNo(dto.getSourceNo());
        if (CollectionUtil.isEmpty((Collection)inventoryUsageRecordEos) && !dto.getIgnorePreempt().booleanValue()) {
            throw new BizException(StrUtil.format((CharSequence)"\u8be5\u5355\u636e[%s]\u67e5\u8be2\u4e0d\u5230\u9884\u5360\u8bb0\u5f55", (Object[])new Object[]{dto.getSourceNo()}));
        }
        List<String> logicWarehouseCodes = details.stream().map(CalcDetailDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        logicWarehouseCodes.add(dto.getInLogicWarehouseCode());
        List<LogicWarehouseEo> logicWarehouseEos = this.queryEnableLogicWarehouseByCodes(logicWarehouseCodes);
        AssertUtils.notEmpty(logicWarehouseEos, (String)"\u903b\u8f91\u4ed3[%s]\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u88ab\u7981\u7528", (Object[])new Object[]{logicWarehouseCodes});
        List<ItemSkuDto> skuDtos = this.checkSku(details);
        if (InventoryConfig.isPreemptHiddenBatch() && dto.getDetails().stream().anyMatch(r -> "99999999-hidden".equals(r.getBatch()))) {
            List noMatchDetails = dto.getDetails().stream().filter(r -> !"99999999-hidden".equals(r.getBatch())).collect(Collectors.toList());
            dto.setDetails(dto.getDetails().stream().filter(r -> "99999999-hidden".equals(r.getBatch())).collect(Collectors.toList()));
            this.shoutLogicInventoryEosByOut(dto, logicWarehouseEos.stream().filter(r -> !Objects.equals(dto.getInLogicWarehouseCode(), r.getWarehouseCode())).collect(Collectors.toList()), skuDtos, new ArrayList<LogicInventoryEo>());
            dto.getDetails().addAll(noMatchDetails);
        }
        dto.getDetails().stream().filter(r -> !r.isNeedFindBatch()).forEach(r -> r.setBatch(InventoryConfig.getDefaultBatch()));
        ArrayList<CalcDetailDto> releaseDetails = dto.getIgnorePreempt() != false ? new ArrayList(10) : this.updatePreempt(details, inventoryUsageRecordEos);
        this.inventoryDueInDomain.insertBatch(this.transferDueIn(dto.getDetails().stream().map(r -> {
            CalcDetailDto calcDetailDto = (CalcDetailDto)BeanUtil.copyProperties((Object)r, CalcDetailDto.class, (String[])new String[0]);
            calcDetailDto.setLogicWarehouseCode(dto.getInLogicWarehouseCode());
            return calcDetailDto;
        }).collect(Collectors.toList()), dto.getSourceNo()));
        CalcInventoryDto logicCalcDto = this.createLogicCalcDto(dto, releaseDetails);
        CalcInventoryDto logicTotalCalcDto = this.createCalcLogicTotalDtoByLogicDto(logicCalcDto);
        this.calcExecuteManager.register(CalcExecuteBo.builder().updateModel(true).logicWarehouseEos(logicWarehouseEos).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicCalcDto})).build());
        this.calcExecuteManager.register(CalcExecuteBo.builder().logicWarehouseEos(logicWarehouseEos).updateModel(false).calcDto(Lists.newArrayList((Object[])new CalcInventoryDto[]{logicTotalCalcDto})).build());
    }

    private CalcInventoryDto createLogicCalcDto(TransferOutDto dto, List<CalcDetailDto> releaseDetails) {
        CalcInventoryDetailDto detailDto;
        CalcInventoryDto calcInventoryDto = this.createLogicCalcDto(dto, (CalcDetailDto source, CalcInventoryDetailDto target) -> {
            target.setOperate(dto.getDesc() + "-\u51fa\u5e93");
            target.setChangeBalance(BigDecimalUtils.negate((BigDecimal)source.getNum()));
            target.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)source.getNum()));
        });
        for (CalcDetailDto releaseDetail : releaseDetails) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u91ca\u653e\u9884\u5360");
            detailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)releaseDetail.getNum()));
            detailDto.setChangeAvailable(releaseDetail.getNum());
            detailDto.setWarehouseCode(releaseDetail.getLogicWarehouseCode());
            detailDto.setSkuCode(releaseDetail.getSkuCode());
            TransferOutAbleImpl.settingBatch(detailDto, releaseDetail);
            detailDto.setInventoryProperty(releaseDetail.getInventoryProperty());
            detailDto.setValidNegative(Boolean.valueOf(false));
            calcInventoryDto.getDetails().add(detailDto);
        }
        for (CalcDetailDto pd : dto.getDetails()) {
            detailDto = new CalcInventoryDetailDto();
            detailDto.setOperate(dto.getDesc() + "-\u589e\u52a0\u5728\u9014");
            detailDto.setChangeIntransit(pd.getNum());
            detailDto.setWarehouseCode(dto.getInLogicWarehouseCode());
            detailDto.setSkuCode(pd.getSkuCode());
            detailDto.setBatch(pd.getBatch());
            detailDto.setExpireTime(pd.getExpireDate());
            detailDto.setProduceTime(pd.getProduceDate());
            detailDto.setInventoryProperty(pd.getInventoryProperty());
            detailDto.setValidNegative(Boolean.valueOf(false));
            calcInventoryDto.getDetails().add(detailDto);
        }
        return calcInventoryDto;
    }
}

