/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commons;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.yunxi.dg.base.center.enums.PcpBasicInventoryBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.PcpBasicTradeBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.PcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.SapCenterTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.dto.sap.PushItemReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushSalesHeadReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushSalesItemReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushSalesTransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushStorageOrderHeadReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushStorageOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushTransferStorageOrderHeadReqDto;
import com.yunxi.dg.base.center.inventory.dto.sap.PushTransferStorageOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SapPushHelper {
    private static final Logger log = LoggerFactory.getLogger(SapPushHelper.class);
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ITransferOrderDas transferOrderDas;

    public void pushResultOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        log.info("\u63a8\u9001\u5355\u636e\u5165\u53c2 csDeliveryResultOrderEo:{},detailEoList:{}", (Object)JSON.toJSONString((Object)csDeliveryResultOrderEo), (Object)JSON.toJSONString(detailEoList));
        List<String> transferList = Arrays.asList(PcpBasicInventoryBusinessTypeEnum.TRANSFER_WARHEOUSE.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORES_TO_CARGO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_SALES_WARHEOUSE_SEND.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_BACK.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STORE_RAISED.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_WAREHOUSE.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_STORE_ENQUIRY.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_WAREHOUSE_DELIVERY.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_STORE_ENQUIRY_REFUND.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode());
        List<String> notSaleListList = Arrays.asList(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_TRIAL_PRODUCTION.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEMONSTRATE_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_DEVELOPMENT_ACQUISITION.getCode(), PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_MAINTENANCE_MATERIALS.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_OPPORTUNITY.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_BORROW_MACHINE.getCode(), PcpBusinessTypeEnum.OTHER_OUT.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RECEIVE_OUT.getCode(), PcpBusinessTypeEnum.SALES_OUTBOUND_MARKETING_MATERIAL.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RECEIVE_IN.getCode());
        List<String> notPurchaseList = Arrays.asList(PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_TRIAL_PRODUCTION.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEMONSTRATE_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_PACKAGING_RECIPIENTS.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_DEVELOPMENT_ACQUISITION.getCode(), PcpBasicTradeBusinessTypeEnum.REFUND_ORDER_MAINTENANCE_MATERIALS.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_STAFF_ALSO.getCode(), PcpBasicInventoryBusinessTypeEnum.TRANSFER_RETURN_PILOT_MACHINE.getCode(), PcpBusinessTypeEnum.CUSTOMER_REFUNDING_ORDER.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RECEIVE_OUT.getCode(), PcpBusinessTypeEnum.SALES_OUTBOUND_MARKETING_MATERIAL.getCode(), PcpBusinessTypeEnum.DICT_ALLOT_PRODUCTION_RECEIVE_IN.getCode());
        log.info("\u63a8\u9001\u5355\u636e\u7c7b\u578b:" + csDeliveryResultOrderEo.getDisplayBusinessType());
        if (transferList.contains(csDeliveryResultOrderEo.getDisplayBusinessType())) {
            this.pushTransferResultOrder(csDeliveryResultOrderEo, detailEoList);
        } else if (PcpBusinessTypeEnum.DICT_ALLOT_CONSIGNMENT_SALE.getCode().equals(csDeliveryResultOrderEo.getDisplayBusinessType())) {
            this.pushSaleTransferResultOrder(csDeliveryResultOrderEo, detailEoList);
        } else if (notSaleListList.contains(csDeliveryResultOrderEo.getDisplayBusinessType())) {
            this.pushNotSaleResultOrder(csDeliveryResultOrderEo, detailEoList);
        } else if (notPurchaseList.contains(csDeliveryResultOrderEo.getDisplayBusinessType())) {
            this.pushNotPurchaseResultOrder(csDeliveryResultOrderEo, detailEoList);
        }
    }

    private void pushNotPurchaseResultOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        this.pushOrder(csDeliveryResultOrderEo, detailEoList);
    }

    private void pushNotSaleResultOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        this.pushOrder(csDeliveryResultOrderEo, detailEoList);
    }

    private void pushOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        String message;
        String tag;
        String warehouseCode;
        String moveType = null;
        if ("delivery".equals(csDeliveryResultOrderEo.getOrderType())) {
            warehouseCode = csDeliveryResultOrderEo.getDeliveryLogicWarehouseCode();
            tag = "PUSH_DELIVERY_RESULT_ORDER";
            moveType = SapCenterTypeEnum.getSapType((String)csDeliveryResultOrderEo.getDisplayBusinessType());
            message = "pushOrder\u63a8\u9001\u975e\u9500\u552e\u51fa\u5e93\u5355mq\u6d88\u606f\uff0cmoveType:" + moveType;
        } else {
            warehouseCode = csDeliveryResultOrderEo.getReceiveLogicWarehouseCode();
            tag = "PUSH_RECEIVED_RESULT_ORDER";
            message = "pushOrder\u63a8\u9001\u83f2\u91c7\u8d2d\u5165\u5e93\u5355mq\u6d88\u606f";
        }
        PushStorageOrderHeadReqDto head = new PushStorageOrderHeadReqDto();
        head.setId(csDeliveryResultOrderEo.getId().toString());
        head.setCreateDate(DateUtil.formatDateTime((Date)csDeliveryResultOrderEo.getCreateTime()));
        head.setSapMoveType("");
        if (StringUtils.isNotEmpty((CharSequence)moveType)) {
            head.setSapMoveType(moveType);
        }
        head.setKostl("C10005021");
        String factoryType = "1220";
        head.setFactoryType(factoryType);
        head.setCustomerCode("");
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDas.filter().eq((Object)"transfer_order_no", (Object)csDeliveryResultOrderEo.getRelevanceNo())).one();
        if (transferOrder != null && StringUtils.isNotEmpty((CharSequence)transferOrder.getCustomerCode())) {
            head.setCustomerCode(transferOrder.getCustomerCode());
        }
        head.setTransferOrderNo(csDeliveryResultOrderEo.getRelevanceNo());
        head.setSrcOrderNo(csDeliveryResultOrderEo.getExternalOrderNo());
        head.setRefNo(csDeliveryResultOrderEo.getPreOrderNo());
        ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailEoList.size());
        for (int i = 0; i < detailEoList.size(); ++i) {
            PushItemReqDto sapItemReqDto = new PushItemReqDto();
            sapItemReqDto.setCode(detailEoList.get(i).getSkuCode());
            sapItemReqDto.setRowNum(String.valueOf(i + 1));
            sapItemReqDto.setWarehouseCode(warehouseCode);
            sapItemReqDto.setNum(detailEoList.get(i).getQuantity().toString());
            sapItemReqDto.setFactoryType(factoryType);
            sapItemReqDto.setMoveReason("");
            itemReqDtoList.add(sapItemReqDto);
        }
        PushStorageOrderReqDto sapStorageOrderReqDto = new PushStorageOrderReqDto();
        sapStorageOrderReqDto.setStorageOrderHearReqDto(head);
        sapStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
        log.info(message);
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)sapStorageOrderReqDto));
    }

    private void pushSaleTransferResultOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        String factoryType = "1220";
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDas.filter().eq((Object)"transfer_order_no", (Object)csDeliveryResultOrderEo.getRelevanceNo())).one();
        if (transferOrder != null) {
            String warehouseCode;
            String sapType;
            if ("out".equals(csDeliveryResultOrderEo.getOrderType())) {
                sapType = "ZKB";
                warehouseCode = csDeliveryResultOrderEo.getDeliveryLogicWarehouseCode();
            } else {
                sapType = "ZKA";
                warehouseCode = csDeliveryResultOrderEo.getReceiveLogicWarehouseCode();
            }
            PushSalesTransferOrderReqDto salesTransferOrderReqDto = new PushSalesTransferOrderReqDto();
            PushSalesHeadReqDto sapSalesHeadReqDto = new PushSalesHeadReqDto();
            sapSalesHeadReqDto.setId(transferOrder.getId().toString());
            sapSalesHeadReqDto.setType(sapType);
            sapSalesHeadReqDto.setChannelCode("00");
            sapSalesHeadReqDto.setFactoryType(factoryType);
            sapSalesHeadReqDto.setTransferOrderNo(transferOrder.getTransferOrderNo());
            sapSalesHeadReqDto.setCustomerCode(transferOrder.getCustomerCode());
            sapSalesHeadReqDto.setCreateDate(DateUtil.formatDateTime((Date)transferOrder.getCreateTime()));
            sapSalesHeadReqDto.setRefNo(csDeliveryResultOrderEo.getPreOrderNo());
            ArrayList itemReqDtoList = new ArrayList(detailEoList.size());
            String finalWarehouseCode = warehouseCode;
            detailEoList.forEach(d -> {
                PushSalesItemReqDto item = new PushSalesItemReqDto();
                item.setCode(d.getSkuCode());
                item.setNum(d.getQuantity().toString());
                item.setWarehouseCode(finalWarehouseCode);
                item.setFactoryType(factoryType);
                itemReqDtoList.add(item);
            });
            salesTransferOrderReqDto.setSapSalesHeadReqDto(sapSalesHeadReqDto);
            salesTransferOrderReqDto.setItemReqDtoList(itemReqDtoList);
            log.info("pushSaleTransferResultOrder\u53d1\u9001\u63a8\u9001\u5bc4\u552e\u8c03\u62e8mq\u6d88\u606f");
            this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "PUSH_CONSIGNMENT_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)salesTransferOrderReqDto));
        } else {
            log.info("\u63a8\u9001\u5bc4\u552e\u8c03\u62e8\u51fa\u5165\u5e93\u5355\u8c03\u62e8\u5355\u4e0d\u5b58\u5728,\u8c03\u62e8\u5355\u5355\u53f7\u4e3a" + csDeliveryResultOrderEo.getRelevanceNo());
        }
    }

    private void pushTransferResultOrder(ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo, List<ReceiveDeliveryResultOrderDetailEo> detailEoList) {
        PushTransferStorageOrderHeadReqDto head = new PushTransferStorageOrderHeadReqDto();
        head.setWarehouseCode(csDeliveryResultOrderEo.getReceiveLogicWarehouseCode());
        String factoryType = "1220";
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDas.filter().eq((Object)"transfer_order_no", (Object)csDeliveryResultOrderEo.getRelevanceNo())).one();
        if (transferOrder != null) {
            String sapNo = transferOrder.getSapNO();
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{sapNo})) {
                String moveType;
                String warehouseCode;
                String tag;
                if ("delivery".equals(csDeliveryResultOrderEo.getOrderType())) {
                    tag = "PUSH_TRANSFER_OUT_ORDER";
                    warehouseCode = csDeliveryResultOrderEo.getDeliveryLogicWarehouseCode();
                    moveType = "Z13";
                } else {
                    tag = "PUSH_TRANSFER_IN_ORDER";
                    warehouseCode = csDeliveryResultOrderEo.getReceiveLogicWarehouseCode();
                    moveType = "Z15";
                }
                PushTransferStorageOrderReqDto pushTransferStorageOrderReqDto = new PushTransferStorageOrderReqDto();
                head.setId(transferOrder.getId().toString());
                head.setSapNo(sapNo);
                head.setSapMoveType(moveType);
                head.setCreateDate(DateUtil.formatDateTime((Date)new Date()));
                head.setFactoryType(factoryType);
                head.setRefNo(csDeliveryResultOrderEo.getPreOrderNo());
                ArrayList<PushItemReqDto> itemReqDtoList = new ArrayList<PushItemReqDto>(detailEoList.size());
                for (int i = 0; i < detailEoList.size(); ++i) {
                    PushItemReqDto sapItemReqDto = new PushItemReqDto();
                    sapItemReqDto.setCode(detailEoList.get(i).getSkuCode());
                    sapItemReqDto.setRowNum(String.valueOf(i + 1));
                    sapItemReqDto.setNum(detailEoList.get(i).getQuantity().toString());
                    sapItemReqDto.setFactoryType(factoryType);
                    sapItemReqDto.setWarehouseCode(warehouseCode);
                    itemReqDtoList.add(sapItemReqDto);
                }
                pushTransferStorageOrderReqDto.setSapTransferStorageOrderHearReqDto(head);
                pushTransferStorageOrderReqDto.setItemReqDtoList(itemReqDtoList);
                InventoryConfig.registerSynchronizationAfterCommit(() -> {
                    log.info("pushTransferResultOrder\u53d1\u9001\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355mq\u6d88\u606f");
                    this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", tag, (Object)JSON.toJSONString((Object)pushTransferStorageOrderReqDto));
                });
            } else {
                log.info("\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355sap\u5355\u53f7\u7f3a\u5931,\u8c03\u62e8\u5355\u5355\u53f7\u4e3a" + csDeliveryResultOrderEo.getRelevanceNo());
            }
        } else {
            log.info("\u63a8\u9001\u8c03\u62e8\u51fa\u5165\u5e93\u5355\u8c03\u62e8\u5355\u4e0d\u5b58\u5728,\u8c03\u62e8\u5355\u5355\u53f7\u4e3a" + csDeliveryResultOrderEo.getRelevanceNo());
        }
    }
}

