/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commons.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.dict.api.query.IPcpDictQueryApi;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.service.commons.CommonService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CommonServiceImpl
implements CommonService {
    private static final Logger logger = LoggerFactory.getLogger(CommonServiceImpl.class);
    @Resource
    private IContext context;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPcpDictQueryApi dictQueryApi;

    @Override
    public Long getUserOrganizationId() {
        Object restResponse;
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0cuserId:{}", (Object)userId);
        if (null != userId && null != (restResponse = null).getData()) {
            logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u7ec4\u7ec7id\uff0corganizationId:{}", restResponse.getData());
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public Long getOrganizationIdByUserId(Long userId) {
        Object restResponse = null;
        if (null != restResponse.getData()) {
            return (Long)restResponse.getData();
        }
        return null;
    }

    @Override
    public List<Long> getUserLogicWarehouseIds() {
        List<Long> warehouseIds = new ArrayList<Long>();
        Long userId = this.context.userId();
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684userId:{}", (Object)userId);
        if (Objects.isNull(userId)) {
            return warehouseIds;
        }
        Long orgId = 1L;
        logger.info("\u6839\u636euserId\u67e5\u8be2\u5230\u7ec4\u7ec7id\uff1a{}", (Object)orgId);
        if (Objects.isNull(orgId)) {
            return warehouseIds;
        }
        List list = ((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().select(new String[]{"id"}).eq((Object)"organization_id", (Object)orgId)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            warehouseIds = list.stream().map(BaseEo::getId).collect(Collectors.toList());
        }
        logger.info("\u83b7\u53d6\u767b\u5f55\u7528\u6237\u7684\u903b\u8f91\u4ed3\u5e93id\u96c6\u5408\uff0c\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString(warehouseIds));
        return warehouseIds;
    }

    @Override
    public void getSetUserName() {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName("system");
        }
    }

    @Override
    public void getSetUserName(String createPerson) {
        if (StringUtils.isBlank((CharSequence)this.context.userName())) {
            this.context.userName(StringUtils.isNotBlank((CharSequence)createPerson) ? createPerson : "system");
        }
    }

    @Override
    public String getCustomerIdByChannelName(String channelName) {
        try {
            DictDto dictDto = (DictDto)this.dictQueryApi.queryByGroupCodeAndCode("CHANNEL", "CONFIG").getData();
            if (dictDto == null || StringUtils.isEmpty((CharSequence)dictDto.getValue())) {
                logger.info("\u627e\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u7ec4\u540d\u79f0:{},\u7f16\u7801:{}", (Object)"CHANNEL", (Object)"CONFIG");
                return null;
            }
            Map channelMap = JacksonUtil.toMap((String)dictDto.getValue());
            if (channelMap.get(channelName) != null) {
                return String.valueOf(channelMap.get(channelName));
            }
        }
        catch (Exception e) {
            logger.error("\u6839\u636e\u6e20\u9053\u540d\u79f0\u83b7\u53d6\u5ba2\u6237ID\u65f6\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
        }
        return null;
    }
}

