/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.component;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import com.yomahub.liteflow.core.NodeComponent;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.eo.PhysicsWarehouseEo;
import com.yunxi.dg.base.center.inventory.proxy.transform.ITrLogisticsMappingRelationQueryApiProxy;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.transform.LogisticsMappingType;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationReqDto;
import com.yunxi.dg.base.center.transform.TrLogisticsMappingRelationRespDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LiteflowComponent(value="logisticsMapping")
public class LogisticsMappingComponent
extends NodeComponent {
    private static final Logger log = LoggerFactory.getLogger(LogisticsMappingComponent.class);
    @Resource
    private ITrLogisticsMappingRelationQueryApiProxy trLogisticsMappingRelationQueryApiProxy;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IPhysicsWarehouseDomain physicsWarehouseDomain;

    public void process() throws Exception {
        this.getRequestData();
    }

    public void logisticsMapping(BasicsReceiveReqDto csBasicsReceiveReqDto, InOutResultOrderEo inOutResultOrderEo) {
        if (!InventoryConfig.isLogisticsMapping()) {
            return;
        }
        log.info("outSendBack-->csBasicsReceiveReqDto:{}", (Object)JSON.toJSONString((Object)csBasicsReceiveReqDto));
        List shippingInfoReqDtoList = csBasicsReceiveReqDto.getShippingInfoReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
            String warehouseCode;
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
            String shippingCompanyCode = csWmsShippingInfoReqDto.getShippingCompanyCode();
            if (StringUtils.isEmpty((CharSequence)shippingCompanyCode) && StringUtils.isNotEmpty((CharSequence)csBasicsReceiveReqDto.getShippingCompanyCode())) {
                shippingCompanyCode = csBasicsReceiveReqDto.getShippingCompanyCode();
            }
            if (StringUtils.isEmpty((CharSequence)(warehouseCode = csBasicsReceiveReqDto.getWarehouseCode())) && CollectionUtils.isNotEmpty((Collection)csBasicsReceiveReqDto.getDetailReqDtoList())) {
                warehouseCode = ((BasicsDetailReqDto)csBasicsReceiveReqDto.getDetailReqDtoList().get(0)).getWarehouseCode();
            }
            LogicWarehouseRespDto csLogicWarehouseRespDto = this.queryByCodeAndFlag(warehouseCode);
            log.info("outSendBack-->csLogicWarehouseRespDto:{}", (Object)JSON.toJSONString((Object)csLogicWarehouseRespDto));
            if (ObjectUtils.isNotEmpty((Object)csLogicWarehouseRespDto)) {
                TrLogisticsMappingRelationReqDto trLogisticsMappingRelationReqDto = new TrLogisticsMappingRelationReqDto();
                trLogisticsMappingRelationReqDto.setMappingType(LogisticsMappingType.WMS.getCode());
                trLogisticsMappingRelationReqDto.setExternalLogisticsCode(shippingCompanyCode);
                trLogisticsMappingRelationReqDto.setSystematicCode(csLogicWarehouseRespDto.getEntitySystemCode());
                log.info("logisticsMapping-->trLogisticsMappingRelationReqDto:{}", (Object)JSON.toJSONString((Object)trLogisticsMappingRelationReqDto));
                TrLogisticsMappingRelationRespDto trLogisticsMappingRelationRespDto = this.trLogisticsMappingRelationQueryApiProxy.queryByRelationReqDtoSiteMatching(trLogisticsMappingRelationReqDto);
                log.info("logisticsMapping-->trLogisticsMappingRelationRespDto:{}", (Object)JSON.toJSONString((Object)trLogisticsMappingRelationRespDto));
                if (ObjectUtils.isNotEmpty((Object)trLogisticsMappingRelationRespDto)) {
                    CsWmsShippingInfoReqDto wmsCsWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                    for (CsWmsShippingInfoReqDto csWmsShippingInfoReq : shippingInfoReqDtoList) {
                        csWmsShippingInfoReq.setShippingCompanyCode(trLogisticsMappingRelationRespDto.getLogisticsCode());
                        csWmsShippingInfoReq.setShippingCompanyName(trLogisticsMappingRelationRespDto.getLogisticsName());
                        csWmsShippingInfoReq.setFirstShippingCompanyCode(wmsCsWmsShippingInfoReqDto.getShippingCompanyCode());
                        csWmsShippingInfoReq.setFirstShippingCompanyName(wmsCsWmsShippingInfoReqDto.getShippingCompanyName());
                    }
                } else {
                    String message = "\u53d1\u8d27\u56de\u4f20\u65f6\uff0cWMS\u7269\u6d41" + shippingCompanyCode + "\u6620\u5c04\u4e0d\u5230\u7269\u6d41\u7f16\u7801";
                    csBasicsReceiveReqDto.setLogisticsRemark(message);
                }
            }
        }
    }

    private LogicWarehouseRespDto queryByCodeAndFlag(String logicWarehouseCode) {
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)logicWarehouseCode), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogicWarehouseEo logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseCode)).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(logicWarehouseEo), (String)("\u903b\u8f91\u4ed3 " + logicWarehouseCode + " \u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        PhysicsWarehouseEo physicsWarehouseEo = (PhysicsWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.physicsWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)logicWarehouseEo.getPhysicsWarehouseCode())).last("limit 1")).one();
        AssertUtils.isFalse((boolean)Objects.isNull(physicsWarehouseEo), (String)("\u7269\u7406\u4ed3" + logicWarehouseEo.getPhysicsWarehouseCode() + "\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5"));
        if (ObjectUtil.equals((Object)physicsWarehouseEo.getInterconnectionFlag(), (Object)1)) {
            LogicWarehouseRespDto dto = new LogicWarehouseRespDto();
            CubeBeanUtils.copyProperties((Object)dto, (Object)logicWarehouseEo, (String[])new String[0]);
            return dto;
        }
        return null;
    }
}

