/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.constants.OverchargeStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOverchargeStrategyDomain;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OverchargeStrategyEo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.AbstractOverchargeProcessor;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeMetaBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeResultBo;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class DispatchOrderOverchargeProcessor
extends AbstractOverchargeProcessor {
    @Resource
    private IOverchargeStrategyDomain overchargeStrategyDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    @Override
    protected OverchargeResultBo doOverchargeCheck(OverchargeMetaBo overchargeMetaBo, boolean isEqualSum, boolean isEqualBatch, boolean isGtSum) {
        boolean inFlag = StringUtils.equals((CharSequence)"in", (CharSequence)overchargeMetaBo.getNoticeOrderEo().getOrderType());
        OverchargeStrategyEo overchargeStrategyEo = (OverchargeStrategyEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.overchargeStrategyDomain.filter().eq((Object)"order_type", (Object)OverchargeStrategyOrderTypeEnum.TRANSFER.getCode())).eq((Object)"dr", (Object)0)).last(" limit 1")).one();
        if (inFlag) {
            if (InventoryConfig.isMultipleIn(overchargeMetaBo.getNoticeOrderEo().getJumpDocumentType(), overchargeMetaBo.getNoticeOrderEo().getDisplayBusinessType()) || !InventoryConfig.isCanHangUp()) {
                boolean checkFlow;
                boolean bl = checkFlow = Objects.nonNull(overchargeStrategyEo) && 0 == overchargeStrategyEo.getReceiveWarehouseOverchargeFlag();
                if (checkFlow) {
                    Map<Long, BigDecimal> noticeMap = overchargeMetaBo.getBatchNoticeDetailEos().stream().collect(Collectors.toMap(InOutNoticeOrderDetailEo::getLineNo, InOutNoticeOrderDetailEo::getWaitQuantity));
                    for (BasicsDetailReqDto wmsDetailDto : overchargeMetaBo.getWmsDetailDtos()) {
                        BigDecimal decimal = noticeMap.get(wmsDetailDto.getLineNo());
                        if (wmsDetailDto.getQuantity().compareTo(decimal) <= 0) continue;
                        return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u8d85\u6536", CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode());
                    }
                }
                if (checkFlow && isGtSum) {
                    return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u8d85\u6536", CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode());
                }
                return OverchargeResultBo.getSuccess();
            }
            if (!isEqualSum) {
                return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d");
            }
        } else if (!isEqualSum) {
            if (InventoryConfig.isMultipleOut(overchargeMetaBo.getNoticeOrderEo().getJumpDocumentType(), overchargeMetaBo.getNoticeOrderEo().getDisplayBusinessType()) || !InventoryConfig.isCanHangUp()) {
                if (isGtSum) {
                    return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u8d85\u53d1", CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode());
                }
                return OverchargeResultBo.getSuccess();
            }
            return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d");
        }
        return OverchargeResultBo.getSuccess();
    }

    @Override
    public CsRelevanceTableNameEnum getType() {
        return CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER;
    }
}

