/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.convert.entity.AutoTransferConfigConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutoTransferConfigDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AutoTransferConfigDto;
import com.yunxi.dg.base.center.inventory.eo.AutoTransferConfigEo;
import com.yunxi.dg.base.center.inventory.service.entity.IAutoTransferConfigService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AutoTransferConfigServiceImpl
extends BaseServiceImpl<AutoTransferConfigDto, AutoTransferConfigEo, IAutoTransferConfigDomain>
implements IAutoTransferConfigService {
    private static final Logger log = LoggerFactory.getLogger(AutoTransferConfigServiceImpl.class);

    public AutoTransferConfigServiceImpl(IAutoTransferConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<AutoTransferConfigDto, AutoTransferConfigEo> converter() {
        return AutoTransferConfigConverter.INSTANCE;
    }

    @Override
    public RestResponse<Integer> insertBatch(List<AutoTransferConfigDto> dtos) {
        log.info("\u6279\u91cf\u65b0\u589e\u4ed3\u5e93\u5bf9\u63a5\u7cfb\u7edf\u662f\u5426\u81ea\u52a8\u4e0b\u53d1\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dtos));
        List autoTransferConfigEos = ((IAutoTransferConfigDomain)this.domain).filter().list();
        if (CollectionUtils.isNotEmpty((Collection)autoTransferConfigEos)) {
            List ids = autoTransferConfigEos.stream().map(e -> e.getId()).collect(Collectors.toList());
            ((IAutoTransferConfigDomain)this.domain).getMapper().deleteBatchIds(ids);
        }
        if (CollectionUtils.isEmpty(dtos)) {
            return new RestResponse((Object)0);
        }
        ArrayList eos = new ArrayList();
        CubeBeanUtils.copyCollection(eos, dtos, AutoTransferConfigEo.class);
        return new RestResponse((Object)((IAutoTransferConfigDomain)this.domain).insertBatch(eos));
    }

    private void checkParam(List<AutoTransferConfigDto> dtos) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dtos), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dtos.forEach(dto -> {
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseCode()), (String)"\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getWarehouseName()), (String)"\u4ed3\u5e93\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        });
    }
}

