/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.convert.entity.HistoryLogisticsConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IHistoryLogisticsDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.HistoryLogisticsDto;
import com.yunxi.dg.base.center.inventory.eo.HistoryLogisticsEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.entity.IHistoryLogisticsService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class HistoryLogisticsServiceImpl
extends BaseServiceImpl<HistoryLogisticsDto, HistoryLogisticsEo, IHistoryLogisticsDomain>
implements IHistoryLogisticsService {
    private static final Logger logger = LoggerFactory.getLogger(HistoryLogisticsServiceImpl.class);

    public HistoryLogisticsServiceImpl(IHistoryLogisticsDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<HistoryLogisticsDto, HistoryLogisticsEo> converter() {
        return HistoryLogisticsConverter.INSTANCE;
    }

    @Override
    public void convertByOutNotice(InOutNoticeOrderEo outOrderEo) {
        HistoryLogisticsDto dto;
        if (ObjectUtil.isEmpty((Object)outOrderEo) || StringUtils.isBlank((CharSequence)outOrderEo.getDocumentNo())) {
            logger.info("\u5165\u53c2\u5f02\u5e38");
            return;
        }
        logger.info("\u6839\u636e\u51fa\u5e93\u901a\u77e5\u5355\u8f6c\u5316\u5386\u53f2\u7269\u6d41\uff1a{}", (Object)JSON.toJSONString((Object)outOrderEo));
        if (StringUtils.isNotBlank((CharSequence)outOrderEo.getShippingCode())) {
            dto = new HistoryLogisticsDto();
            dto.setDocumentNo(outOrderEo.getDocumentNo());
            dto.setRelevanceNo(outOrderEo.getRelevanceNo());
            dto.setShippingCode(outOrderEo.getShippingCode());
            dto.setShippingCompany(outOrderEo.getShippingCompany());
            dto.setShippingCompanyName(outOrderEo.getShippingCompanyName());
            dto.setIfsub(Integer.valueOf(0));
            this.insert(dto);
        }
        if (StringUtils.isNotBlank((CharSequence)outOrderEo.getSubShippingCode())) {
            dto = new HistoryLogisticsDto();
            dto.setDocumentNo(outOrderEo.getDocumentNo());
            dto.setRelevanceNo(outOrderEo.getRelevanceNo());
            dto.setShippingCode(outOrderEo.getSubShippingCode());
            dto.setShippingCompany(outOrderEo.getShippingCompany());
            dto.setShippingCompanyName(outOrderEo.getShippingCompanyName());
            dto.setIfsub(Integer.valueOf(1));
            this.insert(dto);
        }
    }

    public RestResponse<Long> insert(HistoryLogisticsDto dto) {
        return super.insert((BaseDto)dto);
    }
}

