/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutNoticeOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutBusinessService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InOutBusinessServiceImpl
extends BaseServiceImpl<InOutNoticeOrderDto, InOutNoticeOrderEo, IInOutNoticeOrderDomain>
implements IInOutBusinessService {
    private static final Logger log = LoggerFactory.getLogger(InOutBusinessServiceImpl.class);
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    public InOutBusinessServiceImpl(IInOutNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOutNoticeOrderDto, InOutNoticeOrderEo> converter() {
        return InOutNoticeOrderConverter.INSTANCE;
    }

    @Override
    public void earlyProductOutDispose(BasicsReceiveReqDto reqDto) {
        log.info("earlyProductOutDispose\uff1a{}", (Object)JSON.toJSONString((Object)reqDto));
        List detailReqDtoList = reqDto.getDetailReqDtoList();
        AssertUtil.isFalse((boolean)CollUtil.isEmpty((Collection)detailReqDtoList), (String)"\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        String inOutNoticeOrderNo = reqDto.getInOutNoticeOrderNo();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderNo)).eq((Object)"order_type", (Object)"out")).list(Integer.valueOf(1));
        if (CollUtil.isEmpty((Collection)inOutNoticeOrderEoList)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355 {} \u4e0d\u5b58\u5728", (Object)inOutNoticeOrderNo);
            return;
        }
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        String extension = inOutNoticeOrderEo.getExtension();
        if (StrUtil.isBlank((CharSequence)extension)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355 {} \u65e0\u63d0\u524d\u51fa\u5e93\u6807\u8bc6", (Object)inOutNoticeOrderNo);
            return;
        }
        JSONObject extensionObj = JSON.parseObject((String)extension);
        Integer earlyProductOutbound = extensionObj.getInteger("earlyProductOutbound");
        if (Objects.isNull(earlyProductOutbound) || !Objects.equals(earlyProductOutbound, 1)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355 {} \u65e0\u63d0\u524d\u51fa\u5e93\u6807\u8bc6", (Object)inOutNoticeOrderNo);
            return;
        }
        List orderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"pre_order_no", (Object)inOutNoticeOrderNo)).list();
        if (CollUtil.isEmpty((Collection)orderDetailEoList)) {
            log.info("\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728 {}", (Object)inOutNoticeOrderNo);
            return;
        }
        Map detailReqDtoMap = detailReqDtoList.stream().collect(Collectors.toMap(BasicsDetailReqDto::getLineNo, Function.identity(), (o, o1) -> {
            o.setQuantity(BigDecimalUtils.add((BigDecimal)o.getQuantity(), (BigDecimal)o1.getQuantity()));
            return o;
        }));
        InOutResultOrderDetailEo updateOrderDetailEo = null;
        for (InOutResultOrderDetailEo orderDetailEo : orderDetailEoList) {
            Long lineNo = orderDetailEo.getLineNo();
            BasicsDetailReqDto detailReqDto = (BasicsDetailReqDto)detailReqDtoMap.get(orderDetailEo.getLineNo());
            if (Objects.isNull(detailReqDto)) continue;
            BigDecimal quantity = orderDetailEo.getQuantity();
            Long id = orderDetailEo.getId();
            updateOrderDetailEo = new InOutResultOrderDetailEo();
            updateOrderDetailEo.setId(id);
            BigDecimal newQuantity = NumberUtil.add((Number)quantity, (Number)detailReqDto.getQuantity());
            updateOrderDetailEo.setQuantity(newQuantity);
            this.inOutResultOrderDetailDomain.updateSelective((BaseEo)updateOrderDetailEo);
            log.info("{} \u51fa\u5e93\u660e\u7ec6\u884c {} \u66f4\u65b0\u6570\u91cf\u4e3a {}", new Object[]{inOutNoticeOrderNo, lineNo, newQuantity});
        }
    }

    @Override
    public void earlyProductOutClearQuantity(Long id) {
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((IInOutNoticeOrderDomain)this.domain).selectByPrimaryKey(id);
        AssertUtil.isFalse((boolean)Objects.isNull(outNoticeOrderEo), (String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728");
        String inOutNoticeOrderNo = outNoticeOrderEo.getDocumentNo();
        String extension = outNoticeOrderEo.getExtension();
        if (StrUtil.isBlank((CharSequence)extension)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355 {} \u65e0\u63d0\u524d\u51fa\u5e93\u6807\u8bc6", (Object)inOutNoticeOrderNo);
            return;
        }
        JSONObject extensionObj = JSON.parseObject((String)extension);
        Integer earlyProductOutbound = extensionObj.getInteger("earlyProductOutbound");
        if (Objects.isNull(earlyProductOutbound) || !Objects.equals(earlyProductOutbound, 1)) {
            log.info("\u51fa\u5e93\u901a\u77e5\u5355 {} \u65e0\u63d0\u524d\u51fa\u5e93\u6807\u8bc6", (Object)inOutNoticeOrderNo);
            return;
        }
        List orderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"pre_order_no", (Object)inOutNoticeOrderNo)).list();
        if (CollUtil.isEmpty((Collection)orderDetailEoList)) {
            log.info("\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4e0d\u5b58\u5728 {}", (Object)inOutNoticeOrderNo);
            return;
        }
        log.info("earlyProductOutClearQuantity {}", (Object)inOutNoticeOrderNo);
        InOutResultOrderDetailEo updateOrderDetailEo = new InOutResultOrderDetailEo();
        updateOrderDetailEo.setQuantity(BigDecimal.ZERO);
        for (InOutResultOrderDetailEo orderDetailEo : orderDetailEoList) {
            updateOrderDetailEo.setId(orderDetailEo.getId());
            this.inOutResultOrderDetailDomain.updateSelective((BaseEo)updateOrderDetailEo);
        }
    }
}

