/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.BdTypeOfDocumentEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutResultOrderConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.baseorder.CsOutResultSolutionToHangRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.baseorder.DeliveredOutResultInfoDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.baseorder.DeliveredOutResultInfoRespDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderConfirmFacadeBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderUnhookFacadeBo;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutResultOrderService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOutResultOrderServiceImpl
extends BaseServiceImpl<InOutResultOrderDto, InOutResultOrderEo, IInOutResultOrderDomain>
implements IInOutResultOrderService {
    private static final Logger log = LoggerFactory.getLogger(InOutResultOrderServiceImpl.class);
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private ILockService lockService;
    private static final String TABLENAME = "mq_sale_out_order_unhook#";
    @Autowired
    IItemSkuDgQueryApiProxy itemSkuProxy;

    public InOutResultOrderServiceImpl(IInOutResultOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOutResultOrderDto, InOutResultOrderEo> converter() {
        return InOutResultOrderConverter.INSTANCE;
    }

    @Override
    public void unhook(String documentNo) {
        log.info("\u89e3\u6302\u5165\u51fa\u5e93\u7ed3\u679c\u5355\u7684\u5355\u53f7\uff1a{}", (Object)documentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNo), (String)"\u5165\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        List eoList = ((ExtQueryChainWrapper)((IInOutResultOrderDomain)this.domain).filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)eoList), (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        InOutResultOrderEo eo = (InOutResultOrderEo)eoList.get(0);
        if (StringUtils.equals((CharSequence)"\u7269\u6d41\u6620\u5c04\u5f02\u5e38", (CharSequence)eo.getOverChargeReason())) {
            throw new BizException("\u7269\u6d41\u6620\u5c04\u5f02\u5e38\u6302\u8d77\u6682\u4e0d\u652f\u6301\u624b\u52a8\u89e3\u6302");
        }
        List csOutResultOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)csOutResultOrderDetailEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u660e\u7ec6\u4fe1\u606f");
        String key = String.join((CharSequence)"inOutResultOrder_unhook", documentNo);
        this.repeatFilter.checkRepeat(key, () -> {
            List<String> statusEnumList = Arrays.asList(BaseOrderStatusEnum.ORO_HANG_UP.getCode(), BaseOrderStatusEnum.IRO_HANG_UP.getCode(), BaseOrderStatusEnum.HANG_UP.getCode());
            AssertUtil.isTrue((boolean)statusEnumList.contains(eo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e3a\u975e\u6302\u8d77\u72b6\u6001");
            this.solutionToHangInventory(eo, csOutResultOrderDetailEoList);
        }, true, "\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c");
    }

    @Override
    public void confirm(String documentNo) {
        log.info("\u786e\u8ba4\u51fa\u5e93\u7ed3\u679c\u5355\u7684\u5355\u53f7\uff1a{}", (Object)documentNo);
        AssertUtils.notBlank((String)documentNo, (String)"\u51fa\u5e93\u7ed3\u679c\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        List eoList = ((ExtQueryChainWrapper)((IInOutResultOrderDomain)this.domain).filter().eq((Object)"document_no", (Object)documentNo)).list();
        AssertUtils.notEmpty((Collection)eoList, (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        InOutResultOrderEo eo = (InOutResultOrderEo)eoList.get(0);
        if (!BaseOrderStatusEnum.ORO_WAIT_CONFIRM.getCode().equals(eo.getOrderStatus())) {
            throw new BizException("\u8be5\u7ed3\u679c\u5355 \u4e0d\u5904\u4e8e\u5f85\u786e\u8ba4\u72b6\u6001");
        }
        InOutResultOrderConfirmFacadeBo facadeBo = new InOutResultOrderConfirmFacadeBo();
        facadeBo.setDocumentNo(documentNo);
        facadeBo.setInOutResultOrderEo(eo);
        this.baseOrderFacade.outResultOrderConfirm(facadeBo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void confirmAndUpdate(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutResultOrderEo inOutResultOrderEo) {
        this.confirm(inOutResultOrderEo.getDocumentNo());
        if (CollectionUtils.isNotEmpty((Collection)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList())) {
            this.updateShippingInfo(basicsReceiveBasicsReqDto, inOutResultOrderEo);
        }
    }

    private void updateShippingInfo(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutResultOrderEo inOutResultOrderEo) {
        List csWmsShippingInfoReqDtos;
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList().get(0);
        InOutResultOrderEo updateResultOrderEo = new InOutResultOrderEo();
        updateResultOrderEo.setId(inOutResultOrderEo.getId());
        if (null != basicsReceiveBasicsReqDto.getInOutTime()) {
            updateResultOrderEo.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
        }
        if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingNo())) {
            updateResultOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
        }
        if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingType())) {
            updateResultOrderEo.setShippingType(csWmsShippingInfoReqDto.getShippingType());
        }
        if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyCode())) {
            updateResultOrderEo.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyName())) {
            updateResultOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyName());
        }
        if (CollectionUtils.isNotEmpty((Collection)(csWmsShippingInfoReqDtos = DataExtractUtils.jsonStrToList((String)inOutResultOrderEo.getShippingJson(), CsWmsShippingInfoReqDto.class)))) {
            csWmsShippingInfoReqDtos.forEach(wmsShippingInfoReqDto -> {
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingNo())) {
                    wmsShippingInfoReqDto.setShippingNo(csWmsShippingInfoReqDto.getShippingNo());
                }
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingType())) {
                    wmsShippingInfoReqDto.setShippingType(csWmsShippingInfoReqDto.getShippingType());
                }
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyCode())) {
                    wmsShippingInfoReqDto.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                }
                if (StringUtils.isNotEmpty((CharSequence)csWmsShippingInfoReqDto.getShippingCompanyName())) {
                    wmsShippingInfoReqDto.setShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                }
            });
            updateResultOrderEo.setShippingJson(JSON.toJSONString((Object)csWmsShippingInfoReqDtos));
        } else {
            updateResultOrderEo.setShippingJson(JSON.toJSONString((Object)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList()));
        }
        ((IInOutResultOrderDomain)this.domain).updateSelective((BaseEo)updateResultOrderEo);
    }

    @Override
    public DeliveredOutResultInfoRespDto queryDeliveredInfo(String preOrderNo) {
        List csItemEoList;
        log.info("queryDeliveredInfo==>\u6839\u636e\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u67e5\u8be2\u5df2\u53d1\u8d27\u8d27\u54c1\u6570\u91cf\u4fe1\u606f,preOrderNo:{}", (Object)preOrderNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)preOrderNo), (String)"\u524d\u7f6e\u4e1a\u52a1\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper outResultOrderDetailQueryWrapper = new QueryWrapper();
        outResultOrderDetailQueryWrapper.eq((Object)"pre_order_no", (Object)preOrderNo);
        List csOutResultOrderDetailEoList = this.inOutResultOrderDetailDomain.getMapper().selectList((Wrapper)outResultOrderDetailQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)csOutResultOrderDetailEoList)) {
            return new DeliveredOutResultInfoRespDto();
        }
        List cargoCodeList = csOutResultOrderDetailEoList.stream().map(InOutResultOrderDetailEo::getSkuCode).collect(Collectors.toList());
        Map<Object, Object> itemMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(cargoCodeList) && CollectionUtils.isNotEmpty((Collection)(csItemEoList = this.itemSkuProxy.queryBySkuCode(cargoCodeList)))) {
            itemMap = csItemEoList.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity()));
        }
        DeliveredOutResultInfoRespDto csDeliveredOutResultInfoRespDto = new DeliveredOutResultInfoRespDto();
        ArrayList csDeliveredOutResultInfoDetailRespDtoList = Lists.newArrayList();
        csDeliveredOutResultInfoRespDto.setDeliveredOutResultInfoDetailRespDtoList((List)csDeliveredOutResultInfoDetailRespDtoList);
        for (InOutResultOrderDetailEo orderDetailEo : csOutResultOrderDetailEoList) {
            DeliveredOutResultInfoDetailRespDto respDto = new DeliveredOutResultInfoDetailRespDto();
            CubeBeanUtils.copyProperties((Object)respDto, (Object)orderDetailEo, (String[])new String[0]);
            String cargoCode = orderDetailEo.getSkuCode();
            ItemSkuDgRespDto csItemEo = (ItemSkuDgRespDto)itemMap.get(cargoCode);
            if (null != csItemEo) {
                respDto.setLongCode(csItemEo.getCode());
            }
            csDeliveredOutResultInfoDetailRespDtoList.add(respDto);
        }
        log.info("queryDeliveredInfo==>\u8fd4\u56de\u6570\u636e,csDeliveredOutResultInfoRespDto:{}", (Object)JSON.toJSONString((Object)csDeliveredOutResultInfoRespDto));
        return csDeliveredOutResultInfoRespDto;
    }

    private CsOutResultSolutionToHangRespDto solutionToHangInventory(InOutResultOrderEo inOutResultOrderEo, List<InOutResultOrderDetailEo> csOutResultOrderDetailEoList) {
        int fail = 0;
        try {
            InOutResultOrderUnhookFacadeBo facadeBo = new InOutResultOrderUnhookFacadeBo();
            facadeBo.setInOutResultOrderEo(inOutResultOrderEo);
            facadeBo.setInOutResultOrderEoList(csOutResultOrderDetailEoList);
            facadeBo.setOrderType(inOutResultOrderEo.getOrderType());
            boolean onlyProcessResult = this.isOnlyProcessResult(inOutResultOrderEo);
            if (onlyProcessResult) {
                facadeBo.setOnlyProcessResult(true);
                facadeBo.setAppendRecord(true);
            }
            this.baseOrderFacade.inOutResultOrderUnhook(facadeBo);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            throw new BizException(e.getLocalizedMessage());
        }
        CsOutResultSolutionToHangRespDto outResultSolutionToHangRespDto = new CsOutResultSolutionToHangRespDto();
        outResultSolutionToHangRespDto.setFailNum(Integer.valueOf(1 - fail));
        outResultSolutionToHangRespDto.setSuccessNum(Integer.valueOf(fail));
        return outResultSolutionToHangRespDto;
    }

    private boolean isOnlyProcessResult(InOutResultOrderEo inOutResultOrderEo) {
        return BdTypeOfDocumentEnum.SAP_INVENTORY_SYNC.getCode().equals(inOutResultOrderEo.getBusinessType()) || "POS".equals(inOutResultOrderEo.getShopCode()) && Objects.equals(inOutResultOrderEo.getDisplayBusinessType(), CsPcpBusinessTypeEnum.DICT_ALLOT_STORE_RAISED.getCode());
    }

    private List<String> getOutResultOrder(List<String> documentNos) {
        ExtQueryChainWrapper sqlFilters = ((IInOutResultOrderDomain)this.domain).filter();
        if (CollectionUtils.isNotEmpty(documentNos)) {
            sqlFilters.in((Object)"document_no", documentNos);
        }
        sqlFilters.eq((Object)"order_status", (Object)"oro_hang_up");
        sqlFilters.eq((Object)"order_type", (Object)"out");
        sqlFilters.eq((Object)"jump_document_type", (Object)"SALE_OUT_ORDER");
        sqlFilters.last("  AND create_time>= CURRENT_DATE() - INTERVAL 2 DAY");
        List outResultOrderEos = sqlFilters.list();
        if (CollectionUtils.isNotEmpty((Collection)outResultOrderEos)) {
            return outResultOrderEos.stream().map(InOutResultOrderEo::getDocumentNo).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public List<String> dealSaleOutOrder(List<String> documentNos) {
        List<String> outDocumentNos = null;
        outDocumentNos = CollectionUtils.isNotEmpty(documentNos) ? this.getOutResultOrder(documentNos) : this.getOutResultOrder(null);
        ArrayList outResultOrderDocumentNos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(outDocumentNos)) {
            List partition = Lists.partition(outDocumentNos, (int)10);
            partition.forEach(v -> {
                List orderDetailEos = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", (Collection)v)).list();
                if (CollectionUtils.isNotEmpty((Collection)orderDetailEos)) {
                    List orderDocumentNos = orderDetailEos.stream().map(InOutResultOrderDetailEo::getDocumentNo).distinct().collect(Collectors.toList());
                    this.inOutResultOrderDetailDomain.batchSetBatchNullByOutResultOrderDetail(orderDocumentNos);
                    outResultOrderDocumentNos.addAll(orderDocumentNos);
                }
            });
        }
        return outResultOrderDocumentNos;
    }
}

