/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.DateUtil;
import com.dtyunxi.util.ParamConverter;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.inventory.convert.entity.LabelExpiryStrategyConverter;
import com.yunxi.dg.base.center.inventory.dao.mapper.RelInventoryBatchTagMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILabelExpiryStrategyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelInventoryBatchTagDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.BatchExpiryTagRuleDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LabelExpiryStrategyDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LabelExpiryStrategyPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.ProcessLabelReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.RelInventoryBatchTagPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.LabelExpiryStrategyEo;
import com.yunxi.dg.base.center.inventory.eo.RelInventoryBatchTagEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILabelExpiryStrategyService;
import com.yunxi.dg.base.center.inventory.service.entity.enums.TagGroupEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LabelExpiryStrategyServiceImpl
extends BaseServiceImpl<LabelExpiryStrategyDto, LabelExpiryStrategyEo, ILabelExpiryStrategyDomain>
implements ILabelExpiryStrategyService {
    private static final Logger log = LoggerFactory.getLogger(LabelExpiryStrategyServiceImpl.class);
    public static Executor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() * 2, Runtime.getRuntime().availableProcessors() * 3, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadFactory(){

        @Override
        public Thread newThread(@NotNull Runnable r) {
            return new Thread(r, "\u6548\u671f\u6253\u6807-");
        }
    }, new ThreadPoolExecutor.CallerRunsPolicy());
    @Resource
    private IRelInventoryBatchTagDomain iRelInventoryBatchTagDomain;
    @Resource
    private IInventoryBatchDomain iInventoryBatchDomain;
    @Resource
    private RelInventoryBatchTagMapper relInventoryBatchTagMapper;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;

    public LabelExpiryStrategyServiceImpl(ILabelExpiryStrategyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LabelExpiryStrategyDto, LabelExpiryStrategyEo> converter() {
        return LabelExpiryStrategyConverter.INSTANCE;
    }

    @Override
    public void save(List<LabelExpiryStrategyDto> dto) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dto), (String)"\u5165\u53c2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List dataDictDtoList = Optional.ofNullable(this.pcpDictQueryApiProxy.generalBasicDataInfo(Arrays.asList("special_batch"))).orElse(new ArrayList());
        Set specialBatchSet = dataDictDtoList.stream().map(DataDictDto::getSubValue).collect(Collectors.toSet());
        LabelExpiryStrategyEo labelExpiryStrategyEo = new LabelExpiryStrategyEo();
        List labelExpiryStrategyEoList = dto.stream().map(r -> {
            LabelExpiryStrategyEo labelExpiryStrategyEo1 = new LabelExpiryStrategyEo();
            BeanUtil.copyProperties((Object)r, (Object)labelExpiryStrategyEo1, (String[])new String[0]);
            String jsonString = JSONObject.toJSONString((Object)r.getBatchExpiryTagRuleDtoList());
            labelExpiryStrategyEo1.setExpiryJson(jsonString);
            return labelExpiryStrategyEo1;
        }).collect(Collectors.toList());
        ((ILabelExpiryStrategyDomain)this.domain).delete((BaseEo)labelExpiryStrategyEo);
        ((ILabelExpiryStrategyDomain)this.domain).insertBatch(labelExpiryStrategyEoList);
        List inventoryBatchEos = this.iInventoryBatchDomain.filter().list();
        List<ProcessLabelReqDto> processLabelReqDtoList = inventoryBatchEos.stream().filter(o -> !specialBatchSet.contains(o.getBatch())).map(r -> {
            ProcessLabelReqDto processLabelReqDto = new ProcessLabelReqDto();
            BeanUtil.copyProperties((Object)r, (Object)processLabelReqDto, (String[])new String[0]);
            processLabelReqDto.setInventoryBatchId(r.getId());
            return processLabelReqDto;
        }).collect(Collectors.toList());
        this.process(processLabelReqDtoList);
    }

    @Override
    public List<LabelExpiryStrategyDto> queryList(LabelExpiryStrategyPageReqDto dto) {
        List list = ((ExtQueryChainWrapper)((ILabelExpiryStrategyDomain)this.domain).filter().orderByAsc((Object)"start_day")).list();
        List labelExpiryStrategyDtoList = BeanUtil.copyToList((Collection)list, LabelExpiryStrategyDto.class);
        for (LabelExpiryStrategyDto labelExpiryStrategyDto : labelExpiryStrategyDtoList) {
            List batchExpiryTagRuleDtoList = JSONArray.parseArray((String)labelExpiryStrategyDto.getExpiryJson(), BatchExpiryTagRuleDto.class);
            labelExpiryStrategyDto.setBatchExpiryTagRuleDtoList(batchExpiryTagRuleDtoList);
        }
        return labelExpiryStrategyDtoList;
    }

    @Override
    public void process(List<ProcessLabelReqDto> dto) {
        ConcurrentLinkedQueue reBizTagRecordReqDtoList = new ConcurrentLinkedQueue();
        List list = ((ILabelExpiryStrategyDomain)this.domain).filter().list();
        List collect = dto.stream().collect(Collectors.toMap(ProcessLabelReqDto::getInventoryBatchId, Function.identity(), (o, q) -> o)).values().stream().collect(Collectors.toList());
        List<CompletableFuture> completableFutures = collect.stream().filter(p -> ObjectUtil.isNotEmpty((Object)p.getExpireTime()) && ObjectUtil.isNotEmpty((Object)p.getProduceTime())).map(o -> CompletableFuture.supplyAsync(() -> {
            Integer expire = this.getDaysBetween(o.getProduceTime(), o.getExpireTime());
            ArrayList<LabelExpiryStrategyEo> toSort = new ArrayList<LabelExpiryStrategyEo>();
            for (LabelExpiryStrategyEo r : list) {
                if (r.getEndDay() == null) {
                    r.setEndDay(Integer.valueOf(Integer.MAX_VALUE));
                }
                toSort.add(r);
            }
            toSort.sort(Comparator.comparing(LabelExpiryStrategyEo::getEndDay));
            block1: for (LabelExpiryStrategyEo r : toSort) {
                if (expire > r.getEndDay() || expire <= r.getStartDay()) continue;
                List batchExpiryTagRuleDtoList = JSONArray.parseArray((String)r.getExpiryJson(), BatchExpiryTagRuleDto.class).stream().sorted(Comparator.comparing(BatchExpiryTagRuleDto::getRightScale).reversed()).collect(Collectors.toList());
                log.info("\u6807\u7b7e\u7b56\u7565\u96c6\u5408batchExpiryTagRuleDtoList\u6392\u5e8f{}", (Object)JSONObject.toJSONString(batchExpiryTagRuleDtoList));
                Date failuredate = o.getProduceTime();
                for (int i = 0; i < batchExpiryTagRuleDtoList.size(); ++i) {
                    RelInventoryBatchTagEo reBizTagRecordReqDto = this.getReBizTagRecordReqDto((ProcessLabelReqDto)o);
                    BatchExpiryTagRuleDto batchExpiryTagRuleDto = (BatchExpiryTagRuleDto)batchExpiryTagRuleDtoList.get(i);
                    BigDecimal addDay = new BigDecimal(expire).multiply(batchExpiryTagRuleDto.getRightScale().subtract(batchExpiryTagRuleDto.getLeftScale())).divide(new BigDecimal("100"), 6, 1);
                    reBizTagRecordReqDto.setEffectiveTime(failuredate);
                    failuredate = LabelExpiryStrategyServiceImpl.calculateDate(failuredate, addDay);
                    reBizTagRecordReqDto.setTagCode(batchExpiryTagRuleDto.getTagCode());
                    reBizTagRecordReqDto.setFailureTime(failuredate);
                    if (i == batchExpiryTagRuleDtoList.size() - 1) {
                        reBizTagRecordReqDto.setFailureTime(DateUtil.parse((String)"9999-12-01 00:00:00"));
                        reBizTagRecordReqDto.setTagCode(batchExpiryTagRuleDto.getTagCode());
                        reBizTagRecordReqDtoList.add(reBizTagRecordReqDto);
                        continue block1;
                    }
                    reBizTagRecordReqDtoList.add(reBizTagRecordReqDto);
                }
            }
            return true;
        }, executor)).collect(Collectors.toList());
        CompletableFuture.allOf(completableFutures.toArray(new CompletableFuture[0]));
        List idList = dto.stream().map(ProcessLabelReqDto::getInventoryBatchId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return;
        }
        RelInventoryBatchTagPageReqDto relInventoryBatchTagPageReqDto = new RelInventoryBatchTagPageReqDto();
        relInventoryBatchTagPageReqDto.setInventoryBatchIdList(idList);
        try {
            Map attachments = ServiceContext.getContext().getAttachments();
            CompletableFuture.runAsync(() -> {
                attachments.forEach((k, v) -> ServiceContext.getContext().setAttachment(k, v));
                this.relInventoryBatchTagMapper.deleteList(relInventoryBatchTagPageReqDto);
                this.iRelInventoryBatchTagDomain.insertBatch(reBizTagRecordReqDtoList.stream().collect(Collectors.toList()));
            }, executor);
        }
        catch (Exception e) {
            throw new BizException(e.getMessage());
        }
    }

    private RelInventoryBatchTagEo getReBizTagRecordReqDto(ProcessLabelReqDto o) {
        RelInventoryBatchTagEo relInventoryBatchTagEo = new RelInventoryBatchTagEo();
        relInventoryBatchTagEo.setSkuCode(o.getSkuCode());
        relInventoryBatchTagEo.setBatch(o.getBatch());
        relInventoryBatchTagEo.setInventoryBatchId(o.getInventoryBatchId());
        relInventoryBatchTagEo.setTagType(TagGroupEnum.EXPIRY_DATE.getCode());
        return relInventoryBatchTagEo;
    }

    private Integer getDaysBetween(Date date1, Date date2) {
        long diffInMilliseconds = Math.abs(date2.getTime() - date1.getTime());
        long diffInDays = TimeUnit.DAYS.convert(diffInMilliseconds, TimeUnit.MILLISECONDS);
        return ParamConverter.convertToInteger((Object)diffInDays);
    }

    public static Date calculateDate(Date date, BigDecimal daysToAdd) {
        BigDecimal millisecondsPerDay = new BigDecimal("86400000");
        BigDecimal millisecondsToAdd = daysToAdd.multiply(millisecondsPerDay);
        long millisecondsToAddLong = millisecondsToAdd.longValue();
        long resultTime = date.getTime() + millisecondsToAddLong;
        Date resultDate = new Date();
        resultDate.setTime(resultTime);
        return resultDate;
    }
}

