/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.LockTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicInventoryConverter;
import com.yunxi.dg.base.center.inventory.dao.das.IInventoryOperateLogDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventorySnapshotDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.LockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseLockDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LockLogicInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.InventoryOperateLogEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventorySnapshotEo;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicInventoryService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DateUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class LogicInventoryServiceImpl
extends BaseServiceImpl<LogicInventoryDto, LogicInventoryEo, ILogicInventoryDomain>
implements ILogicInventoryService {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryServiceImpl.class);
    @Resource
    ICalcInventoryService calcInventoryService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ILogicInventorySnapshotDas logicInventorySnapshotDas;
    @Resource
    private IInventoryOperateLogDas inventoryOperateLogDas;

    public LogicInventoryServiceImpl(ILogicInventoryDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicInventoryDto, LogicInventoryEo> converter() {
        return LogicInventoryConverter.INSTANCE;
    }

    @Override
    public List<LogicInventoryDto> queryBySkuCodesWithWarehouseCode(String outLogicWarehouseCode, Set<String> skuCodeSet) {
        return BeanUtil.copyToList((Collection)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ILogicInventoryDomain)this.domain).filter().eq((Object)"warehouse_code", (Object)outLogicWarehouseCode)).in((Object)"sku_code", skuCodeSet)).list(), LogicInventoryDto.class);
    }

    @Override
    public List<LogicInventoryDto> queryByBatchAndSkuCodes(String outLogicWarehouseCode, String batch, Set<String> skuCodeSet) {
        return BeanUtil.copyToList((Collection)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ILogicInventoryDomain)this.domain).filter().eq((Object)"warehouse_code", (Object)outLogicWarehouseCode)).eq((Object)"batch", (Object)batch)).in((Object)"sku_code", skuCodeSet)).list(), LogicInventoryDto.class);
    }

    @Override
    public void lockOrUnlockInventory(LockLogicInventoryDto dto, String type) {
        log.info("\u9501\u5b9a\u5e93\u5b58\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        LogicInventoryEo eo = this.checkParam(dto);
        log.info("\u6570\u636e\u5e93\u67e5\u8be2\u903b\u8f91\u5e93\u5b58\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)eo));
        String key = eo.getWarehouseCode() + " " + eo.getSkuCode() + " " + eo.getBatch();
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setType(type);
        record.setDocumentCode(type);
        OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
        unitConversionDetail.setCurUnit(dto.getUnit());
        unitConversionDetail.setSkuCode(eo.getSkuCode());
        unitConversionDetail.setCurNum(dto.getQuantity());
        record.setOrderUnitConversionDetailList((List)Lists.newArrayList((Object[])new OrderUnitConversionReqDto.OrderUnitConversionDetail[]{unitConversionDetail}));
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(record);
        log.info("\u8f6c\u6362\u5355\u4f4d\u540e\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(orderUnitConversionRecordDtos));
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(orderUnitConversionRecordDtos), (String)"\u8f6c\u6362\u5355\u4f4d\u8fd4\u53c2\u4e3a\u7a7a");
        OrderUnitConversionRecordDto orderUnitConversionRecordDto = orderUnitConversionRecordDtos.get(0);
        if (LockTypeEnum.LOCK.getCode().equals(type)) {
            AssertUtil.isTrue((eo.getAvailable().compareTo(orderUnitConversionRecordDto.getToNum()) >= 0 ? 1 : 0) != 0, (String)"\u9501\u5e93\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u5355\u4f4d\u53ef\u7528\u5e93\u5b58");
        }
        if (LockTypeEnum.UNLOCK.getCode().equals(type)) {
            AssertUtil.isTrue((eo.getLockInventory().compareTo(orderUnitConversionRecordDto.getToNum()) >= 0 ? 1 : 0) != 0, (String)"\u89e3\u9501\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u57fa\u672c\u5355\u4f4d\u9501\u5b9a\u5e93\u5b58");
        }
        ArrayList details = Lists.newArrayList();
        CalcDetailDto detail = new CalcDetailDto();
        detail.setLogicWarehouseCode(eo.getWarehouseCode());
        detail.setSkuCode(eo.getSkuCode());
        detail.setNum(orderUnitConversionRecordDto.getToNum());
        detail.setBatch(eo.getBatch());
        detail.setLineNo(Long.valueOf(1L));
        details.add(detail);
        if (LockTypeEnum.LOCK.getCode().equals(type)) {
            LockDto lockParam = new LockDto();
            lockParam.setSourceNo(key);
            lockParam.setSourceType(CsInventorySourceTypeEnum.LOCK_INVENTORY.getCode());
            lockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            lockParam.setDesc(dto.getReason());
            lockParam.setDetails((List)details);
            this.calcInventoryService.lock(lockParam);
        } else {
            ReleaseLockDto releaseLockParam = new ReleaseLockDto();
            releaseLockParam.setSourceNo(key);
            releaseLockParam.setSourceType(CsInventorySourceTypeEnum.UNLOCK_INVENTORY.getCode());
            releaseLockParam.setBusinessType(CsPcpBusinessTypeEnum.LOCK_ORDER.getCode());
            releaseLockParam.setDesc(dto.getReason());
            releaseLockParam.setDetails((List)details);
            this.calcInventoryService.releaseLock(releaseLockParam);
        }
    }

    @Override
    public List<LogicInventoryDto> queryThirdWarehouse(LogicInventoryPageReqDto dto) {
        return ((ILogicInventoryDomain)this.domain).queryThirdWarehouse(dto);
    }

    private LogicInventoryEo checkParam(LockLogicInventoryDto dto) {
        AssertUtil.isTrue((boolean)Objects.nonNull(dto), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)Objects.nonNull(dto.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)Objects.nonNull(dto.getQuantity()), (String)"\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getUnit()), (String)"\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        LogicInventoryEo eo = (LogicInventoryEo)((ILogicInventoryDomain)this.domain).getMapper().selectById((Serializable)dto.getId());
        AssertUtil.isTrue((boolean)Objects.nonNull(eo), (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u903b\u8f91\u5e93\u5b58\u4fe1\u606f");
        return eo;
    }

    @Override
    public List<LogicInventoryDto> querySnapshot(LogicInventoryPageReqDto dto) {
        String querySnapshotTime = dto.getSnapshotTime();
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)querySnapshotTime), (String)"\u5feb\u7167\u67e5\u8be2\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isFalse((StringUtils.isEmpty((CharSequence)dto.getWarehouseCode()) && StringUtils.isEmpty((CharSequence)dto.getWarehouseName()) && ObjectUtil.isEmpty((Object)dto.getWarehouseId()) ? 1 : 0) != 0, (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            querySnapshotTime = DateUtils.formatY_M_D((Date)DateUtils.parseString((String)querySnapshotTime, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (ParseException e) {
            throw new BizException("\u5feb\u7167\u67e5\u8be2\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        LogicInventorySnapshotEo logicInventorySnapshotEo = this.getRecentlySnapshot(querySnapshotTime, querySnapshotTime, 0);
        AssertUtil.isFalse((boolean)ObjectUtil.isEmpty((Object)logicInventorySnapshotEo), (String)"\u65e0\u6700\u8fd1\u4e00\u5468\u7684\u5e93\u5b58\u5feb\u7167");
        String snapshotTime = logicInventorySnapshotEo.getSnapshotDate();
        AssertUtil.isFalse((boolean)StringUtils.isEmpty((CharSequence)snapshotTime), (String)"\u5feb\u7167\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        String startTime = snapshotTime = snapshotTime + " 00:00:00";
        String endTime = dto.getSnapshotTime();
        if (this.greaterThanSnapshotTime(snapshotTime, dto.getSnapshotTime())) {
            startTime = dto.getSnapshotTime();
            endTime = snapshotTime;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        LambdaQueryWrapper logWrapper = new LambdaQueryWrapper();
        wrapper.eq(BaseEo::getDr, (Object)0);
        logWrapper.eq(BaseEo::getDr, (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)dto.getWarehouseName())) {
            wrapper.like(InventoryOperateLogEo::getWarehouseName, (Object)dto.getWarehouseName());
            logWrapper.like(LogicInventorySnapshotEo::getWarehouseName, (Object)dto.getWarehouseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)dto.getWarehouseCode())) {
            wrapper.eq(InventoryOperateLogEo::getWarehouseCode, (Object)dto.getWarehouseCode());
            logWrapper.eq(LogicInventorySnapshotEo::getWarehouseCode, (Object)dto.getWarehouseCode());
        }
        if (ObjectUtil.isNotEmpty((Object)dto.getWarehouseId())) {
            wrapper.eq(InventoryOperateLogEo::getWarehouseId, (Object)dto.getWarehouseId());
            logWrapper.eq(LogicInventorySnapshotEo::getWarehouseId, (Object)dto.getWarehouseId());
        }
        if (StringUtils.isNotEmpty((CharSequence)startTime)) {
            wrapper.gt(InventoryOperateLogEo::getChangeTime, (Object)startTime);
        }
        if (StringUtils.isNotEmpty((CharSequence)endTime)) {
            wrapper.lt(InventoryOperateLogEo::getChangeTime, (Object)endTime);
        }
        List inventoryOperateLogEos = this.inventoryOperateLogDas.getMapper().selectList((Wrapper)wrapper);
        if (StringUtils.isNotEmpty((CharSequence)logicInventorySnapshotEo.getSnapshotDate())) {
            logWrapper.eq(LogicInventorySnapshotEo::getSnapshotDate, (Object)logicInventorySnapshotEo.getSnapshotDate());
        }
        List logicInventorySnapshotEos = this.logicInventorySnapshotDas.getMapper().selectList((Wrapper)logWrapper);
        return this.calculateInventory(inventoryOperateLogEos, logicInventorySnapshotEos);
    }

    private List<LogicInventoryDto> calculateInventory(List<InventoryOperateLogEo> inventoryOperateLogEos, List<LogicInventorySnapshotEo> logicInventorySnapshotEos) {
        ArrayList resultLogicInventoryDto = Lists.newArrayList();
        if (CollectionUtils.isEmpty(logicInventorySnapshotEos)) {
            return resultLogicInventoryDto;
        }
        if (CollectionUtils.isEmpty(inventoryOperateLogEos)) {
            for (LogicInventorySnapshotEo logicInventorySnapshotEo : logicInventorySnapshotEos) {
                LogicInventoryDto logicInventoryDto = new LogicInventoryDto();
                BeanUtils.copyProperties((Object)logicInventorySnapshotEo, (Object)logicInventoryDto);
                resultLogicInventoryDto.add(logicInventoryDto);
            }
            return resultLogicInventoryDto;
        }
        for (LogicInventorySnapshotEo logicInventorySnapshotEo : logicInventorySnapshotEos) {
            List<InventoryOperateLogEo> inventoryOperateLogEoList = inventoryOperateLogEos.stream().filter(o -> StringUtils.equals((CharSequence)logicInventorySnapshotEo.getWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)logicInventorySnapshotEo.getSkuCode(), (CharSequence)o.getSkuCode()) && StringUtils.equals((CharSequence)logicInventorySnapshotEo.getBatch(), (CharSequence)o.getBatch())).collect(Collectors.toList());
            LogicInventoryDto logicInventoryDto = new LogicInventoryDto();
            BeanUtils.copyProperties((Object)logicInventorySnapshotEo, (Object)logicInventoryDto);
            if (CollectionUtils.isNotEmpty(inventoryOperateLogEoList)) {
                this.calculateInventoryByInventoryOperateLog(logicInventoryDto, inventoryOperateLogEoList);
            }
            resultLogicInventoryDto.add(logicInventoryDto);
        }
        return resultLogicInventoryDto;
    }

    private void calculateInventoryByInventoryOperateLog(LogicInventoryDto logicInventoryDto, List<InventoryOperateLogEo> inventoryOperateLogEoList) {
        for (InventoryOperateLogEo inventoryOperateLogEo : inventoryOperateLogEoList) {
            BigDecimal changeInventory = inventoryOperateLogEo.getChangeInventory();
            if (StringUtils.equals((CharSequence)inventoryOperateLogEo.getInOutFlag(), (CharSequence)"in")) {
                changeInventory = BigDecimalUtils.multiply((BigDecimal)changeInventory, (BigDecimal)new BigDecimal(-1));
            }
            switch (inventoryOperateLogEo.getChangeType()) {
                case "balance": {
                    logicInventoryDto.setBalance(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getBalance(), (BigDecimal)changeInventory));
                    break;
                }
                case "preempt": {
                    logicInventoryDto.setPreempt(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getPreempt(), (BigDecimal)changeInventory));
                    break;
                }
                case "disable": {
                    logicInventoryDto.setAllocate(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getAllocate(), (BigDecimal)changeInventory));
                    break;
                }
                case "activity_allocate": {
                    logicInventoryDto.setActivityAllocate(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getActivityAllocate(), (BigDecimal)changeInventory));
                    break;
                }
                case "intransit": {
                    logicInventoryDto.setIntransit(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getIntransit(), (BigDecimal)changeInventory));
                    break;
                }
                case "transfer": {
                    logicInventoryDto.setTransfer(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getTransfer(), (BigDecimal)changeInventory));
                    break;
                }
                case "completed": {
                    logicInventoryDto.setCompleted(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getCompleted(), (BigDecimal)changeInventory));
                    break;
                }
                case "available": {
                    logicInventoryDto.setAvailable(BigDecimalUtils.add((BigDecimal)logicInventoryDto.getAvailable(), (BigDecimal)changeInventory));
                    break;
                }
            }
        }
    }

    private boolean greaterThanSnapshotTime(String snapshotDateStr, String querySnapshotDateStr) {
        try {
            Date snapshotDate = DateUtils.parseString((String)snapshotDateStr, (String)"yyyy-MM-dd");
            Date querySnapshotDate = DateUtils.parseString((String)querySnapshotDateStr, (String)"yyyy-MM-dd HH:mm:ss");
            int second = DateUtils.diffSecond((Date)querySnapshotDate, (Date)snapshotDate);
            return second >= 0;
        }
        catch (ParseException e) {
            log.info("\u5224\u65ad\u5feb\u7167\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
            return false;
        }
    }

    private LogicInventorySnapshotEo getRecentlySnapshot(String beforeSnapshotTime, String nextSnapshotTine, Integer count) {
        if (count > 3) {
            return null;
        }
        LogicInventorySnapshotEo logicInventorySnapshotEo = this.getLogicInventorySnapshotBySnapshotTime(beforeSnapshotTime);
        if (ObjectUtil.isNotEmpty((Object)logicInventorySnapshotEo)) {
            return logicInventorySnapshotEo;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        Date beforeSnapshotDate = null;
        Date nextSnapshotDate = null;
        String beforeSnapshotStr = null;
        String nextSnapshotStr = null;
        try {
            beforeSnapshotDate = DateUtils.addDate((Date)DateUtils.parseString((String)beforeSnapshotTime, (String)"yyyy-MM-dd"), (int)-1);
            nextSnapshotDate = DateUtils.addDate((Date)DateUtils.parseString((String)nextSnapshotTine, (String)"yyyy-MM-dd"), (int)1);
        }
        catch (ParseException e) {
            log.info("\u5feb\u7167\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
        }
        if (ObjectUtil.isNotEmpty((Object)beforeSnapshotDate)) {
            beforeSnapshotStr = DateUtils.formatDate((Date)beforeSnapshotDate, (String)"yyyy-MM-dd");
        }
        if (ObjectUtil.isNotEmpty(nextSnapshotDate)) {
            nextSnapshotStr = DateUtils.formatDate((Date)nextSnapshotDate, (String)"yyyy-MM-dd");
        }
        if (StringUtils.isNotEmpty((CharSequence)beforeSnapshotStr)) {
            logicInventorySnapshotEo = this.getLogicInventorySnapshotBySnapshotTime(beforeSnapshotStr);
        }
        if (ObjectUtil.isNotEmpty((Object)logicInventorySnapshotEo)) {
            return logicInventorySnapshotEo;
        }
        if (StringUtils.isNotEmpty((CharSequence)nextSnapshotStr)) {
            logicInventorySnapshotEo = this.getLogicInventorySnapshotBySnapshotTime(nextSnapshotStr);
        }
        if (ObjectUtil.isNotEmpty((Object)logicInventorySnapshotEo)) {
            return logicInventorySnapshotEo;
        }
        return this.getRecentlySnapshot(beforeSnapshotStr, nextSnapshotStr, count);
    }

    private LogicInventorySnapshotEo getLogicInventorySnapshotBySnapshotTime(String snapshotTime) {
        return this.logicInventorySnapshotDas.queryBySnapshotDate(snapshotTime);
    }
}

