/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.aliyuncs.utils.StringUtils;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.inventory.convert.entity.LogicInventorySnapshotConverter;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryDas;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventorySnapshotDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventorySnapshotDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventorySnapshotDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventorySnapshotPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventorySnapshotEo;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicInventorySnapshotService;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseService;
import com.yunxi.dg.base.center.inventory.utils.DateUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LogicInventorySnapshotServiceImpl
extends BaseServiceImpl<LogicInventorySnapshotDto, LogicInventorySnapshotEo, ILogicInventorySnapshotDomain>
implements ILogicInventorySnapshotService {
    private static final Logger log = LoggerFactory.getLogger(LogicInventorySnapshotServiceImpl.class);
    @Resource
    private ILogicInventorySnapshotDas inventorySnapshotDas;
    private static final String REDIS_SAVE_LOGIC_INVENTORY_SNAPSHOT_LOCK = "redis_save_logic_inventory_snapshot_lock";
    private static final int REDIS_SAVE_LOGIC_INVENTORY_SNAPSHOT_EXPIRE_TIME = 120;
    @Resource
    private ICacheService cacheService;
    @Resource
    private ILogicInventoryDas logicInventoryDas;
    @Resource
    private ILogicWarehouseService logicWarehouseService;

    public LogicInventorySnapshotServiceImpl(ILogicInventorySnapshotDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<LogicInventorySnapshotDto, LogicInventorySnapshotEo> converter() {
        return LogicInventorySnapshotConverter.INSTANCE;
    }

    @Override
    public void save() {
        this.save(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(String snapshotDate) {
        try {
            boolean isUniqueOrder = this.cacheService.add(REDIS_SAVE_LOGIC_INVENTORY_SNAPSHOT_LOCK, (Object)1, 120);
            if (!isUniqueOrder) {
                return;
            }
            String currentDate = snapshotDate;
            if (StringUtils.isEmpty((CharSequence)snapshotDate)) {
                currentDate = LogicInventorySnapshotServiceImpl.addOneDay(DateUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd"), 0);
            }
            LogicInventorySnapshotEo logicInventorySnapshotEo = new LogicInventorySnapshotEo();
            logicInventorySnapshotEo.setSnapshotDate(currentDate);
            ((ILogicInventorySnapshotDomain)this.domain).logicDelete((BaseEo)logicInventorySnapshotEo);
            List logicInventoryEos = ((ExtQueryChainWrapper)this.logicInventoryDas.filter().eq((Object)"dr", (Object)0)).list();
            ArrayList logicInventorySnapshotEos = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)logicInventoryEos)) {
                List<String> warehouseCodes = logicInventoryEos.stream().map(LogicInventoryEo::getWarehouseCode).distinct().collect(Collectors.toList());
                Map<String, LogicWarehouseRespDto> logicWarehouseRespDtoMap = this.getLogicWarehouseRespDto(warehouseCodes);
                for (LogicInventoryEo logicInventoryEo : logicInventoryEos) {
                    logicInventorySnapshotEo = new LogicInventorySnapshotEo();
                    BeanUtil.copyProperties((Object)logicInventoryEo, (Object)logicInventorySnapshotEo, (String[])new String[]{"createTime", "updateTime", "id"});
                    logicInventorySnapshotEo.setSnapshotDate(currentDate);
                    if (logicWarehouseRespDtoMap.containsKey(logicInventoryEo.getWarehouseCode())) {
                        LogicWarehouseRespDto logicWarehouseRespDto = logicWarehouseRespDtoMap.get(logicInventoryEo.getWarehouseCode());
                        logicInventorySnapshotEo.setOrganizationId(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationId() : null);
                        logicInventorySnapshotEo.setOrganizationCode(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationCode() : null);
                        logicInventorySnapshotEo.setOrganizationName(Objects.nonNull(logicWarehouseRespDto) ? logicWarehouseRespDto.getOrganizationName() : null);
                    }
                    logicInventorySnapshotEos.add(logicInventorySnapshotEo);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)logicInventorySnapshotEos)) {
                List logicInventorySnapshotEoList = CollUtil.split((Collection)logicInventorySnapshotEos, (int)1000);
                logicInventorySnapshotEoList.forEach(eoList -> ((ILogicInventorySnapshotDomain)this.domain).insertBatch(eoList));
            }
        }
        catch (Exception e) {
            log.info("\u4fdd\u5b58\u5e93\u5b58\u5feb\u7167\u6570\u636e\u5f02\u5e38=={}", (Object)e.getMessage());
        }
        finally {
            this.cacheService.delCache(REDIS_SAVE_LOGIC_INVENTORY_SNAPSHOT_LOCK);
        }
    }

    @Override
    public RestResponse<PageInfo<LogicInventorySnapshotDto>> page(LogicInventorySnapshotPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        List dtoList = this.inventorySnapshotDas.page(dto);
        PageInfo pageInfo = new PageInfo(dtoList);
        return new RestResponse((Object)pageInfo);
    }

    private Map<String, LogicWarehouseRespDto> getLogicWarehouseRespDto(List<String> warehouseCodes) {
        Map<Object, Object> logicWarehouseRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            LogicWarehousePageReqDto dto = new LogicWarehousePageReqDto();
            dto.setWarehouseCodeList(warehouseCodes);
            List<LogicWarehouseRespDto> logicWarehouseRespDtos = this.logicWarehouseService.queryDataListByParams(dto);
            logicWarehouseRespDtoMap = logicWarehouseRespDtos.stream().collect(Collectors.toMap(LogicWarehouseRespDto::getWarehouseCode, Function.identity(), (k1, k2) -> k1));
        }
        return logicWarehouseRespDtoMap;
    }

    public static String addOneDay(String dateStr, Integer count) {
        try {
            Date parse = new SimpleDateFormat("yyyy-MM-dd").parse(dateStr);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(parse);
            ((Calendar)calendar).add(5, count);
            parse = calendar.getTime();
            return new SimpleDateFormat("yyyy-MM-dd").format(parse);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BizException("-1", e.getMessage());
        }
    }
}

