/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDetailDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.transcation.TransactionCallBackService;
import com.yunxi.dg.base.center.item.ItemExchangeUnitDgReqDto;
import com.yunxi.dg.base.center.item.ItemExchangeUnitDgRespDto;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.dto.entity.ItemUnitConversionDgDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OrderUnitConversionRecordServiceImpl
extends BaseServiceImpl<OrderUnitConversionRecordDto, OrderUnitConversionRecordEo, IOrderUnitConversionRecordDomain>
implements IOrderUnitConversionRecordService {
    private static final Logger log = LoggerFactory.getLogger(OrderUnitConversionRecordServiceImpl.class);
    @Resource
    private IItemSkuDgQueryApiProxy iItemSkuDgQueryApiProxy;
    @Resource
    private TransactionCallBackService transactionCallBackService;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    ItemDetailDataQueryHelperImpl itemDetailDataQueryHelper;
    public static final String ORDER_UNIT_CACHE_KEY = "orderUnitCacheKey";

    public OrderUnitConversionRecordServiceImpl(IOrderUnitConversionRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OrderUnitConversionRecordDto, OrderUnitConversionRecordEo> converter() {
        return OrderUnitConversionRecordConverter.INSTANCE;
    }

    @Override
    public List<OrderUnitConversionRecordDto> queryAndSaveUnitConversion(OrderUnitConversionReqDto record) {
        List<OrderUnitConversionRecordDto> recordDtos;
        List<Object> restResponse;
        if (Objects.isNull(record) || CollectionUtils.isEmpty((Collection)record.getOrderUnitConversionDetailList())) {
            return new ArrayList<OrderUnitConversionRecordDto>();
        }
        log.info("\u5355\u4f4d\u8f6c\u6362\u8bf7\u6c42:{}", (Object)JSONUtil.toJsonStr((Object)record));
        AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)record.getDocumentCode()), (String)"\u5355\u636e\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<ItemExchangeUnitDgReqDto> unitDtoList = new ArrayList<ItemExchangeUnitDgReqDto>();
        for (OrderUnitConversionReqDto.OrderUnitConversionDetail itemReqDto : record.getOrderUnitConversionDetailList()) {
            boolean flag = StringUtils.isBlank((CharSequence)itemReqDto.getSkuCode()) || Objects.isNull(itemReqDto.getCurNum());
            if (flag) continue;
            if (record.isHasRowId() && Objects.isNull(itemReqDto.getRowId())) {
                record.setHasRowId(false);
            }
            ItemExchangeUnitDgReqDto unitDto = new ItemExchangeUnitDgReqDto();
            unitDto.setSkuCode(itemReqDto.getSkuCode());
            unitDto.setCurrentNum(itemReqDto.getCurNum());
            unitDto.setCurrentUnit(itemReqDto.getCurUnit());
            unitDtoList.add(unitDto);
        }
        if (CollectionUtils.isEmpty(unitDtoList)) {
            return new ArrayList<OrderUnitConversionRecordDto>();
        }
        try {
            restResponse = new ArrayList();
        }
        catch (Error | Exception e) {
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            restResponse = new ArrayList();
        }
        if (CollectionUtils.isEmpty(restResponse)) {
            restResponse = unitDtoList.stream().map(r -> {
                ItemExchangeUnitDgRespDto respDto = (ItemExchangeUnitDgRespDto)BeanUtil.copyProperties((Object)r, ItemExchangeUnitDgRespDto.class, (String[])new String[0]);
                respDto.setTargetUnit(r.getCurrentUnit());
                respDto.setTargetNum(r.getCurrentNum());
                respDto.setCode(r.getSkuCode());
                return respDto;
            }).collect(Collectors.toList());
        }
        log.info("\u5355\u4f4d\u6362\u7b97\u5904\u7406-restResponse\uff1a{}", (Object)JSONUtil.toJsonStr(restResponse));
        if (record.isHasRowId()) {
            Map unitDgRespDtoMap = restResponse.stream().collect(Collectors.toMap(r -> String.join((CharSequence)InventoryConfig.getCommonSeparate(), r.getCode(), r.getCurrentUnit()), Function.identity(), (o, o1) -> o));
            recordDtos = record.getOrderUnitConversionDetailList().stream().map(r -> {
                ItemExchangeUnitDgRespDto re = (ItemExchangeUnitDgRespDto)unitDgRespDtoMap.get(String.join((CharSequence)InventoryConfig.getCommonSeparate(), r.getSkuCode(), r.getCurUnit()));
                OrderUnitConversionRecordDto recordDto = (OrderUnitConversionRecordDto)BeanUtil.copyProperties((Object)re, OrderUnitConversionRecordDto.class, (String[])new String[0]);
                BigDecimal decimal = UnitTransferUtils.pareSaleNum((BigDecimal)r.getCurNum(), (BigDecimal)BigDecimalUtils.divide((BigDecimal)re.getCurrentNum(), (BigDecimal)re.getTargetNum()), (BigDecimal)BigDecimalUtils.divide((BigDecimal)re.getTargetNum(), (BigDecimal)re.getCurrentNum()));
                recordDto.setToNum(decimal);
                recordDto.setNum(r.getCurNum());
                recordDto.setUnit(r.getCurUnit());
                recordDto.setSkuCode(r.getSkuCode());
                recordDto.setToUnit(re.getTargetUnit());
                recordDto.setDocumentCode(record.getDocumentCode());
                recordDto.setType(record.getType());
                recordDto.setGrossWeight(re.getGrossWeight());
                recordDto.setVolume(re.getVolume());
                recordDto.setMatchKey(r.getRowId() + "");
                return recordDto;
            }).collect(Collectors.toList());
        } else {
            recordDtos = restResponse.stream().map(re -> {
                OrderUnitConversionRecordDto recordDto = (OrderUnitConversionRecordDto)BeanUtil.copyProperties((Object)re, OrderUnitConversionRecordDto.class, (String[])new String[0]);
                recordDto.setToNum(re.getTargetNum());
                recordDto.setNum(re.getCurrentNum());
                recordDto.setUnit(re.getCurrentUnit());
                recordDto.setSkuCode(re.getCode());
                recordDto.setToUnit(re.getTargetUnit());
                recordDto.setDocumentCode(record.getDocumentCode());
                recordDto.setType(record.getType());
                recordDto.setMatchKey(re.getItemCode() + InventoryConfig.getCommonSeparate() + re.getCurrentUnit());
                recordDto.setGrossWeight(re.getGrossWeight());
                recordDto.setVolume(re.getVolume());
                recordDto.setExtensionDto(BeanUtil.copyProperties((Object)re, OrderUnitConversionRecordDtoExtension.class, (String[])new String[0]));
                return recordDto;
            }).collect(Collectors.toList());
        }
        log.info("\u5355\u4f4d\u6362\u7b97\u5904\u7406-recordDtos\uff1a{}", (Object)JSONUtil.toJsonStr(recordDtos));
        ServiceContext.getContext().setAttachment(ORDER_UNIT_CACHE_KEY + InventoryConfig.getCommonSeparate() + record.getDocumentCode(), JSONUtil.toJsonStr((Object)this.converter().toEoList(recordDtos)));
        this.transactionCallBackService.execute(() -> {
            if (!record.isCanSave()) {
                return;
            }
            List conversionRecordEos = ((ExtQueryChainWrapper)((IOrderUnitConversionRecordDomain)this.domain).filter().eq((Object)"document_code", (Object)record.getDocumentCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)conversionRecordEos)) {
                if (record.isHasRowId()) {
                    Set set = recordDtos.stream().map(OrderUnitConversionRecordDto::getMatchKey).collect(Collectors.toSet());
                    Optional.of(conversionRecordEos.stream().filter(r -> set.contains(r.getMatchKey())).map(BaseEo::getId).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((IOrderUnitConversionRecordDomain)((IOrderUnitConversionRecordDomain)this.domain)).deleteByIds(arg_0));
                } else {
                    Set collect = recordDtos.stream().map(OrderUnitConversionRecordDto::getSkuCode).collect(Collectors.toSet());
                    Optional.of(conversionRecordEos.stream().filter(r -> collect.contains(r.getSkuCode())).map(BaseEo::getId).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((IOrderUnitConversionRecordDomain)((IOrderUnitConversionRecordDomain)this.domain)).deleteByIds(arg_0));
                }
            }
            List orderUnitConversionRecordEos = this.converter().toEoList(recordDtos);
            Optional.of(orderUnitConversionRecordEos).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((IOrderUnitConversionRecordDomain)((IOrderUnitConversionRecordDomain)this.domain)).insertBatch(arg_0));
        });
        return recordDtos;
    }

    @Override
    public List<OrderUnitConversionRecordDto> adapterUnitAndQuery(DispatcherOrderEo eo, List<DispatcherOrderDetailEo> list) {
        List transferUnitList = ((ExtQueryChainWrapper)((IOrderUnitConversionRecordDomain)this.domain).filter().eq((Object)"document_code", (Object)eo.getTransferOrderNo())).list();
        if (CollectionUtils.isEmpty((Collection)transferUnitList)) {
            return new ArrayList<OrderUnitConversionRecordDto>();
        }
        Map dataMap = transferUnitList.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, Function.identity(), (o, o1) -> o));
        List unitConversionRecordEos = list.stream().map(data -> {
            OrderUnitConversionRecordEo orderUnitConversionRecordEo = (OrderUnitConversionRecordEo)dataMap.get(data.getSkuCode());
            AssertUtils.notNull((Object)orderUnitConversionRecordEo, (String)"sku:{},\u8c03\u62e8\u5355\u672a\u5b58\u5728\u5355\u4f4d", (Object[])new Object[]{data.getSkuCode()});
            OrderUnitConversionRecordEo recordEo = (OrderUnitConversionRecordEo)BeanUtil.copyProperties((Object)orderUnitConversionRecordEo, OrderUnitConversionRecordEo.class, (String[])new String[]{"id"});
            recordEo.setDocumentCode(eo.getOrderNo());
            recordEo.setType(eo.getType());
            recordEo.setNum(data.getDispatcherQuantity());
            recordEo.setUnit(orderUnitConversionRecordEo.getUnit());
            recordEo.setToNum(data.getDispatcherQuantity().multiply(orderUnitConversionRecordEo.getToNum()).divide(orderUnitConversionRecordEo.getNum(), 2, RoundingMode.DOWN));
            recordEo.setToUnit(orderUnitConversionRecordEo.getToUnit());
            data.setUnit(recordEo.getUnit());
            data.setQuantity(recordEo.getToNum());
            return recordEo;
        }).collect(Collectors.toList());
        this.transactionCallBackService.execute(() -> ((IOrderUnitConversionRecordDomain)this.domain).insertBatch(unitConversionRecordEos));
        return this.converter().toDtoList(unitConversionRecordEos);
    }

    @Override
    public PageInfo<OrderUnitConversionRecordDto> queryPage(OrderUnitConversionRecordPageReqDto reqDto) {
        PageInfo orderUnitConversionRecordEoPageInfo = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IOrderUnitConversionRecordDomain)this.domain).filter().eq(StringUtils.isNotBlank((CharSequence)reqDto.getDocumentCode()), (Object)"document_code", (Object)reqDto.getDocumentCode())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList()), (Object)"sku_code", (Collection)reqDto.getSkuCodeList())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getUnitList()), (Object)"unit", (Collection)reqDto.getUnitList())).page(reqDto.getPageNum(), reqDto.getPageSize());
        List orderUnitConversionRecordDtos = BeanUtil.copyToList((Collection)orderUnitConversionRecordEoPageInfo.getList(), OrderUnitConversionRecordDto.class);
        PageInfo orderUnitConversionRecordDtoPageInfo = new PageInfo();
        BeanUtil.copyProperties((Object)orderUnitConversionRecordEoPageInfo, (Object)orderUnitConversionRecordDtoPageInfo, (String[])new String[]{"list"});
        orderUnitConversionRecordDtoPageInfo.setList(orderUnitConversionRecordDtos);
        return orderUnitConversionRecordDtoPageInfo;
    }

    private List<OrderUnitConversionRecordEo> getRecordByCode(String transferOrderNo) {
        return Optional.ofNullable(transferOrderNo).map(r -> ServiceContext.getContext().getAttachment("orderUnitCacheKey__" + r)).filter(StringUtils::isNotBlank).map(r -> JSONUtil.parseArray((String)r).toList(OrderUnitConversionRecordEo.class)).orElseGet(() -> ((ExtQueryChainWrapper)((IOrderUnitConversionRecordDomain)this.domain).filter().eq((Object)"document_code", (Object)transferOrderNo)).list());
    }

    @Override
    public Map<String, BasicOrderDtoExtension> calculateWeightAndVolume(IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo) {
        List<OrderUnitConversionRecordEo> orderUnitConversionRecordEos = this.getRecordByCode(calculateWeightAndVolumeBo.getDocumentCode());
        log.info("[\u8ba1\u7b97\u4f53\u79ef\u91cd\u91cf]orderUnitConversionRecordEos->{}", (Object)JSONUtil.toJsonStr(orderUnitConversionRecordEos));
        Map<String, String> skuCodeUnitMap = orderUnitConversionRecordEos.stream().filter(dto -> dto.getToUnit() != null).collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, OrderUnitConversionRecordEo::getToUnit, (k1, k2) -> k1));
        for (IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo volumeDetailBo : calculateWeightAndVolumeBo.getVolumeDetailBos()) {
            volumeDetailBo.setOriQuantity(volumeDetailBo.getQuantity());
            if (!StringUtils.isBlank((CharSequence)volumeDetailBo.getUnit())) continue;
            volumeDetailBo.setUnit(skuCodeUnitMap.get(volumeDetailBo.getSkuCode()));
        }
        if (calculateWeightAndVolumeBo.isCanTransferNum()) {
            Map unitEoMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(x -> x.getSkuCode() + InventoryConfig.getCommonSeparate() + x.getUnit(), Function.identity(), (o, o1) -> o));
            calculateWeightAndVolumeBo.getVolumeDetailBos().forEach(r -> r.setQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)r.getQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)BeanUtil.copyProperties(unitEoMap.get(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getUnit()), OrderUnitConversionRecordDto.class, (String[])new String[0])), (boolean)false)));
            log.info("[\u8ba1\u7b97\u4f53\u79ef\u91cd\u91cf]\u7ecf\u8fc7\u8f6c\u6362\u540e\uff1a{}", (Object)JSONUtil.toJsonStr(calculateWeightAndVolumeBo.getVolumeDetailBos()));
        }
        List<String> skuCodeList = calculateWeightAndVolumeBo.getVolumeDetailBos().stream().map(IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo::getSkuCode).distinct().collect(Collectors.toList());
        List skuDtoList = Optional.ofNullable(this.itemDataQueryHelper.getByCodes(skuCodeList)).orElse(Collections.emptyList());
        Map itemSkuDgRespDtoMap = skuDtoList.stream().collect(Collectors.toMap(r -> r.getSkuCode() + r.getUnit(), Function.identity(), (o1, o) -> o));
        Map itemSkuBaseDgRespDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o1, o) -> o));
        Map<String, List> skuCodeMap = Optional.ofNullable(this.itemDetailDataQueryHelper.getByCodes(skuCodeList)).orElse(Collections.emptyList()).stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getSkuCode()) && CollectionUtils.isNotEmpty((Collection)r.getUnitConvertList())).collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, DgItemSkuDetailRespDto::getUnitConvertList, (k, v) -> k));
        HashMap<String, BasicOrderDtoExtension> dataMap = new HashMap<String, BasicOrderDtoExtension>(calculateWeightAndVolumeBo.getVolumeDetailBos().size());
        for (IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo volumeDetailBo : calculateWeightAndVolumeBo.getVolumeDetailBos()) {
            BasicOrderDtoExtension dtoExtension = new BasicOrderDtoExtension();
            log.info("\u5355\u4f4d\u8f6c\u6362itemSkuDgRespDtoMap\uff1a{}", (Object)JSONUtil.toJsonStr(itemSkuDgRespDtoMap.get(volumeDetailBo.getSkuCode() + volumeDetailBo.getUnit())));
            log.info("\u5355\u4f4d\u8f6c\u6362skuCodeMap\uff1a{}", (Object)JSONUtil.toJsonStr((Object)skuCodeMap.get(volumeDetailBo.getSkuCode())));
            if (itemSkuDgRespDtoMap.containsKey(volumeDetailBo.getSkuCode() + volumeDetailBo.getUnit())) {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)itemSkuDgRespDtoMap.get(volumeDetailBo.getSkuCode() + volumeDetailBo.getUnit());
                BigDecimal temp = BigDecimalUtils.multiply((BigDecimal)itemSkuDgRespDto.getLength(), (BigDecimal)itemSkuDgRespDto.getWidth());
                BigDecimal volume = BigDecimalUtils.multiply((BigDecimal)temp, (BigDecimal)itemSkuDgRespDto.getHeight());
                volume = BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)volume).multiply(this.getVolume(itemSkuDgRespDto.getVolumeUnit())).multiply(this.calcVolume(itemSkuDgRespDto.getSizeUnit())).setScale(6, RoundingMode.DOWN);
                dtoExtension.setWeight(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)itemSkuDgRespDto.getGrossWeight()).multiply(this.getGrossWeight(itemSkuDgRespDto.getWeightUnit())).setScale(3, RoundingMode.DOWN));
                dtoExtension.setVolume(volume);
            } else if (skuCodeMap.containsKey(volumeDetailBo.getSkuCode())) {
                ItemSkuDto skuDgRespDto;
                Map conversionDgDtoMap = skuCodeMap.get(volumeDetailBo.getSkuCode()).stream().collect(Collectors.toMap(ItemUnitConversionDgDto::getConversionUnit, Function.identity(), (o, o1) -> o));
                if (conversionDgDtoMap.containsKey(volumeDetailBo.getUnit())) {
                    ItemUnitConversionDgDto itemUnitConversionDgDto = (ItemUnitConversionDgDto)conversionDgDtoMap.get(volumeDetailBo.getUnit());
                    dtoExtension.setWeight(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)itemUnitConversionDgDto.getGrossWeight()).multiply(this.getGrossWeight(itemUnitConversionDgDto.getWeightUnit())).setScale(3, RoundingMode.DOWN));
                    dtoExtension.setVolume(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)itemUnitConversionDgDto.getVolume()).multiply(this.getVolume(itemUnitConversionDgDto.getVolumeUnit())).setScale(6, RoundingMode.DOWN));
                } else if (itemSkuDgRespDtoMap.containsKey(volumeDetailBo.getSkuCode())) {
                    skuDgRespDto = (ItemSkuDto)itemSkuDgRespDtoMap.get(volumeDetailBo.getSkuCode());
                    dtoExtension.setWeight(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)skuDgRespDto.getGrossWeight()).multiply(this.getGrossWeight(skuDgRespDto.getWeightUnit())).setScale(3, RoundingMode.DOWN));
                    dtoExtension.setVolume(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)skuDgRespDto.getVolume()).multiply(this.getVolume(skuDgRespDto.getVolumeUnit())).setScale(6, RoundingMode.DOWN));
                } else if (itemSkuBaseDgRespDtoMap.containsKey(volumeDetailBo.getSkuCode())) {
                    skuDgRespDto = (ItemSkuDto)itemSkuBaseDgRespDtoMap.get(volumeDetailBo.getSkuCode());
                    dtoExtension.setWeight(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)skuDgRespDto.getGrossWeight()).multiply(this.getGrossWeight(skuDgRespDto.getWeightUnit())).setScale(3, RoundingMode.DOWN));
                    dtoExtension.setVolume(BigDecimalUtils.multiply((BigDecimal)volumeDetailBo.getQuantity(), (BigDecimal)skuDgRespDto.getVolume()).multiply(this.getVolume(skuDgRespDto.getVolumeUnit())).setScale(6, RoundingMode.DOWN));
                }
            }
            dataMap.put(volumeDetailBo.getSkuCode() + InventoryConfig.getCommonSeparate() + volumeDetailBo.getOriQuantity(), dtoExtension);
        }
        log.info("[\u8ba1\u7b97\u4f53\u79ef\u91cd\u91cf]\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonStr(dataMap));
        return dataMap;
    }

    @Override
    public void otherOrderVolumeAndWeightProcess(String orderNo, List<InOtherStorageOrderDetailEo> eos) {
        Map<String, BasicOrderDtoExtension> volumeMap;
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(eos.stream().map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setDocumentCode(orderNo);
        try {
            volumeMap = this.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        }
        catch (Exception e) {
            log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38:{},:{}", (Object)e.getMessage(), (Object)orderNo);
            volumeMap = new HashMap<String, BasicOrderDtoExtension>();
        }
        Map<String, BasicOrderDtoExtension> finalVolumeMap = volumeMap;
        eos.forEach(eo -> Optional.ofNullable(finalVolumeMap.get(eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getQuantity())).ifPresent(dtoExtension -> {
            eo.setVolume(dtoExtension.getVolume());
            eo.setWeight(dtoExtension.getWeight());
        }));
    }

    @Override
    public void baseVolumeAndWeightProcess(String orderNo, List<BaseOrderDetailReqDto> eos, boolean isBase) {
        Map<String, BasicOrderDtoExtension> volumeMap;
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(eos.stream().map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setCanTransferNum(isBase);
        calculateWeightAndVolumeBo.setDocumentCode(orderNo);
        try {
            volumeMap = this.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        }
        catch (Exception e) {
            log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38:{},:{}", (Object)e.getMessage(), (Object)orderNo);
            volumeMap = new HashMap<String, BasicOrderDtoExtension>();
        }
        Map<String, BasicOrderDtoExtension> finalVolumeMap = volumeMap;
        eos.forEach(eo -> Optional.ofNullable(finalVolumeMap.get(eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getQuantity())).ifPresent(dtoExtension -> {
            eo.setVolume(dtoExtension.getVolume());
            eo.setWeight(dtoExtension.getWeight());
        }));
    }

    @Override
    public void planOrderVolumeAndWeightProcess(String orderNo, List<PlanOrderDetailEo> eos) {
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setVolumeDetailBos(eos.stream().map(eo -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(eo.getPlanQuantity());
            calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
            calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList()));
        calculateWeightAndVolumeBo.setDocumentCode(orderNo);
        calculateWeightAndVolumeBo.setCanTransferNum(false);
        Map<String, BasicOrderDtoExtension> volumeMap = null;
        try {
            volumeMap = this.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        }
        catch (Exception e) {
            log.error("\u5355\u4f4d\u8f6c\u6362\u5f02\u5e38:{},:{}", new Object[]{e.getMessage(), orderNo, e});
            volumeMap = new HashMap<String, BasicOrderDtoExtension>();
        }
        Map<String, BasicOrderDtoExtension> finalVolumeMap = volumeMap;
        eos.forEach(eo -> Optional.ofNullable(finalVolumeMap.get(eo.getSkuCode() + InventoryConfig.getCommonSeparate() + eo.getPlanQuantity())).ifPresent(dtoExtension -> {
            eo.setVolume(dtoExtension.getVolume());
            eo.setWeight(dtoExtension.getWeight());
        }));
    }

    private BigDecimal getVolume(String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return new BigDecimal("1");
        }
        switch (unit) {
            case "mm3": {
                return new BigDecimal("0.000000001");
            }
            case "cm3": {
                return new BigDecimal("0.000001");
            }
            case "dm3": {
                return new BigDecimal("0.001");
            }
            case "km3": {
                return new BigDecimal("1000");
            }
        }
        return new BigDecimal("1");
    }

    private BigDecimal calcVolume(String sizeUnit) {
        if (StringUtils.isBlank((CharSequence)sizeUnit)) {
            return new BigDecimal("1");
        }
        switch (sizeUnit) {
            case "mm": {
                return new BigDecimal("0.000000001");
            }
            case "cm": {
                return new BigDecimal("0.000001");
            }
            case "dm": {
                return new BigDecimal("0.001");
            }
            case "km": {
                return new BigDecimal("1000");
            }
        }
        return new BigDecimal("1");
    }

    private BigDecimal getGrossWeight(String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return new BigDecimal("1");
        }
        switch (unit) {
            case "g": {
                return new BigDecimal("0.001");
            }
            case "mg": {
                return new BigDecimal("0.000001");
            }
            case "t": {
                return new BigDecimal("1000");
            }
        }
        return new BigDecimal("1");
    }

    @Override
    public List<OrderUnitConversionRecordEo> getRecordByOrderNo(String orderNo) {
        return this.getOrderUnitConversionRecordEos(orderNo, (ExtQueryChainWrapper<OrderUnitConversionRecordEo>)((IOrderUnitConversionRecordDomain)this.domain).filter());
    }

    @Override
    public List<OrderUnitConversionRecordEo> getOrderUnitConversionRecordEos(String orderNo, ExtQueryChainWrapper<OrderUnitConversionRecordEo> filter) {
        return Optional.ofNullable(orderNo).map(r -> ServiceContext.getContext().getAttachment(ORDER_UNIT_CACHE_KEY + InventoryConfig.getCommonSeparate() + r)).filter(StringUtils::isNotBlank).map(r -> JSONUtil.parseArray((String)r).toList(OrderUnitConversionRecordEo.class)).orElseGet(() -> ((ExtQueryChainWrapper)filter.eq((Object)"document_code", (Object)orderNo)).list());
    }
}

