/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.constants.OverchargeStrategyOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.convert.entity.OverchargeStrategyConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IOverchargeStrategyDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOverchargeStrategyDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.OverchargeStrategyDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OverchargeStrategyDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OverchargeStrategyPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.OverchargeStrategyDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OverchargeStrategyEo;
import com.yunxi.dg.base.center.inventory.service.entity.IOverchargeStrategyService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OverchargeStrategyServiceImpl
extends BaseServiceImpl<OverchargeStrategyDto, OverchargeStrategyEo, IOverchargeStrategyDomain>
implements IOverchargeStrategyService {
    private static final Logger log = LoggerFactory.getLogger(OverchargeStrategyServiceImpl.class);
    @Resource
    private IOverchargeStrategyDetailDomain overchargeStrategyDetailDomain;

    public OverchargeStrategyServiceImpl(IOverchargeStrategyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<OverchargeStrategyDto, OverchargeStrategyEo> converter() {
        return OverchargeStrategyConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Integer> insertBatch(List<OverchargeStrategyDto> dtos) {
        log.info("\u6279\u91cf\u65b0\u589e\u8d85\u6536\u7b56\u7565\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(dtos));
        this.checkParam(dtos);
        ArrayList eos = new ArrayList(dtos.size());
        ArrayList detailEos = new ArrayList();
        ArrayList orderTypes = Lists.newArrayList();
        dtos.forEach(dto -> {
            Long id = IdWorker.getId();
            OverchargeStrategyEo eo = (OverchargeStrategyEo)this.converter().toEo((BaseDto)dto);
            eo.setId(id);
            eos.add(eo);
            orderTypes.add(dto.getOrderType());
            List overchargeStrategyDetailList = dto.getOverchargeStrategyDetailList();
            if (CollectionUtils.isNotEmpty((Collection)overchargeStrategyDetailList)) {
                overchargeStrategyDetailList.forEach(detail -> {
                    OverchargeStrategyDetailEo detailEo = new OverchargeStrategyDetailEo();
                    CubeBeanUtils.copyProperties((Object)detailEo, (Object)detail, (String[])new String[0]);
                    detailEo.setOverchargeStrategyId(id);
                    detailEos.add(detailEo);
                });
            }
        });
        List overchargeStrategyEos = ((ExtQueryChainWrapper)((IOverchargeStrategyDomain)this.domain).filter().in((Object)"order_type", (Collection)orderTypes)).list();
        if (CollectionUtils.isNotEmpty((Collection)overchargeStrategyEos)) {
            List ids = overchargeStrategyEos.stream().map(e -> e.getId()).collect(Collectors.toList());
            ((IOverchargeStrategyDomain)this.domain).getMapper().deleteBatchIds(ids);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"overcharge_strategy_id", ids);
            queryWrapper.in((Object)"dr", new Object[]{0});
            this.overchargeStrategyDetailDomain.getMapper().delete((Wrapper)queryWrapper);
        }
        log.info("\u63d2\u5165\u8d85\u6536\u7b56\u7565\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(eos));
        log.info("\u63d2\u5165\u8d85\u6536\u7b56\u7565\u660e\u7ec6\u8868\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(detailEos));
        int num = ((IOverchargeStrategyDomain)this.domain).insertBatch(eos);
        this.overchargeStrategyDetailDomain.insertBatch(detailEos);
        return new RestResponse((Object)num);
    }

    @Override
    public PageInfo<OverchargeStrategyDto> queryByPage(OverchargeStrategyPageReqDto dto) {
        OverchargeStrategyEo overchargeStrategyEo = new OverchargeStrategyEo();
        CubeBeanUtils.copyProperties((Object)overchargeStrategyEo, (Object)dto, (String[])new String[0]);
        PageInfo pageInfoEo = ((IOverchargeStrategyDomain)this.domain).selectPage((BaseEo)overchargeStrategyEo, dto.getPageNum(), dto.getPageSize());
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)pageInfoEo, (String[])new String[]{"list"});
        if (Objects.isNull(pageInfoEo) || CollectionUtils.isEmpty((Collection)pageInfoEo.getList())) {
            return pageInfo;
        }
        List list = this.converter().toDtoList(pageInfoEo.getList());
        pageInfo.setList(list);
        List ids = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        List detailEos = ((ExtQueryChainWrapper)this.overchargeStrategyDetailDomain.filter().in((Object)"overcharge_strategy_id", ids)).list();
        if (CollectionUtils.isEmpty((Collection)detailEos)) {
            return pageInfo;
        }
        Map<Long, List<OverchargeStrategyDetailEo>> map = detailEos.stream().collect(Collectors.groupingBy(e -> e.getOverchargeStrategyId()));
        list.stream().forEach(e -> {
            List detailEoList = (List)map.get(e.getId());
            ArrayList overchargeStrategyDetailList = new ArrayList();
            CubeBeanUtils.copyCollection(overchargeStrategyDetailList, (Collection)detailEoList, OverchargeStrategyDetailDto.class);
            e.setOverchargeStrategyDetailList(overchargeStrategyDetailList);
        });
        return pageInfo;
    }

    private void checkParam(List<OverchargeStrategyDto> dtos) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(dtos), (String)"\u6279\u91cf\u65b0\u589e\u8d85\u6536\u7b56\u7565\u6570\u636e\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dtos.forEach(dto -> {
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getOrderType()), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            OverchargeStrategyOrderTypeEnum overchargeStrategyOrderTypeEnum = OverchargeStrategyOrderTypeEnum.getByCode((String)dto.getOrderType());
            AssertUtils.isTrue((boolean)Objects.nonNull(overchargeStrategyOrderTypeEnum), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
            if (overchargeStrategyOrderTypeEnum.getOverchargeRatio().booleanValue()) {
                AssertUtils.isTrue((boolean)Objects.nonNull(dto.getDefaultOverchargeRatio()), (String)"\u9ed8\u8ba4\u8d85\u6536\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.isTrue((boolean)Objects.nonNull(dto.getPriorityOverchargeRatioFlag()), (String)"\u662f\u5426\u8bbe\u7f6e\u4f18\u5148\u8d85\u6536\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
            } else {
                AssertUtils.isTrue((boolean)Objects.nonNull(dto.getReceiveWarehouseOverchargeFlag()), (String)"\u6536\u8d27\u4ed3\u662f\u5426\u5141\u8bb8\u8d85\u6536\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
    }
}

