/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.inventory.convert.entity.RelPhysicsWarehouseStorageConditionConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelPhysicsWarehouseStorageConditionDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.RelPhysicsWarehouseStorageConditionDto;
import com.yunxi.dg.base.center.inventory.eo.RelPhysicsWarehouseStorageConditionEo;
import com.yunxi.dg.base.center.inventory.service.entity.IRelPhysicsWarehouseStorageConditionService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RelPhysicsWarehouseStorageConditionServiceImpl
extends BaseServiceImpl<RelPhysicsWarehouseStorageConditionDto, RelPhysicsWarehouseStorageConditionEo, IRelPhysicsWarehouseStorageConditionDomain>
implements IRelPhysicsWarehouseStorageConditionService {
    private static final Logger log = LoggerFactory.getLogger(RelPhysicsWarehouseStorageConditionServiceImpl.class);

    public RelPhysicsWarehouseStorageConditionServiceImpl(IRelPhysicsWarehouseStorageConditionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<RelPhysicsWarehouseStorageConditionDto, RelPhysicsWarehouseStorageConditionEo> converter() {
        return RelPhysicsWarehouseStorageConditionConverter.INSTANCE;
    }

    @Override
    public void batchInsert(List<RelPhysicsWarehouseStorageConditionDto> addReqDtoList) {
        log.info("\u6279\u91cf\u63d2\u5165\u7269\u7406\u4ed3\u5e93\u5173\u8054\u5b58\u50a8\u6761\u4ef6\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString(addReqDtoList));
        if (CollectionUtils.isEmpty(addReqDtoList)) {
            return;
        }
        List<RelPhysicsWarehouseStorageConditionEo> physicsWarehouseStorageConditionEos = this.validParams(addReqDtoList);
        List physicsWarehouseCodes = physicsWarehouseStorageConditionEos.stream().map(e -> e.getPhysicsWarehouseCode()).distinct().collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"physics_warehouse_code", physicsWarehouseCodes);
        ((IRelPhysicsWarehouseStorageConditionDomain)this.domain).getMapper().delete((Wrapper)queryWrapper);
        ((IRelPhysicsWarehouseStorageConditionDomain)this.domain).insertBatch(physicsWarehouseStorageConditionEos);
    }

    private List<RelPhysicsWarehouseStorageConditionEo> validParams(List<RelPhysicsWarehouseStorageConditionDto> addReqDtoList) {
        ArrayList<RelPhysicsWarehouseStorageConditionEo> physicsWarehouseStorageConditionEos = new ArrayList<RelPhysicsWarehouseStorageConditionEo>();
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(addReqDtoList), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        for (RelPhysicsWarehouseStorageConditionDto relPhysicsWarehouseStorageConditionDto : addReqDtoList) {
            AssertUtils.isTrue((boolean)Objects.nonNull(relPhysicsWarehouseStorageConditionDto), (String)"\u5165\u53c2dto\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)relPhysicsWarehouseStorageConditionDto.getStorageConditionCode()), (String)"\u5b58\u50a8\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.isTrue((boolean)StringUtils.isNotBlank((CharSequence)relPhysicsWarehouseStorageConditionDto.getPhysicsWarehouseCode()), (String)"\u7269\u7406\u4ed3\u5e93\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            RelPhysicsWarehouseStorageConditionEo eo = new RelPhysicsWarehouseStorageConditionEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)relPhysicsWarehouseStorageConditionDto, (String[])new String[0]);
            physicsWarehouseStorageConditionEos.add(eo);
        }
        return physicsWarehouseStorageConditionEos;
    }
}

