/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.helper.data;

import cn.hutool.core.bean.BeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.service.helper.data.AbstractDataQueryHelper;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class ItemDataQueryHelperImpl
extends AbstractDataQueryHelper<ItemSkuDto> {
    final IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    public ItemDataQueryHelperImpl(IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy) {
        this.itemSkuDgQueryApiProxy = itemSkuDgQueryApiProxy;
    }

    @Override
    String getCacheKey() {
        return "item:sku";
    }

    @Override
    String getKey(ItemSkuDto itemSkuDto) {
        return itemSkuDto.getSkuCode();
    }

    @Override
    Class<ItemSkuDto> getType() {
        return ItemSkuDto.class;
    }

    @Override
    List<ItemSkuDto> getDataBaseData(List<String> codes) {
        Map itemSkuDgRespDtoMap = this.itemSkuDgQueryApiProxy.queryBySkuCode((List)Lists.newArrayList(codes)).stream().map(skuDgRespDto -> {
            ItemSkuDto itemSkuDto = (ItemSkuDto)BeanUtil.copyProperties((Object)skuDgRespDto, ItemSkuDto.class, (String[])new String[0]);
            itemSkuDto.setSkuCode(skuDgRespDto.getCode());
            itemSkuDto.setSkuName(skuDgRespDto.getName());
            itemSkuDto.setVolume(skuDgRespDto.getVolume());
            itemSkuDto.setWeight(skuDgRespDto.getGrossWeight());
            itemSkuDto.setSkuDisplayName((String)DataExtractUtils.ifNullElse((Object)itemSkuDto.getSkuDisplayName(), (Object)skuDgRespDto.getDisplayName()));
            return itemSkuDto;
        }).collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity(), (o, o1) -> o));
        return codes.stream().map(r -> {
            ItemSkuDto skuDgRespDto = new ItemSkuDto();
            skuDgRespDto.setSkuName(r);
            skuDgRespDto.setSkuCode(r);
            if (itemSkuDgRespDtoMap.containsKey(r)) {
                ItemSkuDto itemSkuDgRespDto = (ItemSkuDto)itemSkuDgRespDtoMap.get(r);
                BeanUtil.copyProperties((Object)itemSkuDgRespDto, (Object)skuDgRespDto, (String[])new String[0]);
            }
            return skuDgRespDto;
        }).collect(Collectors.toList());
    }
}

