/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.listener;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.data.DataDictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.ProcessLabelReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.AssembleDisassembleResultGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeLogisticsGenEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BatchUpdateEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.InspectionPassSuccessEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.OverchargeDifferenceEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushOrderWmsEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushStatusPostbackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.AssembleDisassembleOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.entity.ILabelExpiryStrategyService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IHoldStrategyConfigService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Order
@Component
public class InventoryEventListener {
    private static final Logger log = LoggerFactory.getLogger(InventoryEventListener.class);
    @Resource
    private ICommonsMqService mqService;
    @Resource
    IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    IHoldStrategyConfigService holdStrategyConfigService;
    @Resource
    private ILabelExpiryStrategyService iLabelExpiryStrategyService;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private BaseOrderFacade baseOrderFacade;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BatchUpdateEvent.class})
    public void handlePush(BatchUpdateEvent batchUpdateEvent) {
        Object source = batchUpdateEvent.getSource();
        CompletableFuture.runAsync(() -> {
            List updateInventoryBatchEos = (List)source;
            List dataDictDtoList = Optional.ofNullable(this.pcpDictQueryApiProxy.generalBasicDataInfo(Arrays.asList("special_batch"))).orElse(new ArrayList());
            Set specialBatchSet = dataDictDtoList.stream().map(DataDictDto::getSubValue).collect(Collectors.toSet());
            List<ProcessLabelReqDto> processLabelReqDtoList = updateInventoryBatchEos.stream().filter(o -> !specialBatchSet.contains(o.getBatch())).map(r -> {
                ProcessLabelReqDto processLabelReqDto = new ProcessLabelReqDto();
                BeanUtil.copyProperties((Object)r, (Object)processLabelReqDto, (String[])new String[0]);
                processLabelReqDto.setInventoryBatchId(r.getId());
                return processLabelReqDto;
            }).collect(Collectors.toList());
            if (!InventoryConfig.isNoneBatch()) {
                this.iLabelExpiryStrategyService.process(processLabelReqDtoList);
            }
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={InspectionPassSuccessEvent.class}, fallbackExecution=true)
    public void inspectionPassSuccess(InspectionPassSuccessEvent event) {
        this.sendMq(event.getSource(), "inspectionPassSuccess");
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={PushOrderWmsEvent.class}, fallbackExecution=true)
    public void handlePushWms(PushOrderWmsEvent pushOrderWmsEvent) {
        InOutNoticeOrderContext source = (InOutNoticeOrderContext)pushOrderWmsEvent.getSource();
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u5f00\u59cb\uff0c\u5904\u7406\u5904\u7406wms\u63a8\u9001\u5904\u7406\u7684\u5355\u53f7:{}", (Object)source.getDocumentNo());
        boolean intercept = this.holdStrategyConfigService.doIntercept(source.getInOutNoticeOrderEo());
        if (intercept) {
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u7ed3\u675f\uff0c\u5904\u7406\u5904\u7406wms\u63a8\u9001\u5904\u7406\u7684\u5355\u53f7:{},\u7ed3\u679c:{}", (Object)source.getDocumentNo(), (Object)"\u5df2hold\u5355");
        } else {
            InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
            inOutNoticeOrderEo.setDocumentNo(source.getDocumentNo());
            inOutNoticeOrderEo.setId(source.getInOutNoticeOrderEo().getId());
            boolean b = InventoryConfig.getPushWms().pushWms(source);
            if (source.isAsynchronousWms()) {
                inOutNoticeOrderEo.setPushStatus(b ? CsOutNoticePushStatusEnum.PUSHING.getCode() : CsOutNoticePushStatusEnum.FAIL.getCode());
            } else {
                inOutNoticeOrderEo.setPushStatus(b ? CsOutNoticePushStatusEnum.SUCCESS.getCode() : CsOutNoticePushStatusEnum.FAIL.getCode());
            }
            this.inOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u6267\u884c\u7ed3\u675f\uff0c\u5904\u7406\u5904\u7406wms\u63a8\u9001\u5904\u7406\u7684\u5355\u53f7:{},\u7ed3\u679c:{}", (Object)source.getDocumentNo(), (Object)b);
        }
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={PushStatusPostbackEvent.class}, fallbackExecution=true)
    public void handlePushWms(PushStatusPostbackEvent pushStatusPostbackEvent) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u5916\u90e8\u901a\u77e5\u8ba2\u5355\u63a8\u9001\u72b6\u6001\u56de\u8c03");
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMPLETION, classes={OverchargeDifferenceEvent.class}, fallbackExecution=true)
    public void overchargeDifference(OverchargeDifferenceEvent overchargeDifferenceEvent) {
        log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\u5b8c\u6210\uff0c\u5904\u7406\u8d85\u6536\u3001\u8d85\u53d1");
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={AssembleDisassembleResultGenEvent.class}, fallbackExecution=true)
    public void assembleDisassembleResultGenEvent(AssembleDisassembleResultGenEvent assembleDisassembleResultGenEvent) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u903b\u8f91\u751f\u6210\u901a\u77e5\u5355");
        InventoryConfig.executorNewTransaction(r -> {
            AssembleDisassembleOrderFacadeBo assembleDisassembleOrderFacadeBo = assembleDisassembleResultGenEvent.getAssembleDisassembleOrderFacadeBo();
            this.baseOrderFacade.receiveNoticeOrderGen(assembleDisassembleOrderFacadeBo);
            return r;
        });
    }

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeLogisticsGenEvent.class})
    public void outNoticeLogisticsGenEvent(BaseOrderOutNoticeLogisticsGenEvent event) {
        log.info("\u51fa\u5e93\u901a\u77e5\u5355\u53d6\u53f7\u6210\u529f\u4e8b\u4ef6:{}", event.getSource());
    }

    private void sendMq(Object object, String tag) {
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSONObject.toJSONString((Object)object));
        this.mqService.publishMessage(tag, (Object)messageVo);
    }
}

