/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.pda.listener;

import cn.hutool.json.JSONUtil;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.BaseOrderOutNoticeGenEvent;
import com.yunxi.dg.base.center.inventory.service.pda.IDeliveryLogisticsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalEventListener;

@Component
@Order(value=1)
public class BaseOrderEventPdaListener {
    private static final Logger log = LoggerFactory.getLogger(BaseOrderEventPdaListener.class);
    @Autowired
    IDeliveryLogisticsService deliveryLogisticsService;

    @TransactionalEventListener(phase=TransactionPhase.AFTER_COMMIT, classes={BaseOrderOutNoticeGenEvent.class}, fallbackExecution=true)
    public void outNoticeGenEvent(BaseOrderOutNoticeGenEvent event) {
        event.execute(e -> {
            try {
                InventoryConfig.executorNewTransaction(s -> {
                    this.deliveryLogisticsService.matchAndCreateShipOrder((InOutNoticeOrderContext)e);
                    return s;
                });
            }
            catch (Exception ex) {
                log.info("\u81ea\u52a8\u83b7\u53d6\u8fd0\u5355\u5f02\u5e38:{},{}", (Object)ex.getMessage(), (Object)JSONUtil.toJsonStr((Object)e));
            }
        });
    }
}

