/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.statemachine;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.mapper.StateMachineMapper;
import com.yunxi.dg.base.center.inventory.eo.StateMachineEo;
import com.yunxi.dg.base.center.inventory.statemachine.IStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachineContext;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.StateMachinePersister;
import org.springframework.statemachine.support.DefaultStateMachineContext;

public abstract class AbstractStatemachineExecutor<ENTITY extends BaseEo, EVENT extends Enum, STATE extends Enum>
implements IStatemachineExecutor<ENTITY, EVENT>,
StateMachinePersist<STATE, EVENT, ENTITY> {
    private static final Logger log = LoggerFactory.getLogger(AbstractStatemachineExecutor.class);
    @Resource
    private StateMachineMapper stateMachineMapper;
    @Resource
    private ILockService lockService;
    public static final String STATE_MACHINE_EXECUTOR = "STATEMACHINE:EXECUTOR:";
    public static final String FLAG = "1";

    @Override
    public boolean execute(EVENT event, StatemachineExecutorBo<ENTITY> executorBo) {
        Mutex finalLock;
        boolean bl;
        AssertUtils.isTrue((boolean)Objects.nonNull(executorBo), (String)"\u6267\u884c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        String stateMachineKey = this.getStateMachineKey((BaseEo)executorBo.getEo());
        String key = STATE_MACHINE_EXECUTOR + stateMachineKey;
        int i = 60;
        StateMachine stateMachine = this.getStateMachineFactory().getStateMachine(stateMachineKey);
        Mutex lock = null;
        try {
            lock = this.lockService.lock(key, FLAG, i, i * 2, TimeUnit.SECONDS);
            stateMachine.addStateListener((StateMachineListener)new MyExceptionStateMachineListener());
            stateMachine.start();
            this.getStateMachinePersister().restore(stateMachine, executorBo.getEo());
            Optional.ofNullable(executorBo.getVariables()).ifPresent(var -> var.forEach((k, v) -> Optional.ofNullable(v).ifPresent(val -> stateMachine.getExtendedState().getVariables().put(k, v))));
            stateMachine.getExtendedState().getVariables().put("executorBo", executorBo);
            boolean b = stateMachine.sendEvent(event);
            if (!b || stateMachine.hasStateMachineError()) {
                if (!b && StringUtils.isBlank((CharSequence)executorBo.getErrorMsg())) {
                    executorBo.setErrorMsg(String.format("\u5f53\u524d%s\u72b6\u6001,\u65e0\u6cd5\u64cd\u4f5c:%s\u4e8b\u4ef6", this.loadCurState(null, (BaseEo)executorBo.getEo()), ((Enum)event).name()));
                }
                throw new BizException(executorBo.getErrorMsg());
            }
            this.getStateMachinePersister().persist(stateMachine, executorBo.getEo());
            bl = true;
            finalLock = lock;
        }
        catch (Exception e) {
            try {
                log.error("\u72b6\u6001\u673a\u6267\u884c\u5f02\u5e38\uff1a", (Throwable)e);
                throw new BizException(e.getMessage());
            }
            catch (Throwable throwable) {
                Mutex finalLock2 = lock;
                InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
                stateMachine.stop();
                throw throwable;
            }
        }
        InventoryConfig.registerSynchronizationAfterCompletion(() -> this.lockService.unlock(finalLock2));
        stateMachine.stop();
        return bl;
    }

    public void write(StateMachineContext<STATE, EVENT> context, ENTITY eo) {
        StateMachineEo db = this.stateMachineMapper.selectByTypeAndMachineKey(this.getStatemachineType(), this.getStateMachineKey(eo));
        String stateMachineKey = this.getStateMachineKey(eo);
        StateMachineEo entity = new StateMachineEo();
        if (db == null) {
            entity.setMachineKey(stateMachineKey);
            entity.setStatus(((Enum)context.getState()).name());
            entity.setType(this.getStatemachineType());
            this.stateMachineMapper.insert((Object)entity);
        } else {
            entity.setId(db.getId());
            entity.setMachineKey(stateMachineKey);
            entity.setStatus(((Enum)context.getState()).name());
            entity.setType(this.getStatemachineType());
            this.stateMachineMapper.updateById((BaseEo)entity);
        }
    }

    public StateMachineContext<STATE, EVENT> read(ENTITY eo) {
        String stateMachineKey = this.getStateMachineKey(eo);
        StateMachineEo entity = this.stateMachineMapper.selectByTypeAndMachineKey(this.getStatemachineType(), stateMachineKey);
        STATE curState = this.loadCurState(entity, eo);
        return new DefaultStateMachineContext(curState, null, null, null, null, stateMachineKey);
    }

    protected abstract STATE loadCurState(StateMachineEo var1, ENTITY var2);

    protected abstract String getStateMachineKey(ENTITY var1);

    public abstract String getStatemachineType();

    public abstract StateMachineFactory<STATE, EVENT> getStateMachineFactory();

    public abstract StateMachinePersister<STATE, EVENT, ENTITY> getStateMachinePersister();

    public class MyExceptionStateMachineListener
    extends StateMachineListenerAdapter<STATE, EVENT> {
        public void stateMachineError(StateMachine<STATE, EVENT> stateMachine, Exception exception) {
            Optional.ofNullable(stateMachine.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class)).ifPresent(e -> e.setErrorMsg(exception.getMessage()));
        }
    }
}

