/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.OrderLineClassifyEnum;
import com.yunxi.dg.base.center.inventory.constants.WarehouseOrderLogisticsTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseOrderLogisticsDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseOrderLogisticsEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInOutResultOrderAble
implements InOutResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractInOutResultOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    protected IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    protected IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IWarehouseOrderLogisticsDomain iWarehouseOrderLogisticsDomain;
    @Resource
    protected IInOutNoticeOrderDomain inOutNoticeOrderDomain;

    @Override
    public void doGenerate(InOutResultOrderContext context) {
        log.info("\u751f\u6210\u5165\u51fa\u5e93\u7ed3\u679c\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        InOutResultOrderEo outResultOrderEo = this.getInOutResultOrderEo(context);
        List<InOutResultOrderDetailEo> detailEoList = this.getInOutResultOrderDetailEos(context, outResultOrderEo);
        WarehouseOrderLogisticsEo warehouseOrderLogisticsEo = this.getWarehouseOrderLogisticsEo(context);
        context.setInOutResultOrderEo(outResultOrderEo);
        context.setInOutResultOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        if (context.isWaitConfirm()) {
            outResultOrderEo.setOrderStatus(this.getWaitConfirmStatus());
        } else if (context.isHangup()) {
            outResultOrderEo.setOrderStatus(this.getHangUpStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)warehouseOrderLogisticsEo)) {
            this.iWarehouseOrderLogisticsDomain.insert((BaseEo)warehouseOrderLogisticsEo);
        }
        this.inOutResultOrderDomain.insert((BaseEo)context.getInOutResultOrderEo());
        this.inOutResultOrderDetailDomain.insertBatch(context.getInOutResultOrderDetailEoList());
        if (context.isWaitConfirm()) {
            return;
        }
        if (context.isHangup()) {
            return;
        }
        context.execAfter();
        this.wrapperGenerateAfter(context);
    }

    @NotNull
    private WarehouseOrderLogisticsEo getWarehouseOrderLogisticsEo(InOutResultOrderContext context) {
        WarehouseOrderLogisticsEo warehouseOrderLogisticsEo = new WarehouseOrderLogisticsEo();
        warehouseOrderLogisticsEo.setOutNoticeOrderNo(context.getDocumentNo());
        warehouseOrderLogisticsEo.setBusinessOrderNo(context.getRelevanceNo());
        warehouseOrderLogisticsEo.setType(WarehouseOrderLogisticsTypeEnum.result.getCode());
        Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
            CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
            warehouseOrderLogisticsEo.setShippingNo(csWmsShippingInfoReqDto.getShippingNo());
            warehouseOrderLogisticsEo.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
            warehouseOrderLogisticsEo.setShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
            warehouseOrderLogisticsEo.setShippingType(csWmsShippingInfoReqDto.getShippingType());
            warehouseOrderLogisticsEo.setWmsOrderNo(csWmsShippingInfoReqDto.getWmsOrderNo());
            warehouseOrderLogisticsEo.setConsignmentNo(csWmsShippingInfoReqDto.getConsignNo());
            warehouseOrderLogisticsEo.setBody(JSON.toJSONString((Object)shippingInfoReqDtoList));
        });
        return warehouseOrderLogisticsEo;
    }

    protected abstract String getHangUpStatus();

    protected abstract String getWaitConfirmStatus();

    protected abstract void wrapperGenerate(InOutResultOrderContext var1);

    protected abstract void wrapperGenerateAfter(InOutResultOrderContext var1);

    private InOutResultOrderEo getInOutResultOrderEo(InOutResultOrderContext context) {
        InOutResultOrderEo outResultOrderEo = Optional.ofNullable(context.getInOutResultOrderEo()).orElse(new InOutResultOrderEo());
        context.setDocumentNo(this.getDocumentNo(context));
        BeanUtil.copyProperties((Object)context, (Object)outResultOrderEo, (CopyOptions)CopyOptions.create().ignoreNullValue().setIgnoreProperties(new String[]{"wmsOrderNo"}));
        if (StringUtils.isNotBlank((CharSequence)context.getWmsOrderNo())) {
            outResultOrderEo.setWmsOrderNo(context.getWmsOrderNo());
        }
        outResultOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        outResultOrderEo.setInOutTime((Date)ObjectUtil.defaultIfNull((Object)context.getInOutTime(), (Object)new Date()));
        outResultOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        outResultOrderEo.setOrderType(context.getOperateTypeEnum().getCode().toLowerCase());
        outResultOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        outResultOrderEo.setRemark(context.getRemark());
        JSONObject eoJsonObject = Optional.ofNullable(outResultOrderEo.getExtension()).map(JSON::parseObject).orElseGet(JSONObject::new);
        JSONObject coJsonObject = Optional.ofNullable(context.getExtension()).map(JSON::parseObject).orElseGet(JSONObject::new);
        JSONObject jsonThree = new JSONObject();
        jsonThree.putAll((Map)eoJsonObject);
        jsonThree.putAll((Map)coJsonObject);
        outResultOrderEo.setExtension(jsonThree.toJSONString());
        BaseOrderExtensionHelper.settingExtensionByContext(context, outResultOrderEo);
        if (CollectionUtils.isNotEmpty(context.getShippingInfoReqDtoList())) {
            List consignNoList = context.getShippingInfoReqDtoList().stream().map(CsWmsShippingInfoReqDto::getConsignNo).filter(StringUtils::isNotBlank).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(consignNoList)) {
                String consignNo = String.join((CharSequence)",", consignNoList);
                outResultOrderEo.setConsignmentNo(consignNo);
            }
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> {
                CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = (CsWmsShippingInfoReqDto)shippingInfoReqDtoList.get(0);
                outResultOrderEo.setShippingCode(csWmsShippingInfoReqDto.getShippingNo());
                outResultOrderEo.setShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                outResultOrderEo.setShippingCompany(csWmsShippingInfoReqDto.getShippingCompanyName());
                outResultOrderEo.setShippingJson(JSON.toJSONString((Object)shippingInfoReqDtoList));
                outResultOrderEo.setShippingType(csWmsShippingInfoReqDto.getShippingType());
            });
        }
        return outResultOrderEo;
    }

    private String getDocumentNo(InOutResultOrderContext context) {
        if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.OUT_RESULT_ORDER.getCode()));
        }
        if (BaseOrderOperateTypeEnum.IN_OUT.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.ADJUST_RESULT_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.IN_RESULT_ORDER.getCode()));
    }

    protected List<InOutResultOrderDetailEo> getInOutResultOrderDetailEos(InOutResultOrderContext context, InOutResultOrderEo outResultOrderEo) {
        List<BaseOrderDetailReqDto> reqDtoList = context.getOrderBasicsDetailReqDtoList();
        ArrayList<InOutResultOrderDetailEo> detailEoList = new ArrayList<InOutResultOrderDetailEo>(reqDtoList.size());
        for (BaseOrderDetailReqDto d : reqDtoList) {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            if (CollectionUtils.isNotEmpty(d.getSnCodes())) {
                detailEo.setSnCode(StringUtils.join(d.getSnCodes(), (String)","));
            }
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> detailEo.setShippingCode(StringUtils.join((Iterable)shippingInfoReqDtoList.stream().map(CsWmsShippingInfoReqDto::getShippingNo).collect(Collectors.toList()), (String)",")));
            detailEo.setSkuCode(d.getSkuCode());
            detailEo.setSkuName(d.getSkuName());
            detailEo.setLineNo(d.getLineNo());
            detailEo.setBatch(d.getBatch());
            detailEo.setDocumentNo(outResultOrderEo.getDocumentNo());
            detailEo.setPreOrderItemId(d.getPreOrderItemId());
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
            detailEo.setProduceTime(d.getProduceTime());
            detailEo.setExpireTime(d.getExpireTime());
            detailEo.setQuantity(d.getQuantity());
            detailEo.setExternalOrderNo(context.getExternalOrderNo());
            detailEo.setPreOrderNo(context.getPreOrderNo());
            detailEo.setRelevanceNo(context.getRelevanceNo());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            detailEo.setInventoryProperty(d.getInventoryProperty());
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)Optional.ofNullable(JSONObject.parseObject((String)d.getExtension(), BasicOrderDtoExtension.class)).orElse(new BasicOrderDtoExtension());
            basicOrderDtoExtension.setVolume(d.getVolume());
            basicOrderDtoExtension.setWeight(d.getWeight());
            detailEo.setExtension(JSONObject.toJSONString((Object)basicOrderDtoExtension));
            detailEo.setDispatcherQuantity(d.getDispatcherQuantity());
            detailEo.setDispatcherStatus(d.getDispatcherStatus());
            detailEo.setPackType(d.getPackType());
            detailEo.setOrderLineClassify(d.getOrderLineClassify());
            detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setWmsLineId(d.getWmsLineId());
            detailEoList.add(detailEo);
        }
        return detailEoList;
    }

    @Override
    public void close(InOutResultOrderContext context) {
    }

    @Override
    public void hangUp(InOutResultOrderContext inOutResultOrderContext) {
    }

    protected abstract String getCompleteStatus();

    @Override
    public void unhook(InOutResultOrderContext inOutResultOrderContext) {
        this.doComplete(inOutResultOrderContext);
        this.unhookAfter(inOutResultOrderContext);
    }

    @Override
    public void confirm(InOutResultOrderContext inOutResultOrderContext) {
        this.doComplete(inOutResultOrderContext);
        this.confirmAfter(inOutResultOrderContext);
    }

    private void doComplete(InOutResultOrderContext inOutResultOrderContext) {
        InOutResultOrderEo inOutResultOrderEo = inOutResultOrderContext.getInOutResultOrderEo();
        this.setUnhookWarehouse(inOutResultOrderContext);
        List<InOutResultOrderDetailEo> inOutResultOrderEoList = inOutResultOrderContext.getInOutResultOrderDetailEoList();
        if (CollectionUtils.isNotEmpty(inOutResultOrderContext.getOrderBasicsDetailReqDtoList())) {
            Map<Long, BigDecimal> planQuantityMap = inOutResultOrderEoList.stream().collect(Collectors.toMap(BaseEo::getId, InOutResultOrderDetailEo::getPlanQuantity));
            List updateList = inOutResultOrderContext.getOrderBasicsDetailReqDtoList().stream().map(r -> {
                InOutResultOrderDetailEo inOutResultOrderDetailEo = new InOutResultOrderDetailEo();
                inOutResultOrderDetailEo.setId(r.getRelateId());
                BigDecimal decimal = (BigDecimal)planQuantityMap.get(r.getRelateId());
                AssertUtils.isTrue((boolean)Objects.nonNull(decimal), (String)("id\u5f02\u5e38:" + r.getRelateId()));
                inOutResultOrderDetailEo.setWaitQuantity(BigDecimal.ZERO);
                inOutResultOrderDetailEo.setDoneQuantity(r.getQuantity());
                return inOutResultOrderDetailEo;
            }).collect(Collectors.toList());
            this.inOutResultOrderDetailDomain.getMapper().updateBatchByIds(updateList);
        }
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(inOutResultOrderEo.getId());
        updateEo.setOrderStatus(this.getCompleteStatus());
        updateEo.setTotalQuantity((BigDecimal)Optional.ofNullable(inOutResultOrderContext.getOrderBasicsDetailReqDtoList()).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().map(OrderUnitConverterDto::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(null));
        updateEo.setTotalVolume(inOutResultOrderEo.getTotalVolume());
        updateEo.setTotalWeight(inOutResultOrderEo.getTotalWeight());
        updateEo.setRemark(inOutResultOrderContext.getRemark());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)updateEo);
    }

    protected abstract void setUnhookWarehouse(InOutResultOrderContext var1);

    protected abstract void unhookAfter(InOutResultOrderContext var1);

    protected abstract void confirmAfter(InOutResultOrderContext var1);

    public CalcDetailDto getCalcDetailDto(InOutResultOrderContext context, InOutResultOrderDetailEo detail) {
        CalcDetailDto detailDto = new CalcDetailDto();
        detailDto.setBatch(detail.getBatch());
        detailDto.setInventoryProperty(detail.getInventoryProperty());
        detailDto.setExpireDate(detail.getExpireTime());
        detailDto.setLineNo(detail.getLineNo());
        detailDto.setPreOrderItemId(detail.getPreOrderItemId());
        detailDto.setLogicWarehouseCode(context.getLogicWarehouseCode());
        detailDto.setProduceDate(detail.getProduceTime());
        detailDto.setSkuCode(detail.getSkuCode());
        detailDto.setNum(detail.getDoneQuantity());
        detailDto.setNeedFindBatch(!OrderLineClassifyEnum.PACKAGING_MATERIALS.getCode().equals(detail.getOrderLineClassify()));
        return detailDto;
    }

    @Override
    public boolean validCancel(InOutResultOrderContext context) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)context.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        InOutResultOrderEo inOutResultOrderEo = (InOutResultOrderEo)this.inOutResultOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue((null != inOutResultOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f");
        context.setInOutResultOrderEo(inOutResultOrderEo);
        context.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutResultOrderEo.getRelevanceTableName()));
        return false;
    }

    protected void wrapper(InOutResultOrderContext context, CalcDto transferInDto) {
        context.wrapperInventoryOd(transferInDto);
        ArrayList detailDtos = new ArrayList(context.getInOutResultOrderDetailEoList().stream().filter(e -> BigDecimalUtils.eqZero((BigDecimal)e.getDoneQuantity()) == false).map(detail -> this.getCalcDetailDto(context, (InOutResultOrderDetailEo)detail)).collect(Collectors.toMap(r -> r.getLineNo() + InventoryConfig.getCommonSeparate() + r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch() + InventoryConfig.getCommonSeparate() + r.getInventoryProperty(), Function.identity(), (o, o1) -> {
            o.setNum(BigDecimalUtils.add((BigDecimal)o.getNum(), (BigDecimal)o1.getNum()));
            return o;
        })).values());
        transferInDto.setDetails(detailDtos);
        log.info("\u5165\u5e93\u4e4b\u524d\u5305\u88c5\u4e00\u5c42\u8be6\u7ec6\u4fe1\u606fwrapper-->{}", (Object)JSONObject.toJSONString(detailDtos));
    }

    public void updateStatus(InOutResultOrderEo inOutResultOrderEo, BaseOrderStatusEnum status) {
        InOutResultOrderEo updateEo = new InOutResultOrderEo();
        updateEo.setId(inOutResultOrderEo.getId());
        updateEo.setOrderStatus(status.getCode());
        this.inOutResultOrderDomain.getMapper().updateById((BaseEo)updateEo);
    }
}

