/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.abstracts;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.ReceiveDeliveryResultOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.helper.BaseOrderExtensionHelper;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.codegenerate.GenerateCodeUtil;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReceiveDeliveryResultOrderAble
implements ReceiveDeliveryResultOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AbstractReceiveDeliveryResultOrderAble.class);
    @Resource
    GenerateCodeUtil generateCodeUtil;
    @Resource
    IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Resource
    IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;

    @Override
    public void doGenerate(ReceiveDeliveryResultOrderContext context) {
        log.info("\u751f\u6210\u6536\u53d1\u8d27\u7ed3\u679c\u5355,\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)context));
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = this.getReceiveDeliveryResultOrderEo(context);
        List<ReceiveDeliveryResultOrderDetailEo> detailEoList = this.getDeliveryResultOrderDetailEos(context, csDeliveryResultOrderEo);
        context.setReceiveDeliveryResultOrderEo(csDeliveryResultOrderEo);
        context.setReceiveDeliveryResultOrderDetailEoList(detailEoList);
        this.wrapperGenerate(context);
        context.execBefore();
        this.receiveDeliveryResultOrderDomain.insert((BaseEo)context.getReceiveDeliveryResultOrderEo());
        this.receiveDeliveryResultOrderDetailDomain.insertBatch(context.getReceiveDeliveryResultOrderDetailEoList());
        context.execAfter();
        this.wrapperGenerateAfter(context);
    }

    protected abstract void wrapperGenerate(ReceiveDeliveryResultOrderContext var1);

    protected abstract void wrapperGenerateAfter(ReceiveDeliveryResultOrderContext var1);

    private List<ReceiveDeliveryResultOrderDetailEo> getDeliveryResultOrderDetailEos(ReceiveDeliveryResultOrderContext context, ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo) {
        return context.getOrderBasicsDetailReqDtoList().stream().map(d -> {
            ReceiveDeliveryResultOrderDetailEo detailEo = new ReceiveDeliveryResultOrderDetailEo();
            if (CollectionUtils.isNotEmpty(d.getSnCodes())) {
                detailEo.setSnCode(StringUtils.join(d.getSnCodes(), (String)","));
            }
            Optional.ofNullable(context.getShippingInfoReqDtoList()).filter(CollectionUtils::isNotEmpty).ifPresent(shippingInfoReqDtoList -> detailEo.setShippingCode(StringUtils.join((Iterable)shippingInfoReqDtoList.stream().map(CsWmsShippingInfoReqDto::getShippingNo).collect(Collectors.toList()), (String)",")));
            detailEo.setSkuCode(d.getSkuCode());
            detailEo.setSkuName(d.getSkuName());
            detailEo.setLineNo(d.getLineNo());
            detailEo.setBatch(d.getBatch());
            detailEo.setOrderLineClassify(d.getOrderLineClassify());
            detailEo.setInventoryProperty(d.getInventoryProperty());
            detailEo.setPlanQuantity(d.getQuantity());
            detailEo.setWaitQuantity(BigDecimal.ZERO);
            detailEo.setCancelQuantity(BigDecimal.ZERO);
            detailEo.setDoneQuantity(d.getQuantity());
            detailEo.setQuantity(d.getQuantity());
            detailEo.setExternalOrderNo(context.getExternalOrderNo());
            detailEo.setPreOrderNo(context.getPreOrderNo());
            detailEo.setRelevanceNo(context.getRelevanceNo());
            detailEo.setPreOrderItemId(d.getPreOrderItemId());
            detailEo.setDocumentNo(csDeliveryResultOrderEo.getDocumentNo());
            detailEo.setInitFlag(YesNoEnum.YES.getValue());
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)Optional.ofNullable(JSONObject.parseObject((String)d.getExtension(), BasicOrderDtoExtension.class)).orElse(new BasicOrderDtoExtension());
            basicOrderDtoExtension.setVolume(d.getVolume());
            basicOrderDtoExtension.setWeight(d.getWeight());
            detailEo.setExtension(JSONObject.toJSONString((Object)basicOrderDtoExtension));
            detailEo.setDispatcherQuantity(d.getDispatcherQuantity());
            detailEo.setDispatcherStatus(d.getDispatcherStatus());
            detailEo.setItemStatus(StringUtils.isNotBlank((CharSequence)d.getItemStatus()) ? d.getItemStatus() : CsPlannedOrderItemStatusEnum.COMMON.getCode());
            detailEo.setWmsLineId(d.getWmsLineId());
            detailEo.setApsNo(d.getApsNo());
            return detailEo;
        }).collect(Collectors.toList());
    }

    private ReceiveDeliveryResultOrderEo getReceiveDeliveryResultOrderEo(ReceiveDeliveryResultOrderContext context) {
        ReceiveDeliveryResultOrderEo csDeliveryResultOrderEo = Optional.ofNullable(context.getReceiveDeliveryResultOrderEo()).orElse(new ReceiveDeliveryResultOrderEo());
        context.setDocumentNo(this.getDocumentNo(context));
        CopyOptions copyOptions = CopyOptions.create().ignoreNullValue();
        copyOptions.setIgnoreProperties(new String[]{"inventoryProperty"});
        BeanUtil.copyProperties((Object)context, (Object)csDeliveryResultOrderEo, (CopyOptions)copyOptions);
        csDeliveryResultOrderEo.setId(null);
        csDeliveryResultOrderEo.setOrderStatus(context.getOrderStatus().getCode());
        csDeliveryResultOrderEo.setRelevanceTableName(context.getRelevanceTableName().getCode());
        csDeliveryResultOrderEo.setOrderType(context.getOperateTypeEnum().getCode().toLowerCase(Locale.ROOT));
        csDeliveryResultOrderEo.setTotalQuantity(context.getTotalQuantity() == null ? BigDecimal.ZERO : context.getTotalQuantity());
        csDeliveryResultOrderEo.setRemark(context.getRemark());
        BaseOrderExtensionHelper.settingExtensionByContext(context, csDeliveryResultOrderEo);
        return csDeliveryResultOrderEo;
    }

    private String getDocumentNo(ReceiveDeliveryResultOrderContext context) {
        if (BaseOrderOperateTypeEnum.RECEIVE.equals((Object)context.getOperateTypeEnum())) {
            return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.RECEIVE_RESULT_ORDER.getCode()));
        }
        return this.generateCodeUtil.generateCode(InventoryConfig.getCodeGenByCode(CodeGenEnum.DELIVERY_RESULT_ORDER.getCode()));
    }

    @Override
    public boolean validCancel(ReceiveDeliveryResultOrderContext context) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"document_no", (Object)context.getDocumentNo());
        queryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        ReceiveDeliveryResultOrderEo receiveDeliveryResultOrderEo = (ReceiveDeliveryResultOrderEo)this.receiveDeliveryResultOrderDomain.getMapper().selectOne((Wrapper)queryWrapper);
        AssertUtil.isTrue((null != receiveDeliveryResultOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u6536\u53d1\u8d27\u7ed3\u679c\u5355\u4fe1\u606f");
        context.setReceiveDeliveryResultOrderEo(receiveDeliveryResultOrderEo);
        return false;
    }

    @Override
    public void close(ReceiveDeliveryResultOrderContext context) {
    }
}

