/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.baseorder.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.abstracts.AbstractInOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AssemblyDisassemblyNoticeOrderAbleImpl
extends AbstractInOutNoticeOrderAble {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyNoticeOrderAbleImpl.class);

    @Override
    protected void wrapperGenerate(InOutNoticeOrderContext context) {
    }

    @Override
    protected void wrapperGenerateAfter(InOutNoticeOrderContext context) {
    }

    @Override
    public void complete(InOutNoticeOrderContext inOutNoticeOrderContext) {
        InOutNoticeOrderContext context = new InOutNoticeOrderContext();
        CubeBeanUtils.copyProperties((Object)context, (Object)inOutNoticeOrderContext, (String[])new String[0]);
        String relevanceNo = inOutNoticeOrderContext.getRelevanceNo();
        String orderType = BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).eq((Object)"order_type", (Object)orderType)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u7ec4\u88c5\u62c6\u5378\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        context.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        context.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        context.setNoticeEndModule(true);
        super.complete(context);
    }

    @Override
    protected String getCompleteStatus(InOutNoticeOrderContext inOutNoticeOrderContext) {
        return inOutNoticeOrderContext.isNoticeEnd() ? (inOutNoticeOrderContext.isNoticeEndStatus() ? BaseOrderStatusEnum.FINISH_OVER.getCode() : BaseOrderStatusEnum.COMPLETED.getCode()) : BaseOrderStatusEnum.PORTION_PROCESSING.getCode();
    }

    @Override
    public boolean checkEnd(InOutNoticeOrderContext context, List<InOutNoticeOrderDetailEo> detailEoList) {
        String displayBusinessType = context.getInOutNoticeOrderEo().getDisplayBusinessType();
        int type = AssemblyDisassemblyOrderBizTypeEnum.getByName((String)displayBusinessType).getPackType();
        Map<String, BigDecimal> collect = detailEoList.stream().filter(x -> x.getPackType() == type).collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode, Collectors.mapping(r -> BigDecimalUtils.subtract((BigDecimal)r.getPlanQuantity(), (BigDecimal)r.getDoneQuantity()), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        return detailEoList.stream().noneMatch(r -> BigDecimalUtils.gtZero((BigDecimal)r.getWaitQuantity())) || context.isNoticeEndModule() && collect.values().stream().allMatch(BigDecimalUtils::eqZero);
    }

    @Override
    public void doCancel(InOutNoticeOrderContext context) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u901a\u77e5\u5355\u6267\u884c\u53d6\u6d88\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)context));
        super.doCancel(context);
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.ONO_CANCEL);
        this.updateDetailQuantity(context);
    }

    @Override
    public void doClose(InOutNoticeOrderContext context) {
        super.doClose(context);
        log.info("\u7ec4\u88c5\u62c6\u5378\u901a\u77e5\u5355\u6267\u884c\u5b8c\u7ed3\u903b\u8f91\uff1a{}", (Object)JSON.toJSONString((Object)context));
        InOutNoticeOrderEo inOutNoticeOrderEo = context.getInOutNoticeOrderEo();
        this.updateStatus(inOutNoticeOrderEo, BaseOrderStatusEnum.FINISH_OVER);
        this.updateDetailQuantity(context);
    }
}

