/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IAutomaticAuditPolicyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.AdjustmentOrderUpdateDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.business.adjust.IAdjustmentOrderService;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentInventoryContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.helper.InventoryCheckHelper;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.utils.ExtensionUtil;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineMap;
import com.yunxi.dg.base.center.inventory.statemachine.executor.AdjustmentOrderStatemachineExecutor;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.dto.old.ItemSkuDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.center.share.proxy.inventory.IDgVirtualInventoryApiProxy;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractAdjustmentOrder<T extends BaseDto, E extends BaseEo, D extends IBaseDomain<E>>
extends BaseServiceImpl<AdjustmentOrderDto, AdjustmentOrderEo, IAdjustmentOrderDomain>
implements IAdjustmentOrderService {
    private static final Logger log = LoggerFactory.getLogger(AbstractAdjustmentOrder.class);
    @Resource
    private IAdjustmentOrderDetailDomain adjustmentOrderDetailDomain;
    @Resource
    private AdjustmentOrderStatemachineExecutor adjustmentOrderStatemachineExecutor;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IItemSkuDgQueryApiProxy skuDgQueryApiProxy;
    @Resource
    protected IAutomaticAuditPolicyDomain automaticAuditPolicyDomain;
    @Resource
    private IDgVirtualInventoryApiProxy iDgVirtualInventoryApiProxy;
    @Resource
    private InventoryCheckHelper inventoryCheckHelper;

    public AbstractAdjustmentOrder(IAdjustmentOrderDomain iAdjustmentOrderDomain) {
        super((IBaseDomain)iAdjustmentOrderDomain);
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CREATED, orderCodeSpel="#adjustmentOrderDto.adjustmentNo", typeSpel="#adjustmentOrderDto.orderType")
    public Long addAdjustmentOrder(AdjustmentOrderDto adjustmentOrderDto) {
        log.info("\u8c03\u6574\u5355\u65b0\u589e\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)adjustmentOrderDto));
        this.paramCheck(adjustmentOrderDto);
        InventoryConfig.setCheckInventory(adjustmentOrderDto.getValidInventory());
        String adjustmentOrderNo = Optional.ofNullable(adjustmentOrderDto.getAdjustmentNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(this.genAdjustmentOrderNo());
        adjustmentOrderDto.setAdjustmentNo(adjustmentOrderNo);
        AdjustmentOrderEo adjustmentOrderEo = this.getAdjustmentOrderEo(adjustmentOrderDto);
        ((IAdjustmentOrderDomain)this.domain).insert((BaseEo)adjustmentOrderEo);
        List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos = this.getAdjustmentOrderDetailEos(adjustmentOrderDto);
        this.adjustmentOrderDetailDomain.insertBatch(adjustmentOrderDetailEos);
        if ("wms_batch_adjustment".equals(adjustmentOrderEo.getBusinessType())) {
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
            adjustmentOrderDto.setHasHangup(true);
        }
        if (adjustmentOrderDto.isAutoComplete()) {
            adjustmentOrderDto.setEvent(DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey());
        }
        if (DgAdjustmentInventoryOrderEventEnum.SUBMIT.getKey().equals(adjustmentOrderDto.getEvent()) || DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey().equals(adjustmentOrderDto.getEvent())) {
            if (!adjustmentOrderDto.isHasHangup()) {
                this.submitEvent(adjustmentOrderEo, adjustmentOrderDetailEos, adjustmentOrderDto.isAutoComplete());
                this.auditHandler(adjustmentOrderDto, adjustmentOrderEo);
                return adjustmentOrderEo.getId();
            }
            InventoryConfig.registerSynchronizationAfterCommit(() -> {
                if (adjustmentOrderDto.isHasHangup()) {
                    try {
                        InventoryConfig.executorNewTransaction(s -> {
                            this.submitEvent(adjustmentOrderEo, adjustmentOrderDetailEos, adjustmentOrderDto.isAutoComplete());
                            return s;
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        JSONObject jsonObject = ExtensionUtil.parseJson(adjustmentOrderEo.getExtension());
                        jsonObject.put("hangupMsg", (Object)e.getMessage());
                        adjustmentOrderEo.setExtension(jsonObject.toJSONString());
                        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, adjustmentOrderDetailEos, new StatemachineMap());
                        this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.HANGUP, statemachineExecutorBo);
                        return;
                    }
                }
                this.auditHandler(adjustmentOrderDto, adjustmentOrderEo);
            });
        }
        return adjustmentOrderEo.getId();
    }

    private void auditHandler(AdjustmentOrderDto adjustmentOrderDto, AdjustmentOrderEo adjustmentOrderEo) {
        boolean isAutoAudit;
        boolean bl = isAutoAudit = DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS.getKey().equals(adjustmentOrderDto.getEvent()) || this.automaticAuditPolicyDomain.isAutoAudit(adjustmentOrderDto.getOrderType().toLowerCase(), adjustmentOrderDto.getBusinessType());
        if (isAutoAudit) {
            AdjustmentOrderUpdateDto adjustmentOrderUpdateDto = new AdjustmentOrderUpdateDto();
            adjustmentOrderUpdateDto.setAdjustmentNo(adjustmentOrderEo.getAdjustmentNo());
            adjustmentOrderUpdateDto.setAuditResult(Integer.valueOf(1));
            adjustmentOrderUpdateDto.setAutoComplete(adjustmentOrderDto.isAutoComplete());
            adjustmentOrderUpdateDto.setAuditRemark((String)DataExtractUtils.ifNullElse((Object)adjustmentOrderDto.getAuditRemark(), (Object)"\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838"));
            ((AbstractAdjustmentOrder)SpringBeanUtil.getBean(this.getClass())).audit(adjustmentOrderUpdateDto);
        }
    }

    @Override
    public Integer addBatchAdjustmentOrder(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        return null;
    }

    @Override
    public Integer addAdjustmentOrderBatch(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        return null;
    }

    protected String genAdjustmentOrderNo() {
        return null;
    }

    @Override
    public AdjustmentOrderDto queryById(Long id) {
        AdjustmentOrderEo orderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        BeanUtil.copyProperties((Object)orderEo, (Object)adjustmentOrderDto, (String[])new String[0]);
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)orderEo.getAdjustmentNo())).list();
        List adjustmentOrderDetailDtos = BeanUtil.copyToList((Collection)orderDetailEos, AdjustmentOrderDetailDto.class);
        adjustmentOrderDto.setAdjustmentOrderDetailDtos(adjustmentOrderDetailDtos);
        return adjustmentOrderDto;
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.EDITED, orderCodeSpel="#adjustmentOrderDto.adjustmentNo", typeSpel="#adjustmentOrderDto.orderType")
    public void edit(AdjustmentOrderDto adjustmentOrderDto) {
        log.info("\u8c03\u6574\u5355\u7f16\u8f91\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)adjustmentOrderDto));
        this.paramCheck(adjustmentOrderDto);
        AdjustmentOrderEo adjustmentOrderEo = new AdjustmentOrderEo();
        BeanUtil.copyProperties((Object)adjustmentOrderDto, (Object)adjustmentOrderEo, (String[])new String[0]);
        ((IAdjustmentOrderDomain)this.domain).updateSelective((BaseEo)adjustmentOrderEo);
        List adjustmentOrderDetailEos = BeanUtil.copyToList((Collection)adjustmentOrderDto.getAdjustmentOrderDetailDtos(), AdjustmentOrderDetailEo.class);
        this.handleAdjustmentOrderDetail(adjustmentOrderDetailEos, adjustmentOrderEo.getAdjustmentNo());
        StatemachineMap contextMap = new StatemachineMap();
        contextMap.put(DgAdjustmentInventoryOrderEventEnum.EDIT.getKey(), adjustmentOrderDto.getEvent());
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, adjustmentOrderDetailEos, contextMap);
        boolean execute = this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.EDIT, statemachineExecutorBo);
        if (!execute) {
            log.error("\u7f16\u8f91\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u7f16\u8f91\u5931\u8d25");
        }
    }

    @Override
    public void submit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        boolean isAutoAudit;
        log.info("\u8c03\u6574\u5355\u63d0\u4ea4\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)adjustmentOrderUpdateDto));
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"adjustment_no", (Object)adjustmentOrderUpdateDto.getAdjustmentNo())).one();
        AssertUtil.isFalse((boolean)Objects.isNull(adjustmentOrderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentOrderUpdateDto.getAdjustmentNo())).list();
        this.submitEvent(adjustmentOrderEo, orderDetailEos, false);
        boolean bl = isAutoAudit = "wms_batch_adjustment".equals(adjustmentOrderEo.getBusinessType()) || this.automaticAuditPolicyDomain.isAutoAudit(adjustmentOrderEo.getOrderType().toLowerCase(), adjustmentOrderEo.getBusinessType());
        if (isAutoAudit) {
            adjustmentOrderUpdateDto.setAdjustmentNo(adjustmentOrderEo.getAdjustmentNo());
            adjustmentOrderUpdateDto.setAuditResult(Integer.valueOf(1));
            adjustmentOrderUpdateDto.setAuditRemark("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6838");
            ((AbstractAdjustmentOrder)SpringBeanUtil.getBean(this.getClass())).audit(adjustmentOrderUpdateDto);
        }
    }

    @Override
    public void audit(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        log.info("\u8c03\u6574\u5355\u5ba1\u6838\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)adjustmentOrderUpdateDto));
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"adjustment_no", (Object)adjustmentOrderUpdateDto.getAdjustmentNo())).one();
        this.auditCheck(adjustmentOrderEo, adjustmentOrderUpdateDto);
        adjustmentOrderEo.setAuditRemark(adjustmentOrderUpdateDto.getAuditRemark());
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentOrderUpdateDto.getAdjustmentNo())).list();
        this.auditEvent(adjustmentOrderEo, orderDetailEos, adjustmentOrderUpdateDto.getAuditResult(), adjustmentOrderUpdateDto.isAutoComplete());
        boolean isApproved = YesNoEnum.YES.getValue().equals(adjustmentOrderUpdateDto.getAuditResult());
        String remark = StrUtil.emptyToDefault((CharSequence)adjustmentOrderUpdateDto.getAuditRemark(), (String)"EMPTY");
        OptUtil.addOptLog((String)OperationLogTypeEnum.getAuditType((boolean)isApproved), (String)remark, (String)adjustmentOrderUpdateDto.getAdjustmentNo(), (String)adjustmentOrderEo.getOrderType());
    }

    @Override
    @OptLogContext(logType=OperationLogTypeEnum.CANCELED, orderCodeSpel="#adjustmentOrderUpdateDto.adjustmentNo", typeSpel="#adjustmentOrderUpdateDto.orderType")
    public void cancel(AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        JSONObject jsonObject;
        log.info("\u8c03\u6574\u5355\u53d6\u6d88\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)adjustmentOrderUpdateDto));
        AdjustmentOrderEo adjustmentOrderEo = StringUtils.isNotBlank((CharSequence)adjustmentOrderUpdateDto.getPreOrderNo()) ? (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"pre_order_no", (Object)adjustmentOrderUpdateDto.getPreOrderNo())).one() : (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"adjustment_no", (Object)adjustmentOrderUpdateDto.getAdjustmentNo())).one();
        AssertUtils.isFalse((boolean)Objects.isNull(adjustmentOrderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        adjustmentOrderUpdateDto.setOrderType(adjustmentOrderEo.getOrderType());
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentOrderEo.getAdjustmentNo())).list();
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, orderDetailEos, new StatemachineMap());
        String extension = statemachineExecutorBo.getEo().getExtension();
        if (StringUtils.isNotBlank((CharSequence)extension)) {
            jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("cancelReason", (Object)adjustmentOrderUpdateDto.getAuditRemark());
            extension = jsonObject.toJSONString();
        } else {
            jsonObject = new JSONObject();
            jsonObject.put("cancelReason", (Object)adjustmentOrderUpdateDto.getAuditRemark());
            extension = jsonObject.toJSONString();
        }
        statemachineExecutorBo.getEo().setExtension(extension);
        statemachineExecutorBo.setEo(statemachineExecutorBo.getEo());
        boolean execute = this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.CANCEL, statemachineExecutorBo);
        if (!execute) {
            log.error("\u53d6\u6d88\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u53d6\u6d88\u5931\u8d25");
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.CANCELED.name(), (String)"EMPTY", (String)adjustmentOrderEo.getAdjustmentNo(), (String)adjustmentOrderEo.getOrderType());
    }

    @Override
    public BatchOrderOperationMsgDto batchCancel(List<AdjustmentOrderUpdateDto> adjustmentOrderUpdateDtoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        adjustmentOrderUpdateDtoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.cancel((AdjustmentOrderUpdateDto)dto);
                resMsg.setMsg(dto.getAdjustmentNo());
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u53d6\u6d88\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getAdjustmentNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(adjustmentOrderUpdateDtoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    @Override
    public AdjustmentOrderDto queryByAdjustmentNo(String adjustmentNo) {
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"adjustment_no", (Object)adjustmentNo)).one();
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        BeanUtil.copyProperties((Object)adjustmentOrderEo, (Object)adjustmentOrderDto, (String[])new String[0]);
        return adjustmentOrderDto;
    }

    @Override
    public AdjustmentOrderDto queryByPreOrderNo(String preOrderNo) {
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"pre_order_no", (Object)preOrderNo)).one();
        if (adjustmentOrderEo == null) {
            return null;
        }
        AdjustmentOrderDto adjustmentOrderDto = new AdjustmentOrderDto();
        BeanUtil.copyProperties((Object)adjustmentOrderEo, (Object)adjustmentOrderDto, (String[])new String[0]);
        return adjustmentOrderDto;
    }

    @Override
    public List<AdjustmentOrderDetailDto> queryDetailByAdjustmentNo(String adjustmentNo) {
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentNo)).list();
        List adjustmentOrderDetailDtos = BeanUtil.copyToList((Collection)orderDetailEos, AdjustmentOrderDetailDto.class);
        OrderUnitConversionRecordDto orderUnitConversionRecordDto = new OrderUnitConversionRecordDto();
        orderUnitConversionRecordDto.setDocumentCode(adjustmentNo);
        PageInfo orderUnitConversionRecordDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.orderUnitConversionRecordService.page((BaseDto)orderUnitConversionRecordDto, 1, 10000));
        List unitConversionRecordDtos = Optional.ofNullable(orderUnitConversionRecordDtoPageInfo.getList()).orElse(new ArrayList());
        Map unitConversionRecordDtoMap = unitConversionRecordDtos.stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
        List<String> skuCodes = adjustmentOrderDetailDtos.stream().map(AdjustmentOrderDetailDto::getSkuCode).distinct().collect(Collectors.toList());
        Map<String, ItemSkuDgRespDto> itemSkuDgRespDtoMap = this.getItemSkuDgRespDto(skuCodes);
        adjustmentOrderDetailDtos.forEach(adjustmentOrderDetailDto -> {
            OrderUnitConversionRecordDto recordDto = Optional.ofNullable(unitConversionRecordDtoMap.get(this.getKey(adjustmentOrderDetailDto.getSkuCode(), adjustmentOrderDetailDto.getChangeQuantity(), adjustmentOrderDetailDto.getUnit()))).orElse(new OrderUnitConversionRecordDto());
            if (itemSkuDgRespDtoMap.containsKey(adjustmentOrderDetailDto.getSkuCode())) {
                ItemSkuDgRespDto itemSkuDgRespDto = (ItemSkuDgRespDto)itemSkuDgRespDtoMap.get(adjustmentOrderDetailDto.getSkuCode());
                adjustmentOrderDetailDto.setBarCode(Objects.nonNull(itemSkuDgRespDto) ? itemSkuDgRespDto.getBarCode() : null);
            }
            adjustmentOrderDetailDto.setUnitQuantity(recordDto.getToNum());
        });
        return adjustmentOrderDetailDtos;
    }

    public String getChageType(AdjustmentOrderDetailEo orderDetailEo) {
        return orderDetailEo.getChangeType();
    }

    private AdjustmentOrderEo getAdjustmentOrderEo(AdjustmentOrderDto adjustmentOrderDto) {
        LogicWarehouseEo logicWarehouseEo;
        AdjustmentOrderEo adjustmentOrderEo = new AdjustmentOrderEo();
        BeanUtil.copyProperties((Object)adjustmentOrderDto, (Object)adjustmentOrderEo, (String[])new String[0]);
        adjustmentOrderEo.setOrderStatus(DgAdjustmentInventoryOrderStatusEnum.WAIT_SUBMIT.getKey());
        adjustmentOrderEo.setPushWms(Integer.valueOf(null == adjustmentOrderDto.getPushWms() ? (InventoryConfig.getPushWms().canPushWms(PushWmsAble.CanPushWmsBo.builder().logicWarehouseCode(adjustmentOrderDto.getWarehouseCode()).businessType(adjustmentOrderDto.getBusinessType()).orderType(adjustmentOrderDto.getOrderType()).relevanceTableNameEnum(CsRelevanceTableNameEnum.IN_ADJUSTMENT_ORDER).inOut("adjust").relevanceNo(adjustmentOrderDto.getAdjustmentNo()).build()) ? 1 : 0) : adjustmentOrderDto.getPushWms()));
        adjustmentOrderEo.setPushSap(Integer.valueOf(null == adjustmentOrderDto.getPushSap() ? (InventoryConfig.getPushSapAble().canPush(PushAble.CanPushBo.builder().logicWarehouseCode(adjustmentOrderDto.getWarehouseCode()).build()) ? 1 : 0) : adjustmentOrderDto.getPushSap()));
        if (StringUtils.isBlank((CharSequence)adjustmentOrderDto.getWarehouseName()) || StringUtils.isBlank((CharSequence)adjustmentOrderDto.getPhysicsWarehouseName()) || StringUtils.isBlank((CharSequence)adjustmentOrderDto.getOrganizationName())) {
            logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)adjustmentOrderDto.getWarehouseCode())).last("limit 1")).one();
            adjustmentOrderEo.setWarehouseName(logicWarehouseEo.getWarehouseName());
            adjustmentOrderEo.setPhysicsWarehouseCode(logicWarehouseEo.getPhysicsWarehouseCode());
            adjustmentOrderEo.setPhysicsWarehouseName(logicWarehouseEo.getPhysicsWarehouseName());
            adjustmentOrderEo.setOrganizationCode(logicWarehouseEo.getOrganizationCode());
            adjustmentOrderEo.setOrganizationName(logicWarehouseEo.getOrganizationName());
        }
        if (StringUtils.isNotBlank((CharSequence)adjustmentOrderEo.getOrigWarehouseCode()) && StringUtils.isBlank((CharSequence)adjustmentOrderEo.getOrigWarehouseName())) {
            logicWarehouseEo = (LogicWarehouseEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.logicWarehouseDomain.filter().eq((Object)"warehouse_code", (Object)adjustmentOrderDto.getOrigWarehouseCode())).last("limit 1")).one();
            adjustmentOrderEo.setOrigWarehouseName(logicWarehouseEo.getWarehouseName());
        }
        return adjustmentOrderEo;
    }

    private List<AdjustmentOrderDetailEo> getAdjustmentOrderDetailEos(AdjustmentOrderDto adjustmentOrderDto) {
        List adjustmentOrderDetailDtos = adjustmentOrderDto.getAdjustmentOrderDetailDtos();
        this.checkExpireTime(adjustmentOrderDetailDtos);
        List adjustmentOrderDetailEos = BeanUtil.copyToList((Collection)adjustmentOrderDetailDtos, AdjustmentOrderDetailEo.class);
        adjustmentOrderDetailEos.forEach(orderDetailEo -> {
            orderDetailEo.setAdjustmentNo(adjustmentOrderDto.getAdjustmentNo());
            orderDetailEo.setChangeType(this.getChageType((AdjustmentOrderDetailEo)orderDetailEo));
            if ("wms_batch_adjustment".equals(adjustmentOrderDto.getBusinessType())) {
                orderDetailEo.setBatch((String)DataExtractUtils.ifNullElse((Object)orderDetailEo.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
                orderDetailEo.setOrigBatch((String)DataExtractUtils.ifNullElse((Object)orderDetailEo.getOrigBatch(), (Object)InventoryConfig.getDefaultBatch()));
            }
        });
        return adjustmentOrderDetailEos;
    }

    private void submitEvent(AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos, boolean autoComplete) {
        this.submitCheck(adjustmentOrderEo, adjustmentOrderDetailEos);
        StatemachineMap statemachineMap = new StatemachineMap();
        statemachineMap.put("autoComplete", autoComplete);
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, adjustmentOrderDetailEos, statemachineMap);
        boolean execute = this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.SUBMIT, statemachineExecutorBo);
        if (!execute) {
            log.error("\u63d0\u4ea4\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u63d0\u4ea4\u5931\u8d25");
        }
    }

    private void submitCheck(AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos) {
        if (InventoryConfig.isCanSupplyInventory()) {
            this.inventoryCheckHelper.inventoryCheck(adjustmentOrderDetailEos.stream().filter(r -> AdjustmentChangeTypeEnum.DECREASE.getCode().equals(r.getChangeType())).collect(Collectors.groupingBy(AdjustmentOrderDetailEo::getSkuCode, Collectors.mapping(AdjustmentOrderDetailEo::getChangeQuantity, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))), adjustmentOrderEo.getWarehouseCode(), adjustmentOrderEo.getSubWarehouseCode());
        }
    }

    private void auditEvent(AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> orderDetailEos, Integer auditResult, boolean autoComplete) {
        boolean execute;
        StatemachineMap statemachineMap = new StatemachineMap();
        statemachineMap.put("autoComplete", adjustmentOrderEo);
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, orderDetailEos, statemachineMap);
        DgAdjustmentInventoryOrderEventEnum audit = DgAdjustmentInventoryOrderEventEnum.AUDIT_FAIL;
        if (YesNoEnum.YES.getValue().equals(auditResult)) {
            audit = DgAdjustmentInventoryOrderEventEnum.AUDIT_SUCCESS;
        }
        if (!(execute = this.adjustmentOrderStatemachineExecutor.execute(audit, statemachineExecutorBo))) {
            log.error("\u5ba1\u6838\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new BizException("\u5ba1\u6838\u5931\u8d25");
        }
    }

    public void paramCheck(AdjustmentOrderDto adjustmentOrderDto) {
        adjustmentOrderDto.setValidInventory((Boolean)ObjectUtil.defaultIfNull((Object)adjustmentOrderDto.getValidInventory(), (Object)Boolean.TRUE));
    }

    private String getCurrentBatch(String orderType, AdjustmentOrderDetailEo detailEo) {
        String currentBatch = detailEo.getBatch();
        if (AdjustmentOrderTypeEnum.BATCH_ADJUSTMENT.getType().equals(orderType)) {
            currentBatch = detailEo.getOrigBatch();
        }
        return currentBatch;
    }

    private void auditCheck(AdjustmentOrderEo adjustmentOrderEo, AdjustmentOrderUpdateDto adjustmentOrderUpdateDto) {
        AssertUtils.isFalse((boolean)Objects.isNull(adjustmentOrderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        AssertUtils.isFalse((null == adjustmentOrderUpdateDto.getAuditResult() ? 1 : 0) != 0, (String)"\u5ba1\u6838\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private void handleAdjustmentOrderDetail(List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos, String adjustmentNo) {
        List orderDetailEos = Optional.ofNullable(adjustmentOrderDetailEos).orElse(new ArrayList());
        orderDetailEos.forEach(o -> {
            o.setId(null);
            o.setAdjustmentNo(adjustmentNo);
        });
        List detailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentNo)).list();
        if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
            List ids = detailEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.adjustmentOrderDetailDomain.logicDeleteByIds(ids);
        }
        this.adjustmentOrderDetailDomain.insertBatch(orderDetailEos);
    }

    private void unitProcess(String adjustmentOrderNo, List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        ArrayList unitConversionDetails = new ArrayList();
        adjustmentOrderDetailDtos.forEach(adjustmentOrderDetailDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(adjustmentOrderDetailDto.getUnit());
            unitConversionDetail.setSkuCode(adjustmentOrderDetailDto.getSkuCode());
            unitConversionDetail.setCurNum(adjustmentOrderDetailDto.getChangeQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(adjustmentOrderNo);
        orderUnitConversionReqDto.setType("adjustment");
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> conversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
    }

    private StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBoBuilder(AdjustmentOrderEo adjustmentOrderEo, List<AdjustmentOrderDetailEo> adjustmentOrderDetailEos, StatemachineMap contextMap) {
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = new StatemachineExecutorBo<AdjustmentOrderEo>();
        contextMap.put(AdjustmentInventoryContextEnum.ADJUSTMENT_INVENTORY_ORDER_DETAIL.getCode(), adjustmentOrderDetailEos);
        statemachineExecutorBo.setEo(adjustmentOrderEo);
        statemachineExecutorBo.setVariables(contextMap);
        return statemachineExecutorBo;
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }

    @Override
    public List<AdjustmentOrderDto> queryByExternalOrderNos(List<String> externalOrderNos) {
        List adjustmentOrderEos = ((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().in((Object)"external_order_no", externalOrderNos)).list();
        List adjustmentOrderDtos = this.converter().toDtoList(adjustmentOrderEos);
        return adjustmentOrderDtos;
    }

    private void checkExpireTime(List<AdjustmentOrderDetailDto> adjustmentOrderDetailDtos) {
        adjustmentOrderDetailDtos.forEach(o -> {
            if (Objects.nonNull(o.getProduceTime()) && Objects.nonNull(o.getExpireTime())) {
                AssertUtils.isFalse((boolean)o.getProduceTime().after(o.getExpireTime()), (String)("\u5546\u54c1" + o.getSkuCode() + "sku\u7684\u6279\u6b21" + o.getBatch() + "\u7684\u751f\u4ea7\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u8fc7\u671f\u65e5\u671f"));
            }
        });
    }

    @Override
    public void withdraw(String adjustmentNo) {
        log.info("\u8c03\u6574\u5355\u64a4\u56de\u5165\u53c2:{}", (Object)adjustmentNo);
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().eq((Object)"adjustment_no", (Object)adjustmentNo)).one();
        AssertUtil.isFalse((boolean)Objects.isNull(adjustmentOrderEo), (String)"\u5355\u636e\u4e0d\u5b58\u5728");
        List orderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentNo)).list();
        StatemachineExecutorBo<AdjustmentOrderEo> statemachineExecutorBo = this.statemachineExecutorBoBuilder(adjustmentOrderEo, orderDetailEos, new StatemachineMap());
        boolean execute = this.adjustmentOrderStatemachineExecutor.execute(DgAdjustmentInventoryOrderEventEnum.WITHDRAW, statemachineExecutorBo);
        if (!execute) {
            log.error("\u64a4\u56de\u5931\u8d25", (Object)Thread.currentThread().getName(), null);
            throw new RuntimeException("\u64a4\u56de\u5931\u8d25");
        }
    }

    @Override
    public BatchOrderOperationMsgDto batchWithdraw(List<String> adjustmentNoList) {
        ArrayList errorReasonList = Lists.newArrayList();
        AtomicInteger errorCount = new AtomicInteger();
        adjustmentNoList.forEach(dto -> {
            BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
            try {
                this.withdraw((String)dto);
                resMsg.setMsg(dto);
                resMsg.setReqStatus(Integer.valueOf(1));
                errorReasonList.add(resMsg);
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u64a4\u56de\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto, e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
                errorCount.getAndIncrement();
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorCount.intValue()));
        msgDto.setSuccCount(Integer.valueOf(adjustmentNoList.size() - errorCount.intValue()));
        msgDto.setResMsgList((List)errorReasonList);
        return msgDto;
    }

    private Map<String, ItemSkuDgRespDto> getItemSkuDgRespDto(List<String> skuCodes) {
        HashMap skuDgRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(skuCodes)) {
            List itemSkuDgRespDtos;
            int length;
            int i = 0;
            for (length = skuCodes.size(); length > 500; length -= 500) {
                itemSkuDgRespDtos = this.skuDgQueryApiProxy.queryBySkuCode(skuCodes.subList(i, i + 500));
                if (CollectionUtils.isNotEmpty((Collection)itemSkuDgRespDtos)) {
                    skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2)));
                }
                i += 500;
            }
            if (length > 0 && CollectionUtils.isNotEmpty((Collection)(itemSkuDgRespDtos = this.skuDgQueryApiProxy.queryBySkuCode(skuCodes.subList(i, i + length))))) {
                skuDgRespDtoMap.putAll(itemSkuDgRespDtos.stream().collect(Collectors.toMap(ItemSkuDgRespDto::getCode, Function.identity(), (k1, k2) -> k2)));
            }
        }
        return skuDgRespDtoMap;
    }

    @Override
    public Boolean updateRemarkById(Long id, String remark) {
        AssertUtils.isTrue((id != null ? 1 : 0) != 0, (String)"\u8c03\u6574\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        AdjustmentOrderEo adjustmentOrderEo = new AdjustmentOrderEo();
        adjustmentOrderEo.setId(id);
        adjustmentOrderEo.setRemark(remark);
        return ((IAdjustmentOrderDomain)this.domain).updateSelective((BaseEo)adjustmentOrderEo) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAdjustmentRemark(List<AdjustmentOrderDto> orderDtos) {
        log.info("\u66f4\u65b0\u8c03\u6574\u5355\u5907\u6ce8-U9\u5f62\u6001\u8f6c\u6362\u5355\u53f7\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(orderDtos));
        AssertUtils.notEmpty(orderDtos, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List adjustmentNos = orderDtos.stream().map(AdjustmentOrderDto::getAdjustmentNo).collect(Collectors.toList());
        List adjustmentOrderEos = ((ExtQueryChainWrapper)((IAdjustmentOrderDomain)this.domain).filter().in((Object)"adjustment_no", adjustmentNos)).list();
        if (CollectionUtils.isNotEmpty((Collection)adjustmentOrderEos)) {
            Map orderDtoMap = orderDtos.stream().collect(Collectors.toMap(AdjustmentOrderDto::getAdjustmentNo, Function.identity(), (k1, k2) -> k1));
            Map adjustmentOrderEoMap = adjustmentOrderEos.stream().collect(Collectors.toMap(AdjustmentOrderEo::getAdjustmentNo, Function.identity(), (k1, k2) -> k1));
            adjustmentOrderEoMap.forEach((k, v) -> {
                if (orderDtoMap.containsKey(k)) {
                    AdjustmentOrderDto adjustmentOrderDto = (AdjustmentOrderDto)orderDtoMap.get(k);
                    AdjustmentOrderEo adjustmentOrderEo = new AdjustmentOrderEo();
                    adjustmentOrderEo.setId(v.getId());
                    adjustmentOrderEo.setRemark(Objects.nonNull(adjustmentOrderDto) ? adjustmentOrderDto.getU9ConversionOrderNo() : null);
                    ((IAdjustmentOrderDomain)this.domain).updateSelective((BaseEo)adjustmentOrderEo);
                }
            });
        }
    }

    @Override
    public Integer addAdjustmentOrderBatchV2(List<AdjustmentOrderDto> adjustmentOrderDtos) {
        return null;
    }

    @Override
    public AdjustmentOrderDto queryByAdjustmentId(Long id) {
        return null;
    }

    @Override
    public List<AdjustmentOrderDto> addAdjustmentOrderBatchV3(List<AdjustmentOrderDto> reqDtoList) {
        return Collections.emptyList();
    }
}

