/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.action;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IAdjustmentOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.AdjustmentOrderEo;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentChangeTypeEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.AdjustmentInventoryContextEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.adjust.stateMachine.enums.DgAdjustmentInventoryOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AdjustmentInventoryReleasePreemptAction
extends AbstractAction<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AdjustmentInventoryReleasePreemptAction.class);
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private IAdjustmentOrderDetailDomain adjustmentOrderDetailDomain;

    @Override
    public void doExecute(StateContext<DgAdjustmentInventoryOrderStatusEnum, DgAdjustmentInventoryOrderEventEnum> context) {
        log.info("\u8fdb\u5165\u5e93\u5b58\u8c03\u6574\u5355\u91ca\u653e\u9884\u5360\u5e93\u5b58\u52a8\u4f5c");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        AdjustmentOrderEo adjustmentOrderEo = (AdjustmentOrderEo)executorBo.getEo();
        List adjustmentOrderDetailEos = Optional.ofNullable((List)executorBo.getVariables().get(AdjustmentInventoryContextEnum.ADJUSTMENT_INVENTORY_ORDER_DETAIL.getCode())).filter(CollectionUtils::isNotEmpty).orElseGet(() -> ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)adjustmentOrderEo.getAdjustmentNo())).list());
        ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
        releasePreemptDto.setSourceType(adjustmentOrderEo.getOrderType());
        releasePreemptDto.setSourceNo(adjustmentOrderEo.getAdjustmentNo());
        releasePreemptDto.setBusinessType(adjustmentOrderEo.getBusinessType());
        ArrayList<CalcDetailDto> calcDetailDtos = new ArrayList<CalcDetailDto>();
        for (AdjustmentOrderDetailEo orderDetailEo : adjustmentOrderDetailEos) {
            if (!AdjustmentChangeTypeEnum.DECREASE.getCode().equals(orderDetailEo.getChangeType())) continue;
            CalcDetailDto calcDetailDto = new CalcDetailDto();
            calcDetailDto.setLogicWarehouseCode(adjustmentOrderEo.getWarehouseCode());
            calcDetailDto.setBatch(orderDetailEo.getBatch());
            calcDetailDto.setNum(orderDetailEo.getChangeQuantity());
            calcDetailDto.setLineNo(orderDetailEo.getId());
            calcDetailDto.setSkuCode(orderDetailEo.getSkuCode());
            calcDetailDto.setInventoryProperty(orderDetailEo.getInventoryProperty());
            calcDetailDtos.add(calcDetailDto);
        }
        releasePreemptDto.setDetails(calcDetailDtos);
        if (CollectionUtils.isNotEmpty(calcDetailDtos)) {
            releasePreemptDto.setAllRelease(Boolean.valueOf(true));
            this.calcInventoryService.releasePreempt(releasePreemptDto);
        }
    }
}

