/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.action;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.enums.AssemblyDisassemblyOrderBizTypeEnum;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.CsInventorySourceTypeEnum;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.eo.AssemblyDisassemblyOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.OutNoticeOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.business.assemble.stateMachine.enums.AssemblyDisassemblyOrderStatusEventEnum;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderInventoryExe;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.statemachine.AbstractAction;
import com.yunxi.dg.base.center.inventory.statemachine.StatemachineExecutorBo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.statemachine.StateContext;
import org.springframework.stereotype.Component;

@Component
public class AssemblyDisassemblyCancelAction
extends AbstractAction<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> {
    private static final Logger log = LoggerFactory.getLogger(AssemblyDisassemblyCancelAction.class);
    @Resource
    protected TransferOrderInventoryExe transferOrderInventoryExe;
    @Resource
    protected BaseOrderFacade baseOrderFacade;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    protected OutNoticeOrderAbleImpl outNoticeOrderAble;
    @Resource
    protected IReceiveDeliveryNoticeOrderDomain iReceiveDeliveryNoticeOrderDomain;

    @Override
    protected void doExecute(StateContext<AssemblyDisassemblyOrderStatusEnum, AssemblyDisassemblyOrderStatusEventEnum> context) {
        log.info("\u7ec4\u88c5\u62c6\u5378\u5355\u6267\u884c\u53d6\u6d88\u52a8\u4f5c\u3002");
        StatemachineExecutorBo executorBo = (StatemachineExecutorBo)context.getExtendedState().get((Object)"executorBo", StatemachineExecutorBo.class);
        log.info("\u6253\u5370\uff1a{}", (Object)JSONObject.toJSONString((Object)executorBo));
        AssemblyDisassemblyOrderEo orderEo = (AssemblyDisassemblyOrderEo)executorBo.getEo();
        if (AssemblyDisassemblyOrderStatusEnum.isProcessing(orderEo.getOrderStatus())) {
            this.doReleaseOrder(orderEo.getOrderNo());
        } else if (!AssemblyDisassemblyOrderStatusEnum.AUDIT_FAIL.getKey().equals(orderEo.getOrderStatus())) {
            this.doReleaseInventory(orderEo.getOrderNo(), orderEo.getBizType());
        }
    }

    public void doReleaseOrder(String orderNo) {
        List receiveDeliveryNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iReceiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"dr", (Object)YesNoEnum.NO)).list();
        for (ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo : receiveDeliveryNoticeOrderEoList) {
            if (!"delivery".equals(receiveDeliveryNoticeOrderEo.getOrderType())) continue;
            BaseOrderCommonCancelBo commonCancelBo = BaseOrderCommonCancelBo.builder().documentNo(receiveDeliveryNoticeOrderEo.getDocumentNo()).sourceType(CsInventorySourceTypeEnum.OUT_OTHER_RELEASE.getCode()).build();
            this.baseOrderFacade.deliveryNoticeOrderCancel(commonCancelBo);
        }
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)orderNo)).eq((Object)"order_type", (Object)CodeGenEnum.ASSEMBLY_DISASSEMBLY.getCode())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.PROCESSING.getCode())).eq((Object)"dr", (Object)YesNoEnum.NO)).list();
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEos)) {
            log.info("\u67e5\u8be2\u4e0d\u5230\u7ec4\u88c5\u62c6\u5378\u901a\u77e5\u5355\uff01");
            return;
        }
        for (InOutNoticeOrderEo eo : inOutNoticeOrderEos) {
            InOutNoticeOrderContext context = new InOutNoticeOrderContext();
            context.setDocumentNo(eo.getDocumentNo());
            context.setInOutNoticeOrderEo(eo);
            context.setLogicWarehouseCode(eo.getOutLogicWarehouseCode());
            this.outNoticeOrderAble.doCancel(context);
        }
    }

    public void doReleaseInventory(String orderNo, Integer bizType) {
        this.transferOrderInventoryExe.release(orderNo, AssemblyDisassemblyOrderBizTypeEnum.getByType((Integer)bizType).name(), true);
    }
}

