/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.difforder.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsInventoryStrategyEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.DispatcherStatusEnum;
import com.yunxi.dg.base.center.enums.InventoryInOutEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.DocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryDueInDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.OrderCancelResponseDto;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsDisPatcherOrderEnum;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherHandleStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleaseIntransitDto;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.calc.base.CalcDetailDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderCloseReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.DispatcherOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.bussiness.difforder.DispatcherOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryDueInEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.proxy.data.IQimenInventoryApiProxy;
import com.yunxi.dg.base.center.inventory.service.annotatin.OptLogContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.PushWmsAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.impl.InResultOrderAbleImpl;
import com.yunxi.dg.base.center.inventory.service.business.difforder.IDispatcherOrderService;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DiffOrderOptContext;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatchOperateBo;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatcherOperateWayEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.commonsendback.CommonSendBackAble;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemDataQueryRespDto;
import com.yunxi.dg.base.center.message.OrderCancelQimenMessageReqDto;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DispatcherOrderServiceImpl
implements IDispatcherOrderService {
    private static final Logger log = LoggerFactory.getLogger(DispatcherOrderServiceImpl.class);
    @Resource
    private IDispatcherOrderDomain dispatcherOrderDomain;
    @Resource
    private IDispatcherOrderDetailDomain dispatcherOrderDetailDomain;
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private IContext context;
    @Autowired
    private ICalcInventoryService calcInventoryService;
    @Autowired
    private RepeatFilter repeatFilter;
    @Autowired
    BaseOrderFacade baseOrderFacade;
    @Autowired
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private CommonSendBackAble commonSendBackAble;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDomain iInOutNoticeOrderDomain;
    @Resource
    IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Autowired
    ILogicWarehouseDomain logicWarehouseDomain;
    @Autowired
    IQimenInventoryApiProxy qimenInventoryApiProxy;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    public IPhysicsWarehouseDomain physicsWarehouseDomain;
    @Resource
    public IInventoryDueInDomain inventoryDueInDomain;
    @Value(value="${inventory.dispatcher.split.module:0}")
    private Integer splitModule;

    @Override
    public Long addDispatcherOrder(DispatcherOrderReqDto addReqDto) {
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        this.dispatcherOrderDomain.insert((BaseEo)dispatcherOrderEo);
        return dispatcherOrderEo.getId();
    }

    @Override
    public void modifyDispatcherOrder(DispatcherOrderReqDto modifyReqDto) {
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        this.dispatcherOrderDomain.updateSelective((BaseEo)dispatcherOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void calculateDifferencesDispatcher(String transferOrderNo) {
        boolean flag;
        String key = "DISPATCHER_ORDER:" + transferOrderNo;
        this.repeatFilter.checkRepeat(key, () -> this.checkParams(transferOrderNo), true);
        TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
        TransferOrderTypeEnum transferOrderTypeEnum = TransferOrderTypeEnum.getEnumByCode((String)transferOrderEo.getType());
        boolean bl = flag = transferOrderTypeEnum != null && CsInventoryStrategyEnum.VIRTUAL.getCode().equalsIgnoreCase(transferOrderTypeEnum.getVirtualTag()) || YesNoEnum.YES.getValue().equals(transferOrderEo.getIsVirtual());
        if (flag) {
            return;
        }
        AssertUtil.isTrue((null != transferOrderEo ? 1 : 0) != 0, (String)("\u5355\u53f7" + transferOrderNo + "\u4e0d\u5b58\u5728!"));
        log.info("\u8fdb\u884c\u6536\u53d1\u5dee\u5f02\u5904\u7406\u7684\u6311\u62e8\u5355\u8be6\u60c5\u662f:{}", (Object)JSON.toJSONString((Object)transferOrderEo));
        AssertUtil.isTrue((TransferOrderStatus.END.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderStatus.COMPLETED.code().equals(transferOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u53ea\u6709\u5df2\u5b8c\u7ed3\u6216\u5df2\u5b8c\u6210\u624d\u53ef\u4ee5\u8ba1\u7b97\u5dee\u5f02\uff01");
        List dispatcherOrderEos = ((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)dispatcherOrderEos), (String)("\u8c03\u62e8\u5355\u53f7" + transferOrderNo + "\u5df2\u751f\u6210\u4e86\u6536\u53d1\u5dee\u5f02\u5355\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u751f\u6210!"));
        List transferOrderDetailEos = this.transferOrderDetailDomain.queryByTransferOrderNo(transferOrderNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)transferOrderDetailEos), (String)"\u8c03\u62e8\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderDetailEo outResultOrderDetailEo = new InOutResultOrderDetailEo();
        outResultOrderDetailEo.setRelevanceNo(transferOrderNo);
        List csOutNoticeOrderDetailEos = this.inOutNoticeOrderDetailDomain.queryCsOutNoticeOrderDetailList(outResultOrderDetailEo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderDetailEos), (String)"\u5165\u5e93\u901a\u77e5\u5355\u8be6\u60c5\u4e3a\u7a7a");
        InOutResultOrderEo outResultOrderEo = new InOutResultOrderEo();
        outResultOrderEo.setRelevanceNo(transferOrderNo);
        outResultOrderEo.setDispatcherStatus(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
        List csOutResultOrderDetailEos = this.inOutResultOrderDetailDomain.queryCsOutResultOrderDetailList(outResultOrderEo);
        this.dispatcher(transferOrderEo, transferOrderDetailEos, csOutNoticeOrderDetailEos, csOutResultOrderDetailEos);
        transferOrderEo.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.WAIT_PENGDING.getCode());
        this.transferOrderDomain.update((BaseEo)transferOrderEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void removeDispatcherOrder(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.dispatcherOrderDomain.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public DispatcherOrderRespDto queryById(Long id) {
        DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)this.dispatcherOrderDomain.selectByPrimaryKey(id);
        DispatcherOrderRespDto dispatcherOrderRespDto = new DispatcherOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)dispatcherOrderEo, (BaseVo)dispatcherOrderRespDto);
        return dispatcherOrderRespDto;
    }

    @Override
    public PageInfo<DispatcherOrderRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        DispatcherOrderReqDto dispatcherOrderReqDto = (DispatcherOrderReqDto)JSON.parseObject((String)filter, DispatcherOrderReqDto.class);
        DispatcherOrderEo dispatcherOrderEo = new DispatcherOrderEo();
        CubeBeanUtils.copyProperties((Object)dispatcherOrderEo, (Object)dispatcherOrderReqDto, (String[])new String[0]);
        PageInfo eoPageInfo = this.dispatcherOrderDomain.selectPage((BaseEo)dispatcherOrderEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DispatcherOrderRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void handleDifferencesDispatcher(DispatcherOrderReqDto dispatcherOrderReqDto) {
        log.info("\u5904\u7406\u6536\u53d1\u5dee\u5f02\u5355\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)dispatcherOrderReqDto));
        AssertUtil.isTrue((null != dispatcherOrderReqDto ? 1 : 0) != 0, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dispatcherOrderReqDto.getOrderNo()), (String)"\u5dee\u5f02\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String key = "DISPATCHER_ORDER:" + dispatcherOrderReqDto.getOrderNo();
        this.checkParams(dispatcherOrderReqDto.getOrderNo());
        this.repeatFilter.checkRepeat(key, () -> this.doHandleDifferencesDispatcher(dispatcherOrderReqDto), true);
    }

    public void doHandleDifferencesDispatcher(DispatcherOrderReqDto dispatcherOrderReqDto) {
        DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"order_no", (Object)dispatcherOrderReqDto.getOrderNo())).one();
        AssertUtil.isTrue((null != dispatcherOrderEo ? 1 : 0) != 0, (String)"\u5dee\u5f02\u5355\u4e0d\u5b58\u5728");
        this.unitProcess(dispatcherOrderReqDto);
        AssertUtil.isTrue((!CsDisPatcherOrderEnum.Status.CANCEL.getCode().equals(dispatcherOrderEo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.FINISH.getCode().equals(dispatcherOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5df2\u5b8c\u6210\u6216\u5df2\u53d6\u6d88\u7684\u5dee\u5f02\u5355\u7981\u6b62\u64cd\u4f5c");
        List dispatcherOrderDetailEos = ((ExtQueryChainWrapper)this.dispatcherOrderDetailDomain.filter().eq((Object)"order_id", (Object)dispatcherOrderEo.getId())).list();
        List dispatcherOrderDetailReqDtos = dispatcherOrderReqDto.getDispatcherOrderDetailReqDtos();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dispatcherOrderDetailReqDtos), (String)"\u5dee\u5f02\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List<DispatcherOrderDetailEo> dispatcherOrderDetailEos1 = this.checkQuantity(dispatcherOrderEo, dispatcherOrderDetailReqDtos, dispatcherOrderDetailEos);
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).one();
        Map<String, List<DispatcherOrderDetailEo>> collect = dispatcherOrderDetailEos1.stream().collect(Collectors.groupingBy(DispatcherOrderDetailEo::getOperationWay));
        collect.keySet().forEach(k -> {
            Map<String, List<DispatcherOrderDetailEo>> operationWayWarehouseCode = ((List)collect.get(k)).stream().collect(Collectors.groupingBy(a -> a.getOperationWay() + (StringUtils.isBlank((CharSequence)a.getWarehouseCode()) ? "" : a.getWarehouseCode())));
            operationWayWarehouseCode.keySet().forEach(v -> DiffOrderOptContext.getDiffOrderOptAble().handle(DispatchOperateBo.builder().dispatcherOperateWayEnum(DispatcherOperateWayEnum.getByCode(k)).dispatcherOrderDetailEos((List)operationWayWarehouseCode.get(v)).dispatcherOrderReqDto(dispatcherOrderReqDto).originalTransferOrderEo(transferOrder).eo(dispatcherOrderEo).isTransferWms(Boolean.TRUE).isAutoFinish(Boolean.FALSE).build()));
        });
        String remark = "EMPTY";
        DispatcherStatusEnum statusEnum = DispatcherStatusEnum.getByCode((String)dispatcherOrderEo.getBusinessType());
        if (statusEnum != null) {
            remark = statusEnum.getDesc();
        }
        OptUtil.addOptLog((String)OperationLogTypeEnum.DISPATCHER.name(), (String)remark, (String)dispatcherOrderReqDto.getOrderNo(), (String)dispatcherOrderEo.getOrderType());
    }

    private void unitProcess(DispatcherOrderReqDto dispatcherOrderReqDto) {
        ArrayList unitConversionDetails = new ArrayList();
        dispatcherOrderReqDto.getDispatcherOrderDetailReqDtos().forEach(adjustmentOrderDetailDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitConversionDetail = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitConversionDetail.setCurUnit(adjustmentOrderDetailDto.getUnit());
            unitConversionDetail.setSkuCode(adjustmentOrderDetailDto.getSkuCode());
            unitConversionDetail.setCurNum(adjustmentOrderDetailDto.getDispatcherQuantity());
            unitConversionDetails.add(unitConversionDetail);
        });
        OrderUnitConversionReqDto orderUnitConversionReqDto = new OrderUnitConversionReqDto();
        orderUnitConversionReqDto.setDocumentCode(dispatcherOrderReqDto.getOrderNo());
        orderUnitConversionReqDto.setType("dispatcher");
        orderUnitConversionReqDto.setCanSave(false);
        orderUnitConversionReqDto.setOrderUnitConversionDetailList(unitConversionDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.orderUnitConversionRecordService.queryAndSaveUnitConversion(orderUnitConversionReqDto);
        Map map = orderUnitConversionRecordDtos.stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getUnit(), Function.identity(), (o, o1) -> o));
        dispatcherOrderReqDto.getDispatcherOrderDetailReqDtos().forEach(r -> r.setDispatcherQuantity(UnitTransferUtils.pareSaleNum((BigDecimal)r.getDispatcherQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)map.get(r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getUnit())), (boolean)true)));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void cancelDispatcherInOutNoticeOrder(String orderNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String key = "DISPATCHER_ORDER:" + orderNo;
        this.repeatFilter.checkRepeat(key, () -> {
            List inOutNoticeOrderEos = this.iInOutNoticeOrderDomain.queryByDocumentNo(orderNo);
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)(orderNo + "\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u4e0d\u5b58\u5728"));
            InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
            AssertUtil.isTrue((BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u53ea\u5141\u8bb8\u5f85\u51fa\u5e93\u6216\u5f85\u5165\u5e93\u8fdb\u884c\u53d6\u6d88");
            List receiveDeliveryNoticeOrderEos = this.receiveDeliveryNoticeOrderDomain.queryByDocumentNo(inOutNoticeOrderEo.getPreOrderNo());
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveDeliveryNoticeOrderEos), (String)(inOutNoticeOrderEo.getPreOrderNo() + "\u53d1\u8d27\u901a\u77e5\u5355\u53f7\u4e0d\u5b58\u5728"));
            ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)receiveDeliveryNoticeOrderEos.get(0);
            OrderCancelResponseDto orderCancelResponseDto = this.sendOrderCancelDesc(inOutNoticeOrderEo, orderNo);
            AssertUtil.isTrue((null != orderCancelResponseDto ? 1 : 0) != 0, (String)"\u8c03\u7528wms\u5355\u636e\u53d6\u6d88\u5931\u8d25");
            if ("success".equals(orderCancelResponseDto.getFlag())) {
                inOutNoticeOrderEo.setOrderStatus("in".equals(inOutNoticeOrderEo.getOrderType()) ? BaseOrderStatusEnum.INO_CANCEL.getCode() : BaseOrderStatusEnum.ONO_CANCEL.getCode());
                deliveryNoticeOrderEo.setOrderStatus("receive".equals(deliveryNoticeOrderEo.getOrderType()) ? BaseOrderStatusEnum.RNO_CANCEL.getCode() : BaseOrderStatusEnum.DNO_CANCEL.getCode());
                inOutNoticeOrderEo.setRemark("");
                deliveryNoticeOrderEo.setRemark("");
                List dispatcherOrderDetailEos = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_status", (Object)CsDisPatcherOrderEnum.Status.WAIT.getCode())).eq((Object)"delivery_notice_no", (Object)inOutNoticeOrderEo.getPreOrderNo()));
                List collect = dispatcherOrderDetailEos.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.dispatcherOrderDetailDomain.updateDispatcherUntreatedQuantityByIds(collect);
                if (DispatcherOperateWayEnum.MORE_TRANSFER.getCode().equals(((DispatcherOrderDetailEo)dispatcherOrderDetailEos.get(0)).getOperationWay())) {
                    ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
                    releasePreemptDto.setSourceNo(deliveryNoticeOrderEo.getDocumentNo());
                    releasePreemptDto.setSourceType(deliveryNoticeOrderEo.getRelevanceTableName());
                    releasePreemptDto.setBusinessType(deliveryNoticeOrderEo.getBusinessType());
                    this.calcInventoryService.releasePreempt(releasePreemptDto);
                }
                List dispatcherOrderDetailEos1 = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_status", (Object)CsDisPatcherOrderEnum.Status.WAIT.getCode())).eq((Object)"order_no", (Object)inOutNoticeOrderEo.getRelevanceNo()));
                Map<String, List<DispatcherOrderDetailEo>> dispatcherOrderDetailEoMap = dispatcherOrderDetailEos1.stream().filter(eo -> eo.getDispatcherQuantity().compareTo(eo.getUntreatedQuantity()) == 0).collect(Collectors.groupingBy(detail -> detail.getSkuCode() + detail.getBatch()));
                dispatcherOrderDetailEoMap.forEach((k, v) -> {
                    if (v.size() > 1) {
                        DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
                        dispatcherOrderDetailEo.setParentId(null != ((DispatcherOrderDetailEo)v.get(0)).getParentId() ? ((DispatcherOrderDetailEo)v.get(0)).getParentId() : ((DispatcherOrderDetailEo)v.get(0)).getId());
                        dispatcherOrderDetailEo.setOrderId(((DispatcherOrderDetailEo)v.get(0)).getOrderId());
                        dispatcherOrderDetailEo.setOrderNo(((DispatcherOrderDetailEo)v.get(0)).getOrderNo());
                        dispatcherOrderDetailEo.setOrderType(((DispatcherOrderDetailEo)v.get(0)).getOrderType());
                        dispatcherOrderDetailEo.setBusinessType(((DispatcherOrderDetailEo)v.get(0)).getBusinessType());
                        dispatcherOrderDetailEo.setSkuCode(((DispatcherOrderDetailEo)v.get(0)).getSkuCode());
                        dispatcherOrderDetailEo.setSkuName(((DispatcherOrderDetailEo)v.get(0)).getSkuName());
                        dispatcherOrderDetailEo.setBatch(((DispatcherOrderDetailEo)v.get(0)).getBatch());
                        dispatcherOrderDetailEo.setSpecification(((DispatcherOrderDetailEo)v.get(0)).getSpecification());
                        dispatcherOrderDetailEo.setStorageCondition(((DispatcherOrderDetailEo)v.get(0)).getStorageCondition());
                        dispatcherOrderDetailEo.setProductDate(((DispatcherOrderDetailEo)v.get(0)).getProductDate());
                        dispatcherOrderDetailEo.setDueDate(((DispatcherOrderDetailEo)v.get(0)).getDueDate());
                        dispatcherOrderDetailEo.setDispatcherQuantity(v.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setDispatcherStatus(((DispatcherOrderDetailEo)v.get(0)).getDispatcherStatus());
                        dispatcherOrderDetailEo.setQuantity(v.stream().map(DispatcherOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setQuantity(v.stream().map(DispatcherOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setPlanQuantity(v.stream().map(DispatcherOrderDetailEo::getPlanQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setInQuantity(v.stream().map(DispatcherOrderDetailEo::getInQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setOutQuantity(v.stream().map(DispatcherOrderDetailEo::getOutQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setCancelQuantity(v.stream().map(DispatcherOrderDetailEo::getCancelQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setProcessedQuantity(v.stream().map(DispatcherOrderDetailEo::getProcessedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setProcessingQuantity(v.stream().map(DispatcherOrderDetailEo::getProcessingQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setUntreatedQuantity(v.stream().map(DispatcherOrderDetailEo::getUntreatedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setDispatcherCause(null);
                        dispatcherOrderDetailEo.setWarehouseCode(null);
                        dispatcherOrderDetailEo.setWarehouseName(null);
                        dispatcherOrderDetailEo.setWeight(v.stream().map(DispatcherOrderDetailEo::getWeight).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setVolume(v.stream().map(DispatcherOrderDetailEo::getVolume).reduce(BigDecimal.ZERO, BigDecimal::add));
                        dispatcherOrderDetailEo.setUnit(((DispatcherOrderDetailEo)v.get(0)).getUnit());
                        dispatcherOrderDetailEo.setOperationPerson(this.context.userName());
                        dispatcherOrderDetailEo.setOperationTime(new Date());
                        dispatcherOrderDetailEo.setOperationWay(null);
                        dispatcherOrderDetailEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                        dispatcherOrderDetailEo.setRemark(null);
                        dispatcherOrderDetailEo.setLiabilityProject(null);
                        this.dispatcherOrderDetailDomain.insert((BaseEo)dispatcherOrderDetailEo);
                        v.stream().forEach(detail -> {
                            detail.setOrderStatus(CsDisPatcherOrderEnum.Status.CANCEL.getCode());
                            this.dispatcherOrderDetailDomain.update((BaseEo)detail);
                        });
                    }
                });
                BigDecimal dispatcherQuantity = dispatcherOrderDetailEos1.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal untreatedQuantity = dispatcherOrderDetailEos1.stream().map(DispatcherOrderDetailEo::getUntreatedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (dispatcherQuantity.compareTo(untreatedQuantity) == 0) {
                    DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).one();
                    dispatcherOrderEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                    this.dispatcherOrderDomain.update((BaseEo)dispatcherOrderEo);
                    TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).one();
                    transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.WAIT_PENGDING.getCode());
                    this.transferOrderDomain.update((BaseEo)transferOrder);
                }
            } else {
                inOutNoticeOrderEo.setRemark(orderCancelResponseDto.getMessage());
                deliveryNoticeOrderEo.setRemark(orderCancelResponseDto.getMessage());
            }
            this.iInOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
            this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)deliveryNoticeOrderEo);
        }, true);
    }

    @Override
    public OrderCancelResponseDto sendOrderCancelDesc(InOutNoticeOrderEo inOutNoticeOrderEo, String orderNo) {
        boolean b = InventoryConfig.getPushWmsAble().canPushWms(PushWmsAble.CanPushWmsBo.builder().businessType(inOutNoticeOrderEo.getDisplayBusinessType()).relevanceTableNameEnum(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName())).orderType(inOutNoticeOrderEo.getJumpDocumentType()).logicWarehouseCode(BasicsOrderOperateTypeEnum.IN.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderType()) ? inOutNoticeOrderEo.getInLogicWarehouseCode() : inOutNoticeOrderEo.getOutLogicWarehouseCode()).inOut(inOutNoticeOrderEo.getOrderType()).relevanceNo(inOutNoticeOrderEo.getRelevanceNo()).build());
        if (b) {
            OrderCancelQimenMessageReqDto reqDto = new OrderCancelQimenMessageReqDto();
            reqDto.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
            reqDto.setOrderType(inOutNoticeOrderEo.getOrderType());
            reqDto.setWarehouseCode(BasicsOrderOperateTypeEnum.IN.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderType()) ? inOutNoticeOrderEo.getInLogicWarehouseCode() : inOutNoticeOrderEo.getOutLogicWarehouseCode());
            log.info("\u63a8\u9001\u53d6\u6d88\u903b\u8f91");
            AssertUtil.isTrue((boolean)InventoryConfig.getPushWms().sendOrderCancel(reqDto), (String)"\u53d6\u6d88wms\u5931\u8d25");
        }
        OrderCancelResponseDto orderCancelResponseDto = new OrderCancelResponseDto();
        orderCancelResponseDto.setFlag("success");
        return orderCancelResponseDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    @OptLogContext(logType=OperationLogTypeEnum.CLOSE, orderCodeSpel="#dispatcherOrderCloseReqDto.orderNo", typeSpel="#dispatcherOrderCloseReqDto.orderType", remarkSpel="#dispatcherOrderCloseReqDto.remark")
    public void closeDispatcherOrder(DispatcherOrderCloseReqDto dispatcherOrderCloseReqDto) {
        AssertUtil.isTrue((null != dispatcherOrderCloseReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dispatcherOrderCloseReqDto.getOrderNo()), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String key = "DISPATCHER_ORDER:" + dispatcherOrderCloseReqDto.getOrderNo();
        this.repeatFilter.checkRepeat(key, () -> {}, true);
        DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)this.dispatcherOrderDomain.getMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_no", (Object)dispatcherOrderCloseReqDto.getOrderNo())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue()));
        AssertUtil.isTrue((null != dispatcherOrderEo ? 1 : 0) != 0, (String)(dispatcherOrderCloseReqDto.getOrderNo() + "\u6536\u53d1\u5dee\u5f02\u5355\u4e0d\u5b58\u5728"));
        AssertUtil.isTrue((CsDisPatcherOrderEnum.Status.WAIT.getCode().equals(dispatcherOrderEo.getOrderStatus()) || CsDisPatcherOrderEnum.Status.PORTION_WAIT.getCode().equals(dispatcherOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u53ea\u6709\u5f85\u5904\u7406\u6216\u90e8\u5206\u5904\u7406\u72b6\u6001\u624d\u5141\u8bb8\u5173\u95ed");
        List dispatcherOrderDetailEos = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_no", (Object)dispatcherOrderCloseReqDto.getOrderNo())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue()));
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dispatcherOrderDetailEos), (String)"\u6536\u53d1\u5dee\u5f02\u5355\u660e\u7ec6\u4e0d\u5b58\u5728");
        BigDecimal processingQuantity = dispatcherOrderDetailEos.stream().filter(a -> CsDisPatcherOrderEnum.Status.WAIT.getCode().equals(a.getOrderStatus())).map(r -> (BigDecimal)ObjectUtils.defaultIfNull((Object)r.getProcessingQuantity(), (Object)BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        AssertUtil.isTrue((processingQuantity.compareTo(BigDecimal.ZERO) <= 0 ? 1 : 0) != 0, (String)"\u5173\u95ed\u5931\u8d25\uff0c\u5904\u7406\u4e2d\u6570\u91cf\uff1e0\uff0c\u8bf7\u5148\u5230\u6536\u53d1\u5dee\u5f02\u5355\u8be6\u60c5\u9875\u53d6\u6d88\u51fa\u5e93/\u5165\u5e93\u901a\u77e5\u5355");
        dispatcherOrderCloseReqDto.setOrderType(dispatcherOrderEo.getOrderType());
        dispatcherOrderEo.setOrderStatus(CsTransferDispatcherHandleStatusEnum.CLOSE.getCode());
        this.dispatcherOrderDomain.update((BaseEo)dispatcherOrderEo);
        if (CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(dispatcherOrderEo.getBusinessType())) {
            InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)dispatcherOrderEo.getTransferOrderNo())).last("limit 1")).one();
            ReleaseIntransitDto releaseIntransitDto = new ReleaseIntransitDto();
            releaseIntransitDto.setSourceNo(dispatcherOrderEo.getTransferOrderNo());
            releaseIntransitDto.setSourceType(dispatcherOrderEo.getType());
            if (Objects.nonNull(inOutNoticeOrderEo)) {
                releaseIntransitDto.setExternalOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
                releaseIntransitDto.setBusinessType(inOutNoticeOrderEo.getJumpDocumentType());
            }
            releaseIntransitDto.setNoneLineNo(Boolean.TRUE);
            List inventoryOperateLogEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryDueInDomain.filter().eq((Object)"source_no", (Object)dispatcherOrderEo.getTransferOrderNo())).isNotNull((Object)"batch")).list();
            log.info("\u91ca\u653e\u5168\u90e8\u5728\u9014");
            Map<String, BigDecimal> canRelseMap = inventoryOperateLogEoList.stream().collect(Collectors.groupingBy(InResultOrderAbleImpl::getBatchKey, Collectors.mapping(InventoryDueInEo::getRequestNum, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
            releaseIntransitDto.setDetails(canRelseMap.entrySet().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)((BigDecimal)r.getValue()))).map(entry -> {
                String[] split = ((String)entry.getKey()).split(InventoryConfig.getCommonSeparate());
                CalcDetailDto calcDetailDto = InResultOrderAbleImpl.initCalcDto(entry, split);
                calcDetailDto.setBatch(split[3]);
                if (BigDecimalUtils.eqZero((BigDecimal)calcDetailDto.getNum()).booleanValue()) {
                    return null;
                }
                return calcDetailDto;
            }).filter(Objects::nonNull).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty((Collection)releaseIntransitDto.getDetails())) {
                this.calcInventoryService.releaseInransit(releaseIntransitDto);
            }
        }
        TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).one();
        log.info("\u6536\u53d1\u5dee\u5f02\u72b6\u6001:{}", (Object)dispatcherOrderEo.getOrderStatus());
        dispatcherOrderEo.setOrderStatus(CsDisPatcherOrderEnum.Status.CLOSE.getCode());
        this.dispatcherOrderDomain.update((BaseEo)dispatcherOrderEo);
        transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PROCESSED.getCode());
        List dispatcherOrderEos = ((ExtQueryChainWrapper)this.dispatcherOrderDomain.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).list();
        if (dispatcherOrderEos.size() > 1) {
            DispatcherOrderEo otherDispatcherOrderEo = (DispatcherOrderEo)dispatcherOrderEos.stream().filter(e -> !e.getOrderNo().equals(dispatcherOrderEo.getOrderNo())).collect(Collectors.toList()).get(0);
            log.info("otherDispatcherOrderEo:{}", (Object)JSON.toJSONString((Object)otherDispatcherOrderEo));
            if (CsDisPatcherOrderEnum.Status.CLOSE.getCode().equals(dispatcherOrderEo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.FINISH.getCode().equals(otherDispatcherOrderEo.getOrderStatus()) && !CsDisPatcherOrderEnum.Status.CLOSE.getCode().equals(otherDispatcherOrderEo.getOrderStatus())) {
                transferOrder.setDispatcherHandleStatus(CsTransferDispatcherHandleStatusEnum.PORTION_PENGDING.getCode());
            }
        }
        this.transferOrderDomain.update((BaseEo)transferOrder);
    }

    public void createInResultShifting(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        InOutNoticeOrderEo csOutNoticeOrderEo;
        List csOutNoticeOrderDetailEoList;
        List csOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iInOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)dispatcherOrderEo.getOrderNo())).eq((Object)"order_type", (Object)InventoryInOutEnum.IN.getCode())).list();
        if (CollectionUtils.isNotEmpty((Collection)csOutNoticeOrderEoList) && CollectionUtils.isNotEmpty((Collection)(csOutNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryByDocumentNo((csOutNoticeOrderEo = (InOutNoticeOrderEo)csOutNoticeOrderEoList.stream().sorted(Comparator.comparing(BaseEo::getCreateTime).reversed()).collect(Collectors.toList()).get(0)).getDocumentNo())))) {
            BasicsReceiveReqDto csWmsInSendBackReqDto = new BasicsReceiveReqDto();
            csWmsInSendBackReqDto.setInOutNoticeOrderNo(csOutNoticeOrderEo.getDocumentNo());
            csWmsInSendBackReqDto.setInOutTime(new Date());
            if (!Objects.isNull(dispatcherOrderEo.getBizDate())) {
                csWmsInSendBackReqDto.setBizDate(dispatcherOrderEo.getBizDate());
                csWmsInSendBackReqDto.setInOutTime(dispatcherOrderEo.getBizDate());
            }
            csWmsInSendBackReqDto.setIgnoreOvercharge(Boolean.valueOf(true));
            Optional.ofNullable(csOutNoticeOrderEo.getExtension()).filter(StringUtils::isNotBlank).map(r -> JSON.parseArray((String)r, CsWmsShippingInfoReqDto.class)).ifPresent(arg_0 -> ((BasicsReceiveReqDto)csWmsInSendBackReqDto).setShippingInfoReqDtoList(arg_0));
            ArrayList detailReqDtoList = new ArrayList();
            csOutNoticeOrderDetailEoList.forEach(itemInfo -> {
                BasicsDetailReqDto csWmsInSendBackDetailReqDto = new BasicsDetailReqDto();
                csWmsInSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getId());
                csWmsInSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                csWmsInSendBackDetailReqDto.setBatch((String)DataExtractUtils.ifNullElse((Object)itemInfo.getBatch(), (Object)""));
                csWmsInSendBackDetailReqDto.setQuantity(itemInfo.getWaitQuantity());
                csWmsInSendBackDetailReqDto.setWarehouseCode(csOutNoticeOrderEo.getWarehouseCode());
                csWmsInSendBackDetailReqDto.setProduceTime(itemInfo.getProduceTime());
                csWmsInSendBackDetailReqDto.setExpireTime(itemInfo.getExpireTime());
                detailReqDtoList.add(csWmsInSendBackDetailReqDto);
            });
            csWmsInSendBackReqDto.setDetailReqDtoList(detailReqDtoList);
            this.commonSendBackAble.receiveIn(csWmsInSendBackReqDto);
        }
    }

    private List<DispatcherOrderDetailEo> checkQuantity(DispatcherOrderEo dispatcherOrderEo, List<DispatcherOrderDetailReqDto> dispatcherOrderDetailReqDtos, List<DispatcherOrderDetailEo> dispatcherOrderDetailEos) {
        List<DispatcherOrderDetailEo> collect = dispatcherOrderDetailEos.stream().filter(a -> CsDisPatcherOrderEnum.Status.WAIT.getCode().equals(a.getOrderStatus())).collect(Collectors.toList());
        BigDecimal processedQuantity = collect.stream().map(DispatcherOrderDetailEo::getProcessedQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal dispatcherQuantity = dispatcherOrderDetailReqDtos.stream().map(DispatcherOrderDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("\u6536\u53d1\u5dee\u5f02\u5355{}\uff0c\u5224\u5b9a\u5dee\u5f02\u5355\u7684\u4e3b\u5355\u72b6\u6001\u7684\u603b\u6570\u91cf\uff1a{},\u5df2\u5904\u7406\u603b\u6570\u91cf\uff1a{},\u672c\u6b21\u5904\u7406\u603b\u6570\u91cf\uff1a{},\u5df2\u5904\u7406\u603b\u6570\u91cf+\u672c\u6b21\u5904\u7406\u603b\u6570\u91cf\uff1a{}", new Object[]{dispatcherOrderEo.getOrderNo(), dispatcherOrderEo.getTotalQuantity(), processedQuantity, dispatcherQuantity, processedQuantity.add(dispatcherQuantity)});
        Map<Long, BigDecimal> reduceMap2 = dispatcherOrderDetailReqDtos.stream().collect(Collectors.toMap(BaseDto::getId, DispatcherOrderDetailReqDto::getDispatcherQuantity, BigDecimal::add));
        Map<Long, List<DispatcherOrderDetailReqDto>> dispatcherOrderDetailReqDtoMap = dispatcherOrderDetailReqDtos.stream().collect(Collectors.groupingBy(BaseDto::getId));
        StringBuffer sbuffer = new StringBuffer();
        ArrayList<DispatcherOrderDetailEo> list = new ArrayList<DispatcherOrderDetailEo>();
        log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cfreduceMap2:{}", (Object)JSON.toJSONString(reduceMap2));
        log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cfdispatcherOrderDetailReqDtoMap:{}", (Object)JSON.toJSONString(dispatcherOrderDetailReqDtoMap));
        collect.forEach(order -> {
            Long key = order.getId();
            log.info("\u6536\u53d1\u5dee\u5f02\u5355,\u5224\u5b9a\u662f\u5426\u9700\u8981\u62c6\u884c\u7684\u5904\u7406\u6570\u91cforder.getUntreatedQuantity():{},key:{}", (Object)order.getUntreatedQuantity(), (Object)key.toString());
            if (BigDecimalUtils.gtZero((BigDecimal)order.getUntreatedQuantity()).booleanValue() && reduceMap2.containsKey(key)) {
                if (order.getUntreatedQuantity().compareTo((BigDecimal)reduceMap2.get(key)) < 0) {
                    sbuffer.append("\u7269\u6599").append(order.getSkuCode()).append("\u5f85\u5904\u7406\u6570\u91cf\u5927\u4e8e\u5355\u636e\u7684\u5f85\u5904\u7406\u6570\u91cf");
                } else if (order.getUntreatedQuantity().compareTo((BigDecimal)reduceMap2.get(key)) > 0) {
                    this.splitDispathcerOrderDetail((DispatcherOrderDetailEo)order, (List)dispatcherOrderDetailReqDtoMap.get(key), order.getUntreatedQuantity().subtract((BigDecimal)reduceMap2.get(key)), (List<DispatcherOrderDetailEo>)list);
                } else if (((List)dispatcherOrderDetailReqDtoMap.get(key)).size() == 1) {
                    order.setProcessingQuantity(order.getUntreatedQuantity());
                    order.setUntreatedQuantity(BigDecimal.ZERO);
                    order.setRemark(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getRemark());
                    order.setOperationWay(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getOperationWay());
                    order.setDispatcherCause(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getDispatcherCause());
                    order.setOperationTime(new Date());
                    order.setOperationPerson(this.context.userName());
                    order.setLiabilityProject(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getLiabilityProject());
                    order.setWarehouseName(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getWarehouseName());
                    order.setWarehouseCode(((DispatcherOrderDetailReqDto)((List)dispatcherOrderDetailReqDtoMap.get(key)).get(0)).getWarehouseCode());
                    this.dispatcherOrderDetailDomain.update((BaseEo)order);
                    list.add((DispatcherOrderDetailEo)order);
                } else {
                    this.splitDispathcerOrderDetail((DispatcherOrderDetailEo)order, (List)dispatcherOrderDetailReqDtoMap.get(key), order.getUntreatedQuantity().subtract((BigDecimal)reduceMap2.get(key)), (List<DispatcherOrderDetailEo>)list);
                }
            }
        });
        AssertUtil.isTrue((boolean)StringUtils.isBlank((CharSequence)sbuffer), (String)sbuffer.toString());
        BigDecimal unQuantity = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)) {
            unQuantity = list.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        log.info("\u524d\u7aef\u4f20\u8fc7\u6765\u7684\u5f85\u5904\u7406\u6570\u91cf:{},\u8ba1\u7b97\u4e4b\u540e\u7684\u5f85\u5904\u7406\u6570\u91cf:{}", (Object)dispatcherQuantity, (Object)unQuantity);
        AssertUtil.isTrue((unQuantity.compareTo(dispatcherQuantity) == 0 ? 1 : 0) != 0, (String)"\u5dee\u5f02\u6570\u91cf\u8ba1\u7b97\u6709\u8bef\uff0c\u8bf7\u8c03\u6574\uff01");
        return list;
    }

    public void splitDispathcerOrderDetail(DispatcherOrderDetailEo eo, List<DispatcherOrderDetailReqDto> list, BigDecimal subtract, List<DispatcherOrderDetailEo> listDetailEo) {
        boolean splitUnProcessLine = subtract.compareTo(BigDecimal.ZERO) > 0;
        ArrayList<DispatcherOrderDetailEo> curProcessList = new ArrayList<DispatcherOrderDetailEo>(list.size() + list.size() / 2);
        for (int i = 0; i < list.size(); ++i) {
            DispatcherOrderDetailReqDto dto = list.get(i);
            DispatcherOrderDetailEo dispatcherOrderDetailEo = this.setDispatcherOrderDetailEo(eo, dto.getDispatcherQuantity(), dto.getDispatcherQuantity(), BigDecimal.ZERO, dto.getDispatcherCause(), dto.getWarehouseCode(), dto.getWarehouseName(), dto.getOperationWay(), CsDisPatcherOrderEnum.Status.WAIT.getCode(), dto.getRemark(), dto.getOldUnit(), dto.getLiabilityProject());
            if (list.size() - 1 == i && !splitUnProcessLine) {
                this.compensation(eo, curProcessList, dispatcherOrderDetailEo);
            }
            curProcessList.add(dispatcherOrderDetailEo);
            this.dispatcherOrderDetailDomain.insert((BaseEo)dispatcherOrderDetailEo);
        }
        if (splitUnProcessLine) {
            DispatcherOrderDetailEo dispatcherOrderDetailEo = this.setDispatcherOrderDetailEo(eo, subtract, BigDecimal.ZERO, subtract, null, null, null, null, CsDisPatcherOrderEnum.Status.WAIT.getCode(), eo.getRemark(), eo.getUnit(), null);
            this.compensation(eo, curProcessList, dispatcherOrderDetailEo);
            this.dispatcherOrderDetailDomain.insert((BaseEo)dispatcherOrderDetailEo);
        }
        eo.setOrderStatus(null != eo.getParentId() ? CsDisPatcherOrderEnum.Status.CANCEL.getCode() : CsDisPatcherOrderEnum.Status.SPLIT.getCode());
        this.dispatcherOrderDetailDomain.update((BaseEo)eo);
        listDetailEo.addAll(curProcessList);
    }

    private void compensation(DispatcherOrderDetailEo eo, List<DispatcherOrderDetailEo> curProcessList, DispatcherOrderDetailEo dispatcherOrderDetailEo) {
        dispatcherOrderDetailEo.setPlanQuantity(eo.getPlanQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getPlanQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setQuantity(eo.getQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setCancelQuantity(eo.getCancelQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getCancelQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setInQuantity(eo.getInQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getInQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
        dispatcherOrderDetailEo.setOutQuantity(eo.getOutQuantity().subtract(curProcessList.stream().map(DispatcherOrderDetailEo::getOutQuantity).reduce(BigDecimal.ZERO, BigDecimal::add)));
    }

    public DispatcherOrderDetailEo setDispatcherOrderDetailEo(DispatcherOrderDetailEo eo, BigDecimal subtract, BigDecimal processedQuantity, BigDecimal untreatedQuantity, String dispatcherCause, String warehouseCoe, String warehouseName, String operationWay, String orderStatus, String remark, String oldUnit, String liabilityProject) {
        int inventoryPrecision = InventoryConfig.getInventoryPrecision();
        DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
        dispatcherOrderDetailEo.setParentId(null != eo.getParentId() ? eo.getParentId() : eo.getId());
        dispatcherOrderDetailEo.setOrderId(eo.getOrderId());
        dispatcherOrderDetailEo.setInventoryProperty(eo.getInventoryProperty());
        dispatcherOrderDetailEo.setOrderNo(eo.getOrderNo());
        dispatcherOrderDetailEo.setOrderType(eo.getOrderType());
        dispatcherOrderDetailEo.setBusinessType(eo.getBusinessType());
        dispatcherOrderDetailEo.setSkuCode(eo.getSkuCode());
        dispatcherOrderDetailEo.setSkuName(eo.getSkuName());
        dispatcherOrderDetailEo.setBatch(eo.getBatch());
        dispatcherOrderDetailEo.setSpecification(eo.getSpecification());
        dispatcherOrderDetailEo.setStorageCondition(eo.getStorageCondition());
        dispatcherOrderDetailEo.setProductDate(eo.getProductDate());
        dispatcherOrderDetailEo.setDueDate(eo.getDueDate());
        dispatcherOrderDetailEo.setDispatcherQuantity(subtract);
        dispatcherOrderDetailEo.setDispatcherStatus(eo.getDispatcherStatus());
        dispatcherOrderDetailEo.setOutResultDocumentNo(eo.getOutResultDocumentNo());
        BigDecimal cardinal = eo.getDispatcherQuantity();
        dispatcherOrderDetailEo.setQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getQuantity(), subtract));
        dispatcherOrderDetailEo.setPlanQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getPlanQuantity(), subtract));
        dispatcherOrderDetailEo.setInQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getInQuantity(), subtract));
        dispatcherOrderDetailEo.setOutQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getOutQuantity(), subtract));
        dispatcherOrderDetailEo.setCancelQuantity(this.calQuantityByCell(inventoryPrecision, cardinal, eo.getCancelQuantity(), subtract));
        dispatcherOrderDetailEo.setProcessedQuantity(BigDecimal.ZERO);
        dispatcherOrderDetailEo.setProcessingQuantity(processedQuantity);
        dispatcherOrderDetailEo.setUntreatedQuantity(untreatedQuantity);
        dispatcherOrderDetailEo.setDispatcherCause(dispatcherCause);
        dispatcherOrderDetailEo.setWarehouseCode(warehouseCoe);
        dispatcherOrderDetailEo.setWarehouseName(warehouseName);
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
        calculateWeightAndVolumeDetailBo.setQuantity(dispatcherOrderDetailEo.getDispatcherQuantity());
        calculateWeightAndVolumeDetailBo.setUnit(eo.getUnit());
        calculateWeightAndVolumeDetailBo.setSkuCode(eo.getSkuCode());
        calculateWeightAndVolumeBo.setVolumeDetailBos(Arrays.asList(calculateWeightAndVolumeDetailBo));
        calculateWeightAndVolumeBo.setDocumentCode(eo.getOrderNo());
        calculateWeightAndVolumeBo.setCanTransferNum(true);
        Map<String, BasicOrderDtoExtension> map = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        String str = this.getKey(dispatcherOrderDetailEo.getSkuCode(), dispatcherOrderDetailEo.getDispatcherQuantity());
        if (map.containsKey(str)) {
            BasicOrderDtoExtension basicOrderDtoExtension = map.get(str);
            dispatcherOrderDetailEo.setWeight(basicOrderDtoExtension.getWeight());
            dispatcherOrderDetailEo.setVolume(basicOrderDtoExtension.getVolume());
        }
        dispatcherOrderDetailEo.setUnit(eo.getUnit());
        dispatcherOrderDetailEo.setOperationPerson(this.context.userName());
        dispatcherOrderDetailEo.setOperationTime(new Date());
        dispatcherOrderDetailEo.setOperationWay(operationWay);
        dispatcherOrderDetailEo.setOrderStatus(orderStatus);
        dispatcherOrderDetailEo.setRemark(remark);
        dispatcherOrderDetailEo.setLiabilityProject(liabilityProject);
        return dispatcherOrderDetailEo;
    }

    private String getKey(String skuCode, BigDecimal quantity) {
        return skuCode + InventoryConfig.getCommonSeparate() + quantity;
    }

    @NotNull
    private BigDecimal getMaxValue(BigDecimal quantity, BigDecimal subtract, int inventoryPrecision, BigDecimal cardinal) {
        BigDecimal decimal = this.calQuantityByCell(inventoryPrecision, cardinal, quantity, subtract);
        return decimal.compareTo(subtract) < 0 ? subtract : decimal;
    }

    @NotNull
    private BigDecimal calQuantityByCell(int inventoryPrecision, BigDecimal divide, BigDecimal quantity, BigDecimal subtract) {
        if (this.splitModule == 0) {
            return BigDecimal.ZERO;
        }
        return subtract.multiply(quantity).divide(divide, inventoryPrecision, RoundingMode.HALF_DOWN);
    }

    private void dispatcher(TransferOrderEo transferOrderEo, List<TransferOrderDetailEo> transferOrderDetailEos, List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, List<InOutResultOrderDetailEo> csOutResultOrderDetailEos) {
        DispatcherOrderEo eo = new DispatcherOrderEo();
        this.packageDispathcer(eo, transferOrderEo);
        Map<String, BigDecimal> ratioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderEo.getTransferOrderNo())).list().stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, TransferOrderDetailEo> transferOrderDetailEoMap = transferOrderDetailEos.stream().collect(Collectors.toMap(a -> a.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), o -> {
            BigDecimal decimal = (BigDecimal)ratioMap.get(o.getSkuCode());
            o.setQuantity(BigDecimalUtils.multiply((BigDecimal)o.getQuantity(), (BigDecimal)decimal));
            o.setDoneInQuantity(BigDecimalUtils.multiply((BigDecimal)o.getDoneInQuantity(), (BigDecimal)decimal));
            o.setDoneOutQuantity(BigDecimalUtils.multiply((BigDecimal)o.getDoneOutQuantity(), (BigDecimal)decimal));
            o.setDispatcherQuantity(BigDecimalUtils.multiply((BigDecimal)o.getDispatcherQuantity(), (BigDecimal)decimal));
            o.setDispatcherLessQuantity(BigDecimalUtils.multiply((BigDecimal)o.getDispatcherLessQuantity(), (BigDecimal)decimal));
            o.setWaitInQuantity(BigDecimalUtils.multiply((BigDecimal)o.getWaitInQuantity(), (BigDecimal)decimal));
            o.setWaitOutQuantity(BigDecimalUtils.multiply((BigDecimal)o.getWaitOutQuantity(), (BigDecimal)decimal));
            return o;
        }, (key1, key2) -> key1));
        Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap = BeanUtil.copyToList(csOutNoticeOrderDetailEos, InOutNoticeOrderDetailEo.class).stream().collect(Collectors.toMap(a -> a.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> {
            key2.setDoneQuantity(BigDecimalUtils.add((BigDecimal)key1.getDoneQuantity(), (BigDecimal)key2.getDoneQuantity()));
            key2.setPlanQuantity(BigDecimalUtils.add((BigDecimal)key1.getPlanQuantity(), (BigDecimal)key2.getPlanQuantity()));
            return key2;
        }));
        if (CollectionUtils.isEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos = new ArrayList<InOutResultOrderDetailEo>();
        }
        Map<String, InOutResultOrderDetailEo> outResultOrderDetailEoMap = BeanUtil.copyToList(csOutResultOrderDetailEos, InOutResultOrderDetailEo.class).stream().collect(Collectors.toMap(a -> a.getPreOrderNo() + InventoryConfig.getCommonSeparate() + a.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> {
            key2.setDoneQuantity(BigDecimalUtils.add((BigDecimal)key1.getDoneQuantity(), (BigDecimal)key2.getDoneQuantity()));
            return key2;
        }));
        List<String> itemCodeList = transferOrderDetailEos.stream().filter(info -> StringUtils.isNotEmpty((CharSequence)info.getSkuCode())).map(TransferOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemDataQueryRespDto> respDtoList = this.selectItem(itemCodeList);
        Map<String, Object> itemMap = new HashMap<String, ItemDataQueryRespDto>(respDtoList.size());
        if (CollectionUtils.isNotEmpty(respDtoList)) {
            itemMap = respDtoList.stream().collect(Collectors.toMap(ItemDataQueryRespDto::getCode, Function.identity(), (c1, c2) -> c2));
        }
        ArrayList<DispatcherOrderDetailEo> list = new ArrayList<DispatcherOrderDetailEo>();
        HashMap<String, ItemDataQueryRespDto> finalItemMap = itemMap;
        this.sendBackMore(csOutResultOrderDetailEos, transferOrderDetailEoMap, outNoticeOrderDetailEoMap, list, finalItemMap);
        Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailCountMap = BeanUtil.copyToList(csOutNoticeOrderDetailEos, InOutNoticeOrderDetailEo.class).stream().collect(Collectors.toMap(a -> a.getDocumentNo() + InventoryConfig.getCommonSeparate() + a.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : a.getBatch()), Function.identity(), (key1, key2) -> {
            key2.setDoneQuantity(BigDecimalUtils.add((BigDecimal)key1.getDoneQuantity(), (BigDecimal)key2.getDoneQuantity()));
            key2.setPlanQuantity(BigDecimalUtils.add((BigDecimal)key1.getPlanQuantity(), (BigDecimal)key2.getPlanQuantity()));
            key2.setCancelQuantity(BigDecimalUtils.add((BigDecimal)key1.getCancelQuantity(), (BigDecimal)key2.getCancelQuantity()));
            return key2;
        }));
        this.matchDispatch(csOutNoticeOrderDetailEos, transferOrderDetailEoMap, outNoticeOrderDetailCountMap, outResultOrderDetailEoMap, list, finalItemMap);
        this.saveAndInsertLog(eo, list);
    }

    private void saveAndInsertLog(DispatcherOrderEo eo, List<DispatcherOrderDetailEo> list) {
        List<DispatcherOrderDetailEo> dispatcherOrderDetailEos;
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Map<String, List<DispatcherOrderDetailEo>> collect = list.stream().collect(Collectors.groupingBy(DispatcherOrderDetailEo::getBusinessType));
        if (collect.containsKey(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode())) {
            dispatcherOrderDetailEos = collect.get(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
            String moreDispatcherNo = InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.DISPATCHER_ORDER);
            eo.setId(null);
            eo.setOrderNo(moreDispatcherNo);
            eo.setOrderType(DocumentTypeEnum.DISPATCHER_ORDER.getCode());
            eo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
            eo.setTotalQuantity(dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.dispatcherOrderDomain.insert((BaseEo)eo);
            dispatcherOrderDetailEos.forEach(detail -> {
                detail.setId(null);
                detail.setOrderId(eo.getId());
                detail.setOrderNo(eo.getOrderNo());
            });
            this.dispatcherOrderDetailDomain.insertBatch(dispatcherOrderDetailEos);
            OptUtil.addOptLog((String)OperationLogTypeEnum.CREATED.name(), (String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210", (String)moreDispatcherNo, (String)eo.getOrderType());
            this.orderUnitConversionRecordService.adapterUnitAndQuery(eo, dispatcherOrderDetailEos);
        }
        if (collect.containsKey(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode())) {
            dispatcherOrderDetailEos = collect.get(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
            String lessDispatcherNo = InventoryConfig.getGenerateCodeUtil().generateCode(CodeGenEnum.DISPATCHER_ORDER);
            eo.setId(null);
            eo.setOrderNo(lessDispatcherNo);
            eo.setOrderType(DocumentTypeEnum.DISPATCHER_ORDER.getCode());
            eo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
            eo.setTotalQuantity(dispatcherOrderDetailEos.stream().map(DispatcherOrderDetailEo::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
            this.dispatcherOrderDomain.insert((BaseEo)eo);
            dispatcherOrderDetailEos.forEach(detail -> {
                detail.setId(null);
                detail.setOrderId(eo.getId());
                detail.setOrderNo(eo.getOrderNo());
            });
            this.dispatcherOrderDetailDomain.insertBatch(dispatcherOrderDetailEos);
            OptUtil.addOptLog((String)OperationLogTypeEnum.CREATED.name(), (String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210", (String)lessDispatcherNo, (String)eo.getOrderType());
            this.orderUnitConversionRecordService.adapterUnitAndQuery(eo, dispatcherOrderDetailEos);
        }
    }

    private void matchDispatch(List<InOutNoticeOrderDetailEo> csOutNoticeOrderDetailEos, Map<String, TransferOrderDetailEo> transferOrderDetailEoMap, Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap, Map<String, InOutResultOrderDetailEo> outResultOrderDetailEoMap, List<DispatcherOrderDetailEo> list, Map<String, ItemDataQueryRespDto> finalItemMap) {
        ArrayList details = new ArrayList();
        csOutNoticeOrderDetailEos.forEach(dto -> {
            String key = dto.getDocumentNo() + InventoryConfig.getCommonSeparate() + dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
            if (outNoticeOrderDetailEoMap.containsKey(key)) {
                InOutNoticeOrderDetailEo csOutNoticeOrderDetailEo = (InOutNoticeOrderDetailEo)outNoticeOrderDetailEoMap.get(key);
                DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
                TransferOrderDetailEo transferOrderDetailEo1 = (TransferOrderDetailEo)transferOrderDetailEoMap.get(dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch()));
                this.packageDispathcerDetail(dispatcherOrderDetailEo, transferOrderDetailEo1);
                dispatcherOrderDetailEo.setInQuantity(csOutNoticeOrderDetailEo.getDoneQuantity());
                dispatcherOrderDetailEo.setOutQuantity(csOutNoticeOrderDetailEo.getPlanQuantity());
                dispatcherOrderDetailEo.setProcessedQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setCancelQuantity(csOutNoticeOrderDetailEo.getCancelQuantity());
                dispatcherOrderDetailEo.setProcessingQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                dispatcherOrderDetailEo.setOrderType(DocumentTypeEnum.DISPATCHER_ORDER.getCode());
                if (outResultOrderDetailEoMap.containsKey(key)) {
                    log.info("\u5165\u5e93\u901a\u77e5\u547d\u4e2d\u4e86\u5165\u5e93\u7ed3\u679ckey:{}", (Object)key);
                    InOutResultOrderDetailEo outResultOrderDetailEo = (InOutResultOrderDetailEo)outResultOrderDetailEoMap.get(key);
                    log.info("\u6536\u53d1\u5dee\u5f02\u5355\u65b0\u589eoutResultOrderDetailEo:{}", (Object)JSON.toJSONString((Object)outResultOrderDetailEo));
                    log.info("\u6536\u53d1\u5dee\u5f02\u5355\u65b0\u589ecsOutNoticeOrderDetailEo:{}", (Object)JSON.toJSONString((Object)csOutNoticeOrderDetailEo));
                    BigDecimal subtract = outResultOrderDetailEo.getDoneQuantity().subtract(csOutNoticeOrderDetailEo.getPlanQuantity());
                    dispatcherOrderDetailEo.setOutResultDocumentNo(outResultOrderDetailEo.getDocumentNo());
                    dispatcherOrderDetailEo.setDispatcherQuantity(subtract.abs());
                    dispatcherOrderDetailEo.setUntreatedQuantity(subtract.abs());
                    if (BigDecimal.ZERO.compareTo(subtract) > 0) {
                        dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                    } else if (BigDecimal.ZERO.compareTo(subtract) < 0) {
                        dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    }
                } else {
                    log.info("\u5165\u5e93\u901a\u77e5\u6ca1\u6709\u547d\u4e2d\u5165\u5e93\u7ed3\u679ckey:{}", (Object)key);
                    dispatcherOrderDetailEo.setDispatcherQuantity(dto.getPlanQuantity());
                    dispatcherOrderDetailEo.setUntreatedQuantity(dto.getPlanQuantity());
                    dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                }
                log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                calculateWeightAndVolumeDetailBo.setQuantity(dispatcherOrderDetailEo.getDispatcherQuantity());
                calculateWeightAndVolumeDetailBo.setUnit(dispatcherOrderDetailEo.getUnit());
                calculateWeightAndVolumeDetailBo.setSkuCode(dispatcherOrderDetailEo.getSkuCode());
                calculateWeightAndVolumeBo.setVolumeDetailBos(Arrays.asList(calculateWeightAndVolumeDetailBo));
                calculateWeightAndVolumeBo.setDocumentCode(transferOrderDetailEo1.getTransferOrderNo());
                calculateWeightAndVolumeBo.setCanTransferNum(true);
                Map<String, BasicOrderDtoExtension> map = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
                String str = this.getKey(dispatcherOrderDetailEo.getSkuCode(), dispatcherOrderDetailEo.getDispatcherQuantity());
                if (map.containsKey(str)) {
                    BasicOrderDtoExtension basicOrderDtoExtension = map.get(str);
                    dispatcherOrderDetailEo.setWeight(basicOrderDtoExtension.getWeight());
                    dispatcherOrderDetailEo.setVolume(basicOrderDtoExtension.getVolume());
                }
                if (dispatcherOrderDetailEo.getDispatcherQuantity().compareTo(BigDecimal.ZERO) > 0) {
                    log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                    list.add(dispatcherOrderDetailEo);
                }
            }
            list.addAll(details.stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getBatch() + InventoryConfig.getCommonSeparate() + r.getBusinessType(), Function.identity(), (k1, k2) -> {
                k1.setDispatcherQuantity(BigDecimalUtils.add((BigDecimal)k1.getDispatcherQuantity(), (BigDecimal)k2.getDispatcherQuantity()));
                k1.setUntreatedQuantity(BigDecimalUtils.add((BigDecimal)k1.getUntreatedQuantity(), (BigDecimal)k2.getUntreatedQuantity()));
                k1.setInQuantity(BigDecimalUtils.add((BigDecimal)k1.getInQuantity(), (BigDecimal)k2.getInQuantity()));
                k1.setOutQuantity(BigDecimalUtils.add((BigDecimal)k1.getOutQuantity(), (BigDecimal)k2.getOutQuantity()));
                k1.setCancelQuantity(BigDecimalUtils.add((BigDecimal)k1.getCancelQuantity(), (BigDecimal)k2.getCancelQuantity()));
                return k1;
            })).values());
        });
    }

    private void sendBackMore(List<InOutResultOrderDetailEo> csOutResultOrderDetailEos, Map<String, TransferOrderDetailEo> transferOrderDetailEoMap, Map<String, InOutNoticeOrderDetailEo> outNoticeOrderDetailEoMap, List<DispatcherOrderDetailEo> list, Map<String, ItemDataQueryRespDto> finalItemMap) {
        if (CollectionUtils.isNotEmpty(csOutResultOrderDetailEos)) {
            csOutResultOrderDetailEos.forEach(dto -> {
                String key = dto.getSkuCode() + InventoryConfig.getCommonSeparate() + (InventoryConfig.isNoneBatch() ? "" : dto.getBatch());
                if (outNoticeOrderDetailEoMap.containsKey(key)) {
                    return;
                }
                DispatcherOrderDetailEo dispatcherOrderDetailEo = new DispatcherOrderDetailEo();
                TransferOrderDetailEo transferOrderDetailEo1 = (TransferOrderDetailEo)transferOrderDetailEoMap.get(key);
                this.packageDispathcerDetail(dispatcherOrderDetailEo, transferOrderDetailEo1);
                dispatcherOrderDetailEo.setInQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setOutQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setDispatcherQuantity(dto.getDoneQuantity());
                dispatcherOrderDetailEo.setProcessedQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setCancelQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setUntreatedQuantity(dto.getDoneQuantity());
                dispatcherOrderDetailEo.setProcessingQuantity(BigDecimal.ZERO);
                dispatcherOrderDetailEo.setOrderType(DocumentTypeEnum.DISPATCHER_ORDER.getCode());
                dispatcherOrderDetailEo.setBusinessType(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                dispatcherOrderDetailEo.setOutResultDocumentNo(dto.getDocumentNo());
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
                IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
                calculateWeightAndVolumeDetailBo.setQuantity(dispatcherOrderDetailEo.getDispatcherQuantity());
                calculateWeightAndVolumeDetailBo.setUnit(dispatcherOrderDetailEo.getUnit());
                calculateWeightAndVolumeDetailBo.setSkuCode(dispatcherOrderDetailEo.getSkuCode());
                calculateWeightAndVolumeBo.setVolumeDetailBos(Arrays.asList(calculateWeightAndVolumeDetailBo));
                calculateWeightAndVolumeBo.setDocumentCode(transferOrderDetailEo1.getTransferOrderNo());
                calculateWeightAndVolumeBo.setCanTransferNum(true);
                Map<String, BasicOrderDtoExtension> map = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
                String str = this.getKey(dispatcherOrderDetailEo.getSkuCode(), dispatcherOrderDetailEo.getDispatcherQuantity());
                if (map.containsKey(str)) {
                    BasicOrderDtoExtension basicOrderDtoExtension = map.get(str);
                    dispatcherOrderDetailEo.setWeight(basicOrderDtoExtension.getWeight());
                    dispatcherOrderDetailEo.setVolume(basicOrderDtoExtension.getVolume());
                }
                dispatcherOrderDetailEo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
                log.info("\u5dee\u5f02\u5355\u591a\u6536\u65b0\u589e\u660e\u7ec6\u884c\uff1a{}", (Object)JSON.toJSONString((Object)dispatcherOrderDetailEo));
                list.add(dispatcherOrderDetailEo);
            });
        }
    }

    private void checkParams(String transferOrderNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)transferOrderNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private void packageDispathcer(DispatcherOrderEo eo, TransferOrderEo transferOrderEo) {
        eo.setTransferOrderNo(transferOrderEo.getTransferOrderNo());
        eo.setPreOrderNo(transferOrderEo.getPreOrderNo());
        eo.setParentOrderNo(transferOrderEo.getPreOrderNo());
        eo.setExternalPurchaseOrderNo(transferOrderEo.getExternalPurchaseOrderNo());
        eo.setExternalSaleOrderNo(transferOrderEo.getExternalSaleOrderNo());
        eo.setType(transferOrderEo.getType());
        eo.setOrderSrc(transferOrderEo.getOrderSrc());
        eo.setOutLogicWarehouseCode(transferOrderEo.getOutLogicWarehouseCode());
        eo.setOutLogicWarehouseName(transferOrderEo.getOutLogicWarehouseName());
        eo.setInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
        eo.setInLogicWarehouseName(transferOrderEo.getInLogicWarehouseName());
        eo.setOutPhysicsWarehouseCode(transferOrderEo.getOutPhysicsWarehouseCode());
        eo.setOutPhysicsWarehouseName(transferOrderEo.getOutPhysicsWarehouseName());
        eo.setInPhysicsWarehouseCode(transferOrderEo.getInPhysicsWarehouseCode());
        eo.setInPhysicsWarehouseName(transferOrderEo.getInPhysicsWarehouseName());
        eo.setOutOrganization(transferOrderEo.getOutOrganization());
        eo.setOutOrganizationId(transferOrderEo.getOutOrganizationId());
        eo.setInOrganization(transferOrderEo.getInOrganization());
        eo.setInOrganizationId(transferOrderEo.getInOrganizationId());
        eo.setRemark(transferOrderEo.getRemark());
        eo.setSourceSystem(transferOrderEo.getSourceSystem());
        eo.setSubType(transferOrderEo.getSubType());
        eo.setPlanInTime(transferOrderEo.getPlanInTime());
        eo.setPlanOutTime(transferOrderEo.getPlanOutTime());
        eo.setNoBatch(transferOrderEo.getNoBatch());
        eo.setInOrganizationCode(transferOrderEo.getInOrganizationCode());
        eo.setOutOrganizationCode(transferOrderEo.getOutOrganizationCode());
        eo.setIsSendEas(transferOrderEo.getIsSendEas());
        eo.setOrderStatus(CsDisPatcherOrderEnum.Status.WAIT.getCode());
        eo.setBizDate(new Date());
    }

    private void packageDispathcerDetail(DispatcherOrderDetailEo eo, TransferOrderDetailEo transferOrderDetailEo) {
        eo.setSkuCode(transferOrderDetailEo.getSkuCode());
        eo.setSkuName(transferOrderDetailEo.getSkuName());
        eo.setVolume(transferOrderDetailEo.getVolume());
        eo.setWeight(transferOrderDetailEo.getWeight());
        eo.setBatch(transferOrderDetailEo.getBatch());
        eo.setSpecification(transferOrderDetailEo.getSpecification());
        eo.setStorageCondition(transferOrderDetailEo.getStorageCondition());
        eo.setProductDate(transferOrderDetailEo.getProduceTime());
        eo.setDueDate(transferOrderDetailEo.getExpireTime());
        eo.setQuantity(transferOrderDetailEo.getQuantity());
        eo.setPlanQuantity(transferOrderDetailEo.getQuantity());
        eo.setUnit(transferOrderDetailEo.getUnit());
        eo.setInventoryProperty(transferOrderDetailEo.getInventoryProperty());
    }

    private List<ItemDataQueryRespDto> selectItem(List<String> itemCodeList) {
        return Optional.ofNullable(this.itemDataQueryHelper.getByCodes(itemCodeList)).map(list -> list.stream().map(itemSkuDto -> {
            ItemDataQueryRespDto respDto = new ItemDataQueryRespDto();
            respDto.setCode(itemSkuDto.getSkuCode());
            respDto.setName(itemSkuDto.getSkuName());
            respDto.setSpecifications(itemSkuDto.getSpecOne());
            respDto.setSaleUnit(itemSkuDto.getBasicUnit());
            return respDto;
        }).collect(Collectors.toList())).orElse(new ArrayList());
    }
}

