/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.inspection.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.DictEnum;
import com.yunxi.dg.base.center.enums.InspectionPassStatusEnum;
import com.yunxi.dg.base.center.enums.InspectionResultEnum;
import com.yunxi.dg.base.center.enums.OperationLogTypeEnum;
import com.yunxi.dg.base.center.enums.ValidFlagEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.DgInspectionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IDgInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInspectionPassDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInventoryBatchDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.request.inspection.InspectionRecordPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.InspectionPassEo;
import com.yunxi.dg.base.center.inventory.eo.InspectionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.InventoryBatchEo;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionPassService;
import com.yunxi.dg.base.center.inventory.service.business.inspection.IInspectionRecordService;
import com.yunxi.dg.base.center.inventory.service.codegenerate.CodeGenEnum;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.service.third.InspectionSystemBo;
import com.yunxi.dg.base.center.inventory.service.third.api.IInspectionSystemApi;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtListDgRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.components.optlog.core.utils.OptUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
class InspectionRecordServiceImpl
extends BaseServiceImpl<InspectionRecordDto, InspectionRecordEo, IDgInspectionRecordDomain>
implements IInspectionRecordService {
    private static final Logger log = LoggerFactory.getLogger(InspectionRecordServiceImpl.class);
    @Resource
    private IPcpDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private IInspectionPassDomain inspectionPassDomain;
    @Resource
    private IInspectionPassService inspectionPassService;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IInventoryBatchService inventoryBatchService;
    @Resource
    private IInventoryBatchDomain inventoryBatchDomain;
    @Resource
    private IInspectionSystemApi inspectionSystemApi;

    public InspectionRecordServiceImpl(IDgInspectionRecordDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InspectionRecordDto, InspectionRecordEo> converter() {
        return DgInspectionRecordConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void save(List<InspectionRecordDto> inspectionRecordDtoList, boolean judgmentStatus) {
        ArrayList<String> skuCodeList = new ArrayList<String>();
        ArrayList<String> batchList = new ArrayList<String>();
        this.checkParam(inspectionRecordDtoList, skuCodeList, batchList);
        List inspectionPassEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().in((Object)"sku_code", skuCodeList)).in((Object)"batch", batchList)).orderByDesc((Object)"id")).list()).orElse(new ArrayList());
        HashMap inspectionPassEoMap = new HashMap();
        inspectionPassEos.forEach(e -> {
            if (judgmentStatus) {
                AssertUtil.isTrue((InspectionPassStatusEnum.PART_PASS.getKey().equals(e.getPassStatus()) || InspectionPassStatusEnum.PASS.getKey().equals(e.getPassStatus()) ? 1 : 0) != 0, (String)"\u5df2\u653e\u884c/\u90e8\u5206\u653e\u884c\u65e0\u6cd5\u66f4\u6539\u8d28\u68c0\u7ed3\u679c");
            }
            String key = this.mapKey(e.getSkuCode(), e.getBatch());
            List inspectionPassEoList = Optional.ofNullable(inspectionPassEoMap.get(key)).orElse(new ArrayList());
            inspectionPassEoList.add(e);
            inspectionPassEoMap.put(key, inspectionPassEoList);
        });
        List itemSkuExtListDgRespDtos = Optional.ofNullable(this.itemSkuDgQueryApiProxy.querySkuExtBySkuCodes((List)Lists.newArrayList(skuCodeList))).orElse(new ArrayList());
        Map itemMap = itemSkuExtListDgRespDtos.stream().collect(Collectors.toMap(ItemSkuExtListDgRespDto::getSkuCode, Function.identity(), (K1, K2) -> K1));
        List inspectionRecordEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgInspectionRecordDomain)this.domain).filter().in((Object)"sku_code", skuCodeList)).in((Object)"batch", batchList)).orderByDesc((Object)"id")).list()).orElse(new ArrayList());
        Map inspectionRecordEoMap = inspectionRecordEos.stream().collect(Collectors.toMap(e -> this.mapKey(e.getSkuCode(), e.getBatch()), Function.identity(), (k1, k2) -> k1));
        ArrayList insertList = new ArrayList();
        ArrayList updateList = new ArrayList();
        ArrayList<InspectionPassEo> unEligibleList = new ArrayList<InspectionPassEo>();
        ArrayList<InspectionPassEo> addLog = new ArrayList<InspectionPassEo>();
        ArrayList<InventoryBatchReqDto> inventoryBatchReqDtos = new ArrayList<InventoryBatchReqDto>();
        inspectionRecordDtoList.stream().forEach(e -> {
            String mapKey = this.mapKey(e.getSkuCode(), e.getBatch());
            List inspectionPassEoList = (List)inspectionPassEoMap.get(mapKey);
            AssertUtil.isTrue((boolean)Objects.nonNull(inspectionPassEoList), (String)"\u8d28\u68c0\u653e\u884c\u65e0\u6b64\u4fe1\u606f");
            ItemSkuExtListDgRespDto itemSkuExtListDgRespDto = (ItemSkuExtListDgRespDto)itemMap.get(e.getSkuCode());
            AssertUtil.isTrue((boolean)Objects.nonNull(itemMap.get(e.getSkuCode())), (String)"\u6839\u636esku\u7f16\u7801\u627e\u4e0d\u5230\u76f8\u5173\u4fe1\u606f\uff1a{}", (String)e.getSkuCode());
            e.setSkuName(itemSkuExtListDgRespDto.getName());
            InspectionRecordEo inspectionRecordEo = (InspectionRecordEo)inspectionRecordEoMap.get(mapKey);
            if (Objects.isNull(inspectionRecordEo)) {
                inspectionRecordEo = new InspectionRecordEo();
                CubeBeanUtils.copyProperties((Object)inspectionRecordEo, (Object)e, (String[])new String[0]);
                insertList.add(inspectionRecordEo);
            } else {
                inspectionRecordEo.setInspectionReport(e.getInspectionReport());
                inspectionRecordEo.setInspectionResult(e.getInspectionResult());
                inspectionRecordEo.setQualityInspector(e.getQualityInspector());
                inspectionRecordEo.setInspectionResultTime(e.getInspectionResultTime());
                updateList.add(inspectionRecordEo);
            }
            inspectionRecordEo.setSystemReceiveInspectionResultTime(new Date());
            this.setInventoryBatchDtos(inventoryBatchReqDtos, inspectionRecordEo);
            if (InspectionResultEnum.UN_ELIGIBLE.getKey().equals(inspectionRecordEo.getInspectionResult())) {
                unEligibleList.addAll(inspectionPassEoList);
            }
            addLog.addAll(inspectionPassEoList);
        });
        if (CollectionUtils.isNotEmpty(insertList)) {
            ((IDgInspectionRecordDomain)this.domain).insertBatch(insertList);
        }
        if (CollectionUtils.isNotEmpty(updateList)) {
            ((IDgInspectionRecordDomain)this.domain).getMapper().updateBatchByIds(updateList);
        }
        this.updateInspectionPassStatus(unEligibleList);
        this.inventoryBatchService.save(inventoryBatchReqDtos, false);
        this.addLog(addLog, OperationLogTypeEnum.IMPORT_INSPECTION_RECORD, "EMPTY");
    }

    private void updateInspectionPassStatus(List<InspectionPassEo> unEligibleList) {
        if (CollectionUtils.isEmpty(unEligibleList)) {
            return;
        }
        unEligibleList.stream().filter(e -> InspectionPassStatusEnum.WAIT_PASS.getKey().equals(e.getPassStatus())).forEach(e -> this.inspectionPassService.updateStatus(e.getId(), InspectionPassStatusEnum.DISQUALIFICATION.getKey()));
    }

    private void setInventoryBatchDtos(List<InventoryBatchReqDto> inventoryBatchReqDtos, InspectionRecordEo e) {
        InventoryBatchReqDto inventoryBatchReqDto = new InventoryBatchReqDto();
        inventoryBatchReqDto.setBatch(e.getBatch());
        inventoryBatchReqDto.setSkuCode(e.getSkuCode());
        inventoryBatchReqDto.setInspectionResult(e.getInspectionResult());
        inventoryBatchReqDto.setInspectionTime(e.getInspectionResultTime());
        inventoryBatchReqDtos.add(inventoryBatchReqDto);
    }

    @NotNull
    private String mapKey(String skuCode, String batch) {
        return skuCode + InventoryConfig.getCommonSeparate() + batch;
    }

    private void checkParam(List<InspectionRecordDto> dtos, List<String> skuCodeList, List<String> batchList) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(dtos), (String)"\u65b0\u589e\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        dtos.stream().forEach(e -> {
            AssertUtil.isTrue((boolean)Objects.nonNull(e), (String)"\u64cd\u4f5c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getSkuCode()), (String)"SKU\u7f16\u7801\u672a\u586b\u5199");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getBatch()), (String)"\u6279\u6b21\u53f7\u672a\u586b\u5199");
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)e.getInspectionResult()), (String)"\u8d28\u68c0\u7ed3\u679c\u672a\u586b\u5199");
            if (StringUtils.isNotBlank((CharSequence)e.getInspectionReport())) {
                AssertUtil.isTrue((boolean)e.getInspectionReport().startsWith("http"), (String)"\u8be5\u7f51\u5740\u4e0d\u662fhttp\u5f00\u5934\uff0c\u65e0\u6cd5\u8bc6\u522b");
            }
            AssertUtil.isTrue((boolean)Objects.nonNull(InspectionResultEnum.getByKey((String)e.getInspectionResult())), (String)"\u8d28\u68c0\u7ed3\u679c\u586b\u5199\u6709\u8bef");
            skuCodeList.add(e.getSkuCode());
            batchList.add(e.getBatch());
        });
    }

    @Override
    public PageInfo<InspectionRecordDto> queryPage(InspectionRecordPageReqDto dto) {
        PageInfo inspectionRecordEoPage = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgInspectionRecordDomain)this.domain).filter().eq(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), (Object)"sku_code", (Collection)dto.getSkuCodeList())).in(CollectionUtil.isNotEmpty((Collection)dto.getBatchList()), (Object)"batch", (Collection)dto.getBatchList())).page(dto.getPageNum(), dto.getPageSize());
        PageInfo inspectionRecordDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)inspectionRecordDtoPageInfo, (Object)inspectionRecordEoPage, (String[])new String[]{"list", "navigatepageNums"});
        List inspectionRecordDtoList = inspectionRecordEoPage.getList().stream().map(r -> {
            InspectionRecordDto inspectionRecordDto = new InspectionRecordDto();
            CubeBeanUtils.copyProperties((Object)inspectionRecordDto, (Object)r, (String[])new String[0]);
            return inspectionRecordDto;
        }).collect(Collectors.toList());
        inspectionRecordDtoPageInfo.setList(inspectionRecordDtoList);
        return inspectionRecordDtoPageInfo;
    }

    @Override
    public List<InspectionRecordDto> queryList(InspectionRecordPageReqDto dto) {
        List inspectionRecordEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgInspectionRecordDomain)this.domain).filter().eq(StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (Object)"sku_code", (Object)dto.getSkuCode())).eq(StringUtils.isNotBlank((CharSequence)dto.getSkuName()), (Object)"sku_name", (Object)dto.getSkuName())).eq(StringUtils.isNotBlank((CharSequence)dto.getBatch()), (Object)"batch", (Object)dto.getBatch())).in(CollectionUtil.isNotEmpty((Collection)dto.getSkuCodeList()), (Object)"sku_code", (Collection)dto.getSkuCodeList())).in(CollectionUtil.isNotEmpty((Collection)dto.getBatchList()), (Object)"batch", (Collection)dto.getBatchList())).list();
        List list = this.converter().toDtoList(inspectionRecordEos);
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void clear(InspectionRecordDto dto) {
        List unEligibleInspectionPassEos;
        AssertUtil.isTrue((Objects.nonNull(dto) && StringUtils.isNotBlank((CharSequence)dto.getSkuCode()) && StringUtils.isNotBlank((CharSequence)dto.getBatch()) ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List inspectionPassEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().eq((Object)"sku_code", (Object)dto.getSkuCode())).eq((Object)"batch", (Object)dto.getBatch())).list();
        if (CollectionUtils.isNotEmpty((Collection)inspectionPassEos)) {
            inspectionPassEos.forEach(e -> {
                AssertUtil.isTrue((InspectionPassStatusEnum.DISQUALIFICATION.getKey().equals(e.getPassStatus()) || InspectionPassStatusEnum.WAIT_PASS.getKey().equals(e.getPassStatus()) ? 1 : 0) != 0, (String)"\u8d28\u68c0\u653e\u884c\u72b6\u6001\u4e3a\u5f85\u653e\u884c\u6216\u4e0d\u5408\u683c\u624d\u80fd\u6267\u884c\u6e05\u7a7a\u64cd\u4f5c");
                AssertUtil.isTrue((boolean)BigDecimalUtils.equals((BigDecimal)e.getWaitQuantity(), (BigDecimal)e.getQuantity()), (String)"\u5f85\u5904\u7406\u6570\u91cf=\u8d28\u68c0\u5e93\u5b58\u6570\u91cf\u624d\u80fd\u6267\u884c\u6e05\u7a7a\u64cd\u4f5c");
            });
        }
        InspectionRecordEo inspectionRecordEo = (InspectionRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgInspectionRecordDomain)this.domain).filter().eq((Object)"sku_code", (Object)dto.getSkuCode())).eq((Object)"batch", (Object)dto.getBatch())).orderByDesc((Object)"id")).last(" limit 1")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(inspectionRecordEo), (String)"\u8d28\u68c0\u7ed3\u679c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u7a7a\u3002");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inspectionRecordEo.getInspectionResult()), (String)"\u8d28\u68c0\u7ed3\u679c\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u6e05\u7a7a\u3002");
        ArrayList<InspectionPassEo> addLog = new ArrayList<InspectionPassEo>();
        if (InspectionResultEnum.UN_ELIGIBLE.getKey().equals(inspectionRecordEo.getInspectionResult()) && CollectionUtils.isNotEmpty((Collection)inspectionPassEos) && CollectionUtils.isNotEmpty(unEligibleInspectionPassEos = inspectionPassEos.stream().filter(e -> Objects.equals(e.getPassStatus(), InspectionPassStatusEnum.DISQUALIFICATION.getKey())).collect(Collectors.toList()))) {
            unEligibleInspectionPassEos.stream().forEach(e -> {
                addLog.add((InspectionPassEo)e);
                this.inspectionPassService.updateStatus(e.getId(), InspectionPassStatusEnum.WAIT_PASS.getKey());
            });
        }
        inspectionRecordEo.setInspectionResult(null);
        inspectionRecordEo.setInspectionReport(null);
        inspectionRecordEo.setInspectionResultTime(null);
        inspectionRecordEo.setSystemReceiveInspectionResultTime(null);
        inspectionRecordEo.setQualityInspector(null);
        ((IDgInspectionRecordDomain)this.domain).update((BaseEo)inspectionRecordEo);
        this.clearInventoryBatchInspectionData(inspectionRecordEo);
        this.clearInspectionSystemData(dto);
        this.addLog(addLog, OperationLogTypeEnum.CLEAR, "EMPTY");
    }

    private void addLog(List<InspectionPassEo> addLog, OperationLogTypeEnum operationLogTypeEnum, String remark) {
        if (CollectionUtils.isEmpty(addLog)) {
            return;
        }
        addLog.forEach(e -> OptUtil.addOptLog((String)operationLogTypeEnum.name(), (String)remark, (String)e.getInspectionNo(), (String)CodeGenEnum.INSPECTION_PASS_ORDER.getCode()));
    }

    private void clearInspectionSystemData(InspectionRecordDto dto) {
        String enableStatus = this.dockingInspectionSystem();
        if (ValidFlagEnum.ENABLE.getCode().equals(enableStatus)) {
            InspectionSystemBo bo = new InspectionSystemBo();
            bo.setBatch(dto.getBatch());
            bo.setSkuCode(dto.getSkuCode());
            ArrayList<InspectionSystemBo> list = new ArrayList<InspectionSystemBo>();
            list.add(bo);
            RestResponseHelper.extractData(this.inspectionSystemApi.clear(list));
        }
    }

    private void clearInventoryBatchInspectionData(InspectionRecordEo inspectionRecordEo) {
        InventoryBatchEo inventoryBatchEo = (InventoryBatchEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inventoryBatchDomain.filter().eq((Object)"sku_code", (Object)inspectionRecordEo.getSkuCode())).eq((Object)"batch", (Object)inspectionRecordEo.getBatch())).orderByDesc((Object)"id")).last(" limit 1")).one();
        if (Objects.nonNull(inventoryBatchEo)) {
            inventoryBatchEo.setInspectionResult(null);
            inventoryBatchEo.setInspectionTime(null);
            this.inventoryBatchDomain.update((BaseEo)inventoryBatchEo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void samplingMark(InspectionRecordDto dto) {
        InspectionRecordEo inspectionRecordEo = this.checkSamplingMarkParam(dto);
        inspectionRecordEo.setRemark(dto.getRemark());
        inspectionRecordEo.setInspectionResult(InspectionResultEnum.UN_ELIGIBLE.getKey());
        inspectionRecordEo.setQualityInspector(null);
        ((IDgInspectionRecordDomain)this.domain).update((BaseEo)inspectionRecordEo);
        ArrayList<InventoryBatchReqDto> inventoryBatchReqDtos = new ArrayList<InventoryBatchReqDto>();
        this.setInventoryBatchDtos(inventoryBatchReqDtos, inspectionRecordEo);
        this.inventoryBatchService.save(inventoryBatchReqDtos, false);
        List inspectionPassEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().eq((Object)"sku_code", (Object)inspectionRecordEo.getSkuCode())).eq((Object)"batch", (Object)inspectionRecordEo.getBatch())).eq((Object)"pass_status", (Object)InspectionPassStatusEnum.PASS.getKey())).list()).orElse(new ArrayList());
        if (CollectionUtils.isNotEmpty((Collection)inspectionPassEos)) {
            inspectionPassEos.forEach(e -> e.setSamplingMark(Integer.valueOf(1)));
            this.inspectionPassDomain.getMapper().updateBatchByIds(inspectionPassEos);
        }
        this.addLog(inspectionPassEos, OperationLogTypeEnum.SAMPLING_MARK, StringUtils.isNotBlank((CharSequence)dto.getRemark()) ? dto.getRemark() : "EMPTY");
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void unmark(InspectionRecordDto dto) {
        InspectionRecordEo inspectionRecordEo = this.checkSamplingMarkParam(dto);
        inspectionRecordEo.setRemark(null);
        inspectionRecordEo.setInspectionResult(InspectionResultEnum.ELIGIBLE.getKey());
        ((IDgInspectionRecordDomain)this.domain).update((BaseEo)inspectionRecordEo);
        ArrayList<InventoryBatchReqDto> inventoryBatchReqDtos = new ArrayList<InventoryBatchReqDto>();
        this.setInventoryBatchDtos(inventoryBatchReqDtos, inspectionRecordEo);
        this.inventoryBatchService.save(inventoryBatchReqDtos, false);
        List inspectionPassEos = Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inspectionPassDomain.filter().eq((Object)"sku_code", (Object)inspectionRecordEo.getSkuCode())).eq((Object)"batch", (Object)inspectionRecordEo.getBatch())).list()).orElse(new ArrayList());
        this.addLog(inspectionPassEos, OperationLogTypeEnum.UNMARK, "EMPTY");
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void acquire(List<InspectionRecordDto> inspectionRecordDtoList, boolean judgmentStatus) {
        log.info("\u83b7\u53d6\u8d28\u68c0\u7ed3\u679c\u8bb0\u5f55\u8868\u6570\u636e:{}", (Object)JSON.toJSONString(inspectionRecordDtoList));
        String enableStatus = this.dockingInspectionSystem();
        if (!ValidFlagEnum.ENABLE.getCode().equals(enableStatus)) {
            throw new BizException("\u6ca1\u6709\u5bf9\u63a5\u8d28\u68c0\u7cfb\u7edf\uff0c\u65e0\u6cd5\u83b7\u53d6\u8d28\u68c0\u7ed3\u679c");
        }
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(inspectionRecordDtoList), (String)"\u83b7\u53d6\u8d28\u68c0\u7ed3\u679c\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        HashMap map = new HashMap();
        inspectionRecordDtoList.forEach(e -> {
            AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getSkuCode()), (String)"sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)e.getBatch()), (String)"\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            InspectionSystemBo bo = new InspectionSystemBo();
            bo.setSkuCode(e.getSkuCode());
            bo.setBatch(e.getBatch());
            map.put(e.getSkuCode() + e.getBatch(), bo);
        });
        if (map.isEmpty()) {
            return;
        }
        AssertUtil.isTrue((map.size() < 11 ? 1 : 0) != 0, (String)"\u6bcf\u6b21\u83b7\u53d6\u4e0d\u80fd\u8d85\u8fc710\u6761\u3002");
        List dtos = (List)RestResponseHelper.extractData(this.inspectionSystemApi.queryByList(Lists.newArrayList(map.values())));
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return;
        }
        this.save(dtos, judgmentStatus);
    }

    private String dockingInspectionSystem() {
        DictDto dictDto = this.dictQueryApiProxy.querySameTableByGroupCodeAndCode(DictEnum.DOCKING_INSPECTION_SYSTEM.getGroupCode(), DictEnum.DOCKING_INSPECTION_SYSTEM.getCode());
        log.info("\u6839\u636e\u8d28\u68c0\u653e\u884c\u914d\u7f6ecode\u3010{}\u3011\u83b7\u53d6\u5b57\u5178\u8868\u4fe1\u606f\uff1a{}", (Object)DictEnum.DOCKING_INSPECTION_SYSTEM.getCode(), (Object)JSON.toJSONString((Object)dictDto));
        return Objects.nonNull(dictDto) ? dictDto.getValue() : null;
    }

    @Override
    @Transactional
    public void acquire(Date startDate, boolean judgmentStatus) {
        log.info("\u83b7\u53d6\u8d28\u68c0\u7ed3\u679c\u8bb0\u5f55\u8868\u6570\u636e:{}", (Object)JSON.toJSONString((Object)startDate));
        Date now = new Date();
        Date tenDaysAgo = DateUtil.addDays((Date)now, (int)-10);
        AssertUtil.isTrue((boolean)startDate.after(tenDaysAgo), (String)"\u8d77\u59cb\u65e5\u671f\u8d85\u8fc710\u5929\u4e0d\u53ef\u4ee5\u9009\u4e2d\u3002");
        String enableStatus = this.dockingInspectionSystem();
        if (!ValidFlagEnum.ENABLE.getCode().equals(enableStatus)) {
            throw new BizException("\u6ca1\u6709\u5bf9\u63a5\u8d28\u68c0\u7cfb\u7edf\uff0c\u65e0\u6cd5\u83b7\u53d6\u8d28\u68c0\u7ed3\u679c");
        }
        List dtos = (List)RestResponseHelper.extractData(this.inspectionSystemApi.queryByDate(startDate, now));
        if (CollectionUtils.isEmpty((Collection)dtos)) {
            return;
        }
        this.save(dtos, judgmentStatus);
    }

    @NotNull
    private InspectionRecordEo checkSamplingMarkParam(InspectionRecordDto dto) {
        AssertUtil.isTrue((boolean)Objects.nonNull(dto), (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getSkuCode()), (String)"sku\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dto.getBatch()), (String)"\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        InspectionRecordEo inspectionRecordEo = (InspectionRecordEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IDgInspectionRecordDomain)this.domain).filter().eq((Object)"sku_code", (Object)dto.getSkuCode())).eq((Object)"batch", (Object)dto.getBatch())).orderByDesc((Object)"id")).last(" limit 1")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(inspectionRecordEo), (String)"\u627e\u4e0d\u5230\u8d28\u68c0\u7ed3\u679c\u4fe1\u606f");
        return inspectionRecordEo;
    }
}

