/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderStatisticsDto;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.transfer.TransferOrderDispatcherComponent;
import com.yunxi.dg.base.center.inventory.service.business.transfer.action.TransferOrderCompleteAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.AbstractTransferAction;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.ReceiveStateMachinePersist;
import com.yunxi.dg.base.center.inventory.service.business.transfer.stateMachine.TransferOrderApprovalStateMachineConfig;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveEvent;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.StateMachinePersist;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.EnumStateMachineConfigurerAdapter;
import org.springframework.statemachine.config.builders.StateMachineConfigurationConfigurer;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.statemachine.guard.Guard;
import org.springframework.statemachine.listener.StateMachineListener;
import org.springframework.statemachine.listener.StateMachineListenerAdapter;
import org.springframework.statemachine.persist.DefaultStateMachinePersister;
import org.springframework.statemachine.persist.StateMachinePersister;

@Configuration
@EnableStateMachineFactory(name={"receiveStateMachine"})
public class TransferOrderReceiveStateMachineConfig
extends EnumStateMachineConfigurerAdapter<TransferOrderReceiveState, TransferOrderReceiveEvent> {
    private static final Logger logger = LoggerFactory.getLogger(TransferOrderApprovalStateMachineConfig.class);
    @Resource
    private TransferOrderCompleteAction transferOrderCompleteAction;
    @Resource
    private TransferOrderDispatcherComponent transferOrderDispatcherComponent;
    @Resource
    private ReceiveStateMachinePersist receiveStateMachinePersist;
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Resource
    private ICommonsMqService commonsMqService;

    public void configure(StateMachineConfigurationConfigurer<TransferOrderReceiveState, TransferOrderReceiveEvent> config) throws Exception {
        config.withConfiguration().autoStartup(true).machineId("receiveStateMachine").autoStartup(true).listener((StateMachineListener)new StateMachineListenerAdapter<TransferOrderReceiveState, TransferOrderReceiveEvent>(){

            public void stateMachineError(StateMachine stateMachine, Exception exception) {
                stateMachine.getExtendedState().getVariables().put("errMsg", exception.getMessage());
                logger.info("\u72b6\u6001\u673a\u6267\u884c\u5f02\u5e38:{}", (Object)exception.getMessage());
            }
        });
    }

    public void configure(StateMachineStateConfigurer<TransferOrderReceiveState, TransferOrderReceiveEvent> states) throws Exception {
        states.withStates().initial((Object)TransferOrderReceiveState.WAITING_FOR_DELIVERY, this.transferOrderSendMq()).state((Object)TransferOrderReceiveState.RECEIVED, this.transferOrderSendMq()).state((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED, this.transferOrderSendMq()).state((Object)TransferOrderReceiveState.COMPLETED, this.transferOrderSendMq()).choice((Object)TransferOrderReceiveState.RECEIVE_CHOICE).state((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED_COMPLETED, this.transferOrderSendMq());
    }

    public void configure(StateMachineTransitionConfigurer<TransferOrderReceiveState, TransferOrderReceiveEvent> transitions) throws Exception {
        ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)((StateMachineTransitionConfigurer)((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)TransferOrderReceiveState.WAITING_FOR_DELIVERY)).target((Object)TransferOrderReceiveState.RECEIVE_CHOICE).event((Object)TransferOrderReceiveEvent.RECEIVE)).and()).withExternal().source((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED)).target((Object)TransferOrderReceiveState.RECEIVE_CHOICE).event((Object)TransferOrderReceiveEvent.RECEIVE)).and()).withChoice().source((Object)TransferOrderReceiveState.RECEIVE_CHOICE).first((Object)TransferOrderReceiveState.RECEIVED, this.isAllReceive(), this.getAction()).then((Object)TransferOrderReceiveState.COMPLETED, this.isFinishReceive(), this.getOrderReceiveStateTransferOrderReceiveEventAction()).last((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED, this.getTransferOrderReceiveStateTransferOrderReceiveEventAction()).and()).withExternal().source((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED)).target((Object)TransferOrderReceiveState.PARTIALLY_RECEIVED_COMPLETED).event((Object)TransferOrderReceiveEvent.COMPLETE)).guard(context -> true)).action(this.getOrderReceiveStateTransferOrderReceiveEventAction())).action(this.getTransferOrderEo())).and()).withExternal().source((Object)TransferOrderReceiveState.WAITING_FOR_DELIVERY)).event((Object)TransferOrderReceiveEvent.COMPLETE)).target((Object)TransferOrderReceiveState.COMPLETED).guard(context -> true)).action(this.getOrderReceiveStateTransferOrderReceiveEventAction())).action(this.getTransferOrderEo());
    }

    @NotNull
    private Action<TransferOrderReceiveState, TransferOrderReceiveEvent> getTransferOrderEo() {
        return new AbstractTransferAction<TransferOrderReceiveState, TransferOrderReceiveEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context) {
                TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
                TransferOrderReceiveStateMachineConfig.this.transferOrderDispatcherComponent.dispatcherTransferOrder(transferOrderEo.getTransferOrderNo());
            }
        };
    }

    @NotNull
    private Action<TransferOrderReceiveState, TransferOrderReceiveEvent> getOrderReceiveStateTransferOrderReceiveEventAction() {
        return new AbstractTransferAction<TransferOrderReceiveState, TransferOrderReceiveEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context) {
                TransferOrderReceiveStateMachineConfig.this.transferOrderCompleteAction.complete(context);
            }
        };
    }

    private Action<TransferOrderReceiveState, TransferOrderReceiveEvent> getTransferOrderReceiveStateTransferOrderReceiveEventAction() {
        return new AbstractTransferAction<TransferOrderReceiveState, TransferOrderReceiveEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context) {
                ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
                String transferOrderNo = receiveDeliveryResultOrderContext.getRelevanceNo();
                TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)TransferOrderReceiveStateMachineConfig.this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
                transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.PARTIALLY_RECEIVED.getCode());
                TransferOrderStatisticsDto statisticsDto = TransferOrderReceiveStateMachineConfig.this.transferOrderDetailDomain.statisticsByTransferOrderNo(transferOrderNo);
                if (statisticsDto != null) {
                    transferOrderEo.setOutboundTotalQuantity(statisticsDto.getOutboundTotalQuantity());
                    transferOrderEo.setInboundTotalQuantity(statisticsDto.getInboundTotalQuantity());
                    transferOrderEo.setTotalVolume(statisticsDto.getTotalVolume());
                    transferOrderEo.setTotalWeight(statisticsDto.getTotalWeight());
                }
                if (TransferOrderDeliveryState.PARTIALLY_DELIVERED.getCode().equals(transferOrderEo.getShipmentStatus()) || TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode().equals(transferOrderEo.getShipmentStatus())) {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.PARTIALLY_DELIVERED_PARTIALLY_RECEIVED.code());
                } else {
                    transferOrderEo.setOrderStatus(TransferOrderStatus.ALL_DELIVERED_PARTIALLY_RECEIVED.code());
                }
                TransferOrderReceiveStateMachineConfig.this.transferOrderDomain.updateSelective((BaseEo)transferOrderEo);
                TransferOrderReceiveStateMachineConfig.this.transferOrderDetailDomain.updateTransferOrderDetailQuantity(receiveDeliveryResultOrderContext.getReceiveDeliveryResultOrderDetailEoList(), transferOrderEo);
                TransferOrderReceiveStateMachineConfig.this.pushSap(receiveDeliveryResultOrderContext);
            }
        };
    }

    private Action<TransferOrderReceiveState, TransferOrderReceiveEvent> getAction() {
        return new AbstractTransferAction<TransferOrderReceiveState, TransferOrderReceiveEvent>(){

            @Override
            protected void doExecute(StateContext<TransferOrderReceiveState, TransferOrderReceiveEvent> context) {
                ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
                String transferOrderNo = receiveDeliveryResultOrderContext.getRelevanceNo();
                TransferOrderEo transferOrderEo = (TransferOrderEo)((ExtQueryChainWrapper)TransferOrderReceiveStateMachineConfig.this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).one();
                transferOrderEo.setDeliveryStatus(TransferOrderReceiveState.RECEIVED.getCode());
                transferOrderEo.setOrderStatus(TransferOrderStatus.COMPLETED.code());
                TransferOrderStatisticsDto statisticsDto = TransferOrderReceiveStateMachineConfig.this.transferOrderDetailDomain.statisticsByTransferOrderNo(transferOrderNo);
                if (statisticsDto != null) {
                    transferOrderEo.setOutboundTotalQuantity(statisticsDto.getOutboundTotalQuantity());
                    transferOrderEo.setInboundTotalQuantity(statisticsDto.getInboundTotalQuantity());
                    transferOrderEo.setTotalVolume(statisticsDto.getTotalVolume());
                    transferOrderEo.setTotalWeight(statisticsDto.getTotalWeight());
                }
                TransferOrderReceiveStateMachineConfig.this.transferOrderDetailDomain.statisticsDispatcherByTransferOrderNo(transferOrderNo, true, InventoryConfig.isDispatchOrderBatch());
                TransferOrderReceiveStateMachineConfig.this.transferOrderDomain.updateSelective((BaseEo)transferOrderEo);
                TransferOrderReceiveStateMachineConfig.this.transferOrderDispatcherComponent.dispatcherTransferOrder(transferOrderEo.getTransferOrderNo());
                TransferOrderReceiveStateMachineConfig.this.pushSap(receiveDeliveryResultOrderContext);
            }
        };
    }

    private void pushSap(ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext) {
        if (InventoryConfig.getPushSapAble().canPush(PushAble.CanPushBo.builder().build())) {
            InventoryConfig.getPushSapAble().push(receiveDeliveryResultOrderContext);
        }
    }

    @NotNull
    private Guard<TransferOrderReceiveState, TransferOrderReceiveEvent> isAllReceive() {
        return context -> {
            ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
            return this.transferOrderDomain.isAllReceive(receiveDeliveryResultOrderContext.getRelevanceNo()) && this.transferOrderDomain.isAllShip(receiveDeliveryResultOrderContext.getRelevanceNo());
        };
    }

    @NotNull
    private Guard<TransferOrderReceiveState, TransferOrderReceiveEvent> isFinishReceive() {
        return context -> {
            ReceiveDeliveryResultOrderContext receiveDeliveryResultOrderContext = (ReceiveDeliveryResultOrderContext)context.getExtendedState().get((Object)"receiveDeliveryResultOrderContext", ReceiveDeliveryResultOrderContext.class);
            return this.transferOrderDomain.isFinishReceive(receiveDeliveryResultOrderContext.getRelevanceNo()) || this.transferOrderDomain.isFinishShip(receiveDeliveryResultOrderContext.getRelevanceNo());
        };
    }

    @Bean(name={"receiveStateMachinePersister"})
    public StateMachinePersister<TransferOrderReceiveState, TransferOrderReceiveEvent, String> receiveStateMachinePersister() {
        return new DefaultStateMachinePersister((StateMachinePersist)this.receiveStateMachinePersist);
    }

    @NotNull
    private Action<TransferOrderReceiveState, TransferOrderReceiveEvent> transferOrderSendMq() {
        return context -> InventoryConfig.registerSynchronizationAfterCommit(() -> {
            logger.info("\u8c03\u62e8\u5355\u72b6\u6001\u53d8\u66f4\u4e8b\u4ef6\u63a8\u9001");
            TransferOrderEo transferOrderEo = (TransferOrderEo)context.getExtendedState().get((Object)"transferOrderEo", TransferOrderEo.class);
            this.commonsMqService.publishMessage("PUBLISH_TOPIC", "PUSH_TRANSFER_ORDER", (Object)JSON.toJSONString((Object)transferOrderEo));
        });
    }
}

