/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BusinessCallBackStrategyEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.InventorySourceTypeEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.enums.OrderLineClassifyEnum;
import com.yunxi.dg.base.center.enums.PcpBasicTradeBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.PlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.TransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.dao.das.IPlanOrderDetailDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDetailDas;
import com.yunxi.dg.base.center.inventory.dao.mapper.TransferOrderMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IDispatcherOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IRelWarehouseDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsDisPatcherOrderEnum;
import com.yunxi.dg.base.center.inventory.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsOutNoticeOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.OutNoticeOrderPushStatusPostbackReqDto;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.DispatcherOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderDocumentTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.event.PushStatusPostbackEvent;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.InOutResultOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DiffOrderOptContext;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatchOperateBo;
import com.yunxi.dg.base.center.inventory.service.business.difforder.strategy.DispatcherOperateWayEnum;
import com.yunxi.dg.base.center.inventory.service.calc.ICalcInventoryService;
import com.yunxi.dg.base.center.inventory.service.commonsendback.CommonSendBackAble;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.DiffCalculateComponent;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.LogisticsMappingComponent;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.MatchLineNoBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.MatchLineNoComponent;
import com.yunxi.dg.base.center.inventory.service.commonsendback.component.ShipmentDisposeComponent;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeManager;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeMetaBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeResultBo;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutResultOrderService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.openapi.api.order.IProduceOrderQueryApi;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CommonSendBackAbleImpl
implements CommonSendBackAble {
    private static final Logger log = LoggerFactory.getLogger(CommonSendBackAbleImpl.class);
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private CommonSendBackAbleImpl commonSendBackAbleImpl;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;
    @Resource
    private ILogicWarehouseDomain logicWarehouseDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private TransferOrderMapper transferOrderMapper;
    @Resource
    private IRelWarehouseDomain relWarehouseDomain;
    @Resource
    private DiffCalculateComponent diffCalculateComponent;
    @Resource
    MatchLineNoComponent matchLineNoComponent;
    @Resource
    LogisticsMappingComponent logisticsMappingComponent;
    @Resource
    ShipmentDisposeComponent shipmentDisposeComponent;
    @Resource
    private OverchargeManager overchargeManager;
    @Resource
    private IDispatcherOrderDomain dispatcherOrderDomain;
    @Resource
    private ITransferOrderDomain transferOrderDomain;
    @Resource
    private ITransferOrderDetailDas transferOrderDetailDas;
    @Resource
    private IDispatcherOrderDetailDomain dispatcherOrderDetailDomain;
    @Resource
    private ICalcInventoryService calcInventoryService;
    @Resource
    private ILockService lockService;
    @Resource
    IInOutResultOrderService inOutResultOrderService;
    @Resource
    IPlanOrderDetailDas planOrderDetailDas;
    @Resource
    private IProduceOrderQueryApi produceOrderQueryApi;

    @Override
    public Boolean receiveIn(BasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        this.checkParams(basicsReceiveBasicsReqDto, true);
        String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        String orderType = BaseOrderOperateTypeEnum.ASSEMBLY_DISASSEMBLY.getCode().toLowerCase();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderNo)).in((Object)"order_type", (Collection)Lists.newArrayList((Object[])new String[]{"in", "in_out", orderType}))).list();
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        AssertUtil.isTrue((null != inOutNoticeOrderEo ? 1 : 0) != 0, (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u5355\u636e\u4fe1\u606f");
        if (BaseOrderStatusEnum.FINISH_OVER.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.INO_TOTAL_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus())) {
            return true;
        }
        AssertUtil.isTrue((!BaseOrderStatusEnum.INO_CANCEL.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5355\u636e\u5df2\u53d6\u6d88\uff0c\u4e0d\u80fd\u91cd\u590d\u5165\u5e93\u3002");
        String type99 = "_TYPE99";
        if (!StringUtils.isNotBlank((CharSequence)basicsReceiveBasicsReqDto.getWmsOrderNo()) || !basicsReceiveBasicsReqDto.getWmsOrderNo().contains(type99)) {
            AssertUtil.isTrue((BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.INO_PORTION_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.PROCESSING.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.PORTION_PROCESSING.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u975e\u5f85\u5165\u5e93\u548c\u90e8\u5206\u5165\u5e93\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u5165\u5e93\u56de\u4f20");
        }
        this.wmsOperate(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, true);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public Boolean pushStatusPostback(OutNoticeOrderPushStatusPostbackReqDto outNoticeOrderPushStatusPostbackReqDto) {
        String wmsOutInPhysicsWarehouseCode;
        log.info("\u5904\u7406\u5916\u90e8\u901a\u77e5\u8ba2\u5355\u63a8\u9001\u72b6\u6001\u56de\u8c03\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)outNoticeOrderPushStatusPostbackReqDto));
        String documentNo = outNoticeOrderPushStatusPostbackReqDto.getDocumentNo();
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        List inOutNoticeOrderEoList = this.inOutNoticeOrderDomain.getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)inOutNoticeOrderEoList)) {
            return true;
        }
        InOutNoticeOrderEo orgiEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        InOutNoticeOrderEo inOutNoticeOrderEo = new InOutNoticeOrderEo();
        inOutNoticeOrderEo.setId(orgiEo.getId());
        inOutNoticeOrderEo.setOrderType(orgiEo.getOrderType());
        inOutNoticeOrderEo.setWmsReturnId(outNoticeOrderPushStatusPostbackReqDto.getWmsReturnId());
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode(), BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.ONO_WAIT_OUT.getCode()});
        if (!orderStatusList.contains(orgiEo.getOrderStatus())) {
            inOutNoticeOrderEoQueryWrapper.clear();
            inOutNoticeOrderEo.setPushStatus(outNoticeOrderPushStatusPostbackReqDto.getPushStatus());
            inOutNoticeOrderEo.setPushMsg((String)DataExtractUtils.ifNullElse((Object)outNoticeOrderPushStatusPostbackReqDto.getPostbackInfo(), (Object)""));
            inOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)inOutNoticeOrderEo.getId());
            this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)inOutNoticeOrderEoQueryWrapper);
            return true;
        }
        String postbackInfo = outNoticeOrderPushStatusPostbackReqDto.getPostbackInfo();
        String already_exists = "\u5df2\u5b58\u5728";
        boolean filter = Boolean.FALSE;
        if (StringUtils.isNotEmpty((CharSequence)postbackInfo)) {
            filter = postbackInfo.contains(already_exists);
        }
        if (filter || !CsOutNoticePushStatusEnum.FAIL.getCode().equals(outNoticeOrderPushStatusPostbackReqDto.getPushStatus()) || !"out".equals(inOutNoticeOrderEo.getOrderType())) {
            if (CsOutNoticePushStatusEnum.SUCCESS.getCode().equals(outNoticeOrderPushStatusPostbackReqDto.getPushStatus())) {
                inOutNoticeOrderEo.setOrderStatus("out".equals(inOutNoticeOrderEo.getOrderType()) ? BaseOrderStatusEnum.ONO_WAIT_OUT.getCode() : BaseOrderStatusEnum.INO_WAIT_IN.getCode());
            } else if (filter && BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode().equals(orgiEo.getOrderStatus())) {
                inOutNoticeOrderEo.setOrderStatus("out".equals(inOutNoticeOrderEo.getOrderType()) ? BaseOrderStatusEnum.ONO_WAIT_OUT.getCode() : BaseOrderStatusEnum.INO_WAIT_IN.getCode());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(wmsOutInPhysicsWarehouseCode = outNoticeOrderPushStatusPostbackReqDto.getWmsOutInPhysicsWarehouseCode())) && "out".equals(inOutNoticeOrderEo.getOrderType())) {
            inOutNoticeOrderEo.setOutPhysicsWarehouseCode(wmsOutInPhysicsWarehouseCode);
        } else if (StringUtils.isNotEmpty((CharSequence)wmsOutInPhysicsWarehouseCode) && "in".equals(inOutNoticeOrderEo.getOrderType())) {
            inOutNoticeOrderEo.setInPhysicsWarehouseCode(wmsOutInPhysicsWarehouseCode);
        }
        if (StringUtils.isNotBlank((CharSequence)postbackInfo) && filter) {
            log.info("pushStatusPostback==>\u8fde\u63a5\u5668\u56de\u5199\u5355\u636e\u63a8\u9001\u7684\u72b6\u6001,\u5355\u636e\u5df2\u5b58\u5728,\u4e0d\u9700\u8981\u6539\u72b6\u6001:{}", (Object)postbackInfo);
            inOutNoticeOrderEoQueryWrapper.clear();
            inOutNoticeOrderEo.setPushStatus(CsOutNoticePushStatusEnum.SUCCESS.getCode());
            inOutNoticeOrderEo.setPushMsg("");
            inOutNoticeOrderEo.setPushTime((Date)new DateTime());
            inOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)inOutNoticeOrderEo.getId());
            this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)inOutNoticeOrderEoQueryWrapper);
        } else {
            inOutNoticeOrderEoQueryWrapper.clear();
            inOutNoticeOrderEo.setPushStatus(outNoticeOrderPushStatusPostbackReqDto.getPushStatus());
            inOutNoticeOrderEo.setPushMsg((String)DataExtractUtils.ifNullElse((Object)outNoticeOrderPushStatusPostbackReqDto.getPostbackInfo(), (Object)""));
            inOutNoticeOrderEo.setPushTime((Date)new DateTime());
            inOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)inOutNoticeOrderEo.getId());
            this.inOutNoticeOrderDomain.getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)inOutNoticeOrderEoQueryWrapper);
        }
        PushStatusPostbackEvent event = new PushStatusPostbackEvent(inOutNoticeOrderEo);
        InventoryConfig.pushEvent(event);
        return true;
    }

    private List<String> checkDetailInfo(boolean inOut, List<BasicsDetailReqDto> detailReqDtoList) {
        if (CollectionUtils.isEmpty(detailReqDtoList)) {
            return new ArrayList<String>();
        }
        for (BasicsDetailReqDto detailReqDto : detailReqDtoList) {
            BigDecimal quantity;
            String batch = detailReqDto.getBatch();
            AssertUtil.isTrue((InventoryConfig.isNoneBatch() || InventoryConfig.isPreemptHiddenBatch() || StringUtils.isNotBlank((CharSequence)batch) ? 1 : 0) != 0, (String)"\u5546\u54c1\u6279\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
            if (InventoryConfig.isNoneBatch() || inOut) {
                detailReqDto.setBatch((String)ObjectUtils.defaultIfNull((Object)detailReqDto.getBatch(), (Object)InventoryConfig.getDefaultBatch()));
            }
            AssertUtil.isTrue((null != (quantity = detailReqDto.getQuantity()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u6709\u8bef");
            String skuCode = detailReqDto.getSkuCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)skuCode), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return detailReqDtoList.stream().map(BasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
    }

    protected void checkParams(BasicsReceiveReqDto basicsReceiveBasicsReqDto, boolean inOut) {
        log.info("checkParams==>\u53c2\u6570\u6821\u9a8c,basicsReceiveBasicsReqDto:{}", (Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
        AssertUtil.isTrue((null != basicsReceiveBasicsReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String wmsOrderNo = basicsReceiveBasicsReqDto.getWmsOrderNo();
        String inNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)inNoticeOrderNo), (String)"\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inNoticeOrderNo)).last(" limit 1 ")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(outNoticeOrderEo), (String)"\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u53f7\u4e0d\u5b58\u5728");
        if (StringUtils.isBlank((CharSequence)basicsReceiveBasicsReqDto.getWarehouseCode())) {
            basicsReceiveBasicsReqDto.setWarehouseCode("in".equals(outNoticeOrderEo.getOrderType()) ? outNoticeOrderEo.getInLogicWarehouseCode() : outNoticeOrderEo.getOutLogicWarehouseCode());
        }
        List<BasicsDetailReqDto> detailReqDtoList = CommonSendBackAbleImpl.getDetailReqDtoList(basicsReceiveBasicsReqDto.getWarehouseCode(), basicsReceiveBasicsReqDto.getDetailReqDtoList());
        List<BasicsDetailReqDto> packageMaterialDetailReqDtoList = CommonSendBackAbleImpl.getDetailReqDtoList(basicsReceiveBasicsReqDto.getWarehouseCode(), basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList());
        AssertUtil.isTrue((CollectionUtils.isNotEmpty(detailReqDtoList) || CollectionUtils.isNotEmpty(packageMaterialDetailReqDtoList) ? 1 : 0) != 0, (String)"\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue((CollectionUtils.isNotEmpty(detailReqDtoList) && detailReqDtoList.stream().allMatch(ld -> ld.getQuantity() != null && BigDecimal.ZERO.compareTo(ld.getQuantity()) < 0) || CollectionUtils.isNotEmpty(packageMaterialDetailReqDtoList) && packageMaterialDetailReqDtoList.stream().allMatch(ld -> ld.getQuantity() != null && BigDecimal.ZERO.compareTo(ld.getQuantity()) < 0) ? 1 : 0) != 0, (String)"\u5546\u54c1\u660e\u7ec6\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
        List<String> longCodeList = this.checkDetailInfo(inOut, detailReqDtoList);
        List<String> packageMaterialLongCodeList = this.checkDetailInfo(inOut, packageMaterialDetailReqDtoList);
        if (CollectionUtils.isNotEmpty(packageMaterialLongCodeList)) {
            longCodeList.addAll(packageMaterialLongCodeList);
        }
        List itemList = this.itemDataQueryHelper.getByCodes(longCodeList);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(itemList), (String)"\u5546\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        List warehouseCodeList = detailReqDtoList.stream().map(BasicsDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(packageMaterialDetailReqDtoList)) {
            List packageMaterialWarehouseCodeList = packageMaterialDetailReqDtoList.stream().map(BasicsDetailReqDto::getWarehouseCode).distinct().collect(Collectors.toList());
            warehouseCodeList.addAll(packageMaterialWarehouseCodeList);
        }
        QueryWrapper logicWarehouseEoQueryWrapper = new QueryWrapper();
        logicWarehouseEoQueryWrapper.in((Object)"warehouse_code", warehouseCodeList);
        logicWarehouseEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        List csLogicWarehouseEoList = this.logicWarehouseDomain.getMapper().selectList((Wrapper)logicWarehouseEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)csLogicWarehouseEoList), (String)"\u4ed3\u5e93\u4fe1\u606f\u4e0d\u5b58\u5728");
    }

    @Nullable
    private static List<BasicsDetailReqDto> getDetailReqDtoList(String defaultWarehouseCode, List<BasicsDetailReqDto> detailReqDtoList) {
        return Optional.ofNullable(detailReqDtoList).map(list -> list.stream().peek(r -> r.setWarehouseCode((String)ObjectUtils.defaultIfNull((Object)r.getWarehouseCode(), (Object)defaultWarehouseCode))).collect(Collectors.toList())).orElse(detailReqDtoList);
    }

    @Override
    public Boolean receiveOut(BasicsReceiveReqDto basicsReceiveBasicsReqDto) {
        this.checkParams(basicsReceiveBasicsReqDto, true);
        String inOutNoticeOrderNo = basicsReceiveBasicsReqDto.getInOutNoticeOrderNo();
        List inOutNoticeOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderNo)).eq((Object)"order_type", (Object)"out")).list();
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        if (BaseOrderStatusEnum.ONO_TOTAL_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus())) {
            return Boolean.TRUE;
        }
        AssertUtil.isTrue((!BaseOrderStatusEnum.ONO_CANCEL.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) ? 1 : 0) != 0, (String)"\u5355\u636e\u5df2\u53d6\u6d88\uff0c\u4e0d\u80fd\u91cd\u590d\u51fa\u5e93\u3002");
        this.shipmentDisposeComponent.shipmentDispose(inOutNoticeOrderEo, basicsReceiveBasicsReqDto);
        this.wmsOperate(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, false);
        return Boolean.TRUE;
    }

    public void wmsOperate(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag) {
        HashSet<String> lockKeys = new HashSet<String>();
        lockKeys.add(inOutNoticeOrderEo.getRelevanceNo());
        this.loadAppendKey(inOutNoticeOrderEo, lockKeys);
        InventoryConfig.lockList(() -> {
            List outResultOrderEos;
            if (this.checkUnique(basicsReceiveBasicsReqDto.getWmsOrderNo())) {
                log.info("wms\u5355\u53f7\u5224\u65ad\u91cd\u590d:{}", (Object)basicsReceiveBasicsReqDto.getWmsOrderNo());
                throw new BizException("\u8be5\u5916\u90e8\u5355\u53f7\u5df2\u7ecf\u5b58\u5728:{}", basicsReceiveBasicsReqDto.getWmsOrderNo());
            }
            if (!inFlag.booleanValue() && !basicsReceiveBasicsReqDto.isWaitConfirm() && CollectionUtils.isNotEmpty((Collection)(outResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"pre_order_no", (Object)inOutNoticeOrderEo.getDocumentNo())).eq((Object)"order_type", (Object)"out")).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ORO_WAIT_CONFIRM.getCode())).list()))) {
                if (outResultOrderEos.size() > 1) {
                    throw new BizException("\u51fa\u5e93\u7ed3\u679c\u5355\u4fe1\u606f\u4e0d\u552f\u4e00");
                }
                this.inOutResultOrderService.confirmAndUpdate(basicsReceiveBasicsReqDto, (InOutResultOrderEo)outResultOrderEos.get(0));
                return true;
            }
            this.commonSendBackAbleImpl.doWmsOperate(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inFlag);
            return true;
        }, new ArrayList<String>(lockKeys), "wmsOperate", 60);
    }

    private void loadAppendKey(InOutNoticeOrderEo inOutNoticeOrderEo, Set<String> lockKeys) {
        List eos;
        if ("PURCHASE".equals(inOutNoticeOrderEo.getJumpDocumentType())) {
            eos = ((ExtQueryChainWrapper)this.planOrderDetailDas.filter().eq((Object)"order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).list();
            for (PlanOrderDetailEo eo : eos) {
                JSONObject ext;
                String reserveOrderNo;
                if (StringUtils.isEmpty((CharSequence)eo.getExtension()) || StringUtils.isEmpty((CharSequence)(reserveOrderNo = (ext = JSONObject.parseObject((String)eo.getExtension())).getString("reserveOrderNo")))) continue;
                lockKeys.add(reserveOrderNo);
            }
        }
        if ("transfer_order".equals(inOutNoticeOrderEo.getJumpDocumentType())) {
            eos = this.transferOrderDetailDas.queryByTransferOrderNo(inOutNoticeOrderEo.getRelevanceNo());
            ArrayList<String> apsNoList = new ArrayList<String>();
            for (TransferOrderDetailEo eo : eos) {
                JSONObject ext;
                String apsNo;
                if (StringUtils.isEmpty((CharSequence)eo.getExtension()) || StringUtils.isEmpty((CharSequence)(apsNo = (ext = JSONObject.parseObject((String)eo.getExtension())).getString("apsNo")))) continue;
                apsNoList.add(apsNo);
            }
            List produceOrderPageList = Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.produceOrderQueryApi.queryListByApsNoList(apsNoList))).orElse(new ArrayList());
            log.info("produceOrderPageInfo:{}", (Object)LogUtils.buildLogContent((Collection)produceOrderPageList));
            if (CollectionUtils.isNotEmpty((Collection)produceOrderPageList)) {
                produceOrderPageList.forEach(e -> lockKeys.add(e.getSourceOrderNo()));
            }
        }
    }

    private boolean checkUnique(String orderNo) {
        log.info("\u5355\u53f7\u5224\u65ad\u91cd\u590d:{}", (Object)orderNo);
        if (StringUtils.isNotBlank((CharSequence)orderNo)) {
            QueryWrapper csOutResultOrderEoQueryWrapper = new QueryWrapper();
            csOutResultOrderEoQueryWrapper.eq((Object)"wms_order_no", (Object)orderNo);
            csOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)0);
            csOutResultOrderEoQueryWrapper.ne((Object)"order_status", (Object)BaseOrderStatusEnum.ORO_WAIT_CONFIRM.getCode());
            List csOutResultOrderEoList = this.inOutResultOrderDomain.getMapper().selectList((Wrapper)csOutResultOrderEoQueryWrapper);
            return CollectionUtils.isNotEmpty((Collection)csOutResultOrderEoList);
        }
        return false;
    }

    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void doWmsOperate(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag) {
        Map<String, BasicsDetailReqDto> sumDetailMap;
        boolean isAssembly;
        log.info("inOutNoticeNo:{},inFlag:{}", (Object)basicsReceiveBasicsReqDto.getInOutNoticeOrderNo(), (Object)inFlag);
        AssertUtil.isTrue((null != inOutNoticeOrderEo ? 1 : 0) != 0, (String)"\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        if (this.dispathcherWmsOperateHandle(inOutNoticeOrderEo)) {
            return;
        }
        basicsReceiveBasicsReqDto.setIgnoreBatch(Boolean.valueOf(InventoryConfig.isNoneBatch()));
        String inOutStr = inFlag != false ? "\u5165\u5e93" : "\u51fa\u5e93";
        boolean adjust = "in_out".equals(inOutNoticeOrderEo.getOrderType());
        if (adjust) {
            inOutStr = "\u8c03\u6574";
        }
        if (isAssembly = CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.getCode().equals(inOutNoticeOrderEo.getBusinessType())) {
            inOutStr = "\u7ec4\u88c5\u62c6\u5378";
        }
        String noticeOrderNo = inOutNoticeOrderEo.getDocumentNo();
        log.info("\u51fa\u5165\u5e93\u56de\u4f20\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)basicsReceiveBasicsReqDto));
        log.info("\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,InOutNoticeOrderEo:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEo));
        List inOutNoticeOrderDetailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)noticeOrderNo)).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderDetailEoList), (String)(inOutStr + "\u901a\u77e5\u5355\u5546\u54c1\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728"));
        log.info("\u51fa\u5165\u5e93\u5e93\u56de\u4f20\u64cd\u4f5c,inOutNoticeOrderDetailEoList:{}", (Object)JSON.toJSONString((Object)inOutNoticeOrderDetailEoList));
        ArrayList originalOutNoticeOrderDetailRespList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)originalOutNoticeOrderDetailRespList, (Collection)inOutNoticeOrderDetailEoList, CsOutNoticeOrderDetailRespDto.class);
        BusinessCallBackStrategyEnum callBackStrategyEnum = BusinessCallBackStrategyEnum.getByTableName((String)inOutNoticeOrderEo.getRelevanceTableName());
        if (!InventoryConfig.isOrderLineCallbackProcess()) {
            sumDetailMap = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().collect(Collectors.toMap(e -> e.getSkuCode() + e.getInventoryProperty() + e.getBatch(), Function.identity(), CommonSendBackAbleImpl.mergeDetails()));
            log.info("sumDetailMap\uff1a{}", (Object)JSON.toJSONString(sumDetailMap));
            basicsReceiveBasicsReqDto.setDetailReqDtoList((List)Lists.newArrayList(sumDetailMap.values()));
        }
        this.matchLineNoComponent.matchLineNoMoreLine(new MatchLineNoBo(basicsReceiveBasicsReqDto.getDetailReqDtoList(), inOutNoticeOrderDetailEoList));
        basicsReceiveBasicsReqDto.setDetailReqDtoList(basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().filter(r -> BigDecimalUtils.gtZero((BigDecimal)r.getQuantity()) != false || Objects.nonNull(r.getLineNo())).peek(e -> e.setBatch(StringUtils.isNotBlank((CharSequence)e.getBatch()) ? e.getBatch().toUpperCase() : e.getBatch())).collect(Collectors.toList()));
        sumDetailMap = basicsReceiveBasicsReqDto.getDetailReqDtoList().stream().collect(Collectors.toMap(e -> "" + e.getLineNo() + e.getTradeOrderItemId() + e.getSkuCode() + e.getInventoryProperty() + e.getBatch(), Function.identity(), CommonSendBackAbleImpl.mergeDetails()));
        log.info("sumDetailMap\uff1a{}", (Object)JSON.toJSONString(sumDetailMap));
        basicsReceiveBasicsReqDto.setDetailReqDtoList((List)Lists.newArrayList(sumDetailMap.values()));
        OverchargeResultBo overchargeReason = this.overchargeManager.overchargeCheck(new OverchargeMetaBo(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getRelevanceTableName()), inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, basicsReceiveBasicsReqDto.getDetailReqDtoList(), basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList(), inFlag));
        this.diffCalculateComponent.diffCalculate(basicsReceiveBasicsReqDto, inOutNoticeOrderDetailEoList, callBackStrategyEnum, inOutNoticeOrderEo);
        this.generateInOutOrderInfo(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, inOutNoticeOrderDetailEoList, inFlag, basicsReceiveBasicsReqDto.getDetailReqDtoList(), overchargeReason);
    }

    @NotNull
    private static BinaryOperator<BasicsDetailReqDto> mergeDetails() {
        return (o1, o2) -> {
            o1.setQuantity(BigDecimalUtils.add((BigDecimal)o1.getQuantity(), (BigDecimal)o2.getQuantity()));
            o1.setWeight(BigDecimalUtils.add((BigDecimal)o1.getWeight(), (BigDecimal)o2.getWeight()));
            o1.setVolume(BigDecimalUtils.add((BigDecimal)o1.getVolume(), (BigDecimal)o2.getVolume()));
            if (CollectionUtils.isNotEmpty((Collection)o1.getSnCodes()) && CollectionUtils.isNotEmpty((Collection)o2.getSnCodes())) {
                o1.getSnCodes().addAll(o2.getSnCodes());
            }
            return o1;
        };
    }

    private void generateInOutOrderInfo(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutNoticeOrderEo inOutNoticeOrderEo, List<InOutNoticeOrderDetailEo> inOutNoticeOrderDetailEoList, Boolean inFlag, List<BasicsDetailReqDto> detailReqDtoList, OverchargeResultBo overchargeReason) {
        ItemSkuDto itemSkuDto;
        BaseOrderDetailReqDto detailReqDto;
        InOutResultOrderFacadeBo inOutResultOrderFacadeBo = new InOutResultOrderFacadeBo();
        inOutResultOrderFacadeBo.setFullBatchInOutResult(basicsReceiveBasicsReqDto.isFullBatchInOutResult());
        inOutResultOrderFacadeBo.setBizDate(ObjectUtil.isNull((Object)basicsReceiveBasicsReqDto.getBizDate()) ? inOutNoticeOrderEo.getBizDate() : basicsReceiveBasicsReqDto.getBizDate());
        inOutResultOrderFacadeBo.setInOutTime(basicsReceiveBasicsReqDto.getInOutTime());
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        this.handlerExtension(basicsReceiveBasicsReqDto, inOutResultOrderFacadeBo);
        inOutResultOrderFacadeBo.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutResultOrderFacadeBo.setInOutNoticeOrderDetailEos(inOutNoticeOrderDetailEoList);
        inOutResultOrderFacadeBo.setOverchargeQuantity(detailReqDtoList.stream().filter(a -> TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(BasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setReceivelessQuantity(detailReqDtoList.stream().filter(a -> TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(BasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
        inOutResultOrderFacadeBo.setDispatcherStatus(this.getDispatcherStatus(inOutResultOrderFacadeBo.getOverchargeQuantity(), inOutResultOrderFacadeBo.getReceivelessQuantity()));
        inOutResultOrderFacadeBo.setShippingInfoReqDtoList(basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
        inOutResultOrderFacadeBo.setWaitConfirm(basicsReceiveBasicsReqDto.isWaitConfirm());
        List<String> skuCodes = detailReqDtoList.stream().map(BasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList());
        skuCodes.addAll(((List)Optional.ofNullable(basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList()).orElse(new ArrayList(10))).stream().map(BasicsDetailReqDto::getSkuCode).distinct().collect(Collectors.toList()));
        List skuDtoList = this.itemDataQueryHelper.getByCodes(skuCodes);
        AssertUtils.notEmpty(skuDtoList, (String)"\u660e\u7ec6\u5bf9\u5e94\u8d27\u54c1\u4fe1\u606f\u4e0d\u5b58\u5728");
        Map skuDtoMap = skuDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, Function.identity()));
        ArrayList baseOrderDetailReqDtoList = Lists.newArrayList();
        for (BasicsDetailReqDto csWmsBasicsDetailReqDto : detailReqDtoList) {
            detailReqDto = new BaseOrderDetailReqDto();
            itemSkuDto = (ItemSkuDto)skuDtoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
            if (null == itemSkuDto) {
                throw new BizException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, sku code: " + csWmsBasicsDetailReqDto.getSkuCode());
            }
            detailReqDto.setLineNo(csWmsBasicsDetailReqDto.getLineNo());
            detailReqDto.setSkuCode(csWmsBasicsDetailReqDto.getSkuCode());
            detailReqDto.setSkuName(itemSkuDto.getSkuName());
            detailReqDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
            detailReqDto.setSnCodes(csWmsBasicsDetailReqDto.getSnCodes());
            detailReqDto.setInventoryProperty(csWmsBasicsDetailReqDto.getInventoryProperty());
            detailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight());
            detailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume());
            detailReqDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
            detailReqDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
            detailReqDto.setPreOrderItemId((Long)DataExtractUtils.ifNullElse((Object)csWmsBasicsDetailReqDto.getTradeOrderItemId(), (Object)csWmsBasicsDetailReqDto.getPreOrderItemId()));
            detailReqDto.setExtension(csWmsBasicsDetailReqDto.getExtensionExternal());
            detailReqDto.setDispatcherQuantity(csWmsBasicsDetailReqDto.getDispatcherQuantity());
            detailReqDto.setDispatcherStatus(csWmsBasicsDetailReqDto.getDispatcherStatus());
            detailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity());
            detailReqDto.setOrderLineClassify(OrderLineClassifyEnum.COMMON.getCode());
            detailReqDto.setWmsLineId(csWmsBasicsDetailReqDto.getWmsLineId());
            baseOrderDetailReqDtoList.add(detailReqDto);
        }
        if (CollectionUtils.isNotEmpty((Collection)basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList())) {
            for (BasicsDetailReqDto csWmsBasicsDetailReqDto : basicsReceiveBasicsReqDto.getPackageMaterialDetailReqDtoList()) {
                detailReqDto = new BaseOrderDetailReqDto();
                itemSkuDto = (ItemSkuDto)skuDtoMap.get(csWmsBasicsDetailReqDto.getSkuCode());
                if (null == itemSkuDto) {
                    throw new BizException("\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u4e0d\u5b58\u5728, sku code: " + csWmsBasicsDetailReqDto.getSkuCode());
                }
                detailReqDto.setLineNo(csWmsBasicsDetailReqDto.getLineNo());
                detailReqDto.setSkuCode(csWmsBasicsDetailReqDto.getSkuCode());
                detailReqDto.setSkuName(itemSkuDto.getSkuName());
                detailReqDto.setBatch(csWmsBasicsDetailReqDto.getBatch());
                detailReqDto.setSnCodes(csWmsBasicsDetailReqDto.getSnCodes());
                detailReqDto.setInventoryProperty((String)DataExtractUtils.ifNullElse((Object)csWmsBasicsDetailReqDto.getInventoryProperty(), (Object)LogicWarehouseQualityEnum.QUALIFIED.getCode()));
                detailReqDto.setWeight(csWmsBasicsDetailReqDto.getWeight());
                detailReqDto.setVolume(csWmsBasicsDetailReqDto.getVolume());
                detailReqDto.setExpireTime(csWmsBasicsDetailReqDto.getExpireTime());
                detailReqDto.setProduceTime(csWmsBasicsDetailReqDto.getProduceTime());
                detailReqDto.setPreOrderItemId((Long)DataExtractUtils.ifNullElse((Object)csWmsBasicsDetailReqDto.getTradeOrderItemId(), (Object)csWmsBasicsDetailReqDto.getPreOrderItemId()));
                detailReqDto.setExtension(csWmsBasicsDetailReqDto.getExtensionExternal());
                detailReqDto.setDispatcherQuantity(csWmsBasicsDetailReqDto.getDispatcherQuantity());
                detailReqDto.setDispatcherStatus(csWmsBasicsDetailReqDto.getDispatcherStatus());
                detailReqDto.setQuantity(csWmsBasicsDetailReqDto.getQuantity());
                detailReqDto.setOrderLineClassify(OrderLineClassifyEnum.PACKAGING_MATERIALS.getCode());
                detailReqDto.setOnlyRecord(true);
                detailReqDto.setWmsLineId(csWmsBasicsDetailReqDto.getWmsLineId());
                baseOrderDetailReqDtoList.add(detailReqDto);
            }
        }
        inOutResultOrderFacadeBo.setOrderBasicsDetailReqDtoList(baseOrderDetailReqDtoList);
        inOutResultOrderFacadeBo.setWmsOrderNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
        inOutResultOrderFacadeBo.setTotalCartons(basicsReceiveBasicsReqDto.getTotalCartons());
        inOutResultOrderFacadeBo.setMergeQuantity(basicsReceiveBasicsReqDto.getMergeQuantity());
        inOutResultOrderFacadeBo.setFullBatchInOutResult(basicsReceiveBasicsReqDto.isFullBatchInOutResult());
        this.setResultCallback(basicsReceiveBasicsReqDto, inOutNoticeOrderEo, detailReqDtoList, inOutResultOrderFacadeBo, overchargeReason);
        log.info("generateInResultOrderInfo==>\u751f\u6210\u5165\u5e93\u7ed3\u679c\u5355,inOutResultOrderFacadeBo:{}", (Object)JSON.toJSONString((Object)inOutResultOrderFacadeBo));
        if (basicsReceiveBasicsReqDto.isAssignWarehouse()) {
            inOutResultOrderFacadeBo.setSourceType(InventorySourceTypeEnum.OUT_TO_PACKAGE_MATERIAL.getCode());
            inOutResultOrderFacadeBo.setAssignWarehouse(true);
            inOutResultOrderFacadeBo.setLogicWarehouseCode(basicsReceiveBasicsReqDto.getWarehouseCode());
        }
        this.callGenResultOrder(inOutNoticeOrderEo, inFlag, inOutResultOrderFacadeBo);
    }

    private void handlerExtension(BasicsReceiveReqDto basicsReceiveBasicsReqDto, InOutResultOrderFacadeBo inOutResultOrderFacadeBo) {
        JSONObject ored = Optional.ofNullable(basicsReceiveBasicsReqDto.getExtensionExternal()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(JSON::parseObject).orElseGet(JSONObject::new);
        Optional.ofNullable(basicsReceiveBasicsReqDto.getExtension()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).map(JSON::parseObject).ifPresent(arg_0 -> ((JSONObject)ored).putAll(arg_0));
        Optional.ofNullable(basicsReceiveBasicsReqDto.getEarlyProductOutbound()).ifPresent(i -> ored.put("earlyProductOutbound", i));
        inOutResultOrderFacadeBo.setExtensionExternal(ored.toString());
    }

    private void callGenResultOrder(InOutNoticeOrderEo inOutNoticeOrderEo, Boolean inFlag, InOutResultOrderFacadeBo inOutResultOrderFacadeBo) {
        boolean adjust = "in_out".equals(inOutNoticeOrderEo.getOrderType());
        boolean isMerge = BaseOrderDocumentTypeEnum.MERGE.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getDocumentType());
        boolean isAssembly = CsRelevanceTableNameEnum.ASSEMBLY_DISASSEMBLY_ORDER.getCode().equals(inOutNoticeOrderEo.getBusinessType());
        if (isMerge) {
            this.baseOrderFacade.mergeOutResultOrderGen(inOutResultOrderFacadeBo);
        } else if (adjust) {
            this.baseOrderFacade.adjustResultOrderGen(inOutResultOrderFacadeBo);
        } else if (isAssembly) {
            this.baseOrderFacade.assembleDisassembleResultOrderGen(inOutResultOrderFacadeBo);
        } else if (inFlag.booleanValue()) {
            this.baseOrderFacade.inResultOrderGen(inOutResultOrderFacadeBo);
        } else {
            if (CsRelevanceTableNameEnum.CS_TRANSFER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName())) {
                TransferOrderEo transferOrderEo = (TransferOrderEo)this.transferOrderMapper.selectOne((Wrapper)Wrappers.lambdaQuery(TransferOrderEo.class).eq(TransferOrderEo::getTransferOrderNo, (Object)inOutNoticeOrderEo.getRelevanceNo()));
                inOutResultOrderFacadeBo.setTransferInLogicWarehouseCode(transferOrderEo.getInLogicWarehouseCode());
            }
            this.baseOrderFacade.outResultOrderGen(inOutResultOrderFacadeBo);
        }
    }

    private String getDispatcherStatus(BigDecimal overchargeQuantity, BigDecimal receiveLessQuantity) {
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0 && receiveLessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return TransferDispatcherStatusEnum.DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) == 0 && receiveLessQuantity.compareTo(BigDecimal.ZERO) == 0) {
            return TransferDispatcherStatusEnum.NO_DISPATCHER.getCode();
        }
        if (overchargeQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode();
        }
        if (receiveLessQuantity.compareTo(BigDecimal.ZERO) != 0) {
            return TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode();
        }
        return null;
    }

    private void setResultCallback(final BasicsReceiveReqDto basicsReceiveBasicsReqDto, final InOutNoticeOrderEo inOutNoticeOrderEo, final List<BasicsDetailReqDto> detailReqDtoList, InOutResultOrderFacadeBo inOutResultOrderFacadeBo, final OverchargeResultBo overchargeReason) {
        inOutResultOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                if (context instanceof InOutResultOrderContext) {
                    InOutResultOrderContext inContext = (InOutResultOrderContext)context;
                    if (BaseOrderOperateTypeEnum.OUT.equals((Object)context.getOperateTypeEnum())) {
                        inContext.setNoticeEnd(!InventoryConfig.isMultipleOut(inOutNoticeOrderEo.getJumpDocumentType(), inOutNoticeOrderEo.getDisplayBusinessType()));
                        inContext.setNoticeEndStatus(InventoryConfig.isNoticeEndStatus());
                    } else {
                        inContext.setNoticeEnd(!InventoryConfig.isMultipleIn(inOutNoticeOrderEo.getJumpDocumentType(), inOutNoticeOrderEo.getDisplayBusinessType()));
                        inContext.setNoticeEndStatus(InventoryConfig.isNoticeEndStatus());
                    }
                    if (YesNoEnum.YES.getValue().equals(basicsReceiveBasicsReqDto.getIsAllDeal())) {
                        inContext.setNoticeEnd(true);
                        inContext.setNoticeEndStatus(true);
                        log.info("\u53ea\u63a5\u6536\u4e00\u6b21\u56de\u4f20\u7ed3\u679c");
                    }
                    inContext.setFullBatchInOutResult(true);
                    inContext.setHangup(overchargeReason.isOvercharge());
                    InOutResultOrderEo inOutResultOrderEo = inContext.getInOutResultOrderEo();
                    inOutResultOrderEo.setOverChargeReason(overchargeReason.getReason());
                    inOutResultOrderEo.setOverChargeTime(inContext.getCurDate());
                    inOutResultOrderEo.setWmsNo(basicsReceiveBasicsReqDto.getWmsOrderNo());
                    inOutResultOrderEo.setTotalVolume(basicsReceiveBasicsReqDto.getTotalVolume());
                    inOutResultOrderEo.setTotalWeight(basicsReceiveBasicsReqDto.getTotalWeight());
                    inOutResultOrderEo.setEstimatedTime(basicsReceiveBasicsReqDto.getEstimatedTime());
                    inOutResultOrderEo.setInventoryProperty(inOutNoticeOrderEo.getInventoryProperty());
                    String shippingJson = JSON.toJSONString((Object)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
                    inOutResultOrderEo.setShippingJson(shippingJson);
                    if (!inContext.isHangup()) {
                        basicsReceiveBasicsReqDto.setRelevanceNo(inOutNoticeOrderEo.getRelevanceNo());
                        List shippingInfoReqDtoList = basicsReceiveBasicsReqDto.getShippingInfoReqDtoList();
                        if (CollectionUtils.isNotEmpty((Collection)shippingInfoReqDtoList)) {
                            for (CsWmsShippingInfoReqDto csWmsShippingInfoReqDto : shippingInfoReqDtoList) {
                                csWmsShippingInfoReqDto.setFirstShippingCompanyCode(csWmsShippingInfoReqDto.getShippingCompanyCode());
                                csWmsShippingInfoReqDto.setFirstShippingCompanyName(csWmsShippingInfoReqDto.getShippingCompanyName());
                            }
                        }
                        CommonSendBackAbleImpl.this.logisticsMappingComponent.logisticsMapping(basicsReceiveBasicsReqDto, inOutResultOrderEo);
                        if (StringUtils.isNotEmpty((CharSequence)basicsReceiveBasicsReqDto.getLogisticsRemark())) {
                            inOutResultOrderEo.setOverChargeReason("\u7269\u6d41\u6620\u5c04\u5f02\u5e38");
                            inOutResultOrderEo.setRemark(basicsReceiveBasicsReqDto.getLogisticsRemark());
                        }
                        shippingJson = JSON.toJSONString((Object)basicsReceiveBasicsReqDto.getShippingInfoReqDtoList());
                        inOutResultOrderEo.setShippingJson(shippingJson);
                    }
                    inOutResultOrderEo.setReceivelessQuantity(detailReqDtoList.stream().filter(a -> TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(BasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                    inOutResultOrderEo.setDispatcherStatus(CommonSendBackAbleImpl.this.getDispatcherStatus(inOutResultOrderEo.getOverchargeQuantity(), inOutResultOrderEo.getReceivelessQuantity()));
                    inOutResultOrderEo.setOverchargeQuantity(detailReqDtoList.stream().filter(a -> TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode().equals(a.getDispatcherStatus())).map(BasicsDetailReqDto::getDispatcherQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                    if (inContext.isAppendRecord()) {
                        inOutResultOrderEo.setDisplayBusinessType(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode());
                        inOutResultOrderEo.setDisplayBusinessName(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getValue());
                        context.setDisplayBusinessType(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getCode());
                        context.setDisplayBusinessName(PcpBasicTradeBusinessTypeEnum.SALES_OUTBOUND_PACKAGING_RECIPIENTS.getValue());
                        inContext.getInOutResultOrderDetailEoList().forEach(csInResultOrderDetailEo -> csInResultOrderDetailEo.setItemStatus(PlannedOrderItemStatusEnum.COMMON.getCode()));
                        inContext.setIgnorePreempt(true);
                        inContext.setAppendRecord(true);
                    }
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
    }

    private boolean dispathcherWmsOperateHandle(InOutNoticeOrderEo inOutNoticeOrderEo) {
        boolean flag;
        log.info("\u8fdb\u5165\u5230\u6536\u53d1\u5dee\u5f02\u5355\u56de\u4f20\u5224\u65adinOutNoticeOrderEo:{}", (Object)JSONObject.toJSONString((Object)inOutNoticeOrderEo));
        boolean bl = flag = CsRelevanceTableNameEnum.IN_DISPATCHER_ORDER.getCode().equals(inOutNoticeOrderEo.getRelevanceTableName()) && (BaseOrderStatusEnum.INO_WAIT_IN.getCode().equals(inOutNoticeOrderEo.getOrderStatus()) || BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equals(inOutNoticeOrderEo.getOrderStatus()));
        if (flag) {
            log.info("\u9a8c\u8bc1\u901a\u8fc7\uff0c\u6536\u53d1\u5dee\u5f02\u5355\u56de\u4f20\u5224\u65adinOutNoticeOrderEo:{}", (Object)JSONObject.toJSONString((Object)inOutNoticeOrderEo));
            ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getPreOrderNo())).one();
            deliveryNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
            this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)deliveryNoticeOrderEo);
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.FINISH_OVER.getCode());
            this.inOutNoticeOrderDomain.updateSelective((BaseEo)inOutNoticeOrderEo);
            DispatcherOrderEo dispatcherOrderEo = (DispatcherOrderEo)this.dispatcherOrderDomain.getMapper().selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"dr", (Object)YesNoHelper.NO));
            TransferOrderEo transferOrder = (TransferOrderEo)((ExtQueryChainWrapper)this.transferOrderDomain.filter().eq((Object)"transfer_order_no", (Object)dispatcherOrderEo.getTransferOrderNo())).one();
            List dispatcherOrderDetailEos = this.dispatcherOrderDetailDomain.getMapper().selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"order_status", (Object)CsDisPatcherOrderEnum.Status.WAIT.getCode())).eq((Object)"delivery_notice_no", (Object)inOutNoticeOrderEo.getPreOrderNo()));
            if (DispatcherOperateWayEnum.MORE_TRANSFER.getCode().equals(((DispatcherOrderDetailEo)dispatcherOrderDetailEos.get(0)).getOperationWay())) {
                ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
                releasePreemptDto.setSourceNo(deliveryNoticeOrderEo.getDocumentNo());
                releasePreemptDto.setSourceType(deliveryNoticeOrderEo.getRelevanceTableName());
                releasePreemptDto.setBusinessType(deliveryNoticeOrderEo.getBusinessType());
                this.calcInventoryService.releasePreempt(releasePreemptDto);
            }
            Map<String, List<DispatcherOrderDetailEo>> collect = dispatcherOrderDetailEos.stream().filter(a -> CsDisPatcherOrderEnum.Status.WAIT.getCode().equals(a.getOrderStatus())).collect(Collectors.groupingBy(DispatcherOrderDetailEo::getOperationWay));
            collect.keySet().forEach(k -> {
                Map<String, List<DispatcherOrderDetailEo>> operationWayWarehouseCode = ((List)collect.get(k)).stream().collect(Collectors.groupingBy(a -> a.getOperationWay() + (StringUtils.isBlank((CharSequence)a.getWarehouseCode()) ? "" : a.getWarehouseCode())));
                operationWayWarehouseCode.keySet().forEach(v -> DiffOrderOptContext.getDiffOrderOptAble().handle(DispatchOperateBo.builder().dispatcherOperateWayEnum(DispatcherOperateWayEnum.getByCode(k)).dispatcherOrderDetailEos((List)operationWayWarehouseCode.get(v)).originalTransferOrderEo(transferOrder).eo(dispatcherOrderEo).isTransferWms(Boolean.FALSE).isAutoFinish(Boolean.TRUE).build()));
            });
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

