/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.impl;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.enums.CsPlannedOrderItemStatusEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IOverchargeStrategyDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOverchargeStrategyDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IPlanOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OverchargeStrategyDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OverchargeStrategyEo;
import com.yunxi.dg.base.center.inventory.eo.PlanOrderEo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.AbstractOverchargeProcessor;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeMetaBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.overcharge.OverchargeResultBo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuDetailRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PlanOrderOverchargeProcessor
extends AbstractOverchargeProcessor {
    private static final Logger log = LoggerFactory.getLogger(PlanOrderOverchargeProcessor.class);
    @Resource
    private IPlanOrderDomain planOrderDomain;
    @Resource
    private IPlanOrderDetailDomain planOrderDetailDomain;
    @Resource
    private IOverchargeStrategyDomain overchargeStrategyDomain;
    @Resource
    private IOverchargeStrategyDetailDomain overchargeStrategyDetailDomain;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;

    @Override
    protected OverchargeResultBo doOverchargeCheck(OverchargeMetaBo overchargeMetaBo, boolean isEqualSum, boolean isEqualBatch, boolean isGtSum) {
        PlanOrderEo planOrderEo = (PlanOrderEo)((ExtQueryChainWrapper)this.planOrderDomain.filter().eq((Object)"order_no", (Object)overchargeMetaBo.getNoticeOrderEo().getRelevanceNo())).one();
        AssertUtil.assertNotNull((Object)planOrderEo, (String)"\u8ba1\u5212\u5165\u51fa\u5e93\u5355\u67e5\u8be2\u4e0d\u5b58\u5728: {}", (Object[])new Object[]{overchargeMetaBo.getNoticeOrderEo().getRelevanceNo()});
        boolean inFlag = StringUtils.equals((CharSequence)"in", (CharSequence)overchargeMetaBo.getNoticeOrderEo().getOrderType());
        if (inFlag) {
            ServiceContext.getContext().setAttachment("supplierCode", planOrderEo.getSupplierCode());
            ServiceContext.getContext().setAttachment("supplierName", planOrderEo.getSupplierName());
            List planOrderDetailEos = ((ExtQueryChainWrapper)this.planOrderDetailDomain.filter().eq((Object)"order_no", (Object)planOrderEo.getOrderNo())).list();
            List skuCodes = planOrderDetailEos.stream().map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
            ItemQueryDgReqDto itemQueryDgReqDto = new ItemQueryDgReqDto();
            itemQueryDgReqDto.setSkuCodes(skuCodes);
            List itemSkuDgRespDtos = this.itemSkuDgQueryApiProxy.querySkuList(itemQueryDgReqDto);
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)itemSkuDgRespDtos), (String)"\u67e5\u8be2\u5230\u7684\u5546\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            Map<String, DgItemSkuDetailRespDto> itemSkuDetailRespDtoMap = itemSkuDgRespDtos.stream().collect(Collectors.toMap(DgItemSkuRespDto::getSkuCode, Function.identity(), (k1, k2) -> k1));
            Object strategyDetailEoMap = new HashedMap();
            OverchargeStrategyEo overchargeStrategyEo = (OverchargeStrategyEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.overchargeStrategyDomain.filter().eq((Object)"order_type", (Object)planOrderEo.getOrderType())).last(" limit 1")).one();
            if (Objects.nonNull(overchargeStrategyEo)) {
                List detailEoList = ((ExtQueryChainWrapper)this.overchargeStrategyDetailDomain.filter().eq((Object)"overcharge_strategy_id", (Object)overchargeStrategyEo.getId())).list();
                strategyDetailEoMap = detailEoList.stream().collect(Collectors.toMap(e -> this.getKey(e.getDirId(), e.getItemAttribute(), e.getItemBrandId()), Function.identity(), (k1, k2) -> k1));
            }
            isGtSum = this.checkGt(overchargeMetaBo, itemSkuDetailRespDtoMap, overchargeStrategyEo, (Map<String, OverchargeStrategyDetailEo>)strategyDetailEoMap);
            if (InventoryConfig.isMultipleIn(overchargeMetaBo.getNoticeOrderEo().getJumpDocumentType(), overchargeMetaBo.getNoticeOrderEo().getDisplayBusinessType()) || !InventoryConfig.isCanHangUp()) {
                if (isGtSum) {
                    return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u8d85\u6536", CsPlannedOrderItemStatusEnum.OVERCHARGE.getCode());
                }
                return OverchargeResultBo.getSuccess();
            }
            if (!isEqualSum) {
                return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d");
            }
        } else if (!isEqualSum) {
            if (InventoryConfig.isMultipleOut(overchargeMetaBo.getNoticeOrderEo().getJumpDocumentType(), overchargeMetaBo.getNoticeOrderEo().getDisplayBusinessType()) || !InventoryConfig.isCanHangUp()) {
                if (isGtSum) {
                    return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u8d85\u53d1", CsPlannedOrderItemStatusEnum.DIFFERENCE.getCode());
                }
                return OverchargeResultBo.getSuccess();
            }
            if (InventoryConfig.isCanSmallOut()) {
                return OverchargeResultBo.getSuccess();
            }
            return OverchargeResultBo.getFail("\u8d27\u54c1\u6570\u91cf\u4e0d\u5339\u914d");
        }
        return OverchargeResultBo.getSuccess();
    }

    @NotNull
    private String getKey(Long dirId, Integer itemAttribute, Long itemBrandId) {
        return dirId + " " + itemAttribute + " " + itemBrandId;
    }

    @Override
    public CsRelevanceTableNameEnum getType() {
        return CsRelevanceTableNameEnum.PLAN_ORDER;
    }

    private boolean checkGt(OverchargeMetaBo overchargeMetaBo, Map<String, DgItemSkuDetailRespDto> itemDgDtoMap, OverchargeStrategyEo overchargeStrategyEo, Map<String, OverchargeStrategyDetailEo> strategyDetailEoMap) {
        BigDecimal num;
        String skuCode;
        Map<String, List<InOutNoticeOrderDetailEo>> batchNoticeDetailEosMap = overchargeMetaBo.getBatchNoticeDetailEos().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getSkuCode));
        List<BasicsDetailReqDto> wmsDetailDtos = overchargeMetaBo.getWmsDetailDtos();
        boolean hasGt = false;
        HashMap noticeNumMap = Maps.newHashMap();
        HashMap wmsNumMap = Maps.newHashMap();
        for (Map.Entry<String, List<InOutNoticeOrderDetailEo>> cargoEntry : batchNoticeDetailEosMap.entrySet()) {
            skuCode = cargoEntry.getKey();
            num = BigDecimal.ZERO;
            for (InOutNoticeOrderDetailEo detailEo : cargoEntry.getValue()) {
                num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)detailEo.getWaitQuantity());
            }
            noticeNumMap.put(skuCode, num);
        }
        log.info("noticeNumMap:{}", (Object)JSON.toJSONString((Object)noticeNumMap));
        for (BasicsDetailReqDto wmsDetailDto : wmsDetailDtos) {
            skuCode = wmsDetailDto.getSkuCode();
            num = (BigDecimal)wmsNumMap.get(skuCode);
            num = BigDecimalUtils.add((BigDecimal)num, (BigDecimal)wmsDetailDto.getQuantity());
            wmsNumMap.put(skuCode, num);
        }
        log.info("wmsNumMap:{}", (Object)JSON.toJSONString((Object)wmsNumMap));
        boolean existOverchargeStrategy = Objects.nonNull(overchargeStrategyEo);
        for (Map.Entry noticeNumEntry : noticeNumMap.entrySet()) {
            BigDecimal wmsSum;
            BigDecimal noticeSum;
            String skuCode2 = (String)noticeNumEntry.getKey();
            BigDecimal overchargeSum = noticeSum = (BigDecimal)noticeNumEntry.getValue();
            if (existOverchargeStrategy) {
                BigDecimal overchargeRatio = Optional.ofNullable(overchargeStrategyEo.getDefaultOverchargeRatio()).orElse(BigDecimal.ZERO);
                if (1 == overchargeStrategyEo.getPriorityOverchargeRatioFlag()) {
                    DgItemSkuDetailRespDto itemSkuDetailRespDto = itemDgDtoMap.get(skuCode2);
                    String key = this.getKey(itemSkuDetailRespDto.getDirId(), itemSkuDetailRespDto.getItemAttribute(), itemSkuDetailRespDto.getBrandId());
                    overchargeRatio = Optional.ofNullable(strategyDetailEoMap.get(key)).map(v -> v.getOverchargeRatio()).orElse(overchargeRatio);
                }
                log.info("defaultOverchargeRatio:{}", (Object)JSON.toJSONString((Object)overchargeRatio));
                overchargeRatio = overchargeRatio.divide(new BigDecimal("100")).add(BigDecimal.ONE);
                overchargeSum = noticeSum.multiply(overchargeRatio);
            }
            if (!BigDecimalUtils.gt((BigDecimal)(wmsSum = (BigDecimal)wmsNumMap.get(skuCode2)), (BigDecimal)overchargeSum).booleanValue()) continue;
            hasGt = true;
            break;
        }
        return hasGt;
    }
}

