/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.ds.BaseMapper;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.BasicsOrderOperateTypeEnum;
import com.yunxi.dg.base.center.enums.CsBaseOrderAddressContactsTypeEnum;
import com.yunxi.dg.base.center.enums.CsOutNoticePushStatusEnum;
import com.yunxi.dg.base.center.enums.CsPcpBusinessTypeEnum;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.CsValidFlagEnum;
import com.yunxi.dg.base.center.enums.CsWarehouseClassifyEnum;
import com.yunxi.dg.base.center.enums.PcpBusinessTypeEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.InOutNoticeOrderConverter;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.domain.CsWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.BasicOrderDtoExtension;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutOrderTriggerReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InResultOrderInsertItemsReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InResultOrderInsertReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehousePageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicWarehouseRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.NoticeOrderMarkMergeDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OutResultOrderItemReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.OutResultOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.BaseOrderAddressAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.E3OutInSendBackReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.ErpOutInSendBackReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.InSendBackDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.InSendBackReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutSendBackDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutSendBackReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.common.send.back.BasicsReceiveReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.baseorder.GenerateInNoticeOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.eo.BaseOrderAddressEo;
import com.yunxi.dg.base.center.inventory.eo.InOtherStorageOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderCallBack;
import com.yunxi.dg.base.center.inventory.service.baseorder.BaseOrderFacade;
import com.yunxi.dg.base.center.inventory.service.baseorder.InOutNoticeOrderAble;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderOperateTypeEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderBaseContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.BaseOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.InOutNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryNoticeOrderContext;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.BaseOrderCommonCancelBo;
import com.yunxi.dg.base.center.inventory.service.baseorder.facade.bo.ReceiveDeliveryNoticeOrderFacadeBo;
import com.yunxi.dg.base.center.inventory.service.commonsendback.CommonSendBackAble;
import com.yunxi.dg.base.center.inventory.service.entity.IInOutNoticeOrderService;
import com.yunxi.dg.base.center.inventory.service.entity.ILogicWarehouseService;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.holdMerge.IMergeStrategyConfigService;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.item.proxy.newbiz.IItemSkuDgQueryApiProxy;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.DateTimeUtil;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.RepeatFilter;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InOutNoticeOrderServiceImpl
extends BaseServiceImpl<InOutNoticeOrderDto, InOutNoticeOrderEo, IInOutNoticeOrderDomain>
implements IInOutNoticeOrderService {
    private static final Logger log = LoggerFactory.getLogger(InOutNoticeOrderServiceImpl.class);
    @Resource
    public InOutNoticeOrderAble outNoticeOrderAbleImpl;
    @Resource
    private CommonSendBackAble commonSendBackAble;
    @Resource
    private IMergeStrategyConfigService mergeStrategyConfigService;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;
    @Resource
    private IInOutResultOrderDomain outResultOrderDomain;
    @Resource
    private BaseOrderFacade baseOrderFacade;
    @Resource
    private IPcpDictQueryApiProxy pcpDictQueryApiProxy;
    @Resource
    private ILogicWarehouseService logicWarehouseService;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain deliveryNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private RepeatFilter repeatFilter;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IOrderUnitConversionRecordDomain iOrderUnitConversionRecordDomain;
    @Resource
    private IItemSkuDgQueryApiProxy itemSkuDgQueryApiProxy;
    @Resource
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private ITransferOrderDomain iTransferOrderDomain;
    @Resource
    private IInOtherStorageOrderDomain iInOtherStorageOrderDomain;
    @Autowired
    ILockService lockService;

    public InOutNoticeOrderServiceImpl(IInOutNoticeOrderDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InOutNoticeOrderDto, InOutNoticeOrderEo> converter() {
        return InOutNoticeOrderConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public void pushWms(String documentNo) {
        log.info("\u4e0b\u53d1\u5165\u51fa\u5e93\u901a\u77e5\u5355\u5230wms\u7684\u5355\u53f7\uff1a{}", (Object)documentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNo), (String)"\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEoByDocumentNo(documentNo);
        AssertUtil.isTrue((boolean)Objects.nonNull(inOutNoticeOrderEo), (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderContext inOutNoticeOrderContext = new InOutNoticeOrderContext();
        inOutNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutNoticeOrderContext.setIntercept(false);
        inOutNoticeOrderContext.setSendWms(false);
        log.info("\u4e0b\u53d1\u901a\u77e5\u5355\u53d1\u9001mq\u5230\u8fde\u63a5\u5668\u901a\u77e5\u5355\u4fe1\u606f,inOutNoticeOrderContext:{}", (Object)inOutNoticeOrderContext);
        this.outNoticeOrderAbleImpl.submit(inOutNoticeOrderContext);
        inOutNoticeOrderContext.setInOutNoticeOrderDetailEoList(((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list());
        inOutNoticeOrderContext.setOperateTypeEnum(BaseOrderOperateTypeEnum.getByCode(inOutNoticeOrderEo.getOrderType()));
        inOutNoticeOrderContext.setRelevanceTableName(CsRelevanceTableNameEnum.getStatusByCode((String)inOutNoticeOrderEo.getOrderType()));
        inOutNoticeOrderContext.setDocumentNo(inOutNoticeOrderEo.getDocumentNo());
        inOutNoticeOrderContext.setBusinessType(inOutNoticeOrderEo.getBusinessType());
        if ("in".equals(inOutNoticeOrderEo.getOrderType())) {
            inOutNoticeOrderContext.setLogicWarehouseCode(inOutNoticeOrderContext.getInOutNoticeOrderEo().getInLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(inOutNoticeOrderContext.getInOutNoticeOrderEo().getInLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(inOutNoticeOrderContext.getInOutNoticeOrderEo().getInPhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(inOutNoticeOrderContext.getInOutNoticeOrderEo().getInPhysicsWarehouseName());
        } else {
            inOutNoticeOrderContext.setLogicWarehouseCode(inOutNoticeOrderContext.getInOutNoticeOrderEo().getOutLogicWarehouseCode());
            inOutNoticeOrderContext.setLogicWarehouseName(inOutNoticeOrderContext.getInOutNoticeOrderEo().getOutLogicWarehouseName());
            inOutNoticeOrderContext.setPhysicsWarehouseCode(inOutNoticeOrderContext.getInOutNoticeOrderEo().getOutPhysicsWarehouseCode());
            inOutNoticeOrderContext.setPhysicsWarehouseName(inOutNoticeOrderContext.getInOutNoticeOrderEo().getOutPhysicsWarehouseName());
        }
        boolean b = InventoryConfig.getPushWms().pushWms(inOutNoticeOrderContext);
        InOutNoticeOrderEo update = new InOutNoticeOrderEo();
        update.setId(inOutNoticeOrderEo.getId());
        update.setPushStatus(b ? CsOutNoticePushStatusEnum.SUCCESS.getCode() : CsOutNoticePushStatusEnum.FAIL.getCode());
        update.setPushMsg(b ? "" : inOutNoticeOrderEo.getPushMsg());
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)update);
    }

    private InOutNoticeOrderEo getInOutNoticeOrderEoByDocumentNo(String documentNo) {
        List<InOutNoticeOrderEo> eos = this.getInOutNoticeOrderEoByDocumentNos(Lists.newArrayList((Object[])new String[]{documentNo}));
        return CollectionUtils.isNotEmpty(eos) ? eos.get(0) : null;
    }

    @Override
    public void inSendBack(InSendBackReqDto inSendBackReqDto) {
        log.info("inSendBack==>wms\u5165\u5e93\u56de\u4f20,inSendBackReqDto:{}", (Object)JSON.toJSONString((Object)inSendBackReqDto));
        AssertUtil.isTrue((null != inSendBackReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Date inTime = inSendBackReqDto.getInTime();
        if (null == inTime) {
            inSendBackReqDto.setInTime(new Date());
        }
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setPlatformOrderNo(inSendBackReqDto.getPlatformOrderNo());
        basicsReceiveReqDto.setExtension(inSendBackReqDto.getExtension());
        basicsReceiveReqDto.setEarlyProductOutbound(inSendBackReqDto.getEarlyProductOutbound());
        basicsReceiveReqDto.setInOutNoticeOrderNo(inSendBackReqDto.getInNoticeOrderNo());
        basicsReceiveReqDto.setInOutTime(inSendBackReqDto.getInTime());
        basicsReceiveReqDto.setWmsOrderNo(inSendBackReqDto.getWmsOrderNo());
        ArrayList detailReqDtoList = Lists.newArrayList();
        List inDetailList = inSendBackReqDto.getDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inDetailList), (String)"\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (InSendBackDetailReqDto inSendBackDetailReqDto : inDetailList) {
            BasicsDetailReqDto basicsDetailReqDto = new BasicsDetailReqDto();
            basicsDetailReqDto.setBatch(inSendBackDetailReqDto.getBatch());
            basicsDetailReqDto.setQuantity(inSendBackDetailReqDto.getQuantity());
            basicsDetailReqDto.setSkuCode(inSendBackDetailReqDto.getSkuCode());
            basicsDetailReqDto.setInventoryProperty(inSendBackDetailReqDto.getInventoryProperty());
            basicsDetailReqDto.setWarehouseCode(inSendBackDetailReqDto.getWarehouseCode());
            basicsDetailReqDto.setProduceTime(inSendBackDetailReqDto.getProduceTime());
            basicsDetailReqDto.setTradeOrderItemId(inSendBackDetailReqDto.getTradeOrderItemId());
            basicsDetailReqDto.setVolume(inSendBackDetailReqDto.getVolume());
            basicsDetailReqDto.setWeight(inSendBackDetailReqDto.getWeight());
            detailReqDtoList.add(basicsDetailReqDto);
        }
        basicsReceiveReqDto.setDetailReqDtoList((List)detailReqDtoList);
        basicsReceiveReqDto.setTotalVolume(inSendBackReqDto.getTotalVolume());
        basicsReceiveReqDto.setTotalWeight(inSendBackReqDto.getTotalWeight());
        this.commonSendBackAble.receiveIn(basicsReceiveReqDto);
    }

    @Override
    public void outSendBack(OutSendBackReqDto outSendBackReqDto) {
        log.info("outSendBack==>wms\u51fa\u5e93\u56de\u4f20,outSendBackReqDto:{}", (Object)JSON.toJSONString((Object)outSendBackReqDto));
        AssertUtil.isTrue((null != outSendBackReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Date outTime = outSendBackReqDto.getOutTime();
        if (null == outTime) {
            outSendBackReqDto.setOutTime(new Date());
        }
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setPlatformOrderNo(outSendBackReqDto.getPlatformOrderNo());
        basicsReceiveReqDto.setEarlyProductOutbound(outSendBackReqDto.getEarlyProductOutbound());
        basicsReceiveReqDto.setExtension(outSendBackReqDto.getExtension());
        basicsReceiveReqDto.setInOutNoticeOrderNo(outSendBackReqDto.getOutNoticeOrderNo());
        basicsReceiveReqDto.setInOutTime(outSendBackReqDto.getOutTime());
        basicsReceiveReqDto.setWmsOrderNo(outSendBackReqDto.getWmsOrderNo());
        basicsReceiveReqDto.setFullBatchInOutResult(outSendBackReqDto.isFullBatchInOutResult());
        basicsReceiveReqDto.setEstimatedTime(outSendBackReqDto.getEstimatedTime());
        basicsReceiveReqDto.setMergeQuantity(outSendBackReqDto.getMergeQuantity());
        basicsReceiveReqDto.setTotalCartons(outSendBackReqDto.getTotalCartons());
        basicsReceiveReqDto.setShippingInfoReqDtoList(outSendBackReqDto.getShippingInfoReqDtoList());
        List outDetailList = outSendBackReqDto.getDetailReqDtoList();
        List packingMaterialsOutDetailList = outSendBackReqDto.getPackageMaterialDetailReqDtoList();
        AssertUtil.isTrue((CollectionUtils.isNotEmpty((Collection)outDetailList) || CollectionUtils.isNotEmpty((Collection)packingMaterialsOutDetailList) ? 1 : 0) != 0, (String)"\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List<BasicsDetailReqDto> detailReqDtoList = this.detailReqDtoListInfo(outDetailList);
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        List<BasicsDetailReqDto> packingMaterialsDetailReqDtoList = this.detailReqDtoListInfo(packingMaterialsOutDetailList);
        basicsReceiveReqDto.setPackageMaterialDetailReqDtoList(packingMaterialsDetailReqDtoList);
        basicsReceiveReqDto.setWarehouseCode(outSendBackReqDto.getWarehouseCode());
        basicsReceiveReqDto.setTotalVolume(outSendBackReqDto.getTotalVolume());
        basicsReceiveReqDto.setTotalWeight(outSendBackReqDto.getTotalWeight());
        basicsReceiveReqDto.setFullBatchInOutResult(true);
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"document_no", (Object)outSendBackReqDto.getOutNoticeOrderNo())).last(" limit 1")).one();
        AssertUtil.isTrue((boolean)Objects.nonNull(outNoticeOrderEo), (String)"\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        basicsReceiveReqDto.setIsAllDeal(Integer.valueOf(InventoryConfig.isMultipleOut(outNoticeOrderEo.getJumpDocumentType(), outNoticeOrderEo.getDisplayBusinessType()) ? 0 : 1));
        this.commonSendBackAble.receiveOut(basicsReceiveReqDto);
    }

    @Override
    public void e3OutInSendBack(E3OutInSendBackReqDto e3OutInSendBackReqDto) {
        log.info("e3OutInSendBack==>e3\u51fa\u5e93\u56de\u4f20,e3OutInSendBackReqDto:{}", (Object)JSON.toJSONString((Object)e3OutInSendBackReqDto));
        Mutex mutex = this.lockService.lock("InOutNoticeOrderServiceImpl#e3OutInSendBack", e3OutInSendBackReqDto.getTransferOrderNo(), 20, 25, TimeUnit.SECONDS);
        try {
            this.e3OutInSendBackMeasure(e3OutInSendBackReqDto);
        }
        catch (Exception e) {
            log.error("e3\u51fa\u5e93\u56de\u4f20\u5f02\u5e38\uff1a", (Throwable)e);
            throw new BizException(e.getMessage());
        }
        finally {
            this.lockService.unlock(mutex);
        }
    }

    private void e3OutInSendBackMeasure(E3OutInSendBackReqDto e3OutInSendBackReqDto) {
        AssertUtils.notNull((Object)e3OutInSendBackReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)e3OutInSendBackReqDto.getTransferOrderNo(), (String)"\u8c03\u62e8\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)e3OutInSendBackReqDto.getDetailReqDtoList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List transferOrderEos = ((ExtQueryChainWrapper)this.iTransferOrderDomain.filter().eq((Object)"external_order_no", (Object)e3OutInSendBackReqDto.getTransferOrderNo())).list();
        AssertUtils.notEmpty((Collection)transferOrderEos, (String)"\u8c03\u62e8\u5355\u67e5\u8be2\u4e0d\u5b58\u5728");
        TransferOrderEo transferOrderEo = (TransferOrderEo)transferOrderEos.get(0);
        String type = transferOrderEo.getType();
        ArrayList e3TransferTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_B_C.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_B_C.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_C.getCode()});
        ArrayList e3OutTransferTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_C.getCode()});
        ArrayList e3InTransferTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_B_C.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_B_C.getCode()});
        if (!e3TransferTypeList.contains(type)) {
            throw new com.dtyunxi.exceptions.BizException("\u56de\u4f20\u8c03\u62e8\u5355\u7c7b\u578b \u5fc5\u987b\u662f BC\uff0cCB\uff0cCC \u7c7b\u578b");
        }
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.INO_WAIT_IN.getCode()});
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderEo.getTransferOrderNo())).in((Object)"order_status", (Collection)orderStatusList)).list();
        AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u6ca1\u6709\u6709\u6548\u7684\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u636e");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        List detailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list();
        AssertUtils.notEmpty((Collection)detailEoList, (String)"\u67e5\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u660e\u7ec6");
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setInOutNoticeOrderNo(inOutNoticeOrderEo.getDocumentNo());
        List outDetailList = e3OutInSendBackReqDto.getDetailReqDtoList();
        List<BasicsDetailReqDto> detailReqDtoList = this.convertDetailReqDtoList(outDetailList, detailEoList);
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        basicsReceiveReqDto.setRelevanceNo(transferOrderEo.getTransferOrderNo());
        basicsReceiveReqDto.setFullBatchInOutResult(true);
        if (Objects.equals("out", inOutNoticeOrderEo.getOrderType()) && e3OutTransferTypeList.contains(type)) {
            this.commonSendBackAble.receiveOut(basicsReceiveReqDto);
        } else if (Objects.equals("in", inOutNoticeOrderEo.getOrderType()) && e3InTransferTypeList.contains(type)) {
            this.commonSendBackAble.receiveIn(basicsReceiveReqDto);
        }
    }

    @Override
    public void erpOutInSendBack(ErpOutInSendBackReqDto erpOutInSendBackReqDto) {
        log.info("erpOutInSendBack==>erp\u51fa\u5e93\u56de\u4f20,erpOutInSendBackReqDto:{}", (Object)JSON.toJSONString((Object)erpOutInSendBackReqDto));
        AssertUtils.notNull((Object)erpOutInSendBackReqDto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)erpOutInSendBackReqDto.getOrderNo(), (String)"\u8c03\u62e8\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty((Collection)erpOutInSendBackReqDto.getDetailReqDtoList(), (String)"\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        List inOtherStorageOrderEos = ((ExtQueryChainWrapper)this.iInOtherStorageOrderDomain.filter().eq((Object)"storage_order_no", (Object)erpOutInSendBackReqDto.getOrderNo())).list();
        AssertUtils.notEmpty((Collection)inOtherStorageOrderEos, (String)"\u67e5\u8be2\u5176\u4ed6\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
        InOtherStorageOrderEo inOtherStorageOrderEo = (InOtherStorageOrderEo)inOtherStorageOrderEos.get(0);
        if (!StringUtils.equals((CharSequence)PcpBusinessTypeEnum.PARTS_REQUISITION_OUT.getCode(), (CharSequence)inOtherStorageOrderEo.getBusinessType())) {
            throw new BizException("\u5176\u4ed6\u51fa\u5e93\u5355\u7c7b\u578b\u5fc5\u987b\u662f\u914d\u4ef6\u7533\u8bf7\u5355");
        }
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOtherStorageOrderEo.getStorageOrderNo())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_WAIT_OUT.getCode())).list();
        AssertUtils.notEmpty((Collection)inOutNoticeOrderEos, (String)"\u6ca1\u6709\u6709\u6548\u7684\u51fa\u5e93\u901a\u77e5\u5355\u5355\u636e");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEos.get(0);
        List detailEoList = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).list();
        AssertUtils.notEmpty((Collection)detailEoList, (String)"\u67e5\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u660e\u7ec6");
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setInOutNoticeOrderNo(inOutNoticeOrderEo.getDocumentNo());
        List outDetailList = erpOutInSendBackReqDto.getDetailReqDtoList();
        List<BasicsDetailReqDto> detailReqDtoList = this.convertDetailReqDtoList(outDetailList, detailEoList);
        basicsReceiveReqDto.setDetailReqDtoList(detailReqDtoList);
        basicsReceiveReqDto.setRelevanceNo(inOtherStorageOrderEo.getStorageOrderNo());
        basicsReceiveReqDto.setFullBatchInOutResult(true);
        this.commonSendBackAble.receiveOut(basicsReceiveReqDto);
    }

    private List<BasicsDetailReqDto> convertDetailReqDtoList(List<OutSendBackDetailReqDto> outDetailList, List<InOutNoticeOrderDetailEo> detailEoList) {
        ArrayList detailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo detailEo : detailEoList) {
            BasicsDetailReqDto basicsDetailReqDto = new BasicsDetailReqDto();
            OutSendBackDetailReqDto outSendBackDetailReqDto = outDetailList.stream().filter(o -> Objects.equals(o.getSkuCode(), detailEo.getSkuCode())).findFirst().orElse(null);
            AssertUtils.notNull((Object)outSendBackDetailReqDto, (String)"\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
            basicsDetailReqDto.setInventoryProperty(detailEo.getInventoryProperty());
            basicsDetailReqDto.setSkuCode(outSendBackDetailReqDto.getSkuCode());
            basicsDetailReqDto.setQuantity(outSendBackDetailReqDto.getQuantity());
            basicsDetailReqDto.setPreOrderItemId(detailEo.getPreOrderItemId());
            basicsDetailReqDto.setTradeOrderItemId(detailEo.getPreOrderItemId());
            basicsDetailReqDto.setLineNo(detailEo.getLineNo());
            basicsDetailReqDto.setExpireTime(detailEo.getExpireTime());
            basicsDetailReqDto.setProduceTime(detailEo.getProduceTime());
            detailReqDtoList.add(basicsDetailReqDto);
        }
        return detailReqDtoList;
    }

    @Override
    public List<InOutNoticeOrderDto> mergeOutNoticeOrderByDocumentNos(List<String> documentNos) {
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(documentNos), (String)"\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List eos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInOutNoticeOrderDomain)this.domain).filter().in((Object)"document_no", documentNos)).eq((Object)"dr", (Object)0)).eq((Object)"order_type", (Object)"out")).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode())).list();
        AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)eos), (String)String.format("\u51fa\u5e93\u901a\u77e5\u5355\uff1a\u3010%s\u3011\u72b6\u6001\u975e\u5f85\u63d0\u4ea4\uff0c\u4e0d\u80fd\u64cd\u4f5c\u5408\u5e76\u5355\u636e", JSON.toJSONString(documentNos)));
        return this.mergeStrategyConfigService.mergeOutNoticeOrderByDocumentNos(eos.stream().map(InOutNoticeOrderEo::getDocumentNo).distinct().collect(Collectors.toList()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public String generateInNoticeOrder(InOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        log.info("generateInNoticeOrder==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355,inOutOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent((Object)inOutOrderGenerateReqDto));
        this.checkParams(inOutOrderGenerateReqDto);
        this.createDeliveryNoticeOrder(inOutOrderGenerateReqDto);
        List inOutNoticeOrderEos = ((IInOutNoticeOrderDomain)this.domain).queryByRelevanceNo(inOutOrderGenerateReqDto.getOrderNo());
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEos), (String)("\u6839\u636e\u5173\u8054\u5355\u53f7" + inOutOrderGenerateReqDto.getOrderNo() + "\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f"));
        InOutNoticeOrderEo inNoticeOrderNo = inOutNoticeOrderEos.stream().filter(i -> !BaseOrderStatusEnum.INO_CANCEL.getCode().equalsIgnoreCase(i.getOrderStatus())).findFirst().orElse(new InOutNoticeOrderEo());
        return inNoticeOrderNo.getDocumentNo();
    }

    @Override
    public GenerateInNoticeOrderRespDto generateInNoticeOrderReturnDto(InOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        String inNoticeOrderNo = this.generateInNoticeOrder(inOutOrderGenerateReqDto);
        log.info("\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355:{}", (Object)inNoticeOrderNo);
        GenerateInNoticeOrderRespDto respDto = new GenerateInNoticeOrderRespDto(inNoticeOrderNo);
        LogicWarehouseRespDto logicWarehouseRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData(this.logicWarehouseService.queryLogicWarehouseByCode(inOutOrderGenerateReqDto.getLogicWarehouseCode()));
        log.info("\u6839\u636e\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{} \u67e5\u8be2logicWarehouseRespDto:{}", (Object)inOutOrderGenerateReqDto.getLogicWarehouseCode(), (Object)LogUtils.buildLogContent((Object)logicWarehouseRespDto));
        if (Objects.nonNull(logicWarehouseRespDto)) {
            respDto.setSinceTheClosedLoop(Boolean.valueOf(CsValidFlagEnum.ENABLE.getCode().equals(logicWarehouseRespDto.getVirtualMatterFlag())));
        }
        log.info("\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u3001\u5165\u5e93\u901a\u77e5\u5355\u5e76\u8fd4\u56dedto\u8fd4\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    @Override
    public Boolean triggerInOutOrder(InOutOrderTriggerReqDto inOutOrderTriggerReqDto) {
        String documentType;
        String orderNo;
        log.info("triggerInOutOrder==>\u53d6\u6d88/\u6062\u590d\u51fa\u5e93\u901a\u77e5\u5355,inOutOrderTriggerReqDto:{}", (Object)LogUtils.buildLogContent((Object)inOutOrderTriggerReqDto));
        this.checkParams(inOutOrderTriggerReqDto);
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        String documentNo = inOutOrderTriggerReqDto.getDocumentNo();
        if (StringUtils.isNotBlank((CharSequence)documentNo)) {
            inOutNoticeOrderEoQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(orderNo = inOutOrderTriggerReqDto.getOrderNo()))) {
            inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)orderNo);
        }
        if (StringUtils.isNotBlank((CharSequence)(documentType = inOutOrderTriggerReqDto.getDocumentType()))) {
            inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)documentType);
        }
        ArrayList orderStatusList = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode()});
        if ("cancel".equals(inOutOrderTriggerReqDto.getTriggerType())) {
            inOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)orderStatusList);
        }
        List inOutNoticeOrderEoList = ((IInOutNoticeOrderDomain)this.domain).getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u51fa\u5165\u5e93\u901a\u77e5\u5355\u5355\u636e\u4fe1\u606f");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        String orderType = inOutNoticeOrderEo.getOrderType();
        String triggerType = inOutOrderTriggerReqDto.getTriggerType();
        this.checkWms(inOutNoticeOrderEo.getInLogicWarehouseCode(), inOutNoticeOrderEo.getId(), inOutNoticeOrderEo.getDocumentNo());
        boolean checkFlag = true;
        if (!checkFlag) {
            return Boolean.FALSE;
        }
        if ("cancel".equals(triggerType)) {
            ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IInOutNoticeOrderDomain)this.domain).filter().eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo())).in((Object)"order_status", (Collection)orderStatusList)).list().forEach(re -> {
                BaseOrderCommonCancelBo build = BaseOrderCommonCancelBo.builder().documentNo(re.getPreOrderNo()).sourceType(re.getDisplayBusinessType()).businessType(re.getDisplayBusinessType()).releasePreempt(inOutOrderTriggerReqDto.getReleasePreempt()).pushEvent(true).build();
                if ("out".equals(orderType)) {
                    if (inOutOrderTriggerReqDto.getLinkDeliveryReceive().booleanValue()) {
                        this.baseOrderFacade.deliveryNoticeOrderCancel(build);
                    } else {
                        build.setDocumentNo(re.getDocumentNo());
                        this.baseOrderFacade.outNoticeOrderCancel(build);
                    }
                } else if ("in".equals(orderType)) {
                    if (inOutOrderTriggerReqDto.getLinkDeliveryReceive().booleanValue()) {
                        this.baseOrderFacade.receiveNoticeOrderCancel(build);
                    } else {
                        build.setDocumentNo(re.getDocumentNo());
                        this.baseOrderFacade.inNoticeOrderCancel(build);
                    }
                }
            });
            return Boolean.TRUE;
        }
        if ("out".equals(orderType)) {
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
        } else if ("in".equals(orderType)) {
            inOutNoticeOrderEo.setOrderStatus(BaseOrderStatusEnum.INO_WAIT_IN.getCode());
        }
        inOutNoticeOrderEoQueryWrapper.clear();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"id", (Object)inOutNoticeOrderEo.getId());
        ((IInOutNoticeOrderDomain)this.domain).getMapper().update((Object)inOutNoticeOrderEo, (Wrapper)inOutNoticeOrderEoQueryWrapper);
        return Boolean.TRUE;
    }

    @Override
    public String generateInResultOrder(InOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        log.info("generateInResultOrder==>\u521b\u5efa\u6536\u8d27\u7ed3\u679c\u5355\u3001\u5165\u5e93\u7ed3\u679c\u5355,inOutOrderGenerateReqDto:{}", (Object)LogUtils.buildLogContent((Object)inOutOrderGenerateReqDto));
        this.checkParams(inOutOrderGenerateReqDto);
        String afterSaleOrderno = inOutOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)afterSaleOrderno), (String)"\u552e\u540e\u5355\u53f7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper inOutNoticeOrderEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderEoQueryWrapper.eq((Object)"relevance_no", (Object)afterSaleOrderno);
        inOutNoticeOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        inOutNoticeOrderEoQueryWrapper.in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()}));
        List inOutNoticeOrderEoList = ((IInOutNoticeOrderDomain)this.domain).getMapper().selectList((Wrapper)inOutNoticeOrderEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)inOutNoticeOrderEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        log.info("generateInResultOrder==>\u67e5\u8be2\u51fa\u5165\u5e93\u901a\u77e5\u5355\u4fe1\u606f,inOutNoticeOrderEoList:{}", (Object)LogUtils.buildLogContent((Collection)inOutNoticeOrderEoList));
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)inOutNoticeOrderEoList.get(0);
        QueryWrapper inOutNoticeOrderDetailEoQueryWrapper = new QueryWrapper();
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutNoticeOrderDetailEoQueryWrapper.eq((Object)"document_no", (Object)inOutNoticeOrderEo.getDocumentNo());
        List outNoticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.getMapper().selectList((Wrapper)inOutNoticeOrderDetailEoQueryWrapper);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)outNoticeOrderDetailEoList), (String)"\u67e5\u8be2\u4e0d\u5230\u5165\u5e93\u901a\u77e5\u5355\u660e\u7ec6\u4fe1\u606f");
        BasicsReceiveReqDto basicsReceiveReqDto = new BasicsReceiveReqDto();
        basicsReceiveReqDto.setPlatformOrderNo(inOutNoticeOrderEo.getExternalOrderNo());
        basicsReceiveReqDto.setInOutNoticeOrderNo(inOutNoticeOrderEo.getDocumentNo());
        basicsReceiveReqDto.setInOutTime(new Date());
        basicsReceiveReqDto.setWmsOrderNo(IdWorker.getId() + "");
        basicsReceiveReqDto.setOrderAfterSaleFlagCommon(Boolean.FALSE);
        ArrayList wmsBasicsDetailReqDtoList = Lists.newArrayList();
        for (InOutNoticeOrderDetailEo orderDetailEo : outNoticeOrderDetailEoList) {
            BasicsDetailReqDto basicsDetailReqDto = new BasicsDetailReqDto();
            basicsDetailReqDto.setBatch(orderDetailEo.getBatch());
            basicsDetailReqDto.setQuantity(orderDetailEo.getPlanQuantity());
            basicsDetailReqDto.setSkuCode(orderDetailEo.getSkuCode());
            basicsDetailReqDto.setWarehouseCode(inOutNoticeOrderEo.getInLogicWarehouseCode());
            basicsDetailReqDto.setTradeOrderItemId(orderDetailEo.getPreOrderItemId());
            basicsDetailReqDto.setProduceTime(new Date());
            wmsBasicsDetailReqDtoList.add(basicsDetailReqDto);
        }
        basicsReceiveReqDto.setDetailReqDtoList((List)wmsBasicsDetailReqDtoList);
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>(1);
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setShippingNo(inOutOrderGenerateReqDto.getShippingCode());
        csWmsShippingInfoReqDto.setShippingCompanyCode(inOutOrderGenerateReqDto.getShipmentEnterpriseCode());
        csWmsShippingInfoReqDto.setShippingCompanyName(inOutOrderGenerateReqDto.getShipmentEnterpriseName());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        basicsReceiveReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        basicsReceiveReqDto.setShopCode(inOutOrderGenerateReqDto.getShopCode());
        log.info("generateInResultOrder==>\u5165\u5e93,basicsReceiveReqDto:{}", (Object)LogUtils.buildLogContent((Object)basicsReceiveReqDto));
        this.commonSendBackAble.receiveIn(basicsReceiveReqDto);
        QueryWrapper inOutResultOrderEoQueryWrapper = new QueryWrapper();
        inOutResultOrderEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        inOutResultOrderEoQueryWrapper.eq((Object)"pre_order_no", (Object)inOutNoticeOrderEo.getDocumentNo());
        inOutResultOrderEoQueryWrapper.eq((Object)"order_type", (Object)"in");
        List inOutResultOrderEoList = this.outResultOrderDomain.getMapper().selectList((Wrapper)inOutResultOrderEoQueryWrapper);
        String documentNo = CollectionUtils.isNotEmpty((Collection)inOutResultOrderEoList) ? ((InOutResultOrderEo)inOutResultOrderEoList.get(0)).getDocumentNo() : null;
        return documentNo;
    }

    private void checkParams(InOutOrderTriggerReqDto inOutOrderTriggerReqDto) {
        AssertUtil.isTrue((null != inOutOrderTriggerReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = inOutOrderTriggerReqDto.getOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String documentType = inOutOrderTriggerReqDto.getDocumentType();
        AssertUtil.isTrue((StringUtils.isNotBlank((CharSequence)documentType) && ("out".equals(documentType) || "in".equals(documentType)) ? 1 : 0) != 0, (String)"\u5355\u636e\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        String triggerType = inOutOrderTriggerReqDto.getTriggerType();
        AssertUtil.isTrue((StringUtils.isNotBlank((CharSequence)triggerType) && ("cancel".equals(triggerType) || "recover".equals(triggerType)) ? 1 : 0) != 0, (String)"\u89e6\u53d1\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        inOutOrderTriggerReqDto.setLinkDeliveryReceive((Boolean)ObjectUtil.defaultIfNull((Object)inOutOrderTriggerReqDto.getLinkDeliveryReceive(), (Object)true));
    }

    private void createDeliveryNoticeOrder(final InOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo = new ReceiveDeliveryNoticeOrderFacadeBo();
        receiveDeliveryNoticeOrderFacadeBo.setBusinessType(CsPcpBusinessTypeEnum.REFUND_ORDER.getCode());
        receiveDeliveryNoticeOrderFacadeBo.setExternalOrderNo(inOutOrderGenerateReqDto.getPlatformOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setPreOrderNo(null);
        receiveDeliveryNoticeOrderFacadeBo.setSendWms(!inOutOrderGenerateReqDto.isNoSendWms());
        receiveDeliveryNoticeOrderFacadeBo.setAutoComplete(inOutOrderGenerateReqDto.isAutoComplete());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceNo(inOutOrderGenerateReqDto.getOrderNo());
        receiveDeliveryNoticeOrderFacadeBo.setRelevanceTableName(CsRelevanceTableNameEnum.CS_ORDER_AFTER_SALE);
        receiveDeliveryNoticeOrderFacadeBo.setLogicWarehouseCode(inOutOrderGenerateReqDto.getLogicWarehouseCode());
        receiveDeliveryNoticeOrderFacadeBo.setDisplayBusinessType(inOutOrderGenerateReqDto.getBasicDataBusinessType());
        receiveDeliveryNoticeOrderFacadeBo.setRemark(Optional.ofNullable(inOutOrderGenerateReqDto.getSendPersonAddressInfo()).map(e -> e.getRemark()).orElse(null));
        receiveDeliveryNoticeOrderFacadeBo.setCallBack(new BaseOrderCallBack<BaseOrderBaseContext>(){

            @Override
            public void beforeCallBack(BaseOrderBaseContext context) {
                boolean isInstanceof = context instanceof ReceiveDeliveryNoticeOrderContext;
                log.info("beforeCallBack->context instanceof ReceiveDeliveryNoticeOrderContext:{}", (Object)JSON.toJSONString((Object)isInstanceof));
                if (isInstanceof) {
                    BaseOrderAddressAddReqDto sendPersonAddressInfo;
                    BaseOrderAddressEo csBaseOrderAddressEo;
                    ArrayList<BaseOrderAddressEo> baseOrderAddressEoList;
                    ReceiveDeliveryNoticeOrderContext context1 = (ReceiveDeliveryNoticeOrderContext)context;
                    ReceiveDeliveryNoticeOrderEo receiveDeliveryNoticeOrderEo = context1.getReceiveDeliveryNoticeOrderEo();
                    receiveDeliveryNoticeOrderEo.setShipmentEnterpriseCode(inOutOrderGenerateReqDto.getShipmentEnterpriseCode());
                    receiveDeliveryNoticeOrderEo.setOaidOrderSourceCode(inOutOrderGenerateReqDto.getOaidOrderSourceCode());
                    receiveDeliveryNoticeOrderEo.setShipmentEnterpriseName(inOutOrderGenerateReqDto.getShipmentEnterpriseName());
                    receiveDeliveryNoticeOrderEo.setShippingCode(inOutOrderGenerateReqDto.getShippingCode());
                    receiveDeliveryNoticeOrderEo.setRepairOrderNo(inOutOrderGenerateReqDto.getOrderNo());
                    receiveDeliveryNoticeOrderEo.setShopCode(inOutOrderGenerateReqDto.getShopCode());
                    receiveDeliveryNoticeOrderEo.setShopName(inOutOrderGenerateReqDto.getShopName());
                    receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseCode(inOutOrderGenerateReqDto.getOutLogicWarehouseCode());
                    LogicWarehouseRespDto logicWarehouseRespDto = null;
                    if (StringUtils.isNotBlank((CharSequence)inOutOrderGenerateReqDto.getOutLogicWarehouseCode())) {
                        logicWarehouseRespDto = (LogicWarehouseRespDto)RestResponseHelper.extractData(InOutNoticeOrderServiceImpl.this.logicWarehouseService.queryLogicWarehouseByCode(inOutOrderGenerateReqDto.getOutLogicWarehouseCode()));
                    }
                    if (Objects.nonNull(logicWarehouseRespDto)) {
                        receiveDeliveryNoticeOrderEo.setDeliveryLogicWarehouseName(logicWarehouseRespDto.getWarehouseName());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseCode(logicWarehouseRespDto.getPhysicsWarehouseCode());
                        receiveDeliveryNoticeOrderEo.setDeliveryPhysicsWarehouseName(logicWarehouseRespDto.getPhysicsWarehouseName());
                    }
                    String logicWarehouseCode = receiveDeliveryNoticeOrderEo.getReceivePhysicsWarehouseCode();
                    QueryWrapper csWarehouseAddressEoQueryWrapper = new QueryWrapper();
                    csWarehouseAddressEoQueryWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
                    csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_classify", (Object)CsWarehouseClassifyEnum.PHYSICS.getCode());
                    csWarehouseAddressEoQueryWrapper.eq((Object)"valid_flag", (Object)CsValidFlagEnum.ENABLE.getCode());
                    csWarehouseAddressEoQueryWrapper.eq((Object)"warehouse_code", (Object)logicWarehouseCode);
                    List csWarehouseAddressEoList = InOutNoticeOrderServiceImpl.this.warehouseAddressDomain.getMapper().selectList((Wrapper)csWarehouseAddressEoQueryWrapper);
                    log.info("saveBaseOrderAddress==>\u552e\u540e\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csWarehouseAddressEoList:{}", (Object)LogUtils.buildLogContent((Collection)csWarehouseAddressEoList));
                    ArrayList<BaseOrderAddressEo> arrayList = baseOrderAddressEoList = CollectionUtils.isNotEmpty(context1.getBaseOrderAddressEoList()) ? context1.getBaseOrderAddressEoList() : new ArrayList<BaseOrderAddressEo>();
                    if (CollectionUtils.isNotEmpty((Collection)csWarehouseAddressEoList)) {
                        WarehouseAddressEo csWarehouseAddressEo = (WarehouseAddressEo)csWarehouseAddressEoList.get(0);
                        csBaseOrderAddressEo = new BaseOrderAddressEo();
                        csBaseOrderAddressEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                        csBaseOrderAddressEo.setContactsType(CsBaseOrderAddressContactsTypeEnum.CONSIGNEE.getCode());
                        csBaseOrderAddressEo.setProvince(csWarehouseAddressEo.getProvince());
                        csBaseOrderAddressEo.setProvinceCode(csWarehouseAddressEo.getProvinceCode());
                        csBaseOrderAddressEo.setCity(csWarehouseAddressEo.getCity());
                        csBaseOrderAddressEo.setCityCode(csWarehouseAddressEo.getCityCode());
                        csBaseOrderAddressEo.setDistrict(csWarehouseAddressEo.getDistrict());
                        csBaseOrderAddressEo.setDistrictCode(csWarehouseAddressEo.getDistrictCode());
                        csBaseOrderAddressEo.setDetailAddress(csWarehouseAddressEo.getDetailAddress());
                        csBaseOrderAddressEo.setContacts(csWarehouseAddressEo.getContacts());
                        csBaseOrderAddressEo.setPhone(csWarehouseAddressEo.getPhone());
                        log.info("saveBaseOrderAddress==>\u552e\u540e,\u6536\u8d27\u5730\u5740\u4fe1\u606f,\u76f8\u5173\u521b\u5efa\u5165\u5e93\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,receiveCsBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent((Object)csBaseOrderAddressEo));
                        baseOrderAddressEoList.add(csBaseOrderAddressEo);
                    }
                    if (null != (sendPersonAddressInfo = inOutOrderGenerateReqDto.getSendPersonAddressInfo())) {
                        csBaseOrderAddressEo = new BaseOrderAddressEo();
                        csBaseOrderAddressEo.setDocumentNo(receiveDeliveryNoticeOrderEo.getDocumentNo());
                        csBaseOrderAddressEo.setContactsType(CsBaseOrderAddressContactsTypeEnum.CONSIGNOR.getCode());
                        csBaseOrderAddressEo.setProvince(sendPersonAddressInfo.getProvince());
                        csBaseOrderAddressEo.setEncryptProvince(sendPersonAddressInfo.getEncryptProvince());
                        csBaseOrderAddressEo.setProvinceCode(sendPersonAddressInfo.getProvinceCode());
                        csBaseOrderAddressEo.setEncryptProvinceCode(sendPersonAddressInfo.getEncryptProvinceCode());
                        csBaseOrderAddressEo.setCity(sendPersonAddressInfo.getCity());
                        csBaseOrderAddressEo.setEncryptCity(sendPersonAddressInfo.getEncryptCity());
                        csBaseOrderAddressEo.setCityCode(sendPersonAddressInfo.getCityCode());
                        csBaseOrderAddressEo.setEncryptCityCode(sendPersonAddressInfo.getEncryptCityCode());
                        csBaseOrderAddressEo.setDistrict(sendPersonAddressInfo.getDistrict());
                        csBaseOrderAddressEo.setEncryptDistrict(sendPersonAddressInfo.getEncryptDistrict());
                        csBaseOrderAddressEo.setDistrictCode(sendPersonAddressInfo.getDistrictCode());
                        csBaseOrderAddressEo.setEncryptDistrictCode(sendPersonAddressInfo.getEncryptDistrictCode());
                        csBaseOrderAddressEo.setDetailAddress(sendPersonAddressInfo.getDetailAddress());
                        csBaseOrderAddressEo.setEncryptDetailAddress(sendPersonAddressInfo.getEncryptDetailAddress());
                        csBaseOrderAddressEo.setContacts(sendPersonAddressInfo.getContacts());
                        csBaseOrderAddressEo.setEncryptContacts(sendPersonAddressInfo.getEncryptContacts());
                        csBaseOrderAddressEo.setPhone(sendPersonAddressInfo.getPhone());
                        csBaseOrderAddressEo.setEncryptPhone(sendPersonAddressInfo.getEncryptPhone());
                        csBaseOrderAddressEo.setOaid(sendPersonAddressInfo.getOaid());
                        csBaseOrderAddressEo.setRemark(sendPersonAddressInfo.getRemark());
                        log.info("saveBaseOrderAddress==>\u552e\u540e,\u53d1\u8d27\u5730\u5740\u4fe1\u606f,\u521b\u5efa\u6536\u8d27\u901a\u77e5\u5355\u4fdd\u5b58\u5730\u5740\u4fe1\u606f,csBaseOrderAddressEo:{}", (Object)LogUtils.buildLogContent((Object)csBaseOrderAddressEo));
                        baseOrderAddressEoList.add(csBaseOrderAddressEo);
                    }
                    context1.setBaseOrderAddressEoList(baseOrderAddressEoList);
                }
            }

            @Override
            public void afterCallBack(BaseOrderBaseContext context) {
            }
        });
        ArrayList deliveryNoticeOrderDetails = Lists.newArrayList();
        for (InOutOrderGenerateDetailReqDto detail : detailReqDtoList) {
            BaseOrderDetailReqDto detailReqDto = new BaseOrderDetailReqDto();
            detailReqDto.setPreOrderItemId(detail.getTradeOrderItemId());
            detailReqDto.setQuantity(BigDecimalUtils.abs((BigDecimal)detail.getQuantity()));
            detailReqDto.setSkuCode(detail.getSkuCode());
            detailReqDto.setSkuName(detail.getSkuName());
            detailReqDto.setUnit(detail.getUnit());
            detailReqDto.setConvedUnit(StringUtils.isNotBlank((CharSequence)detail.getUnit()));
            detailReqDto.setDocumentCode(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
            detailReqDto.setBaseTo(false);
            deliveryNoticeOrderDetails.add(detailReqDto);
        }
        receiveDeliveryNoticeOrderFacadeBo.setOrderBasicsDetailReqDtoList(deliveryNoticeOrderDetails);
        List<OrderUnitConversionRecordDto> orderUnitConversionRecordDtos = this.getOrderUnitConversionRecordDtos(receiveDeliveryNoticeOrderFacadeBo, deliveryNoticeOrderDetails);
        UnitTransferUtils.unitConvertBySingleOrder((List)deliveryNoticeOrderDetails, (List)OrderUnitConversionRecordConverter.INSTANCE.toEoList(orderUnitConversionRecordDtos));
        this.baseOrderFacade.receiveNoticeOrderGen(receiveDeliveryNoticeOrderFacadeBo);
    }

    private List<OrderUnitConversionRecordDto> getOrderUnitConversionRecordDtos(ReceiveDeliveryNoticeOrderFacadeBo receiveDeliveryNoticeOrderFacadeBo, List<BaseOrderDetailReqDto> deliveryNoticeOrderDetails) {
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setDocumentCode(receiveDeliveryNoticeOrderFacadeBo.getRelevanceNo());
        record.setType(receiveDeliveryNoticeOrderFacadeBo.getBusinessType());
        record.setOrderUnitConversionDetailList(deliveryNoticeOrderDetails.stream().map(itemReqDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitDto = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitDto.setSkuCode(itemReqDto.getSkuCode());
            unitDto.setCurUnit(itemReqDto.getUnit());
            unitDto.setCurNum(itemReqDto.getQuantity());
            return unitDto;
        }).collect(Collectors.toList()));
        return this.orderUnitConversionRecordService.queryAndSaveUnitConversion(record);
    }

    private void checkParams(InOutOrderGenerateReqDto inOutOrderGenerateReqDto) {
        AssertUtil.isTrue((null != inOutOrderGenerateReqDto ? 1 : 0) != 0, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderNo = inOutOrderGenerateReqDto.getOrderNo();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)orderNo), (String)"\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String logicWarehouseCode = inOutOrderGenerateReqDto.getLogicWarehouseCode();
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)logicWarehouseCode), (String)"\u903b\u8f91\u4ed3\u4ed3\u5e93\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        List detailReqDtoList = inOutOrderGenerateReqDto.getDetailReqDtoList();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)detailReqDtoList), (String)"\u5546\u54c1\u660e\u7ec6\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        for (InOutOrderGenerateDetailReqDto generateDetailReqDto : detailReqDtoList) {
            String skuCode = generateDetailReqDto.getSkuCode();
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)skuCode), (String)"\u5546\u54c1sku\u7f16\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal quantity = generateDetailReqDto.getQuantity();
            AssertUtil.isTrue((null != quantity ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            BigDecimal itemPrice = generateDetailReqDto.getItemPrice();
            AssertUtil.isTrue((null != itemPrice ? 1 : 0) != 0, (String)"\u5546\u54c1\u5355\u4ef7\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<InOutNoticeOrderEo> getInOutNoticeOrderEoByDocumentNos(List<String> documentNos) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"document_no", documentNos);
        queryWrapper.eq((Object)"dr", (Object)0);
        return ((IInOutNoticeOrderDomain)this.domain).getMapper().selectList((Wrapper)queryWrapper);
    }

    private List<BasicsDetailReqDto> detailReqDtoListInfo(List<OutSendBackDetailReqDto> outDetailList) {
        ArrayList detailReqDtoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(outDetailList)) {
            return detailReqDtoList;
        }
        for (OutSendBackDetailReqDto outSendBackDetailReqDto : outDetailList) {
            BasicsDetailReqDto basicsDetailReqDto = new BasicsDetailReqDto();
            basicsDetailReqDto.setBatch(outSendBackDetailReqDto.getBatch());
            basicsDetailReqDto.setInventoryProperty(outSendBackDetailReqDto.getInventoryProperty());
            basicsDetailReqDto.setQuantity(outSendBackDetailReqDto.getQuantity());
            basicsDetailReqDto.setSkuCode(outSendBackDetailReqDto.getSkuCode());
            basicsDetailReqDto.setWarehouseCode(outSendBackDetailReqDto.getWarehouseCode());
            basicsDetailReqDto.setSnCodes(outSendBackDetailReqDto.getSnCodes());
            basicsDetailReqDto.setTradeOrderItemId(outSendBackDetailReqDto.getTradeOrderItemId());
            basicsDetailReqDto.setVolume(outSendBackDetailReqDto.getVolume());
            basicsDetailReqDto.setWeight(outSendBackDetailReqDto.getWeight());
            detailReqDtoList.add(basicsDetailReqDto);
        }
        return detailReqDtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> productOutbound(OutResultOrderReqDto reqDto) {
        log.info("\u51fa\u5e93\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((!Objects.isNull(reqDto) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isTrue((null != reqDto.getBizDate() ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((IInOutNoticeOrderDomain)this.domain).selectByPrimaryKey(reqDto.getId());
        AssertUtil.isTrue((!Objects.isNull(outNoticeOrderEo) ? 1 : 0) != 0, (String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728");
        ArrayList list = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.ONO_WAIT_OUT.getCode(), BaseOrderStatusEnum.ONO_PORTION_OUT.getCode()});
        AssertUtil.isTrue((boolean)list.contains(outNoticeOrderEo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e0d\u662f\u5f85\u51fa\u5e93/\u90e8\u5206\u51fa\u5e93\u72b6\u6001,\u4e0d\u53ef\u51fa\u5e93");
        this.repeatFilter.checkRepeat("productOutbound:" + reqDto.getId(), () -> {
            Map<String, OrderUnitConversionRecordDto> orderUnitConversionRecordDtoMap = null;
            if (CollectionUtils.isEmpty((Collection)reqDto.getItemReqDtoList())) {
                List noticeOrderDetailEoList = this.inOutNoticeOrderDetailDomain.queryByDocumentNo(outNoticeOrderEo.getDocumentNo());
                List<OutResultOrderItemReqDto> reqDtoList = this.setItemDetail(noticeOrderDetailEoList);
                AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(reqDtoList), (String)"\u5355\u636e\u51fa\u5e93\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                reqDto.setItemReqDtoList(reqDtoList);
            } else {
                List<OrderUnitConversionRecordDto> respDtoList = this.setOutItemUnitData(outNoticeOrderEo.getRelevanceNo(), outNoticeOrderEo.getOrderType(), reqDto.getItemReqDtoList());
                AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(respDtoList), (String)String.format("\u901a\u77e5\u5355\uff0c\u5355\u636e\u53f7\uff1a%s ,\u5355\u4f4d\u8f6c\u5316\u6709\u8bef", outNoticeOrderEo.getDocumentNo()));
                orderUnitConversionRecordDtoMap = respDtoList.stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getNum() + InventoryConfig.getCommonSeparate() + r.getUnit(), Function.identity(), (o, o1) -> o));
            }
            InOutResultOrderEo orderEo = new InOutResultOrderEo();
            orderEo.setRelevanceNo(outNoticeOrderEo.getRelevanceNo());
            orderEo.setOrderStatus("oro_hang_up");
            List outResultOrderEoList = this.outResultOrderDomain.selectList((BaseEo)orderEo);
            AssertUtil.isTrue((boolean)CollectionUtils.isEmpty((Collection)outResultOrderEoList), (String)String.format("\u901a\u77e5\u5355\u5b58\u5728\u6302\u8d77\u5355\u636e\uff0c\u5355\u636e\u53f7\uff1a%s", outNoticeOrderEo.getDocumentNo()));
            this.checkWms(orderEo.getOutLogicWarehouseCode(), outNoticeOrderEo.getId(), outNoticeOrderEo.getDocumentNo());
            reqDto.setFullBatchInOutResult(true);
            this.outSendBack(this.setOutboundData(outNoticeOrderEo, reqDto, orderUnitConversionRecordDtoMap));
        }, true, "\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        return new RestResponse();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> productInbound(InResultOrderInsertReqDto reqDto) {
        log.info("\u5165\u5e93\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((!Objects.isNull(reqDto) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isTrue((null != reqDto.getId() ? 1 : 0) != 0, (String)"\u5355\u636eID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isTrue((null != reqDto.getBizDate() ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)reqDto.getItemsReqDtoList()), (String)"\u5165\u5e93\u5546\u54c1\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        HashSet checkRepeatData = Sets.newHashSet();
        reqDto.getItemsReqDtoList().forEach(i -> {
            if (checkRepeatData.contains(i.getUniqueKey())) {
                throw new BizException("\u5546\u54c1\u957f\u7f16\u7801+\u6279\u6b21+\u5e93\u5b58\u72b6\u6001+\u524d\u7f6e\u5355\u636eid\u4e0d\u80fd\u90fd\u76f8\u540c");
            }
            checkRepeatData.add(i.getUniqueKey());
        });
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((IInOutNoticeOrderDomain)this.domain).selectByPrimaryKey(reqDto.getId());
        AssertUtil.isTrue((!Objects.isNull(outNoticeOrderEo) ? 1 : 0) != 0, (String)"\u8be5\u5165\u5e93\u5355\u636e\u4e0d\u5b58\u5728");
        ArrayList list = Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.INO_WAIT_IN.getCode(), BaseOrderStatusEnum.INO_PORTION_IN.getCode()});
        AssertUtil.isTrue((boolean)list.contains(outNoticeOrderEo.getOrderStatus()), (String)"\u8be5\u5355\u636e\u4e0d\u662f\u5f85\u5165\u5e93/\u90e8\u5206\u5165\u5e93\u72b6\u6001,\u4e0d\u53ef\u5165\u5e93");
        this.repeatFilter.checkRepeat("productInbound:" + reqDto.getId(), () -> {
            this.checkWms(outNoticeOrderEo.getInLogicWarehouseCode(), outNoticeOrderEo.getId(), outNoticeOrderEo.getDocumentNo());
            List<OrderUnitConversionRecordDto> respDtoList = this.setInItemData(outNoticeOrderEo.getDocumentNo(), outNoticeOrderEo.getOrderType(), reqDto.getItemsReqDtoList());
            AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty(respDtoList), (String)"\u5165\u5e93\u64cd\u4f5c\u5355\u4f4d\u8f6c\u5316\u6709\u8bef");
            Map<String, OrderUnitConversionRecordDto> orderUnitConversionRecordDtoMap = respDtoList.stream().collect(Collectors.toMap(r -> r.getSkuCode() + InventoryConfig.getCommonSeparate() + r.getNum() + InventoryConfig.getCommonSeparate() + r.getUnit(), Function.identity(), (o, o1) -> o));
            this.inSendBack(this.setInData(outNoticeOrderEo, reqDto, orderUnitConversionRecordDtoMap));
        }, true, "\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c");
        return new RestResponse();
    }

    @Override
    public RestResponse<BatchOrderOperationMsgDto> batchProductInbound(List<InResultOrderInsertReqDto> dtos) {
        BatchOrderOperationMsgDto.ResMsg resMsg = new BatchOrderOperationMsgDto.ResMsg();
        ArrayList errorReasonList = Lists.newArrayList();
        dtos.forEach(dto -> {
            try {
                this.productInbound((InResultOrderInsertReqDto)dto);
                resMsg.setMsg(dto.getDocumentNo());
                resMsg.setReqStatus(Integer.valueOf(1));
            }
            catch (Exception e) {
                resMsg.setMsg(String.format("%s\u5165\u5e93\u5931\u8d25,\u5f02\u5e38\u539f\u56e0%s", dto.getDocumentNo(), e.getMessage()));
                resMsg.setReqStatus(Integer.valueOf(0));
                errorReasonList.add(resMsg);
            }
        });
        BatchOrderOperationMsgDto msgDto = new BatchOrderOperationMsgDto();
        msgDto.setFailCount(Integer.valueOf(errorReasonList.size()));
        msgDto.setSuccCount(Integer.valueOf(dtos.size() - errorReasonList.size()));
        msgDto.setResMsgList((List)errorReasonList);
        return new RestResponse((Object)msgDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<String> deliveryNoticeOrderFinish(String outNoticeNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)outNoticeNo), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        List noticeOrderEoList = ((IInOutNoticeOrderDomain)this.domain).queryByDocumentNo(outNoticeNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)noticeOrderEoList), (String)"\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)noticeOrderEoList.get(0);
        if (!BaseOrderStatusEnum.ONO_WAIT_OUT.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.ONO_PORTION_OUT.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderStatus())) {
            throw new BizException("\u51fa\u5e93\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u5b8c\u7ed3");
        }
        List deliveryNoticeOrderEoList = this.deliveryNoticeOrderDomain.queryByDocumentNo(inOutNoticeOrderEo.getPreOrderNo());
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)deliveryNoticeOrderEoList), (String)"\u53d1\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = null;
        for (ReceiveDeliveryNoticeOrderEo noticeOrderEo : deliveryNoticeOrderEoList) {
            if (!BaseOrderStatusEnum.DNO_WAIT_DELIVERY.getCode().equalsIgnoreCase(noticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.DNO_PORTION_DELIVERY.getCode().equalsIgnoreCase(noticeOrderEo.getOrderStatus())) continue;
            deliveryNoticeOrderEo = noticeOrderEo;
            break;
        }
        AssertUtil.isTrue((boolean)Objects.nonNull(deliveryNoticeOrderEo), (String)"\u53d1\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u5b8c\u7ed3");
        this.checkWms(deliveryNoticeOrderEo.getReceiveLogicWarehouseCode(), deliveryNoticeOrderEo.getId(), deliveryNoticeOrderEo.getDocumentNo());
        BaseOrderCommonCancelBo cancelBo = BaseOrderCommonCancelBo.builder().documentNo(deliveryNoticeOrderEo.getDocumentNo()).sourceType(deliveryNoticeOrderEo.getBusinessType()).build();
        this.baseOrderFacade.deliveryNoticeOrderClose(cancelBo);
        return new RestResponse();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<String> receiveNoticeOrderFinish(String inNoticeNo) {
        AssertUtil.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)inNoticeNo), (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        List noticeOrderEoList = ((IInOutNoticeOrderDomain)this.domain).queryByDocumentNo(inNoticeNo);
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)noticeOrderEoList), (String)"\u5165\u5e93\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)noticeOrderEoList.get(0);
        if (!BaseOrderStatusEnum.INO_WAIT_IN.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.INO_PORTION_IN.getCode().equalsIgnoreCase(inOutNoticeOrderEo.getOrderStatus())) {
            throw new BizException("\u5165\u5e93\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u5b8c\u7ed3");
        }
        List receiveNoticeOrderEoList = this.deliveryNoticeOrderDomain.queryByDocumentNo(inOutNoticeOrderEo.getPreOrderNo());
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)receiveNoticeOrderEoList), (String)"\u6536\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo receiveNoticeOrderEo = null;
        for (ReceiveDeliveryNoticeOrderEo noticeOrderEo : receiveNoticeOrderEoList) {
            if (!BaseOrderStatusEnum.RNO_WAIT_RECEIVE.getCode().equalsIgnoreCase(noticeOrderEo.getOrderStatus()) && !BaseOrderStatusEnum.RNO_PORTION_RECEIVE.getCode().equalsIgnoreCase(noticeOrderEo.getOrderStatus())) continue;
            receiveNoticeOrderEo = noticeOrderEo;
            break;
        }
        AssertUtil.isTrue((boolean)Objects.nonNull(receiveNoticeOrderEo), (String)"\u6536\u8d27\u901a\u77e5\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u5b8c\u7ed3");
        this.checkWms(inOutNoticeOrderEo.getInLogicWarehouseCode(), inOutNoticeOrderEo.getId(), inOutNoticeOrderEo.getDocumentNo());
        BaseOrderCommonCancelBo cancelBo = BaseOrderCommonCancelBo.builder().documentNo(receiveNoticeOrderEo.getDocumentNo()).sourceType(receiveNoticeOrderEo.getBusinessType()).pushEvent(true).build();
        this.baseOrderFacade.receiveNoticeOrderClose(cancelBo);
        return new RestResponse();
    }

    private List<OrderUnitConversionRecordDto> setOutItemUnitData(String documentNo, String orderType, List<OutResultOrderItemReqDto> itemReqDtoList) {
        if (CollectionUtils.isEmpty(itemReqDtoList)) {
            return null;
        }
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setDocumentCode(documentNo);
        record.setType(orderType);
        record.setCanSave(false);
        record.setOrderUnitConversionDetailList(itemReqDtoList.stream().map(itemReqDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitDto = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitDto.setSkuCode(itemReqDto.getSkuCode());
            unitDto.setCurUnit(itemReqDto.getUnit());
            unitDto.setCurNum(itemReqDto.getQuantity());
            return unitDto;
        }).collect(Collectors.toList()));
        return this.orderUnitConversionRecordService.queryAndSaveUnitConversion(record);
    }

    private List<OrderUnitConversionRecordDto> setInItemData(String documentNo, String orderType, List<InResultOrderInsertItemsReqDto> itemsReqDtoList) {
        if (CollectionUtils.isEmpty(itemsReqDtoList)) {
            return null;
        }
        OrderUnitConversionReqDto record = new OrderUnitConversionReqDto();
        record.setDocumentCode(documentNo);
        record.setType(orderType);
        record.setOrderUnitConversionDetailList(itemsReqDtoList.stream().map(itemReqDto -> {
            OrderUnitConversionReqDto.OrderUnitConversionDetail unitDto = new OrderUnitConversionReqDto.OrderUnitConversionDetail();
            unitDto.setSkuCode(itemReqDto.getSkuCode());
            unitDto.setCurUnit(itemReqDto.getUnit());
            unitDto.setCurNum(itemReqDto.getQuantity());
            return unitDto;
        }).collect(Collectors.toList()));
        return this.orderUnitConversionRecordService.queryAndSaveUnitConversion(record);
    }

    private OutSendBackReqDto setOutboundData(InOutNoticeOrderEo outNoticeOrderEo, OutResultOrderReqDto reqDto, Map<String, OrderUnitConversionRecordDto> recordRespDtoMap) {
        OutSendBackReqDto receiveReqDto = new OutSendBackReqDto();
        receiveReqDto.setOutNoticeOrderNo(outNoticeOrderEo.getDocumentNo());
        receiveReqDto.setOutTime(Objects.isNull(outNoticeOrderEo.getBizDate()) ? new Date() : outNoticeOrderEo.getBizDate());
        if (!Objects.isNull(reqDto.getInOutTime())) {
            receiveReqDto.setOutTime(reqDto.getInOutTime());
        }
        receiveReqDto.setEarlyProductOutbound(reqDto.getEarlyProductOutbound());
        receiveReqDto.setExtension(reqDto.getExtension());
        receiveReqDto.setEstimatedTime(reqDto.getEstimatedTime());
        receiveReqDto.setBizDate(reqDto.getBizDate());
        ArrayList<CsWmsShippingInfoReqDto> shippingInfoReqDtoList = new ArrayList<CsWmsShippingInfoReqDto>();
        CsWmsShippingInfoReqDto csWmsShippingInfoReqDto = new CsWmsShippingInfoReqDto();
        csWmsShippingInfoReqDto.setOutNoticeOrderNo(outNoticeOrderEo.getDocumentNo());
        csWmsShippingInfoReqDto.setShippingCompanyCode(reqDto.getShippingCompanyCode());
        csWmsShippingInfoReqDto.setShippingCompanyName(reqDto.getShippingCompanyName());
        csWmsShippingInfoReqDto.setShipmentEnterpriseCode(reqDto.getShippingCompanyCode());
        csWmsShippingInfoReqDto.setShipmentEnterpriseName(reqDto.getShippingCompanyName());
        csWmsShippingInfoReqDto.setShippingNo(reqDto.getShippingCode());
        csWmsShippingInfoReqDto.setLogisticsType(reqDto.getShippingType());
        csWmsShippingInfoReqDto.setShippingType(reqDto.getShippingType());
        csWmsShippingInfoReqDto.setDeliveryTime(new Date());
        if (!Objects.isNull(reqDto.getInOutTime())) {
            csWmsShippingInfoReqDto.setDeliveryTime(reqDto.getInOutTime());
        }
        csWmsShippingInfoReqDto.setEstimatedTime(reqDto.getEstimatedTime());
        shippingInfoReqDtoList.add(csWmsShippingInfoReqDto);
        receiveReqDto.setShippingInfoReqDtoList(shippingInfoReqDtoList);
        ArrayList detailReqDtoList = new ArrayList();
        Map<String, BasicOrderDtoExtension> volumeAndWeightMap = this.calcVolumeAndWeight(outNoticeOrderEo, reqDto, receiveReqDto);
        BigDecimal[] totalCartons = new BigDecimal[]{BigDecimal.ZERO};
        reqDto.getItemReqDtoList().forEach(itemInfo -> {
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)volumeAndWeightMap.get(itemInfo.getSkuCode() + InventoryConfig.getCommonSeparate() + itemInfo.getQuantity());
            if (null != recordRespDtoMap && null != recordRespDtoMap.get(this.getItemKey(itemInfo.getSkuCode(), itemInfo.getQuantity(), itemInfo.getUnit()))) {
                OrderUnitConversionRecordDto respDto = (OrderUnitConversionRecordDto)recordRespDtoMap.get(this.getItemKey(itemInfo.getSkuCode(), itemInfo.getQuantity(), itemInfo.getUnit()));
                OutSendBackDetailReqDto csWmsOutSendBackDetailReqDto = new OutSendBackDetailReqDto();
                csWmsOutSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getPreOrderItemId());
                csWmsOutSendBackDetailReqDto.setQuantity(respDto.getToNum());
                csWmsOutSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                csWmsOutSendBackDetailReqDto.setBatch(itemInfo.getBatch());
                csWmsOutSendBackDetailReqDto.setInventoryProperty(itemInfo.getInventoryProperty());
                csWmsOutSendBackDetailReqDto.setWarehouseCode(outNoticeOrderEo.getOutLogicWarehouseCode());
                if (ObjectUtil.isNotEmpty((Object)basicOrderDtoExtension)) {
                    csWmsOutSendBackDetailReqDto.setVolume(basicOrderDtoExtension.getVolume());
                    csWmsOutSendBackDetailReqDto.setWeight(basicOrderDtoExtension.getWeight());
                }
                if (null != itemInfo.getTotalVolume()) {
                    csWmsOutSendBackDetailReqDto.setVolume(itemInfo.getTotalVolume());
                }
                detailReqDtoList.add(csWmsOutSendBackDetailReqDto);
            } else {
                OutSendBackDetailReqDto csWmsOutSendBackDetailReqDto = new OutSendBackDetailReqDto();
                csWmsOutSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getPreOrderItemId());
                csWmsOutSendBackDetailReqDto.setQuantity(itemInfo.getQuantity());
                csWmsOutSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                csWmsOutSendBackDetailReqDto.setBatch(itemInfo.getBatch());
                csWmsOutSendBackDetailReqDto.setInventoryProperty(itemInfo.getInventoryProperty());
                csWmsOutSendBackDetailReqDto.setWarehouseCode(outNoticeOrderEo.getOutLogicWarehouseCode());
                if (ObjectUtil.isNotEmpty((Object)basicOrderDtoExtension)) {
                    csWmsOutSendBackDetailReqDto.setVolume(basicOrderDtoExtension.getVolume());
                    csWmsOutSendBackDetailReqDto.setWeight(basicOrderDtoExtension.getWeight());
                }
                if (null != itemInfo.getTotalVolume()) {
                    csWmsOutSendBackDetailReqDto.setVolume(itemInfo.getTotalVolume());
                }
                detailReqDtoList.add(csWmsOutSendBackDetailReqDto);
            }
            totalCartons[0] = totalCartons[0].add(itemInfo.getQuantity());
        });
        receiveReqDto.setTotalCartons(totalCartons[0]);
        receiveReqDto.setDetailReqDtoList(detailReqDtoList);
        return receiveReqDto;
    }

    @NotNull
    private String getItemKey(String skuCode, BigDecimal num, String unit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num + InventoryConfig.getCommonSeparate() + unit;
    }

    private InSendBackReqDto setInData(InOutNoticeOrderEo outNoticeOrderEo, InResultOrderInsertReqDto reqDto, Map<String, OrderUnitConversionRecordDto> respDtoMap) {
        InSendBackReqDto inSendBackDto = new InSendBackReqDto();
        inSendBackDto.setInNoticeOrderNo(outNoticeOrderEo.getDocumentNo());
        inSendBackDto.setInTime(reqDto.getBizDate());
        inSendBackDto.setBizDate(reqDto.getBizDate());
        inSendBackDto.setExtension(reqDto.getExtension());
        inSendBackDto.setEarlyProductOutbound(reqDto.getEarlyProductOutbound());
        ArrayList detailReqDtoList = new ArrayList();
        Map<String, BasicOrderDtoExtension> volumeAndWeightMap = this.calcVolumeAndWeight(outNoticeOrderEo, reqDto, inSendBackDto);
        reqDto.getItemsReqDtoList().forEach(itemInfo -> {
            BasicOrderDtoExtension basicOrderDtoExtension = (BasicOrderDtoExtension)volumeAndWeightMap.get(itemInfo.getSkuCode() + InventoryConfig.getCommonSeparate() + itemInfo.getQuantity());
            if (null != respDtoMap && null != respDtoMap.get(this.getItemKey(itemInfo.getSkuCode(), itemInfo.getQuantity(), itemInfo.getUnit()))) {
                OrderUnitConversionRecordDto respDto = (OrderUnitConversionRecordDto)respDtoMap.get(this.getItemKey(itemInfo.getSkuCode(), itemInfo.getQuantity(), itemInfo.getUnit()));
                InSendBackDetailReqDto inSendBackDetailReqDto = new InSendBackDetailReqDto();
                inSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getPreOrderItemId());
                inSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                inSendBackDetailReqDto.setQuantity(respDto.getToNum());
                inSendBackDetailReqDto.setBatch(itemInfo.getBatch());
                inSendBackDetailReqDto.setInventoryProperty(itemInfo.getInventoryProperty());
                inSendBackDetailReqDto.setWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
                if (ObjectUtil.isNotEmpty((Object)itemInfo.getProduceTime())) {
                    inSendBackDetailReqDto.setProduceTime(itemInfo.getProduceTime());
                }
                if (ObjectUtil.isNotEmpty((Object)basicOrderDtoExtension)) {
                    inSendBackDetailReqDto.setVolume(basicOrderDtoExtension.getVolume());
                    inSendBackDetailReqDto.setWeight(basicOrderDtoExtension.getWeight());
                }
                detailReqDtoList.add(inSendBackDetailReqDto);
            } else {
                InSendBackDetailReqDto inSendBackDetailReqDto = new InSendBackDetailReqDto();
                inSendBackDetailReqDto.setTradeOrderItemId(itemInfo.getPreOrderItemId());
                inSendBackDetailReqDto.setSkuCode(itemInfo.getSkuCode());
                inSendBackDetailReqDto.setBatch(itemInfo.getBatch());
                inSendBackDetailReqDto.setInventoryProperty(itemInfo.getInventoryProperty());
                inSendBackDetailReqDto.setQuantity(itemInfo.getQuantity());
                inSendBackDetailReqDto.setWarehouseCode(outNoticeOrderEo.getInLogicWarehouseCode());
                if (ObjectUtil.isNotEmpty((Object)itemInfo.getProduceTime())) {
                    inSendBackDetailReqDto.setProduceTime(itemInfo.getProduceTime());
                }
                if (ObjectUtil.isNotEmpty((Object)basicOrderDtoExtension)) {
                    inSendBackDetailReqDto.setVolume(basicOrderDtoExtension.getVolume());
                    inSendBackDetailReqDto.setWeight(basicOrderDtoExtension.getWeight());
                }
                detailReqDtoList.add(inSendBackDetailReqDto);
            }
        });
        inSendBackDto.setDetailReqDtoList(detailReqDtoList);
        return inSendBackDto;
    }

    private Map<String, BasicOrderDtoExtension> calcVolumeAndWeight(InOutNoticeOrderEo outNoticeOrderEo, OutResultOrderReqDto reqDtoreqDto, OutSendBackReqDto inSendBackDto) {
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setDocumentCode(outNoticeOrderEo.getRelevanceNo());
        List<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo> weightAndVolumeDetailBos = reqDtoreqDto.getItemReqDtoList().stream().map(r -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(r.getQuantity());
            calculateWeightAndVolumeDetailBo.setSkuCode(r.getSkuCode());
            calculateWeightAndVolumeDetailBo.setUnit(r.getUnit());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList());
        calculateWeightAndVolumeBo.setVolumeDetailBos(weightAndVolumeDetailBos);
        Map<String, BasicOrderDtoExtension> volume = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        return volume;
    }

    private Map<String, BasicOrderDtoExtension> calcVolumeAndWeight(InOutNoticeOrderEo outNoticeOrderEo, InResultOrderInsertReqDto reqDto, InSendBackReqDto inSendBackDto) {
        IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo calculateWeightAndVolumeBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeBo();
        calculateWeightAndVolumeBo.setDocumentCode(outNoticeOrderEo.getRelevanceNo());
        List<IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo> weightAndVolumeDetailBos = reqDto.getItemsReqDtoList().stream().map(r -> {
            IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo calculateWeightAndVolumeDetailBo = new IOrderUnitConversionRecordService.CalculateWeightAndVolumeDetailBo();
            calculateWeightAndVolumeDetailBo.setQuantity(r.getQuantity());
            calculateWeightAndVolumeDetailBo.setSkuCode(r.getSkuCode());
            calculateWeightAndVolumeDetailBo.setUnit(r.getUnit());
            return calculateWeightAndVolumeDetailBo;
        }).collect(Collectors.toList());
        calculateWeightAndVolumeBo.setVolumeDetailBos(weightAndVolumeDetailBos);
        Map<String, BasicOrderDtoExtension> volume = this.orderUnitConversionRecordService.calculateWeightAndVolume(calculateWeightAndVolumeBo);
        return volume;
    }

    private LogicWarehouseRespDto queryLogicWarehouse(String logicWarehouseCode) {
        LogicWarehousePageReqDto logicWarehousePageReqDto = new LogicWarehousePageReqDto();
        logicWarehousePageReqDto.setWarehouseCode(logicWarehouseCode);
        logicWarehousePageReqDto.setWarehouseStatus(CsValidFlagEnum.ENABLE.getCode());
        List<LogicWarehouseRespDto> warehouseRespDtoList = this.logicWarehouseService.queryDataListByParams(logicWarehousePageReqDto);
        LogicWarehouseRespDto warehouseRespDto = new LogicWarehouseRespDto();
        if (CollectionUtils.isNotEmpty(warehouseRespDtoList)) {
            warehouseRespDto = warehouseRespDtoList.get(0);
        }
        return warehouseRespDto;
    }

    private List<OutResultOrderItemReqDto> setItemDetail(List<InOutNoticeOrderDetailEo> noticeOrderDetailEoList) {
        ArrayList<OutResultOrderItemReqDto> itemReqDtoList = new ArrayList<OutResultOrderItemReqDto>();
        if (CollectionUtils.isEmpty(noticeOrderDetailEoList)) {
            return null;
        }
        List skuCodeList = noticeOrderDetailEoList.stream().map(InOutNoticeOrderDetailEo::getSkuCode).collect(Collectors.toList());
        Map orderUnitConversionRecordEoMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iOrderUnitConversionRecordDomain.filter().eq(StringUtils.isNotBlank((CharSequence)noticeOrderDetailEoList.get(0).getRelevanceNo()), (Object)"document_code", (Object)noticeOrderDetailEoList.get(0).getRelevanceNo())).in(CollectionUtils.isNotEmpty(skuCodeList), (Object)"sku_code", skuCodeList)).list().stream().collect(Collectors.toMap(r -> r.getDocumentCode() + r.getSkuCode(), Function.identity(), (o, o1) -> o));
        if (CollectionUtils.isNotEmpty(noticeOrderDetailEoList)) {
            for (InOutNoticeOrderDetailEo detailEo : noticeOrderDetailEoList) {
                if (detailEo.getWaitQuantity().compareTo(BigDecimal.ZERO) == 0) {
                    log.info("\u8fc7\u6ee4\u6389\u5f85\u51fa\u5e93\u6570\u91cf\u4e3a\u96f6\u7684\u5546\u54c1\u660e\u7ec6\uff0cdetailId{}", (Object)detailEo.getId());
                    continue;
                }
                OutResultOrderItemReqDto itemReqDto = new OutResultOrderItemReqDto();
                itemReqDto.setSkuCode(detailEo.getSkuCode());
                itemReqDto.setBatch(detailEo.getBatch());
                itemReqDto.setPreOrderItemId(detailEo.getPreOrderItemId());
                itemReqDto.setInventoryProperty(detailEo.getInventoryProperty());
                itemReqDto.setProduceTime(DateTimeUtil.DateTimeFormat((Date)detailEo.getProduceTime()));
                itemReqDto.setExpireTime(DateTimeUtil.DateTimeFormat((Date)detailEo.getExpireTime()));
                itemReqDto.setQuantity(detailEo.getWaitQuantity());
                itemReqDto.setPreOrderItemId(detailEo.getPreOrderItemId());
                if (ObjectUtil.isNotEmpty(orderUnitConversionRecordEoMap.get(detailEo.getRelevanceNo() + detailEo.getSkuCode()))) {
                    itemReqDto.setUnit(((OrderUnitConversionRecordEo)orderUnitConversionRecordEoMap.get(detailEo.getRelevanceNo() + detailEo.getSkuCode())).getToUnit());
                }
                itemReqDtoList.add(itemReqDto);
            }
        }
        return itemReqDtoList;
    }

    private List<InResultOrderInsertItemsReqDto> setInItemDetail(List<InOutNoticeOrderDetailEo> noticeOrderDetailEoList) {
        ArrayList<InResultOrderInsertItemsReqDto> itemsReqDtoList = new ArrayList<InResultOrderInsertItemsReqDto>();
        if (CollectionUtils.isNotEmpty(noticeOrderDetailEoList)) {
            for (InOutNoticeOrderDetailEo detailEo : noticeOrderDetailEoList) {
                InResultOrderInsertItemsReqDto itemReqDto = new InResultOrderInsertItemsReqDto();
                itemReqDto.setSkuCode(detailEo.getSkuCode());
                itemReqDto.setBatch(detailEo.getBatch());
                itemReqDto.setQuantity(detailEo.getPlanQuantity());
                itemReqDto.setProduceTime(detailEo.getProduceTime());
                itemReqDto.setExpireTime(detailEo.getExpireTime());
                itemsReqDtoList.add(itemReqDto);
            }
        }
        return itemsReqDtoList;
    }

    private void checkWms(String logicWarehouseCode, Long id, String documentNo) {
        LogicWarehouseRespDto warehouseRespDto = this.queryLogicWarehouse(logicWarehouseCode);
        AssertUtil.isTrue((!Objects.isNull(warehouseRespDto) ? 1 : 0) != 0, (String)"\u903b\u8f91\u4ed3\u5e93\u4e0d\u5b58\u5728");
        DictDto dictDto = new DictDto();
    }

    private DictDto selectDict(String code) {
        return this.pcpDictQueryApiProxy.queryByGroupCodeAndCode("COMMON_CONFIG", code);
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> earlyProductOutbound(OutResultOrderReqDto reqDto) {
        log.info("\u63d0\u524d\u51fa\u5e93\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((!Objects.isNull(reqDto) ? 1 : 0) != 0, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        AssertUtil.isTrue((null != reqDto.getBizDate() ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u65f6\u95f4\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((IInOutNoticeOrderDomain)this.domain).selectByPrimaryKey(reqDto.getId());
        AssertUtil.isTrue((!Objects.isNull(outNoticeOrderEo) ? 1 : 0) != 0, (String)"\u8be5\u5355\u636e\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((boolean)StringUtils.equals((CharSequence)outNoticeOrderEo.getOrderStatus(), (CharSequence)BaseOrderStatusEnum.ONO_WAIT_OUT.getCode()), (String)("\u5355\u636e\u975e\u5f85\u51fa\u5e93\u72b6\u6001\uff0c\u4e0d\u652f\u6301\u63d0\u524d\u51fa\u5e93 \u5355\u53f7\uff1a" + outNoticeOrderEo.getDocumentNo()));
        reqDto.setEarlyProductOutbound(Integer.valueOf(1));
        this.productOutbound(reqDto);
        InOutNoticeOrderEo updateInOutNoticeOrderEo = new InOutNoticeOrderEo();
        updateInOutNoticeOrderEo.setId(outNoticeOrderEo.getId());
        String extension = outNoticeOrderEo.getExtension();
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            JSONObject jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("earlyProductOutbound", (Object)1);
            extension = jsonObject.toJSONString();
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("earlyProductOutbound", (Object)1);
            extension = jsonObject.toJSONString();
        }
        updateInOutNoticeOrderEo.setEarlyProductOutbound(Integer.valueOf(1));
        updateInOutNoticeOrderEo.setExtension(extension);
        ((IInOutNoticeOrderDomain)this.domain).updateSelective((BaseEo)updateInOutNoticeOrderEo);
        return new RestResponse();
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Boolean> earlyProductInbound(InResultOrderInsertReqDto reqDto) {
        log.info("\u63d0\u524d\u5165\u5e93\u64cd\u4f5c:{}", (Object)JSON.toJSONString((Object)reqDto));
        reqDto.setEarlyProductOutbound(Integer.valueOf(1));
        this.productInbound(reqDto);
        InOutNoticeOrderEo outNoticeOrderEo = (InOutNoticeOrderEo)((IInOutNoticeOrderDomain)this.domain).selectByPrimaryKey(reqDto.getId());
        InOutNoticeOrderEo updateInOutNoticeOrderEo = new InOutNoticeOrderEo();
        updateInOutNoticeOrderEo.setId(outNoticeOrderEo.getId());
        String extension = outNoticeOrderEo.getExtension();
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            JSONObject jsonObject = JSONObject.parseObject((String)extension);
            jsonObject.put("earlyProductInbound", (Object)1);
            extension = jsonObject.toJSONString();
        } else {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("earlyProductInbound", (Object)1);
            extension = jsonObject.toJSONString();
        }
        updateInOutNoticeOrderEo.setExtension(extension);
        ((IInOutNoticeOrderDomain)this.domain).updateSelective((BaseEo)updateInOutNoticeOrderEo);
        return new RestResponse();
    }

    private RestResponse<Boolean> updateShipping(InOutNoticeOrderDto reqDto) {
        log.info("\u66f4\u65b0\u7269\u6d41\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)reqDto));
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getDocumentNo()), (String)"\u51fa\u5165\u8d27\u901a\u77e5\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo inOutNoticeOrderEo = (InOutNoticeOrderEo)((ExtQueryChainWrapper)((IInOutNoticeOrderDomain)this.domain).filter().eq((Object)"document_no", (Object)reqDto.getDocumentNo())).one();
        ReceiveDeliveryNoticeOrderEo deliveryNoticeOrderEo = (ReceiveDeliveryNoticeOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)inOutNoticeOrderEo.getRelevanceNo())).eq((Object)"order_type", (Object)BasicsOrderOperateTypeEnum.DELIVERY.getCode())).ne((Object)"order_status", (Object)BaseOrderStatusEnum.DNO_CANCEL.getCode())).eq((Object)"dr", (Object)YesNoEnum.NO.getValue())).one();
        AssertUtil.isTrue((!Objects.isNull(deliveryNoticeOrderEo) ? 1 : 0) != 0, (String)"\u53d1\u8d27\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        AssertUtil.isTrue((!Objects.isNull(inOutNoticeOrderEo) ? 1 : 0) != 0, (String)"\u51fa\u5165\u8d27\u901a\u77e5\u5355\u4e0d\u5b58\u5728");
        ReceiveDeliveryNoticeOrderEo updateDeliveryNoticeOrderEo = new ReceiveDeliveryNoticeOrderEo();
        updateDeliveryNoticeOrderEo.setId(deliveryNoticeOrderEo.getId());
        InOutNoticeOrderEo updateInOutNoticeOrderEo = new InOutNoticeOrderEo();
        updateInOutNoticeOrderEo.setId(inOutNoticeOrderEo.getId());
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShippingCompany())) {
            updateDeliveryNoticeOrderEo.setShippingCompany(reqDto.getShippingCompany());
            updateInOutNoticeOrderEo.setShippingCompany(reqDto.getShippingCompany());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShippingCompanyName())) {
            updateDeliveryNoticeOrderEo.setShippingCompanyName(reqDto.getShippingCompanyName());
            updateInOutNoticeOrderEo.setShippingCompanyName(reqDto.getShippingCompanyName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShipmentEnterpriseCode())) {
            updateDeliveryNoticeOrderEo.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
            updateInOutNoticeOrderEo.setShipmentEnterpriseCode(reqDto.getShipmentEnterpriseCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShipmentEnterpriseName())) {
            updateDeliveryNoticeOrderEo.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
            updateInOutNoticeOrderEo.setShipmentEnterpriseName(reqDto.getShipmentEnterpriseName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getTransportStyle())) {
            updateDeliveryNoticeOrderEo.setTransportStyle(reqDto.getTransportStyle());
            updateInOutNoticeOrderEo.setTransportStyle(reqDto.getTransportStyle());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShippingType())) {
            updateDeliveryNoticeOrderEo.setShippingType(reqDto.getShippingType());
            updateInOutNoticeOrderEo.setShippingType(reqDto.getShippingType());
        }
        if (StringUtils.isEmpty((CharSequence)reqDto.getShippingJson()) && StringUtils.isEmpty((CharSequence)inOutNoticeOrderEo.getShippingJson())) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("shippingCompany", (Object)reqDto.getShippingCompany());
            jsonObject.put("shippingCompanyName", (Object)reqDto.getShippingCompanyName());
            updateInOutNoticeOrderEo.setShippingJson(jsonObject.toJSONString());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShippingJson()) && StringUtils.isEmpty((CharSequence)inOutNoticeOrderEo.getShippingJson())) {
            updateInOutNoticeOrderEo.setShippingJson(reqDto.getShippingJson());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqDto.getShippingJson()) && StringUtils.isNotEmpty((CharSequence)inOutNoticeOrderEo.getShippingJson())) {
            String eoShippingJson = inOutNoticeOrderEo.getShippingJson();
            JSONObject eoJsonObject = JSONObject.parseObject((String)eoShippingJson);
            String reqShippingJson = reqDto.getShippingJson();
            JSONObject reqJsonObject = JSONObject.parseObject((String)reqShippingJson);
            eoJsonObject.putAll((Map)reqJsonObject);
            String resultJsonString = eoJsonObject.toJSONString();
            updateInOutNoticeOrderEo.setShippingJson(resultJsonString);
        }
        this.receiveDeliveryNoticeOrderDomain.updateSelective((BaseEo)updateDeliveryNoticeOrderEo);
        ((IInOutNoticeOrderDomain)this.domain).updateSelective((BaseEo)updateInOutNoticeOrderEo);
        return new RestResponse();
    }

    @Override
    public RestResponse<Boolean> batchUpdateShipping(InOutNoticeOrderDto reqDto) {
        List documentNos = reqDto.getDocumentNos();
        AssertUtil.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)documentNos), (String)"\u51fa\u5165\u8d27\u901a\u77e5\u5355\u53f7\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        for (String documentNo : documentNos) {
            reqDto.setDocumentNo(documentNo);
            this.updateShipping(reqDto);
        }
        return new RestResponse();
    }

    @Override
    public void pushLogistics(String documentNo) {
        log.info("\u4e0b\u53d1\u5165\u51fa\u5e93\u901a\u77e5\u5355\u5230\u7269\u6d41\u4e2d\u5fc3\u7684\u5355\u53f7\uff1a{}", (Object)documentNo);
        AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)documentNo), (String)"\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4e0d\u80fd\u4e3a\u7a7a");
        InOutNoticeOrderEo inOutNoticeOrderEo = this.getInOutNoticeOrderEoByDocumentNo(documentNo);
        AssertUtil.isTrue((boolean)Objects.nonNull(inOutNoticeOrderEo), (String)"\u67e5\u8be2\u4e0d\u5230\u76f8\u5173\u5165\u51fa\u5e93\u901a\u77e5\u5355\u4fe1\u606f");
        InOutNoticeOrderContext inOutNoticeOrderContext = new InOutNoticeOrderContext();
        inOutNoticeOrderContext.setInOutNoticeOrderEo(inOutNoticeOrderEo);
        inOutNoticeOrderContext.setIntercept(false);
        log.info("\u4e0b\u53d1\u901a\u77e5\u5355\u53d1\u9001mq\u5230\u8fde\u63a5\u5668\u901a\u77e5\u5355\u4fe1\u606f,inOutNoticeOrderContext:{}", (Object)inOutNoticeOrderContext);
        this.outNoticeOrderAbleImpl.pushLogistics(inOutNoticeOrderContext);
    }

    private BigDecimal getVolume(String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return new BigDecimal("1");
        }
        switch (unit) {
            case "mm3": {
                return new BigDecimal("0.000000001");
            }
            case "cm3": {
                return new BigDecimal("0.000001");
            }
            case "dm3": {
                return new BigDecimal("0.001");
            }
            case "km3": {
                return new BigDecimal("1000");
            }
        }
        return new BigDecimal("1");
    }

    private BigDecimal getGrossWeight(String unit) {
        if (StringUtils.isBlank((CharSequence)unit)) {
            return new BigDecimal("1");
        }
        switch (unit) {
            case "g": {
                return new BigDecimal("0.001");
            }
            case "mg": {
                return new BigDecimal("0.000001");
            }
            case "t": {
                return new BigDecimal("1000");
            }
        }
        return new BigDecimal("1");
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void updateRetrievalNumberFlag(Long outNoticeOrderId, Integer retrievalNumberFlag) {
        log.info("\u66f4\u65b0\u53d6\u53f7\u6807\u8bc6");
        InOutNoticeOrderEo csOutNoticeOrderEo = new InOutNoticeOrderEo();
        csOutNoticeOrderEo.setId(outNoticeOrderId);
        csOutNoticeOrderEo.setRetrievalNumberFlag(retrievalNumberFlag);
        this.inOutNoticeOrderDomain.updateSelective((BaseEo)csOutNoticeOrderEo);
    }

    @Override
    public void retryMq(String documentNo) {
        this.baseOrderFacade.retryMq(documentNo);
    }

    @Override
    public RestResponse<Boolean> markMerge(NoticeOrderMarkMergeDto reqDto) {
        log.info("\u6ce8\u518c");
        ArrayList pushOrders = new ArrayList();
        Optional.ofNullable(((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().in((Object)"relevance_no", (Collection)reqDto.getOrderNos())).eq((Object)"order_status", (Object)BaseOrderStatusEnum.ONO_WAIT_PUSH.getCode())).list()).filter(CollectionUtils::isNotEmpty).map(list -> list.stream().map(r -> {
            InOutNoticeOrderEo noticeOrderEo = new InOutNoticeOrderEo();
            noticeOrderEo.setId(r.getId());
            if (reqDto.isMerge()) {
                noticeOrderEo.setPushTime((Date)ObjectUtils.defaultIfNull((Object)reqDto.getPushTime(), (Object)new Date()));
            } else {
                noticeOrderEo.setOrderStatus(BaseOrderStatusEnum.ONO_WAIT_OUT.getCode());
                noticeOrderEo.setPushTime(null);
                pushOrders.add(r.getDocumentNo());
            }
            return noticeOrderEo;
        }).collect(Collectors.toList())).filter(CollectionUtils::isNotEmpty).ifPresent(arg_0 -> ((BaseMapper)this.inOutNoticeOrderDomain.getMapper()).updateBatchByIds(arg_0));
        Optional.of(pushOrders).filter(CollectionUtils::isNotEmpty).ifPresent(documentNos -> documentNos.forEach(this::pushWms));
        return new RestResponse();
    }
}

