/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.service.third;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.constants.PushE3StatusEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.convert.entity.OrderUnitConversionRecordConverter;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationDto;
import com.yunxi.dg.base.center.inventory.dto.entity.WarehouseRelationPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.service.entity.IOrderUnitConversionRecordService;
import com.yunxi.dg.base.center.inventory.service.entity.IWarehouseRelationService;
import com.yunxi.dg.base.center.inventory.service.third.PushAble;
import com.yunxi.dg.base.center.inventory.service.third.TransferOrderPushBo;
import com.yunxi.dg.base.center.inventory.service.third.TransferOrderPushErpAble;
import com.yunxi.dg.base.center.openapi.dto.e3.SkuDto;
import com.yunxi.dg.base.center.openapi.dto.e3.SyncE3TransferOrderResDto;
import com.yunxi.dg.base.center.openapi.dto.e3.TransferOrderDto;
import com.yunxi.dg.base.center.openapi.proxy.e3.IExternalE3ApiProxy;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DefaultTransferOrderPushErpAble
implements TransferOrderPushErpAble {
    private static final Logger log = LoggerFactory.getLogger(DefaultTransferOrderPushErpAble.class);
    @Resource
    ITransferOrderDomain transferOrderDomain;
    @Resource
    private IWarehouseRelationService iWarehouseRelationService;
    @Resource
    private IExternalE3ApiProxy iExternalE3ApiProxy;
    @Resource
    private IOrderUnitConversionRecordService orderUnitConversionRecordService;

    @Override
    public String getType() {
        return "default";
    }

    @Override
    public boolean canPush(PushAble.CanPushBo canPushBo) {
        ArrayList orderTypeList = Lists.newArrayList((Object[])new String[]{TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CLOUD_WAREHOUSE_C_C.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_B.getCode(), TransferOrderTypeEnum.CW_WAREHOUSE_C_C.getCode()});
        return orderTypeList.contains(canPushBo.getBusinessType());
    }

    @Override
    public boolean push(TransferOrderPushBo transferOrderPushBo) {
        SyncE3TransferOrderResDto e3TransferOrderResDto;
        Map<String, WarehouseRelationDto> warehouseRelationMap = this.getWarehouseRelationMap(transferOrderPushBo.getTransferOrderReqDto());
        WarehouseRelationDto inWarehouseRelationDto = warehouseRelationMap.get(transferOrderPushBo.getTransferOrderReqDto().getInLogicWarehouseCode());
        WarehouseRelationDto outWarehouseRelationDto = warehouseRelationMap.get(transferOrderPushBo.getTransferOrderReqDto().getOutLogicWarehouseCode());
        if (null == inWarehouseRelationDto || null == outWarehouseRelationDto) {
            log.info("\u6ca1\u6709\u914d\u7f6e\u903b\u8f91\u4ed3e3\u5bf9\u7167\u8868,\u4e0d\u63a8e3");
            String message = "\u6ca1\u6709\u914d\u7f6e\u903b\u8f91\u4ed3e3\u5bf9\u7167\u8868,\u4e0d\u63a8e3";
            this.updateTransferE3Status(transferOrderPushBo.getTransferNo(), PushE3StatusEnum.E3_DISPENSE_WITH_PUSH.getCode(), message, null);
            return false;
        }
        TransferOrderDto e3TransferOrderDto = this.getTransferOrderDto(transferOrderPushBo.getTransferOrderReqDto(), transferOrderPushBo.getDetailList(), transferOrderPushBo.getTransferNo(), inWarehouseRelationDto, outWarehouseRelationDto);
        try {
            e3TransferOrderResDto = (SyncE3TransferOrderResDto)RestResponseHelper.extractData((RestResponse)this.iExternalE3ApiProxy.addTransferOrder(e3TransferOrderDto));
            log.info("E3\u540c\u6b65\u8c03\u62e8\u5355\uff0c\u8fd4\u56de\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)e3TransferOrderResDto));
        }
        catch (Exception e) {
            log.info("\u8c03\u62e8\u5355\u63a8\u9001E3\u5931\u8d25:{}", (Object)e.getMessage());
            this.updateTransferE3Status(transferOrderPushBo.getTransferNo(), PushE3StatusEnum.E3_PUSH_FAIL.getCode(), e.getMessage(), null);
            throw new BizException(e.getMessage());
        }
        this.updateTransferE3Status(transferOrderPushBo.getTransferNo(), PushE3StatusEnum.E3_WAIT_AUDIT.getCode(), null, e3TransferOrderResDto.getData());
        return false;
    }

    @Override
    public boolean cancel(TransferOrderPushBo transferOrderPushBo) {
        return false;
    }

    private Map<String, WarehouseRelationDto> getWarehouseRelationMap(TransferOrderReqDto orderReqDto) {
        ArrayList logicWarehouseCodeList = Lists.newArrayList((Object[])new String[]{orderReqDto.getOutLogicWarehouseCode(), orderReqDto.getInLogicWarehouseCode()});
        WarehouseRelationPageReqDto reqDto = new WarehouseRelationPageReqDto();
        reqDto.setLogicWarehouseCodeList((List)logicWarehouseCodeList);
        List warehouseRelationDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData(this.iWarehouseRelationService.queryList(reqDto))).orElse(Lists.newArrayList());
        log.info("\u6839\u636e\u903b\u8f91\u4ed3\u67e5\u5230ERP\u5173\u7cfb\u4ed3:{}", (Object)JSON.toJSONString((Object)warehouseRelationDtoList));
        return warehouseRelationDtoList.stream().collect(Collectors.toMap(WarehouseRelationDto::getLogicWarehouseCode, Function.identity(), (o1, o2) -> o1));
    }

    private void updateTransferE3Status(String transferOrderNo, String pushE3Status, String message, String externalOrderNo) {
        TransferOrderReqDto transferOrderReqDto = new TransferOrderReqDto();
        transferOrderReqDto.setTransferOrderNo(transferOrderNo);
        transferOrderReqDto.setPushE3Status(pushE3Status);
        transferOrderReqDto.setE3FailReason(message);
        transferOrderReqDto.setExternalOrderNo(externalOrderNo);
        TransferOrderEo updateTransferOrderEo = new TransferOrderEo();
        if (StringUtils.isNotBlank((CharSequence)transferOrderReqDto.getExternalOrderNo())) {
            updateTransferOrderEo.setExternalOrderNo(transferOrderReqDto.getExternalOrderNo());
        }
        updateTransferOrderEo.setPushE3Status(transferOrderReqDto.getPushE3Status());
        updateTransferOrderEo.setE3FailReason(transferOrderReqDto.getE3FailReason());
        this.transferOrderDomain.getMapper().update((Object)updateTransferOrderEo, (Wrapper)Wrappers.update((Object)new TransferOrderEo()).eq((Object)"transfer_order_no", (Object)transferOrderNo));
    }

    private TransferOrderDto getTransferOrderDto(TransferOrderReqDto orderReqDto, List<TransferOrderDetailReqDto> detailList, String transferNo, WarehouseRelationDto inWarehouseRelationDto, WarehouseRelationDto outWarehouseRelationDto) {
        Map<Object, OrderUnitConversionRecordEo> unitConversionRecordDtoMap = this.getUnitConversionRecordDtoMap(transferNo);
        TransferOrderDto dto = new TransferOrderDto();
        dto.setTransferOrderNo(transferNo);
        dto.setOutWarehouseCode(outWarehouseRelationDto.getErpId());
        dto.setOutOrgCode(outWarehouseRelationDto.getE3ChannelCode());
        dto.setInWarehouseCode(inWarehouseRelationDto.getErpId());
        dto.setInOrgCode(inWarehouseRelationDto.getE3ChannelCode());
        dto.setBizDate(orderReqDto.getBizDate());
        dto.setRemark(orderReqDto.getRemark());
        dto.setAuditStatus(YesNoHelper.NO);
        ArrayList skuDtoList = Lists.newArrayList();
        detailList.forEach(detail -> {
            SkuDto skuDto = new SkuDto();
            OrderUnitConversionRecordEo unitEo = (OrderUnitConversionRecordEo)unitConversionRecordDtoMap.get(this.getKey(detail.getSkuCode(), detail.getQuantity(), detail.getUnit()));
            skuDto.setSkuCode(detail.getSkuCode());
            skuDto.setItemCode(detail.getSkuCode());
            skuDto.setNum(UnitTransferUtils.pareSaleNum((BigDecimal)detail.getQuantity(), (OrderUnitConversionRecordDto)((OrderUnitConversionRecordDto)OrderUnitConversionRecordConverter.INSTANCE.toDto((BaseEo)unitEo)), (boolean)true));
            skuDtoList.add(skuDto);
        });
        dto.setSkuList((List)skuDtoList);
        return dto;
    }

    private Map<Object, OrderUnitConversionRecordEo> getUnitConversionRecordDtoMap(String adjustmentNo) {
        return this.orderUnitConversionRecordService.getRecordByOrderNo(adjustmentNo).stream().collect(Collectors.toMap(o -> this.getKey(o.getSkuCode(), o.getNum(), o.getUnit()), Function.identity(), (k1, k2) -> k1));
    }

    private Object getKey(String skuCode, BigDecimal num, String currentUnit) {
        return skuCode + InventoryConfig.getCommonSeparate() + num.setScale(6) + InventoryConfig.getCommonSeparate() + currentUnit;
    }
}

