/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dao.das.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ItemDgDas;
import com.yunxi.dg.base.center.item.dao.mapper.ItemDgMapper;
import com.yunxi.dg.base.center.item.dao.vo.DirShelfItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemSearchDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemDgVo;
import com.yunxi.dg.base.center.item.dto.request.ItemPageDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.ItemDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuRelDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemDgEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ItemDgDasImpl
extends AbstractDas<ItemDgEo, String>
implements ItemDgDas {
    @Resource
    private ItemDgMapper mapper;

    public ItemDgMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void updateStatusByIds(List<Long> itemIds, Integer status) {
        this.getMapper().updateStatusByIds(itemIds, status);
    }

    public List<ItemDgEo> selectByIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        ItemDgEo itemDgEo = ItemDgEo.newInstance();
        itemDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(ids, (String)",")));
        itemDgEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)itemDgEo);
    }

    @Override
    public PageInfo<ShelfItemDgVo> selectByKeyword(String keyword, Integer type, List<Long> dirIds, Long brandId, List<Long> itemIds, List<Long> skuIds, Long sellerId, Long shopId, List<Long> shopIds, List<Long> sellerIds, List<Long> organizationIds, Integer pageNum, Integer pageSize, Long instanceId, Long tenantId, Integer subType, List<Integer> subTypeList, Integer busType, Integer status) {
        ItemDgMapper itemDgMapper = this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemDgVo> ItemDgEoList = itemDgMapper.selectByKeyword(keyword, type, dirIds, brandId, itemIds, skuIds, sellerId, shopId, shopIds, sellerIds, organizationIds, instanceId, tenantId, subType, subTypeList, busType, status);
        return new PageInfo(ItemDgEoList);
    }

    @Override
    public PageInfo<Long> querySaleOut(ItemDgEo query, int page, int size, List<Long> dirIdList) {
        ItemDgMapper mapper = this.getMapper();
        int count = mapper.querySaleOutCount(query, dirIdList);
        PageInfo info = new PageInfo();
        info.setTotal((long)count);
        info.setPageSize(size);
        info.setPageNum(page);
        if (count > 0) {
            int offset = (page - 1) * size;
            info.setList(mapper.querySaleOut(query, offset, size, dirIdList));
        }
        return info;
    }

    public void deleteCacheByKey(String key) {
        this.getCacheService().delCache(this.getCachePre() + key);
    }

    @Override
    public PageInfo<ShelfItemDgVo> selectSelfItemByPage(ShelfItemDgVo shelfItemVo, Integer pageNum, Integer pageSize) {
        ItemDgMapper mapper = this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemDgVo> shelfItemVoList = mapper.selectSelfItemByPage(shelfItemVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    @Override
    public Long selectSelfItemCount(ShelfItemDgVo shelfItemVo) {
        ItemDgMapper mapper = this.getMapper();
        return mapper.selectSelfItems(shelfItemVo).size();
    }

    @Override
    public List<ItemDgVo> pageItemOnSelf(ItemSearchDgVo managementBlockSearchVo) {
        return this.getMapper().pageItemOnSelf(managementBlockSearchVo);
    }

    @Override
    public List<DirShelfItemDgVo> querySkuByDirId(String name, List<Long> dirIds) {
        return this.getMapper().querySkuByDirId(name, dirIds);
    }

    @Override
    public List<ItemDgEo> selectByBrandId(Long brandId) {
        return new ArrayList<ItemDgEo>();
    }

    @Override
    public ItemDgEo selectByItemCode(String itemCode) {
        ItemDgEo param = ItemDgEo.newInstance();
        param.setCode(itemCode);
        List list = this.select((BaseEo)param);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (ItemDgEo)list.get(0);
        }
        return null;
    }

    @Override
    public List<ItemDgRespDto> queryByItemLongCodes(List<String> itemCodes) {
        return this.getMapper().queryByItemLongCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuRelByCodes(List<String> itemCodes) {
        return this.getMapper().queryItemSkuRelByCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuByItemCodes(List<String> itemCodes) {
        return this.getMapper().queryItemSkuByItemCodes(itemCodes);
    }

    @Override
    public List<ItemSkuRelDgRespDto> queryItemSkuBySkuCodes(List<String> skuCodes) {
        return this.getMapper().queryItemSkuBySkuCodes(skuCodes);
    }

    @Override
    public List<Long> queryItemIdByKeywordAndItemIds(String keyword, List<Long> itemIds) {
        return this.getMapper().queryItemIdByKeywordAndItemIds(keyword, itemIds);
    }

    @Override
    public void updateSubStatusByIds(List<Long> ids, Integer subStatus) {
        this.getMapper().updateSubStatusByIds(ids, subStatus);
    }

    @Override
    public void updateIsSaleStatusByIds(List<Long> itemIds, Integer status) {
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", itemIds));
        sqlFilters.add(SqlFilter.eq((String)"dr", (Object)0));
        ItemDgEo queryEo = new ItemDgEo();
        queryEo.setIsSale(status);
        queryEo.setSqlFilters((List)sqlFilters);
        this.updateSelectiveSqlFilter((BaseEo)queryEo);
    }

    @Override
    public List<ItemDgEo> queryByCondition(ItemPageDgReqDto pageDto) {
        return this.getMapper().queryByCondition(pageDto);
    }

    @Override
    public void changeMarketStatus(List<Long> idList, Integer marketStatus) {
        this.getMapper().changeMarketStatus(idList, marketStatus);
    }
}

