/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dao.das.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ItemMediasDgDas;
import com.yunxi.dg.base.center.item.dao.mapper.ItemMediasDgMapper;
import com.yunxi.dg.base.center.item.eo.ItemMediasDgEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ItemMediasDgDasImpl
extends AbstractDas<ItemMediasDgEo, String>
implements ItemMediasDgDas {
    @Resource
    private ItemMediasDgMapper mapper;

    public ItemMediasDgMapper getMapper() {
        return this.mapper;
    }

    @Override
    public List<ItemMediasDgEo> selectByItemId(Long itemId) {
        ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
        itemMediasDgEo.setOrderBy("id");
        itemMediasDgEo.setItemId(itemId);
        return this.select((BaseEo)itemMediasDgEo);
    }

    @Override
    public List<ItemMediasDgEo> selectBySkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
        itemMediasDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"sku_id", (Object)StringUtils.join(skuIds, (String)",")));
        itemMediasDgEo.setSqlFilters((List)sqlFilters);
        itemMediasDgEo.setOrderBy(" id ");
        return this.select((BaseEo)itemMediasDgEo);
    }

    @Override
    public void deleteBatchMedias(List<Long> ids) {
        ItemMediasDgMapper mapper = this.getMapper();
        mapper.deleteBatchMedias(ids);
    }

    @Override
    public List<ItemMediasDgEo> selectByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        ItemMediasDgEo itemMediasDgEo = ItemMediasDgEo.newInstance();
        itemMediasDgEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIds, (String)",")));
        itemMediasDgEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)itemMediasDgEo);
    }

    @Override
    public void removeMediasByItemAndType(List<Long> itemIds, Integer itemType) {
        this.mapper.removeMediasByItemAndType(itemIds, itemType);
    }
}

