/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dao.das.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ItemSkuDgDas;
import com.yunxi.dg.base.center.item.dao.mapper.ItemSkuDgMapper;
import com.yunxi.dg.base.center.item.dao.vo.DgItemSkuRespVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemRelationSkuDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ItemSkuConditionDgVo;
import com.yunxi.dg.base.center.item.dto.request.AccessoryItemReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.ItemSkuQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.request.MarketSkuSearchDto;
import com.yunxi.dg.base.center.item.dto.request.ShopItemQueryDgReqDto;
import com.yunxi.dg.base.center.item.dto.response.AccessoryItemRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuPageRespDto;
import com.yunxi.dg.base.center.item.dto.response.DgItemSkuRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuExtDgRespDto;
import com.yunxi.dg.base.center.item.dto.response.ItemSkuQueryDgRespDto;
import com.yunxi.dg.base.center.item.eo.ItemSkuDgEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class ItemSkuDgDasImpl
extends AbstractDas<ItemSkuDgEo, String>
implements ItemSkuDgDas {
    @Resource
    private ItemSkuDgMapper mapper;

    public ItemSkuDgMapper getMapper() {
        return this.mapper;
    }

    @Override
    public List<ItemSkuDgEo> selectByItemId(Long itemId) {
        ItemSkuDgEo ex = ItemSkuDgEo.newInstance();
        ex.setItemId(itemId);
        return this.select((BaseEo)ex);
    }

    @Override
    public void deleteBatchItemSku(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        ItemSkuDgMapper mapper = this.getMapper();
        mapper.deleteBatchItemSku(ids);
    }

    @Override
    public List<ItemSkuDgEo> selectItemSkuByIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ItemSkuDgEo skuEo = ItemSkuDgEo.newInstance();
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"id", (Object)StringUtils.join(skuIds, (String)",")));
        skuEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)skuEo);
    }

    @Override
    public List<ItemSkuDgEo> selectByItemIds(List<Long> itemIds) {
        if (CollectionUtils.isEmpty(itemIds)) {
            return Lists.newArrayList();
        }
        ItemSkuDgEo skuEo = ItemSkuDgEo.newInstance();
        skuEo.setOrderBy("id");
        ArrayList sqlFilters = Lists.newArrayList();
        sqlFilters.add(SqlFilter.in((String)"item_id", (Object)StringUtils.join(itemIds, (String)",")));
        skuEo.setSqlFilters((List)sqlFilters);
        return this.select((BaseEo)skuEo);
    }

    @Override
    public List<ItemRelationSkuDgVo> queryItemRelationSku(ItemRelationSkuDgVo itemRelationSkuVo) {
        return this.mapper.queryItemRelationSku(itemRelationSkuVo);
    }

    @Override
    public Integer updateByItemIdAndSkuId(ItemSkuDgEo stdItemSkuDgEo) {
        return this.mapper.updateByItemIdAndSkuId(stdItemSkuDgEo);
    }

    @Override
    public PageInfo<ItemRelationSkuDgVo> queryItemSkuPageByCondition(ItemSkuConditionDgVo itemSkuConditionVo, Integer pageNum, Integer pageSize) {
        ItemSkuDgMapper itemSkuMapper = this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ItemRelationSkuDgVo> itemSkuVoList = itemSkuMapper.queryItemSkuByCondition(itemSkuConditionVo);
        return new PageInfo(itemSkuVoList);
    }

    @Override
    public List<ItemSkuQueryDgRespDto> querySkuPage(ItemSkuQueryDgReqDto itemSkuQueryReqDto) {
        return this.mapper.querySkuPage(itemSkuQueryReqDto);
    }

    @Override
    public void addGift(List<Long> skuIds, Integer status) {
        this.mapper.addGift(skuIds, status);
    }

    @Override
    public void addGiftByCodes(List<String> skuCodes, Integer status) {
        this.mapper.addGiftByCodes(skuCodes, status);
    }

    @Override
    public List<ItemSkuExtDgRespDto> queryItemListByPage(ItemQueryDgReqDto itemDgReqDto, List<String> itemCodes, List<String> skuCodes) {
        return this.mapper.queryItemListByPage(itemDgReqDto, itemCodes, skuCodes);
    }

    @Override
    public void batchModifyGiftStatus(List<Long> skuIds, Integer status) {
        this.mapper.batchModifyGiftStatus(skuIds, status);
    }

    @Override
    public void removeGift(Long skuId) {
        this.mapper.removeGift(skuId);
    }

    @Override
    public List<ItemSkuExtDgRespDto> querySkuList(ItemSkuQueryDgReqDto itemSkuQueryDgReqDto) {
        return this.mapper.querySkuList(itemSkuQueryDgReqDto);
    }

    @Override
    public void batchChangeStatus(List<Long> ids, Integer status) {
        this.mapper.batchChangeStatus(ids, status);
    }

    @Override
    public List<DgItemSkuRespVo> queryItemSkuList(ItemQueryDgReqDto itemDgReqDto) {
        return this.mapper.queryItemSkuList(itemDgReqDto);
    }

    @Override
    public void batchRemoveGift(List<Long> skuIds) {
        this.mapper.batchRemoveGift(skuIds);
    }

    @Override
    public List<DgItemSkuRespVo> queryShopItemSkuList(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        return this.mapper.queryShopItemSkuList(shopItemQueryDgReqDto);
    }

    @Override
    public List<DgItemSkuPageRespDto> queryShopItemSkuPage(ShopItemQueryDgReqDto shopItemQueryDgReqDto) {
        return this.mapper.queryShopItemSkuPage(shopItemQueryDgReqDto);
    }

    @Override
    public void removeBomByIds(List<Long> skuIds) {
        this.mapper.removeBomByIds(skuIds);
    }

    @Override
    public List<DgItemSkuRespVo> queryItemPageByCodes(List<String> skuCodes) {
        return this.mapper.queryItemPageByCodes(skuCodes);
    }

    @Override
    public List<DgItemSkuRespDto> queryMarketSkuPage(MarketSkuSearchDto reqDto) {
        return this.mapper.queryMarketSkuPage(reqDto);
    }

    @Override
    public List<AccessoryItemRespDto> queryAccessoryItemList(AccessoryItemReqDto reqDto) {
        return this.mapper.queryAccessoryItemList(reqDto);
    }

    @Override
    public List<DgItemSkuPageRespDto> queryItemSkuListV2(ItemQueryDgReqDto itemDgReqDto) {
        return this.mapper.queryItemSkuListV2(itemDgReqDto);
    }

    @Override
    public List<DgItemSkuPageRespDto> querySimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        return this.mapper.querySimpleItemList(itemDgReqDto);
    }

    @Override
    public Long countSimpleItemList(ItemQueryDgReqDto itemDgReqDto) {
        return this.mapper.countSimpleItemList(itemDgReqDto);
    }

    @Override
    public List<String> querySpecModelBySkuCode(List<String> skuCodes) {
        return this.mapper.querySpecModelBySkuCode(skuCodes);
    }
}

