/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.item.dao.das.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.item.dao.das.ShelfDgDas;
import com.yunxi.dg.base.center.item.dao.mapper.ShelfDgMapper;
import com.yunxi.dg.base.center.item.dao.vo.ShelfDgQueryReqVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfItemSkuDgVo;
import com.yunxi.dg.base.center.item.dao.vo.ShelfListDgRespVo;
import com.yunxi.dg.base.center.item.eo.ShelfDgEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public class ShelfDgDasImpl
extends AbstractDas<ShelfDgEo, String>
implements ShelfDgDas {
    @Resource
    private ShelfDgMapper mapper;

    public ShelfDgMapper getMapper() {
        return this.mapper;
    }

    @Override
    public List<ShelfDgEo> selectByParam(List<Long> shopIds, List<Long> itemIds, List<Long> skuIds, Integer busType) {
        if (CollectionUtils.isEmpty(shopIds) && CollectionUtils.isEmpty(itemIds) && CollectionUtils.isEmpty(skuIds)) {
            return Lists.newArrayList();
        }
        ShelfDgEo param = ShelfDgEo.newInstance();
        ArrayList sqlFilterList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(shopIds)) {
            sqlFilterList.add(SqlFilter.in((String)"shop_id", shopIds));
        }
        if (CollectionUtils.isNotEmpty(itemIds)) {
            sqlFilterList.add(SqlFilter.in((String)"item_id", itemIds));
        }
        if (CollectionUtils.isNotEmpty(skuIds)) {
            sqlFilterList.add(SqlFilter.in((String)"sku_id", skuIds));
        }
        if (busType != null) {
            param.setBusType(busType);
        }
        if (CollectionUtils.isNotEmpty((Collection)sqlFilterList)) {
            param.setSqlFilters((List)sqlFilterList);
        }
        return this.select((BaseEo)param);
    }

    @Override
    public PageInfo<ShelfItemDgVo> selectSelfItemByPage(ShelfItemDgVo shelfItemDgVo, Integer pageNum, Integer pageSize) {
        ShelfDgMapper shelfMapper = this.getMapper();
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfItemDgVo> shelfItemDgVoList = shelfMapper.selectSelfItemByPage(shelfItemDgVo, pageNum, pageSize);
        return new PageInfo(shelfItemDgVoList);
    }

    @Override
    public List<ShelfItemSkuDgVo> selectSelfItemSkuList(Long shopId, Long itemId, Integer busType) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectSelfItemSkuList(shopId, itemId, busType);
    }

    @Override
    public List<ShelfItemSkuDgVo> selectSelfItemSkuListByItemId(Long itemId) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectSelfItemSkuListByItemId(itemId);
    }

    @Override
    public List<ShelfItemSkuDgVo> selectSelfItemSkuListBySkuId(Long shopId, Long skuId) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectSelfItemSkuListBySkuId(shopId, skuId);
    }

    @Override
    public List<ShelfDgEo> selectByParam(Long shopId, Long itemId, Long skuId) {
        if (shopId == null && itemId == null && skuId == null) {
            return Lists.newArrayList();
        }
        ShelfDgEo param = ShelfDgEo.newInstance();
        if (shopId != null) {
            param.setShopId(shopId);
        }
        if (itemId != null) {
            param.setItemId(itemId);
        }
        if (skuId != null) {
            param.setSkuId(skuId);
        }
        return this.select((BaseEo)param);
    }

    @Override
    public List<ShelfItemSkuDgVo> selectSelfItemSkuListBySkuIds(List<Long> skuIds) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectSelfItemSkuListBySkuIds(skuIds);
    }

    @Override
    public Long selectSelfItemCount(@Param(value="shelfItemVo") ShelfItemDgVo shelfItemDgVo) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectSelfItems(shelfItemDgVo).size();
    }

    @Override
    public List<ShelfItemDgVo> selectShelfList(ShelfItemDgVo shelfItemDgVo) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.selectShelfList(shelfItemDgVo);
    }

    @Override
    public List<ShelfItemDgVo> queryItemShelfSkuList(ShelfItemDgVo shelfItemDgVo) {
        ShelfDgMapper shelfMapper = this.getMapper();
        return shelfMapper.queryItemShelfSkuList(shelfItemDgVo);
    }

    @Override
    public Long newSelectSelfItemCount(ShelfItemDgVo shelfItemDgVo) {
        return this.getMapper().newSelectSelfItems(shelfItemDgVo);
    }

    @Override
    public List<Long> selectByBundleItemIds(List<Long> itemIds) {
        return this.getMapper().selectByBundleItemIds(itemIds);
    }

    @Override
    public PageInfo<ShelfListDgRespVo> queryShelfPage(ShelfDgQueryReqVo reqVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<ShelfListDgRespVo> shelfItemVoList = this.getMapper().queryShelfByPage(reqVo, pageNum, pageSize);
        return new PageInfo(shelfItemVoList);
    }

    @Override
    public void updateShelfStatusByIds(List<Long> ids, int status) {
        ShelfDgMapper shelfMapper = this.getMapper();
        shelfMapper.updateShelfStatusByIds(ids, status);
    }
}

